'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_dropdownLB1.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: hde $ $Date: 2005/12/01 08:59:01 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Test Drop Down List Box
'*
'************************************************************************
'*
' #1 tDropDownLB_1           'Check 'Input List'
' #1 tDropDownLB_2           'All input field should be initially empty
' #1 tDropDownLB_3           'Test Add button
' #1 tDropDownLB_4           'Test Return in Item editbox
' #1 tDropDownLB_5           'Test new item will always be added at the end of 'Items on list'
' #1 tDropDownLB_6           'The first entry in the list box is the shown default
' #1 tDropDownLB_7           'Test 'Remove' button
' #1 tDropDownLB_8           'Test 'Move Up' button
' #1 tDropDownLB_9           'Test 'Move Down' button
' #1 tDropDownLB_10          'Test 'Ctrl+Shift+F9'
' #1 tDropDownLB_11          'OK button should insert new value
' #1 tDropDownLB_12          'Test Next button
' #1 tDropDownLB_13          'Test Edit button
' #1 tDropDownLB_14          'Test Edit/Fields
' #1 tDropDownLB_15          'Test Right arrow button
' #1 tDropDownLB_16          'Test Left arrow button
' #1 tDropDownLB_17          'Import from Word document
'*
'\***********************************************************************

testcase tDropDownLB_1

    Dim  iType  as Integer  
    iType = 2
       
    PrintLog "- Check 'Input List'"
    '/// <b>Check 'Input List'</b>
    
    Call hNewDocument
    
    '/// Insert/Field/Other/ Functions
    '/// Check if 'Input List' exists in Type area
    Call fInsertFieldsOther("TabFunktionen")
    Feldtyp.Select iType
    Sleep 3
    if Not EntrysList.IsVisible then
        Warnlog "Maybe wrong type selected in list. Not 'Input list'"
    end if
    TabFunktionen.Close
    
    Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tDropDownLB_2

  Dim  iType  as Integer

  iType = 2

  PrintLog "- All input field should be initially empty"
  '/// <b>All input field should be initially empty</b>

  '/// Open a new document
   Call hNewDocument

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Check if all input field should be initially empty
    Call fInsertFieldsOther("TabFunktionen")
        Feldtyp.Select iType
        Sleep 3
        if Len(NewListEntry.GetText) <> 0 then Warnlog "Item isn't empty!"
        if EntrysList.GetItemCount   <> 0 then Warnlog "Items on list isn't empty!"
        if Len(EntryName.GetText)    <> 0 then Warnlog "Name isn't empty!"
    TabFunktionen.Close

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tDropDownLB_3

  Dim  iType  as Integer
  Dim  sItem  as String

  iType = 2  : sItem = "Entry 1"

  PrintLog "- Test Add button"
  '/// <b>Test Add button</b>

  '/// Open a new document
   Call hNewDocument

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input text in 'Item' , then click 'Add' button
   '/// Check if the text is inserted into 'Items on List'
    Call fInsertFieldsOther("TabFunktionen")
        Feldtyp.Select iType
        Sleep 3
        NewListEntry.SetText sItem
        Sleep 1
        AddListEntry.Click
        Sleep 1
        if EntrysList.GetSelText(1) <> sItem then Warnlog "the text isn't inserted into 'Items on list' correctly!"
    TabFunktionen.Close

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tDropDownLB_4

  Dim  iType  as Integer
  Dim  sItem  as String

  iType = 2  : sItem = "Entry 1"

  PrintLog "- Test Pressing return in Item editbox"
  '/// <b>Test Pressing return in Item editbox</b>

  '/// Open a new document
   Call hNewDocument

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input text in 'Item' , then click 'Add' button
   '/// Check if the text is inserted into 'Items on List'
    Call fInsertFieldsOther("TabFunktionen")
        Feldtyp.Select iType
        Sleep 3
        NewListEntry.SetText sItem
        Sleep 1
        NewListEntry.Typekeys "<Return>"
        Sleep 1
        if EntrysList.GetSelText(1) <> sItem then Warnlog "the text isn't inserted into 'Items on list' correctly!"
    TabFunktionen.Close

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tDropDownLB_5

  Dim  iType   as Integer
  Dim  sItem() as String
  Dim  i , j   as Integer

  iType = 2
  sItem = Array( _
                   "Entry 1"    , _
                   "Entry 2"    , _
                   "Entry 3"    , _
                   "Entry 4"    , _
                   "Entry 5"    , _
                   "Entry 6"    , _
                   )
  j = UBound(sItem)

  PrintLog "- Test new item will always be added at the end of 'Items on list'"
  '/// <b>Test new item will always be added at the end of 'Items on list'</b>

  '/// Open a new document
   Call hNewDocument

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input some items
   '/// Check if new item will always be added at the end of 'Items on list'
    Call fInsertFieldsOther("TabFunktionen")
        Feldtyp.Select iType
        Sleep 3

        For i = 0 to j
            NewListEntry.SetText sItem(i)
            Sleep 1
            AddListEntry.Click
            Sleep 1
        next i

        For i = 0 to j
            try
                EntrysList.Select i+1
                Sleep 1
            catch
                Warnlog "There should be 6 itmes in the Items on list!"
            endcatch
            if EntrysList.GetSelText <> sItem(i) then Warnlog "Hope to get " & sItem(i) & " but get " & EntrysList.GetSelText
        next i
    TabFunktionen.Close

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tDropDownLB_6

  Dim  iType   as Integer
  Dim  sItem() as String
  Dim  i , j   as Integer

  iType = 2
  sItem = Array( _
                   "Entry 1"    , _
                   "Entry 2"    , _
                   "Entry 3"    , _
                   "Entry 4"    , _
                   "Entry 5"    , _
                   "Entry 6"    , _
                   )
  j = UBound(sItem)

  PrintLog "- The first entry in the list box is the shown default"
  '/// <b>The first entry in the list box is the shown default</b>

  '/// Open a new document
   Call hNewDocument

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input some items
   '/// Set focus to the middle Item
   '/// click insert button , then Close the dialog
    Call fInsertFieldsOther("TabFunktionen")
        Feldtyp.Select iType
        Sleep 3

        For i = 0 to j
            NewListEntry.SetText sItem(i)
            Sleep 1
            AddListEntry.Click
            Sleep 1
        next i
        EntrysList.Select 3
        Sleep 1
        Einfuegen.Click
        Sleep 1
    TabFunktionen.Close

    EditSelectAll
    EditCopy

    if GetClipboardText <>  sItem(0) then  Warnlog "should get " &sItem(0) & " but get " & GetClipboardText

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tDropDownLB_7

  Dim  iType   as Integer
  Dim  sItem() as String
  Dim  i , j   as Integer

  iType = 2
  sItem = Array( _
                   "Entry 1"    , _
                   "Entry 2"    , _
                   "Entry 3"    , _
                   "Entry 4"    , _
                 )
  j = UBound(sItem)

  PrintLog "- Test Remove button"
  '/// <b>Test Remove button</b>

  '/// Open a new document
   Call hNewDocument

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input some items
   '/// Set focus to the middle Item
   '/// click remove button
   '/// check if the selected item is removed
    Call fInsertFieldsOther("TabFunktionen")
        Feldtyp.Select iType
        Sleep 3

        try
            RemoveEntry.Click
            Warnlog "The remove button should be only ebabled when an item is selected !"
        catch
        endcatch

        For i = 0 to j
            NewListEntry.SetText sItem(i)
            Sleep 1
            AddListEntry.Click
            Sleep 1
        next i

        EntrysList.Select 3
        Sleep 1
        RemoveEntry.Click
        Sleep 1

        EntrysList.Select 1
        Sleep 1
        if EntrysList.GetSelText <> sItem(0) then Warnlog "Hope to get " & sItem(0) & " but get " & EntrysList.GetSelText

        EntrysList.Select 2
        Sleep 1
        if EntrysList.GetSelText <> sItem(1) then Warnlog "Hope to get " & sItem(1) & " but get " & EntrysList.GetSelText

        EntrysList.Select 3
        Sleep 1
        if EntrysList.GetSelText <> sItem(3) then Warnlog "Hope to get " & sItem(3) & " but get " & EntrysList.GetSelText

        try
            EntrysList.Select 4
            Warnlog "There should be only 3 itmes in the Items on list !"
        catch
        endcatch

    TabFunktionen.Close

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tDropDownLB_8

  Dim  iType                as Integer
  Dim  sItem() , sNewItem() as String
  Dim  i  ,  j              as Integer

  iType = 2
  sItem = Array( _
                   "Entry 1"    , _
                   "Entry 2"    , _
                   "Entry 3"    , _
                   "Entry 4"    , _
                 )
  sNewItem = Array( _
                   "Entry 4"    , _
                   "Entry 1"    , _
                   "Entry 2"    , _
                   "Entry 3"    , _
                   )

  j = UBound(sItem)

  PrintLog "- Test 'Move Up' button"
  '/// <b>Test 'Move Up' button</b>

  '/// Open a new document
   Call hNewDocument

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input some items
   '/// Set focus to the last Item ,
   '/// click Move Up button third times
   '/// check if the 4th item is the 1st one
    Call fInsertFieldsOther("TabFunktionen")
        Feldtyp.Select iType
        Sleep 3

        For i = 0 to j
            NewListEntry.SetText sItem(i)
            Sleep 1
            AddListEntry.Click
            Sleep 1
        next i

        EntrysList.Select 4
        Sleep 1
        MoveUpEntry.Click
        Sleep 1
        MoveUpEntry.Click
        Sleep 1
        MoveUpEntry.Click
        Sleep 1

        For i = 0 to j
            EntrysList.Select i+1
            Sleep 1
            if EntrysList.GetSelText <> sNewItem(i) then Warnlog "Hope to get " & sItem(i) & " but get " & EntrysList.GetSelText
        next i
    TabFunktionen.Close

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tDropDownLB_9

  Dim  iType                as Integer
  Dim  sItem() , sNewItem() as String
  Dim  i  ,  j              as Integer

  iType = 2
  sItem = Array( _
                   "Entry 1"    , _
                   "Entry 2"    , _
                   "Entry 3"    , _
                   "Entry 4"    , _
                 )
  sNewItem = Array( _
                   "Entry 2"    , _
                   "Entry 3"    , _
                   "Entry 4"    , _
                   "Entry 1"    , _
                   )
  j = UBound(sItem)

  PrintLog "- Test 'Move Down' button"
  '/// <b>Test 'Move Down' button</b>

  '/// Open a new document
   Call hNewDocument

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input some items
   '/// Set focus to the 1st Item ,
   '/// click Move Down button third times
   '/// check if the 1st item is the 4th one
    Call fInsertFieldsOther("TabFunktionen")
        Feldtyp.Select iType
        Sleep 3

        For i = 0 to j
            NewListEntry.SetText sItem(i)
            Sleep 1
            AddListEntry.Click
            Sleep 1
        next i

        EntrysList.Select 1
        Sleep 1
        MoveDownEntry.Click
        Sleep 1
        MoveDownEntry.Click
        Sleep 1
        MoveDownEntry.Click
        Sleep 1

        For i = 0 to j
            EntrysList.Select i+1
            Sleep 1
            if EntrysList.GetSelText <> sNewItem(i) then Warnlog "Hope to get " & sItem(i) & " but get " & EntrysList.GetSelText
        next i
    TabFunktionen.Close

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tDropDownLB_10

  Dim  iType       as Integer
  Dim  sItem       as String

  iType = 2
  sItem = "Entry 1"

  PrintLog "- Test 'Ctrl+Shift+F9'"
  '/// <b>Test 'Ctrl+Shift+F9'</b>

  '/// Open a new document
   Call hNewDocument

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input 1 item
   '/// click insert and close the dialog
    Call fInsertFieldsOther("TabFunktionen")
        Feldtyp.Select iType
        Sleep 3
        NewListEntry.SetText sItem
        Sleep 1
        AddListEntry.Click
        Sleep 1
        Einfuegen.Click
        Sleep 1
    TabFunktionen.Close

   '/// Set focus in front of the list
    Call wDokSchreiben "<MOD1 Home>"

   '/// Press Ctrl+Shift+F9
    Call wDokSchreiben "<MOD1 Shift F9>"

    Kontext "EditInputList"
    if EditInputList.Exists then
        EditInputList.Cancel
    else
        Warnlog "The dialog can't be actived ."
    end if

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tDropDownLB_11

  Dim  iType            as Integer
  Dim  sItem1 , sItem2  as String

  iType  = 2
  sItem1 = "Entry 1" : sItem2 = "Entry 2"

  PrintLog "- OK button should insert new value"
  '/// <b>OK button should insert new value</b>

  '/// Open a new document
   Call hNewDocument

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input 2 items
   '/// click insert and close the dialog
    Call fInsertFieldsOther("TabFunktionen")
        Feldtyp.Select iType
        Sleep 3
        NewListEntry.SetText sItem1
        Sleep 1
        AddListEntry.Click
        Sleep 1
        NewListEntry.SetText sItem2
        Sleep 1
        AddListEntry.Click
        Sleep 1

        Einfuegen.Click
        Sleep 1
    TabFunktionen.Close

   '/// Set focus in front of the list
    Call wDokSchreiben "<MOD1 Home>"

   '/// Press Ctrl+Shift+F9
    Call wDokSchreiben "<MOD1 Shift F9>"

   '/// select 2nd list and press OK
    Kontext "EditInputList"
      AllListEntrys.Select 2
      Sleep 1
    EditInputList.OK

   '/// Check if the result is right
    EditSelectAll
    EditCopy

    if GetClipboardText <>  sItem2 then  Warnlog "should get " &sItem2 & " but get " & GetClipboardText

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tDropDownLB_12

  Dim  iType                as Integer
  Dim  sItem1() , sItem2()  as String
  Dim  i  ,  j              as Integer

  iType = 2
  sItem1 = Array( _
                   "Entry 1"    , _
                   "Entry 2"    , _
                   "Entry 3"    , _
                   "Entry 4"    , _
                   )
  sItem2 = Array( _
                   "Entry A"    , _
                   "Entry B"    , _
                   "Entry C"    , _
                   "Entry D"    , _
                   )

  j = UBound(sItem1)

  PrintLog "- Test Next button"
  '/// <b>Test Next button</b>

  '/// Open a new document
   Call hNewDocument

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input some items
   '/// click insert and close the dialog
    Call fInsertFieldsOther("TabFunktionen")

        Feldtyp.Select iType
        Sleep 3

        For i = 0 to j
            NewListEntry.SetText sItem1(i)
            Sleep 1
            AddListEntry.Click
            Sleep 1
        next i

        Einfuegen.Click
        Sleep 1
    TabFunktionen.Close

   '/// Set focus to another line
    Call wDokSchreiben "<End><Return><Return>"

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input some other items
   '/// click insert and close the dialog
    Call fInsertFieldsOther("TabFunktionen")

        Feldtyp.Select iType
        Sleep 3

        For i = 0 to j
            NewListEntry.SetText sItem2(i)
            Sleep 1
            AddListEntry.Click
            Sleep 1
        next i

        Einfuegen.Click
        Sleep 1
    TabFunktionen.Close

   '/// Set focus in front of the 1st list
    Call wDokSchreiben "<MOD1 Home>"

   '/// Press Ctrl+Shift+F9
    Call wDokSchreiben "<MOD1 Shift F9>"

   '/// the 1st group items should be in edit area
    Kontext "EditInputList"
      For i = 0 to j
          AllListEntrys.Select i+1
          Sleep 1
          if AllListEntrys.GetSelText <> sItem1(i) then Warnlog "Hope to get " & sItem1(i) & " but get " & AllListEntrys.GetSelText
      next i

     '/// Press next button , the 2nd group items should be in edit area
      NextListEntry.click
      Sleep 1

      For i = 0 to j
          AllListEntrys.Select i+1
          Sleep 1
          if AllListEntrys.GetSelText <> sItem2(i) then Warnlog "Hope to get " & sItem2(i) & " but get " & AllListEntrys.GetSelText
      next i

    EditInputList.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tDropDownLB_13

  Dim  iType            as Integer
  Dim  sItem1 , sItem2  as String

  iType  = 2
  sItem1 = "Entry 1" : sItem2 = "Entry A"

  PrintLog "- Test Edit button"
  '/// <b>Test Edit button</b>

  '/// Open a new document
   Call hNewDocument

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input a item
   '/// click insert and close the dialog
    Call fInsertFieldsOther("TabFunktionen")
        Feldtyp.Select iType
        Sleep 3

        NewListEntry.SetText sItem1
        Sleep 1
        AddListEntry.Click
        Sleep 1

        Einfuegen.Click
        Sleep 1
    TabFunktionen.Close

   '/// Set focus to another line
    Call wDokSchreiben "<End><Return><Return>"

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input another item
   '/// click insert and close the dialog
    Call fInsertFieldsOther("TabFunktionen")
        Feldtyp.Select iType
        Sleep 3

        NewListEntry.SetText sItem2
        Sleep 1
        AddListEntry.Click
        Sleep 1

        Einfuegen.Click
        Sleep 1
    TabFunktionen.Close

   '/// Set focus in front of the 1st list
    Call wDokSchreiben "<MOD1 Home>"

   '/// Press Ctrl+Shift+F9
    Call wDokSchreiben "<MOD1 Shift F9>"

   '/// Press Edit button , the edit/field dialog should be up
    Kontext "EditInputList"
      EditListEntry.click
      Sleep 1

      Kontext "FeldbefehlBearbeitenFunktionen"
      if FeldbefehlBearbeitenFunktionen.Exists then
          EntrysList.Select 1
          if EntrysList.GetSelText <> sItem1 then
              Warnlog "Hope to get " & sItem1 & " but get " & EntrysList.GetSelText & "->Bug#115731"
          end if
          FeldbefehlBearbeitenFunktionen.Cancel
      else
          Warnlog "The dialog can't be actived ."
      end if

    Kontext "EditInputList"
    EditInputList.cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tDropDownLB_14

  Dim  iType      as Integer
  Dim  sItem()    as String
  Dim  sEntryName as String
  Dim  i , j      as Integer

  iType = 2
  sEntryName = "entryTest"
  sItem = Array( _
                   "Entry 1"    , _
                   "Entry 2"    , _
                   "Entry 3"    , _
                   "Entry 4"    , _
                   "Entry 5"    , _
                   "Entry 6"    , _
                 )
  j = UBound(sItem)

  PrintLog "- Test Edit/Fields"
  '/// <b>Test Edit/Fields</b>

  '/// Open a new document
   Call hNewDocument

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input some items
   '/// set Entry name
   '/// click insert button , then Close the dialog
    Call fInsertFieldsOther("TabFunktionen")
        Feldtyp.Select iType
        Sleep 3

        For i = 0 to j
            NewListEntry.SetText sItem(i)
            Sleep 1
            AddListEntry.Click
            Sleep 1
        next i

        EntryName.SetText sEntryName
        Einfuegen.Click
        Sleep 1

    TabFunktionen.Close

   '/// Set focus in front of the 1st list
    Call wDokSchreiben "<Home>"

   '/// Edit/Fields , check if the entry items' info is correct
    EditFields
    Kontext "FeldbefehlBearbeitenFunktionen"
      For i = 0 to j
          EntrysList.Select i+1
          Sleep 1
          if EntrysList.GetSelText <> sItem(i) then Warnlog "Hope to get " & sItem(i) & " but get " & EntrysList.GetSelText
      next i
      if EntryName.GetText <> sEntryName then  Warnlog "Entry name should be " & sEntryName & " but get " & EntryName.GetText
    FeldbefehlBearbeitenFunktionen.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tDropDownLB_15

  Dim  iType            as Integer
  Dim  sItem1 , sItem2  as String

  iType  = 2
  sItem1 = "Entry 1" : sItem2 = "Entry A"

  PrintLog "- Test Right arrow button"
  '/// <b>Test Right arrow button</b>

  '/// Open a new document
   Call hNewDocument

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input a item
   '/// click insert and close the dialog
    Call fInsertFieldsOther("TabFunktionen")
        Feldtyp.Select iType
        Sleep 3

        NewListEntry.SetText sItem1
        Sleep 1
        AddListEntry.Click
        Sleep 1

        Einfuegen.Click
        Sleep 1
    TabFunktionen.Close

   '/// Set focus to another line
    Call wDokSchreiben "<End><Return><Return>"

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input another item
   '/// click insert and close the dialog
    Call fInsertFieldsOther("TabFunktionen")
        Feldtyp.Select iType
        Sleep 3

        NewListEntry.SetText sItem2
        Sleep 1
        AddListEntry.Click
        Sleep 1

        Einfuegen.Click
        Sleep 1
    TabFunktionen.Close

   '/// Set focus in front of the 1st list
    Call wDokSchreiben "<MOD1 Home>"

   '/// Edit/Fields
    EditFields

   '/// click Right arrow button
    Kontext "FeldbefehlBearbeitenFunktionen"
      EntrysList.Select 1
      if EntrysList.GetSelText <> sItem1 then
          Warnlog "1.Hope to get " & sItem1 & " but get " & EntrysList.GetSelText
      end if
      NaechsterFeldbefehl.Click
      Sleep 1
      EntrysList.Select 1
      if EntrysList.GetSelText <> sItem2 then
          Warnlog "2.Hope to get " & sItem2 & " but get " & EntrysList.GetSelText
      end if
    FeldbefehlBearbeitenFunktionen.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tDropDownLB_16

  Dim  iType            as Integer
  Dim  sItem1 , sItem2  as String

  iType  = 2
  sItem1 = "Entry 1" : sItem2 = "Entry A"

  PrintLog "- Test Left arrow button"
  '/// <b>Test Left arrow button</b>

  '/// Open a new document
   Call hNewDocument

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input a item
   '/// click insert and close the dialog
    Call fInsertFieldsOther("TabFunktionen")
        Feldtyp.Select iType
        Sleep 3

        NewListEntry.SetText sItem1
        Sleep 1
        AddListEntry.Click
        Sleep 1

        Einfuegen.Click
        Sleep 1
    TabFunktionen.Close

   '/// Set focus to another line
    Call wDokSchreiben "<End><Return><Return>"

   '/// Insert/Field/Other/ Functions
   '/// select Input list
   '/// Input another item
   '/// click insert and close the dialog
    Call fInsertFieldsOther("TabFunktionen")
        Feldtyp.Select iType
        Sleep 3

        NewListEntry.SetText sItem2
        Sleep 1
        AddListEntry.Click
        Sleep 1

        Einfuegen.Click
        Sleep 1
    TabFunktionen.Close

   '/// Set focus in front of the 2nd list
    Call wDokSchreiben "<Home>"

   '/// Edit/Fields
    EditFields

   '/// click Left arrow button
    Kontext "FeldbefehlBearbeitenFunktionen"
      EntrysList.Select 1
      if EntrysList.GetSelText <> sItem2 then
          Warnlog "1.Hope to get " & sItem2 & " but get " & EntrysList.GetSelText
      end if
      VorigerFeldbefehl.Click
      Sleep 1
      EntrysList.Select 1
      if EntrysList.GetSelText <> sItem1 then
          Warnlog "2.Hope to get " & sItem1 & " but get " & EntrysList.GetSelText
      end if
    FeldbefehlBearbeitenFunktionen.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------------------------

testcase tDropDownLB_17

    Dim  sTestFile                 as String
    Dim  sItem1() , sItem2()       as String
    Dim  i , j                     as Integer
    
    sTestFile = Convertpath (gTesttoolpath + "writer\level1\input\dropdownLB\DropDownListBox.doc")
    
    sItem1 = Array( _
           "Entry 1"    , _
           "Entry 2"    , _
           "Entry 3"    , _
         )
    sItem2 = Array( _
           "Entry A"    , _
           "Entry B"    , _
           "Entry C"    , _
         )
       
    PrintLog "- Import from Word document"
    '/// <b>Import from Word document</b>    
    '/// Open a new document
    Call hNewDocument    
    '/// Open a word document  which includes 2 entries .
    Call hDateiOeffnen(sTestFile)    
    '/// Set focus in front of first line
    Call wDokSchreiben "<MOD1 Home>"    
    '/// Edit/Fields
    try
        EditFields
    catch
        Warnlog "Can't import word document !"
        Call hCloseDocument
        goto endsub
    endcatch
    
    '/// click Left arrow button
    Kontext "FeldbefehlBearbeitenFunktionen"
    if EntrysList.GetItemCount = 3 then
        For i = 1 to EntrysList.GetItemCount
            EntrysList.Select i
            Sleep 1
            if EntrysList.GetSelText <> sItem1(i-1) then Warnlog "Hope to get " & sItem1(i-1) & " but get " & EntrysList.GetSelText
        next i
    else
        QAErrorlog "#i56768#Not all entrys in field correctly imported!"
    endif
    FeldbefehlBearbeitenFunktionen.Cancel
    
    '/// Set focus in front of third line
    Call wDokSchreiben "<MOD1 Home>"
    Call wDokSchreiben "<Down>" , 2
    Call wDokSchreiben "<Home>"
    
    '/// Edit/Fields
    try
        EditFields
    catch
        Warnlog "Can't import word document !"
        Call hCloseDocument
        goto endsub
    endcatch
    
    '/// click Left arrow button
    Kontext "FeldbefehlBearbeitenFunktionen"
    if EntrysList.GetItemCount = 3 then
        For i = 1 to EntrysList.GetItemCount
            EntrysList.Select i
            Sleep 1
            if EntrysList.GetSelText <> sItem2(i-1) then Warnlog "Hope to get " & sItem2(i-1) & " but get " & EntrysList.GetSelText
        next i
    else
        QAErrorlog "#i56768#Not all entrys in field correctly imported!"
    endif
    FeldbefehlBearbeitenFunktionen.Cancel
    
    Call hCloseDocument ' <- close word document
    
endcase

'-------------------------------------------------------------------------------------------

