'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_010_.inc,v $
'*
'*  $Revision: 1.33.4.1 $
'*
'*  last change: $Author: hde $ $Date: 2008/02/21 08:45:22 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*                                                                **
'* owner : helge.delfs@sun.com                                    **
'*                                                                **
'* short description :                                            **
'*                                                                **
'\******************************************************************

sub w_010_
    printLog Chr(13) + "--------- Objectbars (w_010_.inc) ----------"

'   ** Objectbar
    Call tFormatting
    Call tNumbering
    Call tEnumerating
    Call tIndentIncreaseDecrease

'   ** Objectbar Numbering / Aufzaehlung
    Call tNumFormatting
    Call tNumLevelUpDown
    Call tNumSubpointsUpDown
    Call tNumMoveUpMoveDown
    Call tNumSubpointsMoveUpMoveDown
    Call tNumUnnumberedEntry
    Call tNumRestartNumbering
    Call tNumNumberingOff
    Call tNumNumberingEnumerating
    Call tUpFormatting
    Call tUpLevelUpDown
    Call tUpSubpointsUpDown
    Call tUpMoveUpMoveDown
    Call tUpSubpointsMoveUpMoveDown
    Call tUpUnnumberedEntry
    Call tUpRestartNumbering
    Call tUpNumberingOff
    Call tUpNumberingEnumerating

'   ** Objectbar Table
    Call tInsertFormula
    Call tMergeCells
    Call tSplitCells
    Call tOptimize
    Call tInsertCellRow
    Call tDeleteRow
    Call tDeleteColumn

'   ** Graphics ( same as OLE-Objects and Frames )
    Call tGraphicWrap
    Call tGraphicAlign
    Call tGraphicFlip
    Call tGraphicArrange
    Call tGraphicBorders
    Call tGraphicProperties
    Call tGraphicAnchor

'   ** Formula Bar
    Call tFormulaCancel
    Call tFormulaApply

end sub

'-----------------------------------------------------------

testcase tFormatting
    printlog "- Objectbar ( normal ) : Formatting"
    Call hNewDocument
    '/// Open new document ///
    Call wDokSchreiben ("Formatting <Shift Home>")
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )
    
    printlog "  - Style"
    try
        Vorlage.Select 1
    catch
        Warnlog "Style could not be changed in TextObjectbar"
    endcatch
    '/// Choose first 'style' in object bar ///
    Sleep 5
    printlog "  - Font"
    '/// Select 5th 'Font' in object bar ///
    try
        Schriftart.Select 5
    catch
        Warnlog "Unable to select font in object bar"
    endcatch
    Schriftart.TypeKeys "<Return>"
    Sleep 1
    printlog "  - Font Size"
    '/// Select 10th 'Font Size' in object bar ///
    try
        Schriftgroesse.Select 10
        Schriftgroesse.TypeKeys "<Return>"
    catch
        Warnlog "Uanble to change font size in toolbar"
    endcatch
    Sleep 1
    printlog "  - Bold"
    '/// Select 'Bold' in object bar ///
    Fett.Click
    Sleep 1
    printlog "  - Italic"
    '/// Select 'Italic' in object bar ///
    Kursiv.Click
    Sleep 1
    printlog "  - Underline"
    '/// Select 'Underline' in object bar ///
    Unterstrichen.Click
    Sleep 1
    printlog "  - Align Left"
    '/// Select 'Align Left' in object bar ///
    Linksbuendig.Click
    Sleep 1
    printlog "  - Align Right"
    '/// Select 'Align Right' in object bar ///
    Rechtsbuendig.Click
    Sleep 1
    printlog "  - Centered"
    '/// Select 'Centered' in object bar ///
    Zentriert.Click
    Sleep 1
    if gApplication <> "HTMLDOKUMENT" then
        printlog "  - Justify"
        '/// Select 'Justify' in object bar (not in HTML)///
        Blocksatz.Click
        Sleep 1
    endif
    printlog "  - Font color"
    '/// Select 'Font color' in object bar ///
    Schriftfarbe.Click
    Sleep 1
    printlog "  - Highlighting"
    '/// Select 'Highlighting' in object bar ///
    Zeichenhintergrund.Click
    Sleep 1
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tNumbering
    printlog "- Objectbar ( normal ) : Insert Numbering"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )
    '/// Select 'Numbering' in object bar ///
    Numerierung.Click
    Call wDokSchreiben ("Numbering <Return>", 2)
    '/// Enter word 'Numbering' and '<Return>' two times ///
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tEnumerating
    printlog "- Objectbar ( normal ) : Insert Bullets"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )
    '/// In object bar click 'Bullets' ///
    BulletsOnOff.Click
    Call wDokSchreiben ("Bullets <Return>", 2)
    '/// Enter word 'Bullets' and '<Return>' two times ///
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tIndentIncreaseDecrease
    dim i as Integer

    printlog "- Objectbar ( normal ) : Increase Indent with numbering"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    '/// Click 'Numbering' in object bar ///
    Numerierung.Click
    Sleep 1
	try
        EinzugErhoehen.Click
        '/// Select 'Increase Indent' in object bar (if not possible switch toolbar) ///
    catch
        Warnlog "Unable to select function in Toolbar"
		Call hCloseDocument
		goto endsub
    endcatch

    Sleep 1
    for i=1 to 7
        if EinzugErhoehen.IsEnabled then
            '/// Select 'Increase Indent' 7 times ///
            EinzugErhoehen.Click
        else
            if i = 1 then Warnlog "Increase Indent is disabled !"
        endif
        wait 500
    next i

    printlog "- Objectbar ( normal ) : Decrease Indent with numbering"
    for i=1 to 8
        '/// Select 'Decrease Indent' 8 times ///
        if EinzugVermindern.IsEnabled then
            EinzugVermindern.Click
        else
            if i = 1 then Warnlog "Decrease Indent is disabled !"
        endif
        wait 500
    next i
    '/// Enter '<Return>' 2 times ///
    Call wDokSchreiben ("<Return>", 2)
    Sleep 1

    printlog "- Objectbar ( normal ) : Increase Indent with Bullets"
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    '/// Select 'Bullets' in object bar ///
    BulletsOnOff.Click
    Sleep 1
    for i=1 to 8
        '/// Select 'Increase Indent' 8 times ///
        if EinzugErhoehen.IsEnabled then
            EinzugErhoehen.Click
        else
            if i = 1 then Warnlog "Increase Indent is disabled !"
        endif
        wait 500
    next i

    printlog "- Objectbar ( normal ) : Decrease Indent with Bullets"
    for i=1 to 8
        '/// Select 'Decrease Indent' 8 times ///
        if EinzugVermindern.IsEnabled then
            EinzugVermindern.Click
        else
            if i = 1 then Warnlog "Decrease Indent is disabled !"
        endif
        wait 500
   next i

   Call wDokSchreiben ("<Return>", 2)
   '/// Enter '<Return>' 2 times ///
   Call hCloseDocument
   '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tNumFormatting
    printlog "- Objectbar Numbering : Numbering => Style, Font and Size"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    '/// Select 'Numbering' in object bar ///
    Numerierung.Click
    Sleep 1
    Call wDokSchreiben ("Objectbar Numbering : Numbering => Style, Font and Size <Shift Home>")
    '/// Enter some text in document and select it ///
    Kontext "TextObjectbar"
    printlog "  - Style"
    '/// Change 'Style' in object bar' ///
    try
		Vorlage.Select 1
    catch
        Warnlog "Unable to select function in Toolbar"
		Call hCloseDocument
		goto endsub
    endcatch
    Sleep 1
    printlog "  - Font"
    '/// Change 'Font Style' in object bar' ///
    try
        Schriftart.Select 10
        Schriftart.TypeKeys "<Return>"
    catch
        Warnlog "Unable to select 'Font Style' in object bar"
    endcatch
    Sleep 1
    printlog "  - Font Size"
    '/// Change 'Font Size' in object bar' ///
    try
        Schriftgroesse.Select 10
        Schriftgroesse.TypeKeys "<Return>"
    catch
        Warnlog "Unable to select 'Font Sitze' in object bar"
    endcatch
    Sleep 1
    '/// Enter '<Return>' ///
    Call wDokSchreiben ("<Return>")

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tNumLevelUpDown
    dim i as Integer

    printlog "- Objectbar Numbering : Numbering Level-Up and Down"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    '/// Select 'Numbering' in object bar ///
    Numerierung.Click
    Sleep 1
    
    Kontext "NumObjectbar"
    if Not NumObjectbar.Exists then Call hToolbarSelect("BULLETSANDNUMBERING", true)
    printlog "   - 11 times level down"
    Kontext "NumObjectbar"
    '/// Select 11 times 'Level down' in object bar ///
	try
		Hinunterstufen.Click
    catch
        Warnlog "Unable to select function in Toolbar"
		Call hCloseDocument
		goto endsub
    endcatch

    for i=1 to 9        
		if Hinunterstufen.IsEnabled = True then
            Hinunterstufen.Click
        else
            if i = 1 then Warnlog "Level down is disabled!"
        endif
        wait 500
    next i

    printlog "   - 11 times level up"
    '/// Select 11 times 'Level up' in object bar ///
    for i=1 to 11
        if Hochstufen.IsEnabled then
            Hochstufen.Click
        else
            if i = 1 then Warnlog "Level up is disabled! (#i28550)"
        endif
        wait 500
    next i

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tNumSubpointsUpDown
    dim i as Integer

    printlog "- Objectbar Numbering : Numbering with subpoints up and down"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    Numerierung.Click
    '/// Click 'Numbering' in Object bar ///
    Call wDokSchreiben ("Numbering <Return><Tab>", 2)
    Call wDokSchreiben ("<Tab>Numbering<Up><Up><Up>")
    Sleep 1

    Kontext "NumObjectbar"
    if Not NumObjectbar.Exists then Call hToolbarSelect("BULLETSANDNUMBERING", true)

    printlog "   - 6 times subpoints down"
    '/// click 6 times subpoints down in object bar ///
    if HinunterstufenMitUnterpunkten.IsEnabled then
        HinunterstufenMitUnterpunkten.Click
    else
        if i = 1 then Warnlog "Move up with subpoints is disabled! (#i28550)"
    endif
    wait 500
	
    for i=1 to 5
        if HinunterstufenMitUnterpunkten.IsEnabled then
            HinunterstufenMitUnterpunkten.Click
        else
            if i = 1 then Warnlog "Move down with subpoints is disabled!"
        endif
        wait 500
    next i

    if HinunterstufenMitUnterpunkten.IsEnabled then
        Warnlog "Move down with subpoints is enabled though on Level 10"
    endif
    wait 500
        
    printlog "   - 6 times subpoints up"
    '/// click 6 times subpoints up in object bar ///
    for i=1 to 6
        if HochstufenMitUnterpunkten.IsEnabled then
            HochstufenMitUnterpunkten.Click
        else
            if i = 1 then Warnlog "Move up with subpoints is disabled!"
        endif
        wait 500
    next i

    if HochstufenMitUnterpunkten.IsEnabled then
        Warnlog "Move up with subpoints is enabled!"
    endif
    
    
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tNumMoveUpMoveDown
    dim i as Integer

    printlog "- Objectbar Numbering : Move Numbering up and down"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    Numerierung.Click
    '/// Click 'Numbering' in object bar ///
    Call wDokSchreiben ("Numbering up <Return><Tab>", 3)
    Call wDokSchreiben ("<Tab>Hallo<Return>")
    Call wDokSchreiben ("<Shift Tab>", 5)
    Call wDokSchreiben ("Numbering down <Up><Up>")
    Sleep 1

    printlog "   - 3 times move up"
    '/// click 3 times move up in object bar ///
    Kontext "NumObjectbar"
    if Not NumObjectbar.Exists then Call hToolbarSelect("BULLETSANDNUMBERING", true)
	try
		Hochschieben.Click
    catch
        Warnlog "Unable to select function in Toolbar"
		Call hCloseDocument
		goto endsub
    endcatch
	Hochschieben.Click

    printlog "   - 4 times move down"
    '/// click 4 times move down in object bar ///
    for i=1 to 4
        Hinunterschieben.Click
        Sleep 1
    next i

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tNumSubpointsMoveUpMoveDown
    dim i as Integer

    printlog "- Objectbar Numbering : Move Numbering with subpoints up and down"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    Numerierung.Click
    '/// Click 'Numbering' in object bar ///
    Call wDokSchreiben ("hallo <Return><Tab>", 3)
    Call wDokSchreiben ("<Tab>Hallo<Return>")
    Call wDokSchreiben ("<Shift Tab>", 5)
    Call wDokSchreiben ("Hallo <Up><Up>")
    Sleep 1

    printlog "   - move up 3 times"
    '/// click 3 times move up in object bar ///
    Kontext "NumObjectbar"
    if Not NumObjectbar.Exists then Call hToolbarSelect("BULLETSANDNUMBERING", true)
	try
		HochschiebenMitUnterpunkten.Click
    catch
        Warnlog "Unable to select function in Toolbar"
		Call hCloseDocument
		goto endsub
    endcatch
    HochschiebenMitUnterpunkten.Click

    printlog "   - move down 3 times"
    if Val(mid$(gMinor, 2, Len(gMinor))) >= 139 and Val(mid$(gMinor, 2, Len(gMinor))) <= 140 then
        QAErrorlog "#57856#Loop when moving numbered list up and down with subpoints" 
    else
        '/// click 3 times move down in object bar ///
        for i=1 to 3
            HinunterschiebenMitUnterpunkten.Click
            Sleep 1
        next i
    endif

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tNumUnnumberedEntry
    printlog "- Objectbar Numbering: Paragraph without Numbering"

    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    Numerierung.Click
    '/// Click 'Numbering' in object bar ///
    Call wDokSchreiben ("Paragraph without numbering")
    Kontext "NumObjectbar"
    if Not NumObjectbar.Exists then Call hToolbarSelect("BULLETSANDNUMBERING", true)
    try
        '/// Click 'Insert Unnumbered Entry' ///
        AbsatzOhne.Click
    catch
    	Warnlog "Unable to select function in Toolbar"
    endcatch

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tNumRestartNumbering
    printlog "- Objectbar Numbering: Restart numbering"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    '/// Click 'Numbering' in object bar ///
    Numerierung.Click
    Call wDokSchreiben ("Restart numbering<Return>", 3)
    '/// Enter Text and hit <Return> 3 times ///
    Kontext "NumObjectbar"
    if Not NumObjectbar.Exists then Call hToolbarSelect("BULLETSANDNUMBERING", true)
    try
        '/// Click 'Restart Numbering' in object bar ///
        NeuStarten.Click
    catch
        Warnlog "Unable to select function in Toolbar"
    endcatch

    Call wDokSchreiben ("Restart Numbering<Return>", 3)
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tNumNumberingOff
    printlog "- Objectbar Numbering: Numbering off"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    '/// Click 'Numbering' in object bar ///
    Numerierung.Click
    Call wDokSchreiben ("Numbering Off<Return>", 3)
    '/// Enter Text and hit <Return> 3 times ///
    Kontext "NumObjectbar"
    if Not NumObjectbar.Exists then Call hToolbarSelect("BULLETSANDNUMBERING", true)
    try
        '/// Click 'Numbering off' in objectbar ///
        Ausschalten.Click
    catch
        Warnlog "Unable to select function in Toolbar"
    endcatch

    Call wDokSchreiben ("Numbering Off<Return>", 3)
    '/// Enter Text and hit <Return> 3 times ///
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tNumNumberingEnumerating
    printlog "- Objectbar Numbering: Numbering within a Numbering"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    '/// Click 'Numbering' in object bar ///
    Numerierung.Click
    Kontext
    try
        Active.Setpage TabBullet
        Kontext "TabBullet"
        Warnlog "For some unknown reason the Numbering/Bullets dialog has been opened!"
        TabBullet.Cancel
    catch
    endcatch
    Call wDokSchreiben ("Numbering within a Numbering<Return>")
    '/// Enter text and hit <Return> ///

    Kontext "NumObjectbar"
    if Not NumObjectbar.Exists then Call hToolbarSelect("BULLETSANDNUMBERING", true)
    if NumObjectBar.IsDocked then NumObjectbar.Undock
    try
        '/// Click 'Edit Numbering' in object bar ///
        NumerierungAufzaehlung.Click
        wait 500
    catch
        Kontext
        try
            Active.Setpage TabBullet
            Kontext "TabBullet"
            Warnlog "For some unknown reason the Numbering/Bullets dialog is already opened!"
        catch
    		Warnlog "Unable to select function in Toolbar"
			Call hCloseDocument
			goto endsub
	    endcatch
    endcatch

    Kontext
    '/// Step through all tabpages in 'Numbering/Bullets' dialog ///
    Active.SetPage TabBullet
    Kontext "TabBullet"
    Call DialogTest ( TabBullet )
    Sleep 1

    Kontext
    Active.SetPage TabNumerierungsart
    Kontext "TabNumerierungsart"
    Call DialogTest ( TabNumerierungsart )
    Sleep 1

    Kontext
    Active.SetPage TabNumerierung
    Kontext "TabNumerierung"
    Call DialogTest ( TabNumerierung )
    Sleep 1

    Kontext
    Active.SetPage TabGrafiken
    Kontext "TabGrafiken"
    Call DialogTest ( TabGrafiken )
    Sleep 1

    Kontext
    Active.SetPage TabPositionNumerierung
    Kontext "TabPositionNumerierung"
    Call DialogTest ( TabPositionNumerierung )
    Sleep 1

    Kontext
    Active.SetPage TabOptionenNumerierung
    Kontext "TabOptionenNumerierung"
    Call DialogTest ( TabOptionenNumerierung )
    Sleep 1
    '/// Close 'Numbering/Bullets' dialog ///
    TabOptionenNumerierung.Cancel
    wait 500
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tUpFormatting
    printlog "- Objectbar Numbering : Bullets => Style, Font and -Size"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    '/// Click 'Bullets on/off' in object bar ///
    BulletsOnOff.Click
    Sleep 1
    '/// Enter some text and select it ///
    Call wDokSchreiben ("Bullets => Style, Font and -Size <Shift Home>")
    Kontext "TextObjectbar"
    printlog "  - Style"
    try
		Vorlage.Select 1
    catch
        Warnlog "Unable to select style in Toolbar"
		Call hCloseDocument
		goto endsub
    endcatch
    '/// Select 1st entry in 'Apply Style' ///
    Sleep 5
    printlog "  - Font"
    '/// Select 5th 'Font Name' ///
    try
        Schriftart.Select 5
    catch
        Warnlog "Unable to select font in object bar"
    endcatch
    Schriftart.TypeKeys "<Return>"
    Sleep 1
    printlog "  - Font Size"
    '/// Select 10th 'Font Size' ///
    Schriftgroesse.Select 10
    Schriftgroesse.TypeKeys "<Return>"
    Sleep 1
    '/// Hit <Return> in document ///
    Call wDokSchreiben ("<Return>")

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tUpLevelUpDown
    dim i as Integer

    printlog "- Objectbar Numbering : Bullets level up and down"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    '/// Click 'Bullets on/off' in object bar ///
    BulletsOnOff.Click
    Sleep 1
    Kontext "NumObjectbar"
    if Not NumObjectbar.Exists then Call hToolbarSelect("BULLETSANDNUMBERING", true)

    printlog "   - 11 times level down"
	try
		Hinunterstufen.Click
    catch
        Warnlog "Unable to select function in Toolbar"
		Call hCloseDocument
		goto endsub
    endcatch
		
    for i=1 to 9
        '/// Click 'Down One Level' in object bar 11 times ///
        if Hinunterstufen.IsEnabled then
            Hinunterstufen.Click
        else
            if i = 1 then Warnlog "Level down is disabled !"
        endif
        wait 500
    next i

    printlog "   - 11 times level up"
    '/// Click 'Up One Level' in object bar 11 times ///
    for i=1 to 11
        if Hochstufen.IsEnabled then
            Hochstufen.Click
        else
            if i = 1 then Warnlog "Level up is disabled ! (#i28550)"
        endif
        wait 500
    next i

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tUpSubpointsUpDown
    dim i as Integer

    printlog "- Objectbar Numbering : Bullets with Subpoints up and down"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    '/// Click 'Bullets on/off' in object bar ///
    BulletsOnOff.Click
    '/// Enter some text, hit 'Return' and 'Tab' 2 times ///
    Call wDokSchreiben ("Bullets with Subpoints <Return><Tab>", 2)
    '/// Hit 'Tab', enter some text, and hit 'Cursor Up' 3 times ///
    Call wDokSchreiben ("<Tab>up and down<Up><Up><Up>")
    Sleep 1

    printlog "   - down 6 times"
    '/// Click 'Move Down with Subpoints' 11 times  ///
    Kontext "NumObjectbar"
    if Not NumObjectbar.Exists then Call hToolbarSelect("BULLETSANDNUMBERING", true)
	try
		HinunterstufenMitUnterpunkten.Click
    catch
        Warnlog "Unable to select function in Toolbar"
		Call hCloseDocument
		goto endsub
    endcatch
    Sleep 1    
    
    for i=1 to 5
        if HinunterstufenMitUnterpunkten.IsEnabled then
            HinunterstufenMitUnterpunkten.Click
        else
            if i = 1 then Warnlog "Move with Subpoints down is disabled!"
        endif
        Sleep 1
    next i
    if HinunterstufenMitUnterpunkten.IsEnabled then
        Warnlog "Move with Subpoints down is enabled though on level 10!"
    endif

    printlog "   - up 6 times"
    for i=1 to 6
        '/// Click 'Move Up with Subpoints' 11 times  ///
        if HochstufenMitUnterpunkten.IsEnabled then
            HochstufenMitUnterpunkten.Click
        else
            if i = 1 then Warnlog "Move with Subpoints up is disabled! (#i28550)"
        endif
        Sleep 1
    next i
    if HochstufenMitUnterpunkten.IsEnabled then
        Warnlog "Move with Subpoints up is enabled though on level 1!"
    endif

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tUpMoveUpMoveDown
    dim i as Integer

    printlog "- Objectbar Numbering : move bullets up and down"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    BulletsOnOff.Click
    '/// Click 'Bullets on/off' in object bar ///
    Call wDokSchreiben ("move bullets <Return><Tab>", 3)
    '/// enter some text hit <Return> and <Tab> 3 Times ///
    Call wDokSchreiben ("<Tab>up<Return>")
    '/// Enter one word ///
    Call wDokSchreiben ("<Shift Tab>", 5)
    '/// Hit <Tab> 5 Times ///
    Call wDokSchreiben ("and down <Up><Up>")
    '/// enter text and hit <Cursor Up> 2 times ///
    Sleep 1
    Kontext "NumObjectbar"
    if Not NumObjectbar.Exists then Call hToolbarSelect("BULLETSANDNUMBERING", true)
	printlog "   - 3 times up"
	try
		Hochschieben.Click
    catch
        Warnlog "Unable to select function in Toolbar"
		Call hCloseDocument
		goto endsub
    endcatch

    for i=1 to 2
        '/// Click 'Move Up' in object bar 3 times ///
        Hochschieben.Click
        Sleep 1
    next i

    printlog "   - 4 times down"
    for i=1 to 4
        '/// Click 'Move Down' in object bar 4 times ///
        Hochschieben.Click
        Sleep 1
    next i

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tUpSubpointsMoveUpMoveDown
    dim i as Integer

    printlog "- Objectbar Numbering : Move up and down bullets with subpoints"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    BulletsOnOff.Click
    '/// Click 'Bullets on/off' in object bar ///
    Call wDokSchreiben ("move bullets <Return><Tab>", 3)
    '/// enter some text hit <Return> and <Tab> 3 Times ///
    Call wDokSchreiben ("<Tab>up and down<Return>")
    '/// Enter one word ///
    Call wDokSchreiben ("<Shift Tab>", 5)
    '/// Hit <Tab> 5 Times ///
    Call wDokSchreiben ("with subpoints <Up><Up>")
    '/// enter text and hit <Cursor Up> 2 times ///
    Sleep 1
    printlog "   - move up 3 times"
    Kontext "NumObjectbar"
    if Not NumObjectbar.Exists then Call hToolbarSelect("BULLETSANDNUMBERING", true)
	try
		HochschiebenMitUnterpunkten.Click
    catch
        Warnlog "Unable to select function in Toolbar"
		Call hCloseDocument
		goto endsub
    endcatch

	'/// Click 'Move Up with subpoints' 3 times ///
    HochschiebenMitUnterpunkten.Click

    if Val(mid$(gMinor, 2, Len(gMinor))) >= 139 and Val(mid$(gMinor, 2, Len(gMinor))) <= 140 then
        QAErrorlog "#57856#Loop when moving numbered list up and down with subpoints" 
    else
        printlog "   - move down 3 times"
        for i=1 to 3
            '/// Click 'Move Down with subpoints' 3 times ///
            HinunterschiebenMitUnterpunkten.Click
            Sleep 1
        next i
    endif

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tUpUnnumberedEntry
    printlog "- Objectbar Numbering: Paragraph without Bullets"

    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    BulletsOnOff.Click
    '/// Click 'Bullets on/off' in object bar ///
    Call wDokSchreiben ("Paragraph without Bullets")
    Kontext "NumObjectbar"
    if Not NumObjectbar.Exists then Call hToolbarSelect("BULLETSANDNUMBERING", true)

    try
        '/// Click 'Insert Unnumbered Entry' in object bar ///
        AbsatzOhne.Click
    catch
       	Warnlog "Unable to select function in Toolbar"
    endcatch
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tUpRestartNumbering
    printlog "- Objectbar Numbering: restart Numbering"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    BulletsOnOff.Click
    '/// Click 'Bullets on/off' in object bar ///
    Call wDokSchreiben ("restart Numbering<Return>", 3)
    '/// enter Text and hit <Return> 3 Times ///
    Kontext "NumObjectbar"
    if Not NumObjectbar.Exists then Call hToolbarSelect("BULLETSANDNUMBERING", true)
    try
        '/// Click 'Restart Numbering' in object bar ///
        NeuStarten.Click
    catch
		Warnlog "Unable to select function in Toolbar"
    endcatch

    Call wDokSchreiben ("restart Numbering<Return>", 3)
    '/// enter Text and hit <Return> 3 Times ///
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tUpNumberingOff
    printlog "- Objectbar Numbering: Numbering off"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    BulletsOnOff.Click
    '/// Click 'Bullets on/off' in object bar ///
    Call wDokSchreiben ("Numbering off<Return>", 3)
    '/// enter Text and hit <Return> 3 Times ///
    Kontext "NumObjectbar"
    if Not NumObjectbar.Exists then Call hToolbarSelect("BULLETSANDNUMBERING", true)
    try
        '/// Click 'Numbering off' in object bar ///
        Ausschalten.Click
    catch
		Warnlog "Unable to select function in Toolbar"
    endcatch

    Call wDokSchreiben ("Numbering off<Return>", 3)
    '/// enter Text and hit <Return> 3 Times ///
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tUpNumberingEnumerating
    printlog "- Objectbar Numbering: Numbering and Bullets within numbering"
    Call hNewDocument
    '/// Open new document ///
    Kontext "TextObjectbar"
    if Not TextObjectbar.Exists then Call hToolbarSelect ( "FORMATTING", true )    
    BulletsOnOff.Click
    '/// Click 'Numbering on/off' in object bar ///
    Call wDokSchreiben ("Numbering and Bullets within numbering<Return>")
    '/// enter Text and hit <Return> ///
    Kontext "NumObjectbar"
    if Not NumObjectbar.Exists then Call hToolbarSelect("BULLETSANDNUMBERING", true)
    try
        '/// Click ' Edit Numbering' in object bar ///
        NumerierungAufzaehlung.Click
    catch
		Warnlog "Unable to select function in Toolbar"
		Call hCloseDocument
		goto endsub
    endcatch

	Sleep 1
    '/// In 'Numbering/Bullets' dialog step through all tabpages ///
    Kontext
    Active.SetPage TabBullet
    Kontext "TabBullet"
    Call DialogTest ( TabBullet )

    Kontext
    Active.SetPage TabNumerierungsart
    Kontext "TabNumerierungsart"
    Call DialogTest ( TabNumerierungsart )

    Kontext
    Active.SetPage TabNumerierung
    Kontext "TabNumerierung"
    Call DialogTest ( TabNumerierung )

    Kontext
    Active.SetPage TabGrafiken
    Kontext "TabGrafiken"
    Call DialogTest ( TabGrafiken )

    Kontext
    Active.SetPage TabPositionNumerierung
    Kontext "TabPositionNumerierung"
    Call DialogTest ( TabPositionNumerierung )

    Kontext
    Active.SetPage TabOptionenNumerierung
    Kontext "TabOptionenNumerierung"
    Call DialogTest ( TabOptionenNumerierung )

    '/// Close 'Numbering/Bullets' dialog ///
    TabOptionenNumerierung.Cancel
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tInsertFormula
    printlog "- Table-Objectbar: Formula border in Writer"
    Call hNewDocument
    '/// Open new document ///
    Call hTabelleEinfuegen
    '/// Insert a table ///
	Call hToolbarSelect ( "Table", true )
    '/// Click 'Sum' in object bar ///
    if TableObjectbar.IsVisible = true then
		try
			FormelEingeben.Click
		catch
			Warnlog "Unable to access 'Formula'-Button on toolbar!"
			Call hCloseDocument
			goto endsub
		endcatch
	else
		Warnlog "TableObjectbar is not visible!"
		Call hCloseDocument
		goto endsub
	endif

	Sleep 1
    Kontext "OL_SW_Rechenleiste"
    if OL_SW_Rechenleiste.NotExists then
        QAErrorlog "Formula border doesn't come up"
    else
        '/// Click 'Cancel' in object bar ///
        Verwerfen.Click
    endif

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tMergeCells
    printlog "- Table-Objectbar: Merge Cells"
    Call hNewDocument
    '/// Open new document ///
    Call hTabelleEinfuegen
    '/// Insert a table ///
    Call wDokSchreiben ("<Shift Right>", 2)
    '/// Hit <Shift Right> 2 times ///
    Sleep 2
	Call hToolbarSelect ( "Table", true )
    if TableObjectbar.IsVisible = true then
    	ZellenVerbinden.Click
	else
		Warnlog "TableObjectbar is not visible!"
		Call hCloseDocument
		goto endsub
	endif
        
    '/// Click 'Merge cells' in object bar ///
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tSplitCells
    printlog "- Table-Objectbar: Split Cells"
    Call hNewDocument
    '/// Open new document ///
    Call hTabelleEinfuegen
    '/// Insert a table ///
	Call hToolbarSelect ( "Table", true )
    '/// Click 'Split Cells' in object bar ///
    if TableObjectbar.IsVisible = true then
    		ZelleTeilen.Click
	else
		Warnlog "TableObjectbar is not visible!"
		Call hCloseDocument
		goto endsub
	endif
    '/// Cancel upcoming dialog ///
    Kontext "ZellenTeilen"
    ZellenTeilen.Cancel
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tOptimize
    printlog "- Table-Objectbar: Optimize Table"
    Call hNewDocument
    '/// Open new document ///
    Call hTabelleEinfuegen
    '/// Insert a table and select all in document ///
    Call wDokSchreiben ("<Mod1 A>")
	Call hToolbarSelect ( "Table", true )
    wait 500
    '/// Tear Off toolbar 'Optimize' ///
    Kontext "TableObjectBar"
    try
        Optimieren.TearOff
    catch
        Warnlog "Unable to Tear Off Toolbox 'Optimize'"
        Call hCloseDocument
        goto endsub
    endcatch
    Call wDokSchreiben ("<Mod1 a>")
    Sleep 1

    Kontext "OptimizeTablebar"
    '/// Click 'Space Columns Equally' ///
    SpaltenGleichmaessig.Click
    '/// Click 'Space Rows Equally' ///
    ZeilenGleichmaessig.Click
    Sleep 2
    '/// Click 'Optimal Row Height' ///
    OptimaleZeilenhoehe.Click

    Call wDokSchreiben ("Optimize Table")
    '/// Enter some text ///
    Sleep 1
    Kontext "OptimizeTablebar"
    '/// Click 'Optimal Column Width' ///
    OptimaleSpaltenbreite.Click
    Sleep 1
    '/// Close toolbar 'Optimize' ///
    OptimizeTablebar.Close
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tInsertCellRow
    printlog "- Table-Objectbar: Insert Cell"
    Call hNewDocument
    '/// Open new document ///
    Call hTabelleEinfuegen
    '/// Insert Table ///
	Call hToolbarSelect ( "Table", true )
    if TableObjectbar.IsVisible = true then
    		ZeileEinfuegen.Click
	else
		Warnlog "TableObjectbar is not visible!"
		Call hCloseDocument
		goto endsub
	endif

    '/// Click 'Insert Column' in object bar ///
    Sleep 1
    printlog "- Table-Objectbar: Insert Row"
    SpalteEinfuegen.Click
    '/// Click 'Insert Row' in object bar ///
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tDeleteRow
    printlog "- Table-Objectbar: Delete Row"
    Call hNewDocument
    '/// Open new document ///
    Call hTabelleEinfuegen
    '/// Insert a table ///
    Call hToolbarSelect ( "Table", true )	
    '/// Click 'Delete Row' ///
    if TableObjectbar.IsVisible = true then
    		ZeileLoeschen.Click
	else
		Warnlog "TableObjectbar is not visible!"
		Call hCloseDocument
		goto endsub
	endif

    Sleep 1
    ZeileLoeschen.Click
    '/// Click 'Delete Row' ///
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tDeleteColumn
    dim i as Integer
    printlog "- Table-Objectbar: Delete Column"
    Call hNewDocument
    '/// Open new document ///
    Call hTabelleEinfuegen
    '/// Insert a table ///
    '/// Click 'Delete Column' 2 times ///
    for i=1 to 2
        Call hToolbarSelect ( "Table", true )
        if TableObjectbar.IsVisible = true then
            SpalteLoeschen.Click
        else
            Warnlog "TableObjectbar is not visible!"
            Call hCloseDocument
            goto endsub
        endif        
        Sleep 1
    next i
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tGraphicWrap
    printlog "- Grafik-(Rahmen)-Objectbar: Wrap"
    Call hNewDocument
    '/// Open new document ///
    Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    '/// Insert graphic 'writer/input/grafik/jolink.jpg' ///
    Call hToolbarSelect("Frame", true)
    try
        '/// Check 'Wrap Off' in object bar ///
        NoWrap.Click
        Sleep 1
    catch
        Warnlog "'Wrap Off' in Objectbar couldn't be checked"
    endcatch

    if gApplication <> "HTMLDOKUMENT" then
        try
            Durchlauf.Click
            '/// Check 'Wrap through' in object bar ///
            Sleep 1
        catch
            Warnlog "'Wrap through' in Objectbar couldn't be checked"
        endcatch

        try
            Wrap.Click
            '/// Check 'Wrap On' in object bar ///
            Sleep 1
        catch
            Warnlog "'Wrap on' in Objectbar couldn't be checked"
        endcatch
    else
        Call hToolbarSelect("Picture", true)    
        try
            WrapLeft.Click
            '/// Check 'Wrap Left' in object bar ///
            Sleep 1
        catch
            Warnlog "'Wrap Left' in Objectbar couldn't be checked"
        endcatch

       try
            '/// Check 'Wrap Right' in object bar ///
            WrapRight.Click
            Sleep 1
        catch
            Warnlog "'Wrap Right' in Objectbar couldn't be checked"
        endcatch
    endif

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tGraphicAlign
    printlog "- Graphic-(Frame)-Objectbar: Align"
    Call hNewDocument
    '/// Open new document ///
    Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    '/// Insert graphic 'writer/input/grafik/jolink.jpg' ///

    Call hToolbarSelect("Frame", true)
    try
        Links.Click
        '/// Click 'Left' in object bar ///
        Sleep 1
    catch
        Warnlog "'Left' in Objectbar couldn't be checked"
    endcatch

    try
        Rechts.Click
        '/// Click 'Right' in object bar ///
        Sleep 1
    catch
        Warnlog "'Right' in Objectbar couldn't be checked"
    endcatch

    ' Only Left and Right in WriterWeb
    if gApplication = "HTMLDOKUMENT" then
        Call hCloseDocument
        '/// Close active document ///
        goto endsub
    endif

    try
        '/// Click 'Centered' in object bar (Not WriterWeb) ///
        Zentriert.Click
        Sleep 1
    catch
        Warnlog "'Centered' in Objectbar couldn't be checked"
    endcatch

    try
        Mitte.Click
        '/// Click 'Center' in object bar (Not WriterWeb) ///
        Sleep 1
    catch
        Warnlog "'Center' in Objectbar couldn't be checked"
    endcatch

    try
        Oben.Click
        '/// Click 'Top' in object bar (Not WriterWeb) ///
        Sleep 1
    catch
        Warnlog "'Top' in Objectbar couldn't be checked"
    endcatch

    try
        Unten.Click
        '/// Click 'Bottom' in object bar (Not WriterWeb) ///
        Sleep 1
    catch
        Warnlog "'Bottom' auf Objectbar couldn't be checked"
    endcatch

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tGraphicFlip
    printlog "- Graphic-(Frame)-Objectbar: Flip"
    if gApplication = "HTMLDOKUMENT" then
        Printlog "Not in WriterWeb!"
        goto endsub
    endif

    Call hNewDocument
    '/// Open new document ///
    Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    '/// Insert graphic 'writer/input/grafik/jolink.jpg' ///

    Call hToolbarSelect("Picture", true)
    try
        HorizontalSpiegeln.Click
        '/// Click 'Flip Horizontal' in object bar ///
        Sleep 1
    catch
        Warnlog "'Flip Horizontal' in Objectbar couldn't be checked"
    endcatch

    try
        VertikalSpiegeln.Click
        '/// Click 'Flip Vertical' in object bar ///
        Sleep 1
    catch
        Warnlog "'Flip vertical' in Objectbar couldn't be checked"
    endcatch

    try
        '/// Click 'Flip Horizontal' in object bar ///
        HorizontalSpiegeln.Click
        Sleep 1
        '/// Click 'Flip Vertical' in object bar ///
        VertikalSpiegeln.Click
        Sleep 1
    catch
    endcatch

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tGraphicArrange
    printlog "- Graphic-(Frame)-Objectbar: Arrange"
    Call hNewDocument
    '/// Open new document ///
    Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    '/// Insert graphic 'writer/input/grafik/jolink.jpg' ///

    Call hToolbarSelect("Frame", true)
    try
        GanzNachHinten.Click
        '/// Click 'Send to back' in object bar ///
        Sleep 1
    catch
        Warnlog "'Send to back' in Objectbar couldn't be checked"
    endcatch

    try
        GanzNachVorn.Click
        '/// Click 'Bring to front' in object bar ///
        Sleep 1
    catch
        Warnlog "'Bring to front' in Objectbar couldn't be checked"
    endcatch

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tGraphicBorders
    printlog "- Graphic-(Frame)-Objectbar: Border"
    Call hNewDocument
    '/// Open new document ///
    Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    '/// Insert graphic 'writer/input/grafik/jolink.jpg' ///
    Call hToolbarSelect("Frame", true)
    try
        '/// Tear off Toolbox Border ///
        Umrandung.TearOff
        Sleep 1
        Kontext "TB_Umrandung"
        TB_Umrandung.Move ( 20, 20 )
        '/// Close toolbox ///
        TB_Umrandung.Close
        Sleep 1
    catch
        Warnlog "Error in Toolbox Border"
    endcatch

    try
        Kontext "FrameObjectbar"
        '/// Tear off toolbox 'Borderstyle' ///
        Linienstil.TearOff
        Sleep 1
        Kontext "TB_Umrandungsstil"
        TB_Umrandungsstil.Move ( 20, 20 )
        '/// Close toolbox ///
        TB_Umrandungsstil.Close
        Sleep 1
    catch
        QAErrorlog "#i78975#Error in Toolbox Borderstyle"
    endcatch

    try
        Kontext "FrameObjectbar"
        '/// Tear off Toolbox 'Color' ///
        LinienFarbe.TearOff
        Sleep 1
        Kontext "TB_Farbe"
        TB_Farbe.Move ( 20, 20 )
        TB_Farbe.Close
        '/// Close toolbox ///
        Sleep 1
    catch
		QAErrorlog "#i78975#Error in Toolbox Colour"
    endcatch

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tGraphicProperties
    printlog "- Graphic-(Frame)-Objectbar: Properties"
    Dim j as integer
    
    Call hNewDocument
    '/// Open new document ///
    Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    '/// Insert graphic 'writer/input/grafik/jolink.jpg' ///
    Call hToolbarSelect("Picture", true)
    try
        InsertGraphic.Click
        '/// Click 'Graphic Properties' in object bar ///
    catch
        Warnlog "Error in Objectproperties in Objectbar"
        Call hCloseDocument
        '/// Close active document ///
        goto endsub
    endcatch

    '/// In 'Graphic' dialog step through all tabpages ///
    Kontext
    active.SetPage TabType
    Kontext "TabType"
    Call DialogTest ( TabType )

    Kontext
    active.SetPage TabZusaetze
    Kontext "TabZusaetze"
    Call DialogTest ( TabZusaetze )

    Kontext
    active.SetPage TabUmlauf
    Kontext "TabUmlauf"
    Call DialogTest ( TabUmlauf )

    Kontext
    active.SetPage TabHyperlinkRahmen
    Kontext "TabHyperlinkRahmen"
    Call DialogTest ( TabHyperlinkRahmen )

    Kontext
    active.SetPage TabGrafik
    Kontext "TabGrafik"
    Call DialogTest ( TabGrafik )

    Kontext
    active.SetPage TabUmrandung
    Kontext "TabUmrandung"
    Call DialogTest ( TabUmrandung )

    Kontext
    active.SetPage TabMakro
    ' if no JRE is installed a messagebox appears
    Do
        j = j + 1
        Kontext "Active"
        if Active.Exists then
            if Active.GetRT = 304 then
                if j = 1 then Warnlog Active.Gettext    
                Active.Ok
            else
                exit do
            endif                    
        else
            exit do
        endif
    Loop
    Kontext "TabMakro"
    Call DialogTest ( TabMakro )

    if gApplication <> "HTMLDOKUMENT" then
        Kontext
        active.SetPage TabHintergrund
        Kontext "TabHintergrund"
        Call DialogTest ( TabHintergrund )

        Kontext
        active.SetPage TabZuschneiden
        Kontext "TabZuschneiden"
        Call DialogTest ( TabZuschneiden )
        TabZuschneiden.Cancel
    else
        TabMakro.Cancel
    endif
    '/// Close 'Graphic' dialog ///
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tGraphicAnchor
    printlog "- Graphic-(Frame)-Objectbar: Anchor"
    Call hNewDocument
    '/// Open new document ///
    Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    '/// Insert graphic 'writer/input/grafik/jolink.jpg' ///

    Call hToolbarSelect("Frame", true)
    Sleep 2
    try
        VerankerungWechseln.Click
        '/// Click 'Change Anchor' in object bar ///
    catch
        Warnlog "Error on anchoring objects"
        Call hCloseDocument
        '/// Close active document ///
        goto endsub
    endcatch
    Sleep 1
    '/// Select Anchor 'to page' ///
    MenuSelect ( MenuGetItemID (1) )
    Sleep 1
    Kontext "FrameObjectbar"
    VerankerungWechseln.Click
    '/// Select Anchor 'Paragraph' ///
    MenuSelect ( MenuGetItemID (2) )
    Sleep 1
    Kontext "FrameObjectbar"
    VerankerungWechseln.Click
    '/// Select Anchor 'To Character' ///
    MenuSelect ( MenuGetItemID (3) )
    Sleep 1
    Kontext "FrameObjectbar"
    VerankerungWechseln.Click
    '/// Select Anchor 'As Character' ///
    MenuSelect ( MenuGetItemID (4) )
    Sleep 1

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormulaCancel
    printlog "- Formula Writer: Cancel"
    Call hNewDocument
    '/// Open new document ///
    Call wDokSchreiben ("<F2>")
    '/// Press <F2> ///

    Kontext "OL_SW_Rechenleiste"
    Eingabefeld.TypeKeys "=summe(a+b)"
    '/// enter a formula ///
    Verwerfen.Click
    '/// Click 'Cancel' in formula bar ///
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormulaApply
    printlog "- Formula Writer: Apply"
    Call hNewDocument
    '/// Open new document ///
    Call hTabelleEinfuegen
    '/// Insert a table ///
    Call wDokSchreiben ("12<Right>13<Down>")
    '/// Write in document 12<Cursor Right>13<Cursor Down> ///
    Call hToolbarSelect ( "Table", true )
    '/// Click 'Sum' in object bar ///
    if TableObjectbar.IsVisible = true then
    		FormelEingeben.Click
	else
		Warnlog "TableObjectbar is not visible!"
		Call hCloseDocument
		goto endsub
	endif

    Kontext "OL_SW_Rechenleiste"
    Eingabefeld.TypeKeys "(" + Chr(60)+ "A1:B1"
    Eingabefeld.TypeKeys Chr(62) + ")"
    '/// Enter as formula (A1:B1) and click 'Apply' ///
    Uebernehmen.Click
    Sleep 2
    '/// Check result of formula ///
    Call wDokSchreiben ("<Mod1 A>")
    EditCopy
    if GetClipboardText <> "25" then 
        QAErrorlog "#i80314#Not possible to calculate in tables anymore. Result isn't 25, is: " + GetClipboardText
    endif
    Call hCloseDocument
    '/// Close active document ///
endcase
