'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: docbook_001.inc,v $
'*
'*  $Revision: 1.10.10.2 $
'*
'*  last change: $Author: jsi $ $Date: 2008/03/10 12:51:36 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Library for DocBook XML Im-/Export Test
'*
'************************************************************************
'*
' #1 tDocBookXMLtestdocs        'Main start routine for DocBook XML test 
' #1 fLoadDocBookXMLAndSaveIt   'Testcase <function> for loading and saving 
'*
'\***********************************************************************

sub tDocBookXMLtestdocs
    Dim sSourceDocuments(500) as string
    Dim i as integer, iNumberOfDocuments as integer

    '/// Checking under Tools -> XML Filter Settings that the DocBook XSLT Filter
    '///+ has been installed. If not install them from <i>global\input\xslt_stylesheets\docbook_xhtml.jar</i>.
    if fInitialXMLSetting("docbook") = FALSE then
        warnlog "The DocBook XSLT filter has not been installed!"
        warnlog "Aborting!"
        exit sub
    end if    
    '/// Calculating how many documents are in that directory (max. 500)
    if hDirectoryExists(sSourcePath) then
        '/// Get the file list and put it in a list (max. 500 per directory!).
        call GetAllFileList(sSourcePath, "*.xml" , sSourceDocuments())  
        iNumberOfDocuments = ListCount(sSourceDocuments())
        printlog iNumberOfDocuments & " DocBook XML files found in " & sSourcePath & "."  
        if iNumberOfDocuments > 0 then
            for i = 2 to iNumberOfDocuments
                '/// Call the testcase with each document.                                 
                call fLoadDocBookXMLAndSaveIt(sSourceDocuments(i))
            next i
        else
            warnlog "Path " & sSourcePath & " contains no documents!"
        end if
    else
        warnlog "Path " & sSourcePath & " has not been found!"
    end if
end sub

'-------------------------------------------------------------------------

testcase fLoadDocBookXMLAndSaveIt(sSourceDocument as string)            
Dim sExpFileName as string
Dim sFileName as string
 
sFileName = DateiExtract(sSourceDocument)
sExpFileName = sDestinationPath & sFileName

    '/// Loading the file.
    printlog "Loading " & sFileName & "."
    call hDateiOeffnen (sSourceDocument)
    '/// If the document can not be loaded as XML file (wrong Doctype) it will be loaded as ASCII.
    Kontext "AsciiFilterOptionen"
    if AsciiFilterOptionen.Exists(2) then
        AsciiFilterOptionen.Cancel
        QAErrorLog "The DTD may be does not match. Work around is to load it as ASCII file."
        Goto Endsub
    end if
    '/// If the Filter Selection dialog occours the test will try to select the 'DocBook' entry. 
    Kontext "FilterAuswahl" 
    if FilterAuswahl.Exists(2) then
        QAErrorLog "Filter selection dialog occoured!"
        Filter.Select "DocBook"
        FilterAuswahl.OK
    end if   
    if IsItLoaded = TRUE then
        sleep(3)
        'If there is no document being loaded only the 'backing window' would be visible
        if GetDocumentCount = 0 then
            warnlog "Document " & sFileName & " has not been loaded! It won't be exported! verify manually!" 
        else
            printlog "Saving as " & sExpFileName       
            '/// Saving the document in the work directory.
            if hSpeichernUnterKill(sExpFileName) = TRUE then
                printlog "global::tools::inc::t_files.inc::IsItSaved"
                call IsItSaved
                sleep(3)
                '/// Closing the document also if there is a verification dialog.
                call hCloseAndLooseDocument
                sleep(3)     
                if XMLWellformed (sExpFileName) = FALSE then
                    '/// Checking the well formness of the saved document.
                    warnlog "XML-file " & sExpFileName & " not well formed or does not exist!"
                else
                    '/// Open the exported document.
                    call hDateiOeffnen (sExpFileName)                    
                    Kontext "FilterAuswahl" 
                    if FilterAuswahl.Exists(2) then
                        QAErrorLog "Filter selection dialog occoured!"
                        Filter.Select "DocBook"
                        FilterAuswahl.OK
                    end if
                    if IsItLoaded = TRUE then
                        sleep(3)
                        if GetDocumentCount = 0 then
                            warnlog "EXPORTED document " & sExpFileName & " has not been loaded! It won't be exported! verify manually!" 
                        else
                            '/// Closing the exported document.
                            call hCloseDocument                        
                        end if
                    else
                        warnlog "Loading exported DocBook XML file was not successfull!"
                    end if
                end if
            else
                warnlog "Exporting XML file (" & sExpFileName & ") failed!"                    
            end if
        end if
    else
        warnlog "It was not possible to load the document!"
    end if
endcase  

'-------------------------------------------------------------------------

