'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_xml_vertical_alignment.inc,v $
'*
'*  $Revision: 1.2.2.2 $
'*
'*  last change: $Author: jsi $ $Date: 2008/03/07 14:47:21 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : testing vertical alignment in writer 
'*
'*************************************************************************************************
'*
' #1 tVerticalAlignmentWriter  'Testing for vertical alignment in writer
'*
'\*************************************************************************************************

testcase tVerticalAlignmentWriter

    '/// Dimensioning variables
    dim iSaxSeekIndex as INTEGER        'counter-variable for searching through the styles:styles
    dim sSaveAsFile as STRING           'TestDoc is going to be saved with this name
    dim sWriterContentXML as STRING     'Location of the content.xml
    dim sLoadFileName as STRING         'Variable for name of the Testdoc
    dim sUnpackStorageDir as STRING     'Name of the direcotry where the xml file is being unpacked
    dim sAttrValue as STRING            'Name of the variable to store the searched value in
    Dim xXMLStyleName as STRING         'Draw:Style-name to be searched for
    Dim iChildCount as INTEGER          'Counter for SAX Child nodes
    
    '///Setting paths and variables
    sSaveAsFile = gOfficePath & ConvertPath("user\work\VerticalAlignment.odt")
    printlog "Save-path is " & sSaveAsFile
    sUnpackStorageDir = gOfficePath & ConvertPath("user\work\VerticalAlignment")
    printlog "UnpackStorageDir is " & sUnpackStorageDir    
    printlog "Used Save-As Filter is " & gWriterFilter
    sWriterContentXML = gOfficePath & ConvertPath("user\work\VerticalAlignment\content.xml")
    printlog "ContentXML File is to be found in " & sWriterContentXML
    sLoadFileName = ConvertPath (gTesttoolPath + "xml\level1\input\writer\verttoline1.doc")
    printlog "The used TestDoc is " & sLoadFileName
            
    '//Checking if Storage Directory is empty
    if Dir(sUnpackStorageDir) <> "" then
        printlog "UnpackStorageDir was not empty, deleting."
        RmDir (sUnpackStorageDir)
    else
        printlog "UnpackStorageDir is emtpy."
    endif
    
    '///Loading Test-Document
    if hDateiOeffnen (sLoadFileName) = FALSE then
        warnlog "Loading File failed!"
    else
        printlog "File " & sLoadfileName & " loaded."
        
        '/// Saving document
        if hSpeichernUnterMitFilterKill (sSaveAsFile , gWriterFilter) = FALSE then
            warnlog "Saving " & sSaveAsFile & " failed! -> Exiting test!"
            call hCloseDocument
        else
            printlog "Saving file as " & sSaveAsFile & "."
            printlog "Closing Document."
            call hCloseDocument
        endif
    endif
    
    '/// <i>Unzip</i> or <i>unjar</i> the <i>gOfficePath</i>/user/work/VerticalAlignment.odt
    '///+ into the directory <i>gOfficePath</i>/user/work/VerticalAlignment
    printlog "Unpack storage of test document."
    UnpackStorage(sSaveAsFile, sUnpackStorageDir)
    printlog "Read the test documents DOM."
    
    '/// Use an <i>XML editor</i> like <i><a href="http://www.jedit.org">jEdit</a></i> and open the
    '///+ <i>structure</i> of the XML file <i>gOfficePath</i>/user/work/VerticalAlignment/Object 1/content.xml
    printlog "opening XML file and creating DOM."
    SAXReadFile(sWriterContentXML)
    sleep(2)
    printlog "Going to root node."
    SAXSeekElement("/")
    
    '/// Getting Draw style name to search the attribute in
    '///+<ul><li>office:document-content
    printlog "Searching for draw:style-name to be used..."
    SAXSeekElement("office:document-content")
    '///+<ul><li>office:body
    SAXSeekElement("office:body")
    '///+<ul><li>office:text
    SAXSeekElement("office:text")
    '///+<ul><li>text:p
    SAXSeekElement("text:p" , 1)
    '///+<ul><li>draw:frame
    SAXSeekElement("draw:frame" , 1)
    '///+<ul><li>draw:style-name
    xXMLStyleName = SAXGetAttributeValue("draw:style-name")
    printlog "draw:style-name to search for is " & xXMLStyleName & "."
    '///+ Searching for: style:vertical-pos=&quot;from-top&quot;
    '///+</li></ul></li></ul></li></ul></li></ul></li></ul></li></ul>
    
    '/// Setting parser back to root node
    SAXSeekElement("/")
    '///+<ul><li>office:document-content
    printlog "Seeking office:document-content."
    SAXSeekElement("office:document-content")
    
    '///+<ul><li>office:automatic-styles
    printlog "Seeking office:automatic-styles."
    SAXSeekElement("office:automatic-styles")
     
    '///+<ul><li>style:style
    printlog "Searching through style:style elements."
    
    '///+...in one of the 4 style:style elements there should be a</li>
    iChildCount = SAXGetChildCount
    printlog "There are " & iChildCount & " Childnodes."
    for iSaxSeekIndex = 1 to iChildCount
        SAXSeekElement(iSaxSeekIndex)
        if SAXGetAttributeValue("style:name") = xXMLStyleName then
            SAXSeekElement("style:graphic-properties")
                
            '///+<ul><li>style:graphic-properties 
            '///+with the value <b>from-top</b></li>
            '///+</li></ul></li></ul></ul></li></ul></ul>
            printlog "Seeking for style:vertical-pos."
            if SaxGetAttributeName(5) = "style:vertical-pos" then
                printlog "Found attribute 'style:vertical-pos' in childnode " & iSaxSeekIndex & "."
                printlog "Getting value from style:vertical-pos."
                sAttrValue = SAXGetAttributeValue("style:vertical-pos")
                printlog "Value is " & sAttrValue & "."
                'lcase(sAttrValue)
                if sAttrValue = "from-top" then
                    printlog "Expected value of 'style:vertical-pos' = from-top was found."
                    printlog "Ending test."
                    exit for
                else
                    warnlog "Expected value of 'style:vertical-pos' = from-top was not found!"
                endif
                
            else
                printlog "Attribut style:vertical-pos not found in element " & iSaxSeekIndex & "."
            endif
            SAXSeekElement(0) 
        endif
        SAXSeekElement(0)
    next iSaxSeekIndex
    SAXRelease
endcase
