/* Mercator.java
 * Copyright (C) 1996 by William Giel
 *
 * E-mail: rvdi@usa.nai.net
 * WWW: http://www.nai.net/~rvdi/home.htm
 *
 ***************************************************************************
 * Abstract
 * --------
 * Mercator projection methods (forward and inverse), extends MapProjection
 * class
 *
 * Ref: Thomas, Paul D., Conformal Projections in Geodesy and Cartography,
 * Spec. Publ. 251, U.S. Dept. of Commerce, Coast and Geodetic Survey,
 * Rockville, Md., 1952
 ***************************************************************************
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee for NON-COMMERCIAL purposes is hereby granted.
 * 
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 ***************************************************************************/
 
import java.awt.*;

import MapProjection;

public class Mercator extends MapProjection
{
    Mercator(mappingData data)
    {
        super(data);
    }
    
	double term2(double latitude)
	{
		double sinlat = Math.sin(latitude);
		return Math.pow(1-e*sinlat/1+e*sinlat,e/2.0);
	}

	double isometricLatitude(double latitude)
	{
		return Math.log(Math.tan(Math.PI/4.0 + latitude/2)*term2(latitude));
	}

	public geoPos inverse(Point xy)
	{
        //This was developed by the author, and was not obtained from the
	    //cited reference. If there's a better way, let me know.
	    
		double Y = MAP_SCALE * (double)(FALSE_NORTHING-xy.y);
		double q = Y/a; //isometric latitude
		double approx_latitude = 2.0 * (Math.atan(Math.exp(q)) - Math.PI/4.0);
		for(int i=0;i<ITERATIONS;i++)
			approx_latitude=2*(Math.atan(Math.exp(q)/term2(approx_latitude)) - Math.PI/4.0);

		double X = MAP_SCALE * (double)(FALSE_EASTING-xy.x);
		return new geoPos(approx_latitude*180.0/Math.PI,((X/a) * 180.0/Math.PI)+PRIME_MERIDIAN);
	}

	public Point forward(geoPos latlong)
	{
		double latitude = latlong.latitude * Math.PI/180.0;
		double longitude = (latlong.longitude-PRIME_MERIDIAN) * Math.PI/180.0;
		double q = isometricLatitude(latitude);
		double Y = a * q;

		return new Point((int)(FALSE_EASTING - a*longitude/MAP_SCALE),
		                                            (int)(FALSE_NORTHING - Y/MAP_SCALE));

	}
}
