
import java.lang.*;

import Format;


///////////////////////////////////////////////////
//Exception subclass to handle invalid angle input
///////////////////////////////////////////////////
class Invalid_Angular_Data extends Exception
{
   	Invalid_Angular_Data(String s){super(s);}
}


////////////////////////////////////////////////////
//Contains static methods to convert DDMMSS.SSS...
//angular input to decimal degrees, and back.
////////////////////////////////////////////////////
public class dms
{

   	//////////////////////////////////////////////////
   	//Converts a double value of decimal degrees to
   	//degrees, minutes, and seconds, with the seconds
   	//displayed to the specified precision, in the range
   	// 0 (incl.) to 360 (excl.) Includes, degree, minute
    // and second punctuation.
   	//////////////////////////////////////////////////
    public static String decdeg2dms(double angle, int prec)
    {
    	return decdeg2dms(angle,prec,true);
    }

   	//////////////////////////////////////////////////
   	//Converts a double value of decimal degrees to
   	//degrees, minutes, and seconds, with the seconds
   	//displayed to the specified precision, in the range
   	// 0 (incl.) to 360 (excl.) Can includes, degree, minute
    // and second punctuation, or no punctuation, depending
    // on argument "punctuate"
   	//////////////////////////////////////////////////	
    public static String decdeg2dms(double angle, int prec,boolean punctuate)
    {

    	boolean negative=false;

    	if(angle < 0){
    		negative = true;
    		angle *= -1.0;
    	}
    	
    	long degrees = (long)angle;

    	angle = (angle-(double)degrees) * 60.0;

    	long minutes = (long)angle;

    	angle = (angle-(double)minutes) * 60.0;

		angle = ((double)Math.round(angle * Math.pow(10,prec)))/Math.pow(10,prec);

		if ( (long)angle == 60L ){
			angle-=60.0;
			minutes++;
		}
    	
    	if(minutes >= 60L){
    		degrees++;
    		minutes=0L;
    	}

    	while ( degrees >= 360L ) degrees -= 360L;

		if(punctuate)
    		return new String( 	((negative)?"-":" ") +
    							Long.toString(degrees) + " " +
    							((minutes<10)? "0":"")+
    							Long.toString(minutes) + "' " +
    							((Double.valueOf(Format.toString(angle,prec)).doubleValue()<10)?"0":"")+
    							Format.toString(angle,prec) + "''" );
    	else
    		return new String( 	((negative)?"-":" ")  +
    							Long.toString(degrees)+
    							((minutes<10)? "0":"")+
    							Long.toString(minutes)+
    							((Double.valueOf(Format.toString(angle,prec)).doubleValue()<10)?"0":"")+
    							Format.toString(angle,prec));    		
    }

	///////////////////////////////////////////////////////
	//Converts angular input from DDMMSS.SSS... format
	//to a double value in decimal degrees.
	//
	//The functionality of this code is somewhat obfuscated
	//by all the error checking, but we need it in the real
    //world!
	///////////////////////////////////////////////////////
	public static double dms2decdeg(String d_str) throws Invalid_Angular_Data
	{
		String seconds,dec_seconds,minutes,degrees;
		int sign=1;
		int degs, mins, secs;
		double dec_secs;
		int startIndex,endIndex;

		////////////////////////////////////////
		//remove any leading or trailing spaces!
		////////////////////////////////////////
		d_str=d_str.trim();

		////////////////////////
		//Check for empty string
		////////////////////////
		if (d_str.length()==0)
			throw new Invalid_Angular_Data("No value!");

		/////////////////////////////////////////////////////////
		//Now check for any non-numeric characters...a single '.'
		//and a leading '-' or '+' are allowed, of course.
		/////////////////////////////////////////////////////////
		boolean decimalFlag=false;
		String allowed = new String("+-.0123456789");
		for(startIndex=0;startIndex<d_str.length();startIndex++){
			
			//////////////////////////////////////////
			//Simplest case... a non-numeric character
			//////////////////////////////////////////
			if(allowed.indexOf(d_str.substring(startIndex,startIndex+1))== -1)
				throw new Invalid_Angular_Data("non-numeric in " + d_str);
				
			///////////////////////////////////////////////
			//If a decimal point, it must be the only one,
			//and some numbers must follow it. This code
			//will cause any value entered with a trailing
			//decimal point to be invalid, i.e. 410200.
			//(so don't do that!)
			///////////////////////////////////////////////
			if(allowed.indexOf(d_str.substring(startIndex,startIndex+1))== 2){
				if(decimalFlag==false){
					if(d_str.substring(startIndex,d_str.length()).length()==1)
						throw new Invalid_Angular_Data("nothing follows decimal in" + d_str);
						else decimalFlag=true;
				}
				else throw new Invalid_Angular_Data("multiple decimal points in " + d_str);
			}

			///////////////////////////////////////////////////////////
			//If a minus or plus sign, it must be the first character,
			//and have some numbers following it. If the number is
			//negative, set our sign flag to -1.
			///////////////////////////////////////////////////////////
			if(allowed.indexOf(d_str.substring(startIndex,startIndex+1))== 0
					|| allowed.indexOf(d_str.substring(startIndex,startIndex+1))== 1){
				if(startIndex!=0)
					throw new Invalid_Angular_Data("misplaced sign in " + d_str);
				if(d_str.length()==1)
					throw new Invalid_Angular_Data("nothing follows sign in '" + d_str + "'");
				else if(allowed.indexOf(d_str.substring(startIndex,startIndex+1))== 1)
					sign=-1;
			}
		}
		/////////////////////////////////////////////////
		//Replace any leading sign character with a zero.
		/////////////////////////////////////////////////
		d_str=d_str.replace('-','0');
		d_str=d_str.replace('+','0');

		///////////////////////////////////////////
		//Pad with leading zeros to make life easy!
		///////////////////////////////////////////
		d_str="0000000" + d_str;

		//////////////////////////
		//Find any decimal seconds
		//////////////////////////
		if((startIndex=d_str.indexOf(".")) != -1){
			dec_seconds=d_str.substring(startIndex,d_str.length());
			d_str=d_str.substring(0,startIndex);
		}
		else dec_seconds="0";

		endIndex=d_str.length(); 
		seconds=d_str.substring(endIndex-2,endIndex);
		minutes=d_str.substring(endIndex-4,endIndex-2);
		degrees=d_str.substring(0,endIndex-4);


		dec_secs=Double.valueOf(dec_seconds).doubleValue();
		secs = Integer.valueOf(seconds).intValue();
		mins = Integer.valueOf(minutes).intValue();
		degs = Integer.valueOf(degrees).intValue();

		if(degs >= 360 || mins >= 60 || secs >= 60)
			throw new Invalid_Angular_Data("D, M, or S out of range");
		

		return (double)sign *((double)degs + (double)mins/60.0 +
										((double)secs + dec_secs)/3600.0);
	}

}
	
