/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.text.MessageFormat;
import org.openide.nodes.Node;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;

public abstract class NodeTransfer {
    public static final int DND_NONE = 0;
    public static final int DND_COPY = 1;
    public static final int DND_MOVE = 2;
    public static final int DND_COPY_OR_MOVE = 3;
    public static final int DND_LINK = 0x40000000;
    public static final int DND_REFERENCE = 0x40000000;
    public static final int CLIPBOARD_COPY = 1;
    public static final int CLIPBOARD_CUT = 4;
    public static final int COPY = 1;
    public static final int MOVE = 6;
    private static final DataFlavor nodePasteFlavor = new DataFlavor("application/x-java-openide-nodepaste;class=org.openide.nodes.Node", Node.getString("LBL_nodePasteFlavor"));
    private static MessageFormat dndMimeType = new MessageFormat("application/x-java-openide-nodednd;class=org.openide.nodes.Node;mask={0}");

    private NodeTransfer() {
    }

    private static DataFlavor createDndFlavor(int n) {
        try {
            return new DataFlavor(dndMimeType.format(new Object[]{new Integer(n)}));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalError();
        }
    }

    public static ExTransferable.Single transferable(final Node node, int n) {
        return new ExTransferable.Single(NodeTransfer.createDndFlavor(n)){

            public Object getData() {
                return node;
            }
        };
    }

    public static Node node(Transferable transferable, int n) {
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        if (dataFlavorArray == null) {
            return null;
        }
        int n2 = dataFlavorArray.length;
        String string = "x-java-openide-nodednd";
        String string2 = "application";
        String string3 = "mask";
        int n3 = 0;
        while (n3 < n2) {
            DataFlavor dataFlavor = dataFlavorArray[n3];
            if (dataFlavor.getSubType().equals(string) && dataFlavor.getPrimaryType().equals(string2)) {
                try {
                    int n4 = Integer.valueOf(dataFlavor.getParameter(string3));
                    if ((n4 & n) != 0) {
                        return (Node)transferable.getTransferData(dataFlavor);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    NodeTransfer.maybeReportException(numberFormatException);
                }
                catch (ClassCastException classCastException) {
                    NodeTransfer.maybeReportException(classCastException);
                }
                catch (IOException iOException) {
                    NodeTransfer.maybeReportException(iOException);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    NodeTransfer.maybeReportException(unsupportedFlavorException);
                }
            }
            ++n3;
        }
        return null;
    }

    public static Node[] nodes(Transferable transferable, int n) {
        try {
            if (transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
                MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                int n2 = multiTransferObject.getCount();
                Node[] nodeArray = new Node[n2];
                boolean bl = true;
                int n3 = 0;
                while (n3 < n2) {
                    Node node = NodeTransfer.node(multiTransferObject.getTransferableAt(n3), n);
                    if (node == null) {
                        bl = false;
                        break;
                    }
                    nodeArray[n3] = node;
                    ++n3;
                }
                if (bl && n2 > 0) {
                    return nodeArray;
                }
            } else {
                Node node = NodeTransfer.node(transferable, n);
                if (node != null) {
                    return new Node[]{node};
                }
            }
        }
        catch (ClassCastException classCastException) {
            NodeTransfer.maybeReportException(classCastException);
        }
        catch (IOException iOException) {
            NodeTransfer.maybeReportException(iOException);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            NodeTransfer.maybeReportException(unsupportedFlavorException);
        }
        return null;
    }

    public static Node.Cookie cookie(Transferable transferable, int n, Class clazz) {
        Node node = NodeTransfer.node(transferable, n);
        return node == null ? null : node.getCookie(clazz);
    }

    public static ExTransferable.Single createPaste(final Paste paste) {
        return new ExTransferable.Single(nodePasteFlavor){

            public Object getData() {
                return paste;
            }
        };
    }

    public static Paste findPaste(Transferable transferable) {
        try {
            if (transferable.isDataFlavorSupported(nodePasteFlavor)) {
                return (Paste)transferable.getTransferData(nodePasteFlavor);
            }
        }
        catch (ClassCastException classCastException) {
            NodeTransfer.maybeReportException(classCastException);
        }
        catch (IOException iOException) {
            NodeTransfer.maybeReportException(iOException);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            NodeTransfer.maybeReportException(unsupportedFlavorException);
        }
        return null;
    }

    private static void maybeReportException(Exception exception) {
        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
            exception.printStackTrace();
        }
    }

    public static interface Paste {
        public PasteType[] types(Node var1);
    }
}

