/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml;

import org.openoffice.xmerge.converter.xml.EmbeddedObject;
import org.openoffice.xmerge.converter.xml.OfficeZip;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EmbeddedBinaryObject
extends EmbeddedObject {
    protected byte[] objData = null;

    public EmbeddedBinaryObject(String string, String string2) {
        super(string, string2);
    }

    EmbeddedBinaryObject(String string, String string2, OfficeZip officeZip) {
        super(string, string2, officeZip);
    }

    public byte[] getBinaryData() {
        if (this.objData == null && this.zipFile != null) {
            this.objData = this.zipFile.getNamedBytes(this.objName);
        }
        return this.objData;
    }

    public void setBinaryData(byte[] byArray) {
        this.objData = byArray;
        this.hasChanged = true;
    }

    void write(OfficeZip officeZip) {
        if (this.hasChanged) {
            officeZip.setNamedBytes(this.objName, this.objData);
        }
    }

    void writeManifestData(Document document) throws DOMException {
        Element element = document.createElement("manifest:file-entry");
        element.setAttribute("manifest:media-type", this.objType);
        element.setAttribute("manifest:full-path", this.objName);
        document.getDocumentElement().appendChild(element);
    }
}

