/*************************************************************************
 *
 *  $RCSfile: example.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2001/10/12 15:37:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef WIN
#include <svwin.h>
#include <sysdep.hxx>
#include <string.h>
#include <ctype.h>
#endif

#include <mail.hxx>
#include "about3.hxx"
#include "test.hrc"

#include <stdlib.h>
#include <string.h>
#ifdef WIN
#include <stdio.h>
#include <shellapi.h>
#endif

#include <algorithm>

#define MID_PENCOLOR	10
#define MID_PENRED		11
#define MID_PENBLUE		12
#define MID_PENYELLOW	13
#define MID_PENGREEN	14
#define MID_PENCYAN		15
#define MID_PENMAGENTA	16
#define MID_PENBROWN	17
#define MID_PENRED2		18
#define MID_PENGREEN2	19
#define MID_PENBLACK	20
#define MID_PENWHITE	21

#define MID_PENWIDTH	22
#define MID_PENSMALL	23
#define MID_PENSMALL2	24
#define MID_PENMEDIUM	25
#define MID_PENMEDIUM2	26
#define MID_PENTHICK	27
#define MID_PENTHICK2	28

#define MID_FILE		30
#define MID_QUIT		31
#define MID_ABOUT		32

#define MID_MAIL		40
#define	MID_LOGON		41
#define MID_INBOX		42
#define MID_PREPARE		43
#define MID_LOGOFF		44

// --- class MyApp -------------------------------------------------------

class MyApp : public Application
{
public:
	virtual void 		Main( int, char*[] );
};

// --- class MyInbox -----------------------------------------------------

class MyInbox : public MailBrowseDialog
{
public:
						MyInbox( Window* pParent, MailServer& rSM );
						~MyInbox();
protected:
	void				Open( Window* pParent, const String& rFile );
	BOOL				Close();
};

// --- class MyWin -------------------------------------------------------

class MyWin : public WorkWindow
{
private:
	MailServer*			pServer;
	MyInbox*		 	pInbox;
	USHORT          	nColor;
	USHORT          	nWidth;
	Point           	aLastPoint;

public:
						MyWin();

	virtual BOOL    	Close();
	virtual void    	MouseButtonDown( const MouseEvent& rMEvt );
	virtual void    	MouseButtonUp( const MouseEvent& rMEvt );
	virtual void    	MouseMove( const MouseEvent& rMEvt );
	long            	FileSelect( Menu* pMenu );
	long            	MailSelect( Menu* pMenu );
	long            	ColorSelect( Menu* pMenu );
	long            	WidthSelect( Menu* pMenu );
	void				CloseInbox() { pInbox = 0; }
};

// --- MyInbox::Ctor() ---------------------------------------------------

MyInbox::MyInbox( Window* pParent, MailServer& rMS ) :
	MailBrowseDialog( pParent, rMS )
{
}

// --- MyInbox::Dtor() ---------------------------------------------------

MyInbox::~MyInbox()
{
	( (MyWin*)pApp->GetAppWindow() )->CloseInbox();
}

// --- MyInbox::Close() --------------------------------------------------

BOOL MyInbox::Close()
{
	delete this;
	return TRUE;
}

// --- MyInbox::Open() ---------------------------------------------------

void MyInbox::Open( Window* pParent, const String& rFile )
{
	InfoBox( pParent, String( "MyInbox: Oeffne jetzt " ) + rFile ).Execute();
}

// --- MyWin::MyWin() ----------------------------------------------------

MyWin::MyWin() : WorkWindow( NULL, WB_STDWORK | WB_APP )
{
	pServer = new MailServer( MAIL_DRIVER_SELECT );
	pInbox = 0;
	nColor = 0;
	nWidth = 0;
	aLastPoint = Point( 0, 0 );
}

// --- MyWin::Close() ----------------------------------------------------

BOOL MyWin::Close()
{
	if ( pInbox )
		delete pInbox;

	if ( pServer )
	{
		pServer->Logout();
		delete pServer;
		pServer = 0;
	}

	return WorkWindow::Close();
}

// --- MyWin::MouseButtonDown() ------------------------------------------

void MyWin::MouseButtonDown( const MouseEvent& rMEvt )
{
	CaptureMouse();
	aLastPoint = rMEvt.GetPosPixel();
}

// --- MyWin::MouseButtonUp() --------------------------------------------

void MyWin::MouseButtonUp( const MouseEvent& )
{
	ReleaseMouse();
}

// --- MyWin::MouseMove() ------------------------------------------------

void MyWin::MouseMove( const MouseEvent& rMEvt )
{
	if ( rMEvt.GetMode() & MOUSE_DRAGMOVE )
	{
		DrawLine( aLastPoint, rMEvt.GetPosPixel() );
		aLastPoint = rMEvt.GetPosPixel();
	}
}

// --- MyWin::FileSelect() -----------------------------------------------

long MyWin::FileSelect( Menu* pMenu )
{
	switch ( pMenu->GetCurItemId() )
	{
		case MID_ABOUT:
			{
				AboutBox( this ).Execute();
			}
			break;

		case MID_QUIT:
			Close();
			break;
	}
	return TRUE;
}

// --- MyWin::MailSelect() -----------------------------------------------

long MyWin::MailSelect( Menu* pMenu )
{
	switch ( pMenu->GetCurItemId() )
	{
		case MID_LOGON:
		{
			if ( pServer->Login() != MAIL_STATE_SUCCESS )
				InfoBox( this, "Mail Login Failed!" ).Execute();
			else
			{
				pMenu->EnableItem( MID_LOGON, FALSE );
				pMenu->EnableItem( MID_INBOX );
				pMenu->EnableItem( MID_PREPARE );
				pMenu->EnableItem( MID_LOGOFF );
			}
			break;
		}

		case MID_INBOX:
		{

			pInbox = new MyInbox( this, *pServer );

			// set position
			Point aAppWinPnt = GetPosPixel();
			Size aAppWinSize = GetSizePixel();
			Size aInboxSize = pInbox->GetSizePixel();
			Point aNewPnt( aAppWinPnt.X() +
				std::max( 0, ( aAppWinSize.Width() - aInboxSize.Width() ) / 2 + 1 ),
						   aAppWinPnt.Y() +
				std::max( 0, ( aAppWinSize.Height() - aInboxSize.Height() ) / 2 + 1 ) );
			pInbox->SetPosSizePixel( aNewPnt, pInbox->GetSizePixel() );

			pInbox->Show();
			pMenu->EnableItem( MID_INBOX, FALSE );
			break;
		}

		case MID_PREPARE:
		{
			OutgoingMail aMail;
			if ( pServer->Send( aMail ) != MAIL_STATE_SUCCESS )
				InfoBox( this, "Send Mail failed!" ).Execute();
			break;
		}

		case MID_LOGOFF:
		{
			delete pInbox;
			pInbox = 0;
			pServer->Logout();

			pMenu->EnableItem( MID_LOGON );
			pMenu->EnableItem( MID_INBOX, FALSE );
			pMenu->EnableItem( MID_PREPARE, FALSE  );
			pMenu->EnableItem( MID_LOGOFF, FALSE  );

			break;
		}
	}
	return TRUE;
}

// --- MyWin::ColorSelect() ----------------------------------------------

long MyWin::ColorSelect( Menu* pMenu )
{
	if ( nColor )
		pMenu->CheckItem( nColor, FALSE );
	nColor = pMenu->GetCurItemId();
	pMenu->CheckItem( nColor );

	Pen aPen = GetPen();
	switch( nColor )
	{
		case MID_PENRED:
			 aPen.ChangeColor( Color( COL_RED ) );
			 break;
		case MID_PENBLUE:
			 aPen.ChangeColor( Color( COL_BLUE ) );
			 break;
		case MID_PENYELLOW:
			 aPen.ChangeColor( Color( COL_YELLOW ) );
			 break;
		case MID_PENGREEN:
			 aPen.ChangeColor( Color( COL_GREEN ) );
			 break;
		case MID_PENCYAN:
			 aPen.ChangeColor( Color( COL_CYAN ) );
			 break;
		case MID_PENMAGENTA:
			 aPen.ChangeColor( Color( COL_MAGENTA ) );
			 break;
		case MID_PENBROWN:
			 aPen.ChangeColor( Color( COL_BROWN ) );
			 break;
		case MID_PENRED2:
			 aPen.ChangeColor( Color( COL_LIGHTRED ) );
			 break;
		case MID_PENGREEN2:
			 aPen.ChangeColor( Color( COL_LIGHTGREEN ) );
			 break;
		case MID_PENBLACK:
			 aPen.ChangeColor( Color( COL_BLACK ) );
			 break;
		case MID_PENWHITE:
			 aPen.ChangeColor( Color( COL_WHITE ) );
			 break;
	}
	ChangePen( aPen );

	return TRUE;
}

// --- MyWin::WidthSelect() ----------------------------------------------

long MyWin::WidthSelect( Menu* pMenu )
{
	if ( nWidth )
		pMenu->CheckItem( nWidth, FALSE );
	nWidth = pMenu->GetCurItemId();
	pMenu->CheckItem( nWidth );

	Pen aPen = GetPen();
	switch ( nWidth )
	{
		case MID_PENSMALL:
			aPen.ChangeWidth( 1 );
			break;
		case MID_PENSMALL2:
			aPen.ChangeWidth( 3 );
			break;
		case MID_PENMEDIUM:
			aPen.ChangeWidth( 6 );
			break;
		case MID_PENMEDIUM2:
			aPen.ChangeWidth( 9 );
			break;
		case MID_PENTHICK:
			aPen.ChangeWidth( 15 );
			break;
		case MID_PENTHICK2:
			aPen.ChangeWidth( 21 );
			break;
	}
	ChangePen( aPen );

	return TRUE;
}

// --- MyApp::Main() -----------------------------------------------------

void MyApp::Main( int, char*[] )
{
	MyWin       aMainWin;
	PopupMenu   aFileMenu;
	PopupMenu   aMailMenu;
	PopupMenu   aColorMenu;
	PopupMenu   aWidthMenu;
	MenuBar     aMenuBar;

	aMenuBar.InsertItem( MID_FILE, "~File" );
	aMenuBar.InsertItem( MID_MAIL, "~Mail" );
	aMenuBar.InsertItem( MID_PENCOLOR, "~Color" );
	aMenuBar.InsertItem( MID_PENWIDTH, "~Width" );

	aMenuBar.ChangePopupMenu( MID_FILE,     &aFileMenu );
	aMenuBar.ChangePopupMenu( MID_MAIL,     &aMailMenu );
	aMenuBar.ChangePopupMenu( MID_PENCOLOR, &aColorMenu );
	aMenuBar.ChangePopupMenu( MID_PENWIDTH, &aWidthMenu );

	aFileMenu.InsertItem( MID_ABOUT, "~About..." );
	aFileMenu.InsertSeparator();
	aFileMenu.InsertItem( MID_QUIT, "~Exit..." );

	aMailMenu.InsertItem( MID_LOGON, "~Logon..." );
	aMailMenu.InsertSeparator();
	aMailMenu.InsertItem( MID_INBOX, "~Inbox..." );
	aMailMenu.InsertItem( MID_PREPARE, "~Prepare..." );
	aMailMenu.InsertSeparator();
	aMailMenu.InsertItem( MID_LOGOFF, "L~ogoff" );

	aColorMenu.InsertItem( MID_PENRED, "~Red" );
	aColorMenu.InsertItem( MID_PENBLUE, "~Blue" );
	aColorMenu.InsertItem( MID_PENYELLOW, "~Yellow" );
	aColorMenu.InsertItem( MID_PENGREEN, "~Green" );
	aColorMenu.InsertItem( MID_PENCYAN, "~Cyan" );
	aColorMenu.InsertItem( MID_PENMAGENTA, "~Magenta" );
	aColorMenu.InsertItem( MID_PENBROWN, "~Brown" );
	aColorMenu.InsertItem( MID_PENRED2, "~Light Red" );
	aColorMenu.InsertItem( MID_PENGREEN2, "~Light Green" );
	aColorMenu.InsertItem( MID_PENBLACK, "~Black" );
	aColorMenu.InsertItem( MID_PENWHITE, "~White" );

	aWidthMenu.InsertItem( MID_PENSMALL, "~Small" );
	aWidthMenu.InsertItem( MID_PENSMALL2, "~Small2" );
	aWidthMenu.InsertItem( MID_PENMEDIUM, "~Medium" );
	aWidthMenu.InsertItem( MID_PENMEDIUM2, "~Medium2" );
	aWidthMenu.InsertItem( MID_PENTHICK, "~Large" );
	aWidthMenu.InsertItem( MID_PENTHICK2, "~Large2" );

	aFileMenu.PushSelectHdl( LINK( &aMainWin,
								   MyWin, FileSelect ) );
	aMailMenu.PushSelectHdl( LINK( &aMainWin,
								   MyWin, MailSelect ) );
	aColorMenu.PushSelectHdl( LINK( &aMainWin,
									MyWin, ColorSelect ) );
	aWidthMenu.PushSelectHdl( LINK( &aMainWin,
									MyWin, WidthSelect ) );

	ChangeAppMenu( &aMenuBar );

	aMainWin.SetText( "StarView Paint and Mail" );
	aMainWin.Show();

	Pen aPen = aMainWin.GetPen();
	aPen.ChangeColor( Color( COL_BLUE ) );
	aPen.ChangeWidth( 1 );
	aMainWin.ChangePen( aPen );

	ChangeAppFont( Font( ResId( RID_APPFONT ) ) );
	EnableSVLook();

	aMailMenu.EnableItem( MID_INBOX, FALSE );
	aMailMenu.EnableItem( MID_PREPARE, FALSE );
	aMailMenu.EnableItem( MID_LOGOFF, FALSE );

	Execute();
}

// --- aMyApp ------------------------------------------------------------

MyApp aMyApp;

