
package org.netbeans.modules.openoffice.wizard.nodes;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import org.netbeans.modules.openoffice.wizard.panels.idl.*;
import org.netbeans.modules.openoffice.wizard.actions.idl.*;
import org.netbeans.modules.openoffice.wizard.keys.*;
import org.netbeans.modules.openoffice.wizard.util.StructMemberCreator;
import org.openide.TopManager;
import org.openide.nodes.*;
import org.openide.util.actions.SystemAction;
import org.openide.DialogDescriptor;



public abstract class SENode extends MovableNode
    implements org.openide.nodes.Node.Cookie, StructMemberCreator
{

    public SENode(NameKey namedkey)
    {
        super(namedkey);
        getCookieSet().add(this);
    }

    public SystemAction[] createActions()
    {
        return (new SystemAction[] {
            SystemAction.get(CreateStructMemberAction.class),
            SystemAction.get(DestroyAction.class),
            SystemAction.get(EditAction.class)
        });
    }

    public void createStructMember()
    {
        TopManager topmanager = TopManager.getDefault();
        final AliasPanel aliaspanel = new AliasPanel();
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(aliaspanel, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/nodes/Bundle").getString("TXT_CreateMember"));
        exdialogdescriptor.setButtonListener( new ActionListener() {

            public void actionPerformed(ActionEvent actionevent)
            {
                if(actionevent.getActionCommand().equals("OK"))
                { 
                        String s = aliaspanel.getName();
                        String s1 = aliaspanel.getType();
                        AliasKey aliaskey = new AliasKey(12, s, s1);
                        ((IDLBaseChildren)getChildren()).addKey(aliaskey);
                }
                dialog.setVisible(false);
                dialog.dispose();
            }

        });
       
        dialog = topmanager.createDialog(exdialogdescriptor);
        dialog.setVisible(true);
        
              
    }

    
    private Dialog dialog;
    
}
