/*************************************************************************
 *
 *  $RCSfile: listboxaccessible.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/06/30 14:33:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef SVTOOLS_LISTBOX_ACCESSIBLE
#include "listboxaccessible.hxx"
#endif
#ifndef _SVTREEBOX_HXX
#include "svtreebx.hxx"
#endif

//........................................................................
namespace svt
{
//........................................................................

	//====================================================================
	//= ListBoxAccessibleBase
	//====================================================================
	//--------------------------------------------------------------------
	ListBoxAccessibleBase::ListBoxAccessibleBase( SvTreeListBox& _rWindow )
		:m_pWindow( &_rWindow )
	{
		m_pWindow->AddEventListener( LINK( this, ListBoxAccessibleBase, WindowEventListener ) );
	}

	//--------------------------------------------------------------------
	ListBoxAccessibleBase::~ListBoxAccessibleBase( )
	{
		if ( m_pWindow )
		{
			// cannot call "dispose" here, as it is abstract, so the VTABLE of the derived class
			// is not intact anymore
			// so we call our "disposing" only
			disposing();
		}
	}

	//--------------------------------------------------------------------
	IMPL_LINK( ListBoxAccessibleBase, WindowEventListener, VclSimpleEvent*, pEvent )
	{
    	DBG_ASSERT( pEvent && pEvent->ISA( VclWindowEvent ), "ListBoxAccessibleBase::WindowEventListener: unexpected WindowEvent!" );
    	if ( pEvent && pEvent->ISA( VclWindowEvent ) )
    	{
        	DBG_ASSERT( static_cast< VclWindowEvent* >( pEvent )->GetWindow() , "ListBoxAccessibleBase::WindowEventListener: no event window!" );
        	DBG_ASSERT( static_cast< VclWindowEvent* >( pEvent )->GetWindow() == m_pWindow, "ListBoxAccessibleBase::WindowEventListener: where did this come from?" );

        	ProcessWindowEvent( *static_cast< VclWindowEvent* >( pEvent ) );
    	}
    	return 0;
	}

	// -----------------------------------------------------------------------------
	void ListBoxAccessibleBase::disposing()
	{
		if ( m_pWindow )
			m_pWindow->RemoveEventListener( LINK( this, ListBoxAccessibleBase, WindowEventListener ) );
		m_pWindow = NULL;
	}

	// -----------------------------------------------------------------------------
	void ListBoxAccessibleBase::ProcessWindowEvent( const VclWindowEvent& _rVclWindowEvent )
	{
		if ( isAlive() )
		{
			switch ( _rVclWindowEvent.GetId() )
			{
				case  VCLEVENT_OBJECT_DYING :
				{
		            if ( m_pWindow )
					    m_pWindow->RemoveEventListener( LINK( this, ListBoxAccessibleBase, WindowEventListener ) );
		            m_pWindow = NULL;
					dispose();
					break;
				}
			}
		}
	}

//........................................................................
}	// namespace svt
//........................................................................
