/*************************************************************************
 *
 *  $RCSfile: deco.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>
#include <ctype.h>

#include <deco.hxx>

DecoName::DecoName() :
	eFunctionType( Default ),
	nAccessType( 0 ),
	nCalling( 0 ),
	pClassName( 0x0 )
{
	pTypeList = new ParamList;
	pNameList = new ScopeList;
	pFuncParams = new ParamList;
}

DecoName::DecoName( ByteString aManName ) :
	eFunctionType( Default ),
	nAccessType( 0 ),
	nCalling( 0 ),
	pClassName( 0x0 )
{
	pNameList = new ScopeList;
	pFuncParams = new ParamList;
	aMangledName = aManName;
	pTypeList = new ParamList;
}

DecoName::~DecoName()
{
	ULONG i;
	ULONG nCount = pNameList->Count();
	for ( i=0; i<nCount; i++ )
	{
		ByteString *pStr = pNameList->GetObject(i);
		//delete pStr;
	}
	delete pNameList;
	nCount = pFuncParams->Count();
	for ( i=0; i<nCount; i++ )
	{
		DecoType *pType = pFuncParams->GetObject(i);
		//delete pType;
	}
}

ByteString DecoName::PrintName()
{
	Parse();
	PrintRefs();
	PrintBody();

	fprintf( stderr, "Name : %s\t", aName.GetBuffer());

	//PrintSolsName();
	//fprintf( stderr, " Sol : %s\n", aSolsMName.GetStr());

	fprintf( stderr, " WNT : %s\n", aMangledName.GetBuffer());

	return aName;
}

/*
 * Get ReturnType of function
 *
 */

ULONG DecoName::GetRetType()
{
	DecoType *pType = pFuncParams->GetObject(0);
	return pType->GetType();
}

void DecoName::DbgPrintParams()
{
	ULONG nCount = pFuncParams->Count();
	for ( USHORT i=0; i<nCount; i++ )
	{
		DecoType* pType = pFuncParams->GetObject(i);
		ByteString aType = PrintType( pType->GetType(), pType );
		fprintf( stderr, "DbgPrintParms : %s\n", aType.GetBuffer());
	}
}


/*
 * full name of access method
 *
 */

ByteString DecoName::PrintAccessType(ULONG nType)
{
	ByteString aName;

	return aName;
}

/*
 * Print function human readable
 *
 */

void DecoName::PrintBody()
{
	USHORT i;
	DecoType* pFType = 0x0;
	BOOL bEnd = FALSE;
	ULONG bFuncRet = 0;

	if ( aFunc == "" )
	{
		aName += aFuncName;
		return;
	}
	// first: access
	if ( nAccessType & MAN_TYPE_PROTECTED )
		aName += "protected: ";
	else if ( nAccessType & MAN_TYPE_PUBLIC )
		aName += "public: ";
	else if ( nAccessType & MAN_TYPE_PRIVATE )
		aName += "private: ";

	if ( nAccessType & MAN_TYPE_VIRTUAL )
		aName += "virtual ";
	if ( nAccessType & MAN_TYPE_STATIC )
		aName += "static ";


	// return value

	DecoType *pType = pFuncParams->GetObject(0);

	if ( pType )
		aName += PrintType( pType->GetType(), pType );
	else
		fprintf( stderr, "Error !\n");
	aName += " ";

		/*ParamList* pFuncParams = pDecoName->GetParamList();
		ULONG nCount = pFuncParams->Count();
		for ( j=0; j<nCount; j++ )
		{
			;
		}*/
	if ( pType->GetType() & MAN_TYPE_FUNCPTR )
	{
		pFType = pType;
		bFuncRet = 1;
		DecoName *pFName = pType->GetDecoName();
		DecoType* pFType = pFName->GetParamList()->GetObject(0);
		aName += PrintType( pFType->GetType(), pFType );
		aName += "( ";
		if ( pFName->nCalling & MAN_TYPE_STDCALL )
			aName += "__stdcall ";
		else
			aName += "__cdecl ";
		aName += "* ";
	}

	if ( nCalling & MAN_TYPE_THISCALL )
		aName += "__thiscall ";
	else if ( nCalling & MAN_TYPE_STDCALL )
		aName += "__stdcall ";
	else if ( nCalling & MAN_TYPE_CDECL )
		aName += "__cdecl ";

	/*
	USHORT nCount = pNamespaces->Count();

	ULONG nStart = 0;
	if ( nAccessType & MAN_TYPE_FUNCTION )
		nStart = 1;
	for ( i=nStart; i< nCount-2; i++ )
	{
		aName += *pNamespaces->GetObject(i);
		aName += "::";
	}
	*/

	// write class
	if ( pClassName ) {
		if ( pClassName->GetScope()->Count() > 0 )
		{
			for ( USHORT i=0; i< pClassName->GetScope()->Count(); i++ )
			{
				ByteString* pStr = pClassName->GetScope()->GetObject(i);
				aName += *pStr; aName += "::";
			}
		}
		aName += *pClassName->GetName();
		if ( NName* pNName = pClassName->GetTemplate())
		{
			aName += "<";
			USHORT nCount = pNName->GetScope()->Count();
			for ( USHORT i=0; i< nCount; i++ )
			{
				ByteString* pStr = pNName->GetScope()->GetObject(i);
				aName += *pStr; aName += "::";
			}
			aName += *pNName->GetName();
			aName += ">";
		}
	}

	if ( !(nAccessType & MAN_TYPE_FUNCTION ))
		aName += "::";
	else
		aName += " ";

	// operartors

	aName += aFunc;
	aName += "(";

	// Parameter
	USHORT nCount = pFuncParams->Count();
	for ( i=1; i<nCount; i++)
	{
		DecoType* pType = pFuncParams->GetObject(i);
		if ( pType->GetType() & MAN_TYPE_FUNCPTR )
		{
			bEnd = TRUE;
			DecoName* pFName = pType->GetDecoName();
			ParamList* pFParam = pFName->GetParamList();
			ULONG nCount = pFParam->Count();
			for ( ULONG q=bFuncRet; q<nCount; q++ )
			{
				DecoType* pFType = pFParam->GetObject(q);
				if ( pFType )
					aName += PrintType( pFType->GetType(), pFType );
				else
					fprintf( stderr, "Error !\n");

				if ( (q != nCount-1) && (q != 0 ) )
					aName += ", ";
				if ( q == 0 )
				{
					aName += "( ";
					if ( pFName->nCalling & MAN_TYPE_STDCALL )
						aName += "__stdcall ";
					if ( pFName->nCalling & MAN_TYPE_CDECL )
						aName += "__cdecl ";
					aName += " *)";
					aName += "( ";
				}
			}
			aName += ") ";
		}
		else
		{
			aName += PrintType( pType->GetType(), pType );
			if ( i != nCount-1 && i != 0 )
				aName += ", ";
		}
	}

	aName += ") ";
	if ( nCalling & MAN_TYPE_CONST )
		aName += "const ";

	pType = pFuncParams->GetObject(0);
	if ( pType->GetType() & MAN_TYPE_FUNCPTR )
	{
		aName += " ) (";
		DecoName* pFName = pType->GetDecoName();
		ULONG nCount = pFName->GetParamList()->Count();
		for ( USHORT i=1; i< nCount; i++ )
		{
			DecoType* pFType = pFName->GetParamList()->GetObject(i);
			if ( pFType )
				aName += PrintType( pFType->GetType(), pFType );
			else
				fprintf( stderr, "Error !\n");

			if ( i != nCount-1 && ( i != 0 ))
				aName += ", ";
		}
		aName += ") ";
	}


	// encoding
	/*uu_init();
	unsigned char *pData;
	unsigned char *pOut;

	pData = new uchar[2048];
	pOut = new uchar[8192];

	USHORT nSize = sizeof( *this );
	pData = (uchar *) (void*)this;
	pData[nSize+1] = '\0';

	encode_line( pData, pOut, nSize );

	fprintf( stderr, "UU: %s\n", pOut );*/
}

ByteString DecoName::PrintType( ULONG nType, DecoType* pType )
{
	ByteString aName;
	if ( nType == 0x0 )
		return aName;
	if ( nType & MAN_TYPE_USER )
	{
		ULONG nType = pType->GetType();
		if ( nType & MAN_TYPE_CLASS ) aName += "class "; else
		if ( nType & MAN_TYPE_STRUCT ) aName += "struct "; else
		if ( nType & MAN_TYPE_ENUM ) aName += "enum "; else
			aName += "??? ";

		ULONG nCount = pType->GetUserType()->GetScope()->Count();
		for ( USHORT n=0; n<nCount; n++ )
		{
			ByteString *pStr = pType->GetUserType()->GetScope()->GetObject(n);
			if ( pStr )
			{
				aName += *pStr; aName += "::";
			}
		}
		aName += *pType->GetUserType()->GetName();

		// test if templatr
		if ( pType->GetUserType()->GetTemplate() )
		{
			aName += "<";
			aName += ">";
		}
		aName += " ";
	}

	if ( nType & MAN_TYPE_CONST )
		aName += "const ";
	if ( nType & MAN_TYPE_UNSIGNED )
		aName += "unsigned ";

	if ( nType & MAN_TYPE_VOID )
		aName += "void ";
	else if ( nType & MAN_TYPE_CHAR )
		aName += "char ";
	else if ( nType & MAN_TYPE_INT )
		aName += "int ";
	else if ( nType & MAN_TYPE_SHORT )
		aName += "short ";
	else if ( nType & MAN_TYPE_LONG )
		aName += "long ";
	else if ( nType & MAN_TYPE_FLOAT )
		aName += "float ";
	else if ( nType & MAN_TYPE_DOUBLE )
		aName += "double ";

	if ( nType & MAN_TYPE_PTR )
		aName += "* ";
	else if ( nType & MAN_TYPE_PTRPTR )
		aName += "** ";
	if ( nType & MAN_TYPE_REF )
		aName += "& ";

	return aName;
}

void DecoName::PrintSolsName()
{
	aSolsMName += "__1c";
	if ( nCalling & MAN_TYPE_CLASS )
	{
		aSolsMName += "G";
		aSolsMName += *pClassName->GetName();
	}
	else if ( nCalling & MAN_TYPE_FUNCTION )
		aSolsMName += "J";

	if ( eFunctionType == Ctor )
		aSolsMName += "2t";
	else if ( eFunctionType == Dtor )
		aSolsMName += "2T";

	if ( aFuncName != "" )
	{
		if ( eFunctionType == Default )
		{
			aSolsMName += "C";
			aSolsMName += aFuncName;

			aSolsMName += "6M";
		}
		USHORT nCount = pFuncParams->Count();
		for ( USHORT i=0; i<nCount; i++ )
		{
			DecoType* pType = pFuncParams->GetObject(i);
			if ( pType->GetType() & MAN_TYPE_VOID )
				aSolsMName += "v";
			else if ( pType->GetType() & MAN_TYPE_CHAR )
				aSolsMName += "c";
			else if ( pType->GetType() & MAN_TYPE_CHAR
								&& pType->GetType() & MAN_TYPE_UNSIGNED )
				aSolsMName += "C";
			else if ( pType->GetType() & MAN_TYPE_INT )
				aSolsMName += "i";
			else if ( pType->GetType() & MAN_TYPE_INT
								&& pType->GetType() & MAN_TYPE_UNSIGNED )
				aSolsMName += "I";
			else if ( pType->GetType() & MAN_TYPE_SHORT )
				aSolsMName += "h";
			else if ( pType->GetType() & MAN_TYPE_SHORT
								&& pType->GetType() & MAN_TYPE_UNSIGNED )
				aSolsMName += "H";
			else if ( pType->GetType() & MAN_TYPE_LONG )
				aSolsMName += "l";
			else if ( pType->GetType() & MAN_TYPE_LONG
								&& pType->GetType() & MAN_TYPE_UNSIGNED )
				aSolsMName += "L";
		}

	}

}

void DecoName::Parse()
{

	USHORT nPos = 0;
	USHORT nOldPos = 0;

	bInRet = FALSE;
	// the function name is alwayes the first !!
	USHORT nNext = GetFuncName( aMangledName );
	aFunc = ParseFuncName( aMangledName );

	ByteString aTestStr = aMangledName.Copy( nNext);

	// if mangled name is not only a function
	if ( aMangledName.GetChar( ++nNext ) != '@' )
	{
		ByteString aName = aMangledName.Copy( nNext );
		nNext += GetName( aName );
		pClassName = ParseName( aName );
		// this name is the class name
	}
	else
		nNext++;

	// the access type
	ByteString aAccessStr = aMangledName.Copy( nNext);
	nNext += GetAccess( aAccessStr );
	ParseAccess( aAccessStr );

	// get the return type
	if ( eFunctionType == Default )
	{
		bInRet = TRUE;
		// not an operator
		ByteString aReturnType = aMangledName.Copy( nNext );
		nNext += GetType( aReturnType );
		DecoType* pType = ParseType( aReturnType );

		pFuncParams->Insert( pType, LIST_APPEND );
	}
	bInRet = FALSE;

	// get rest of parameters
	ByteString aParam = aMangledName.Copy( nNext );
	while ( aParam != "Z" )
	{
		nNext += GetType( aParam );
		DecoType* pType = ParseType( aParam );

		if ( pType )
		{
			pFuncParams->Insert( pType, LIST_APPEND );
		}

		aParam = aMangledName.Copy( nNext );
		if ( aParam == "" ) break;
	}

}

NName::NName(ByteString* pNewName)
{
	pScope = new ScopeList;
	pTempl = 0x0;
	pName = pNewName;
}

NName::NName()
{
	pScope = new ScopeList;
	pTempl = 0x0;
	pName = 0x0;
}

void NName::AddScope( ByteString* pSName )
{
	if ( pName == 0x0 )
		pName = pSName;
	else
		pScope->Insert( pSName, LIST_APPEND );
}

DecoType::DecoType()
{
	aType = 0x0;
	pUserType = 0x0;
	pDeco = 0x0;
}

USHORT DecoName::GetFuncName( ByteString& rString )
{
	USHORT nEnd = rString.Search('@');
	return nEnd;
}

ByteString DecoName::ParseFuncName( ByteString& rString )
{
	ByteString aStr;
	USHORT nEnd = rString.Search('@');
	eFunctionType = Default;

	// first char should be a '?'
	if ( rString.GetChar( 0 ) != '?' )
	{
		// else it is C Linking
		return rString;
	}
	char c = rString.GetChar( 2 );
	if ( rString.GetChar( 1 ) == '?' )
	{
		pClassName = new NName( new ByteString(rString.Copy(3,nEnd-3)));
		switch ( c )
		{
			case '0' :
				eFunctionType = Ctor;
				aStr = *pClassName->GetName();
				break;
			case '1' :
				eFunctionType = Dtor;
				aStr += "~";
				aStr += *pClassName->GetName();
				break;
			case '4' :
				eFunctionType = Assign;
				break;
			case '5' :
				eFunctionType = ShiftLeft;
				break;
			case '6' :
				eFunctionType = ShiftRight;
				break;
			case '7' :
				eFunctionType = Not;
				break;
			case '8' :
				eFunctionType = Equal;
				break;
			case '9' :
				eFunctionType = UnEqual;
				break;
			case 'D' : // *
				eFunctionType = Dereference;
				break;
			case 'E' : // ++
				eFunctionType = PlusPlus;
				break;
			case 'F' : // --
				eFunctionType = MinusMinus;
				break;
			case 'G' : // -
				eFunctionType = Minus;
				break;
			case 'H' : // +
				eFunctionType = Plus;
				break;
			case 'I' : // &
				eFunctionType = Reference;
				break;
			case 'J' : // ->*
				eFunctionType = PointerToMember;
				break;
			default :
				;
		}
	}
	if ( eFunctionType != Default )
	{
		DecoType* pType = new DecoType;
		pType->SetType( MAN_TYPE_NULL );
		pFuncParams->Insert( pType, LIST_APPEND );
		pTypeList->Insert( pType, LIST_APPEND );
		//aStr = "";
	}
	else
	{
		aStr = rString.Copy(1,nEnd-1);
		pNameList->Insert( new ByteString(aStr), LIST_APPEND );
	}
	return aStr;
}

USHORT DecoName::GetType( ByteString& rString )
{
	USHORT nEnd = 0;
	BOOL bEnd = FALSE;
	char c = rString.GetChar(0);
	char d = rString.GetChar(1);
	char e = rString.GetChar(2);

	// ignore ?A combinations
	if ( c == '?' && d == 'A' )
	{
		nEnd += 2;
		c = rString.GetChar( nEnd );
		d = rString.GetChar( nEnd+1 );
	}

	while ( !bEnd )
	{
		switch ( c )
		{
			case 'P' :
				if ( d == 'A' || d == 'B' ) nEnd+=2;
				// Function Ptr
				if ( d == '6' && ( e == 'A' || e == 'G') )
				{
					// Return Type and Params
					ByteString aRetType = rString.Copy( nEnd );
					nEnd += aRetType.Search("Z");
					nEnd += 1;
					return nEnd;
				}
				break;
			case 'A' :
				if ( d == 'A' || d == 'B' ) nEnd+=2;
				if ( d == 'W' && e == '4' )
				{
					ByteString aRetType = rString.Copy( nEnd );
					nEnd += aRetType.Search('@');
					nEnd += 1;
					return nEnd;
				}
				break;
			case 'X' :
			case 'H' :
			case 'I' :
			case 'F' :
			case 'G' :
			case 'J' :
			case 'K' :
			case 'D' :
			case 'E' :
			case 'M' :
			case 'N' :
				nEnd++;
				bEnd = TRUE;
				break;
			case 'U' :
			case 'V' :
				{
				nEnd++;
				nEnd+= GetName( rString.Copy( nEnd ));
				}
				bEnd = TRUE;
				break;
			case 'W' :
				{
					ByteString aRetType = rString.Copy( nEnd );
					nEnd += aRetType.Search('@');
					nEnd += 1;
					return nEnd;
				}
			case 'Z' :
				return nEnd = 1;
			default :
				return nEnd = 1;
		}
		c = rString.GetChar( nEnd );
		d = rString.GetChar( nEnd+1);
		e = rString.GetChar( nEnd+2);
	}
	return nEnd;
}

DecoType* DecoName::ParseType( ByteString& rString )
{
	USHORT nPos = 0; BOOL bRef = FALSE; // to be referenced
	DecoType* pType = new DecoType;
	NName* pNName =0x0;
	ULONG nType = 0x0;

	char c = rString.GetChar( nPos );
	char d = rString.GetChar( nPos+1 );
	char e = rString.GetChar( nPos+2 );

	// ignore ?A combinations
	if ( c == '?' && d == 'A' )
	{
		nPos += 2;
		c = rString.GetChar( nPos );
		d = rString.GetChar( nPos+1 );
	}
	// test if Pointer or reference
	switch (c)
	{
		case 'A' :
			// get reference
			switch (d)
			{
				case 'B' :
					nType |= MAN_TYPE_CONST;
				case 'A' :
					nType |= MAN_TYPE_REF;
					break;
				case 'W' :
					if ( e == '4' )
					{
						nType |= MAN_TYPE_ENUM;
						nPos += 3;
						c = rString.GetChar( nPos );
						d = rString.GetChar( nPos+1);
						e = rString.GetChar( nPos+2);
					}
					break;
				default:
					fprintf(stderr, "unknown type\n");
			}
			nPos+=2;
			c = rString.GetChar( nPos );
			d = rString.GetChar( nPos+1 );
			if ( c == 'P' && d == 'A' )
			{
				nType |= MAN_TYPE_PTR;
				nPos += 2;
				c = rString.GetChar( nPos );
				d =	rString.GetChar( nPos+1 );
			}

			bRef = TRUE;
			if ( c != 'P' )
			break;

		case 'P' :
			// got pointer
			switch (d)
			{
				case 'B' :
					nType |= MAN_TYPE_CONST;
				case 'A' :
					nType |= MAN_TYPE_PTR;
					break;
				case '6' :
					// got function pointer
					if ( e =='A' || e == 'G' )
					{
						USHORT nNext = 0;
						nType |= MAN_TYPE_FUNCPTR;

						// new DecoName
						DecoName* pFName = new DecoName;
						pType->SetDecoName( pFName );
						if ( e == 'A' ) pFName->nCalling |= MAN_TYPE_CDECL;
						else if ( e == 'G' ) pFName->nCalling |= MAN_TYPE_STDCALL;

						ByteString aFuncString = rString.Copy( nNext = 3 );

						// get rest of parameters
						while ( aFuncString.GetChar( nNext ) != 'Z' ||
							( aFuncString.GetChar( nNext ) != '@' && aFuncString.GetChar( nNext+1 ) != 'Z') )
						{
							nNext += GetType( aFuncString );
							DecoType* pFType = ParseType( aFuncString );

							if ( pFType )
							{
								pFName->pFuncParams->Insert( pFType, LIST_APPEND );
							}

							aFuncString = rString.Copy( nNext );
										if ( aFuncString == "" ) break;
						}
						nPos = nNext-1;

					}
					pType->SetType( nType );
					// update type list
					pTypeList->Insert( pType, LIST_APPEND );
					return pType;
					break;
				default :
					fprintf(stderr, "%c : unknown type\n", d);
			}
			nPos+=2;
			c = rString.GetChar( nPos );
			d = rString.GetChar( nPos+1 );
			if ( c == 'P' && ( d == 'A' || d == 'B' ) )
			{
				nType |= MAN_TYPE_PTRPTR;
				nPos += 2;
			}
			bRef = TRUE;
			break;

		default:	;
	}
	// test if reference
	if ( isdigit(c) )
	{
		USHORT nRef = c - 48;
		pType = pTypeList->GetObject( nRef );
	}
	else
	{
		switch (c)
		{

			case 'X' :							// void
				nType |= MAN_TYPE_VOID;
				break;
			case 'I' :							// unsigned
				nType |= MAN_TYPE_UNSIGNED;
			case 'H' :							// int
				nType |= MAN_TYPE_INT;
				break;
			case 'G' :							// unsigned
				nType |= MAN_TYPE_UNSIGNED;
			case 'F' :							// short
				nType |= MAN_TYPE_SHORT;
				break;
			case 'K' :							// unsigned
				nType |= MAN_TYPE_UNSIGNED;
			case 'J' :							// long
				nType |= MAN_TYPE_LONG;
				break;
			case 'E' :							// unsigned
				nType |= MAN_TYPE_UNSIGNED;
			case 'D' :							// char
				nType |= MAN_TYPE_CHAR;
				break;
			case 'M' :							// float
				nType |= MAN_TYPE_FLOAT;
				break;
			case 'N' :							// float
				nType |= MAN_TYPE_DOUBLE;
				break;
			case 'U' :
				{
				nType |= MAN_TYPE_STRUCT;
				ByteString aName = rString.Copy( ++nPos );
				nPos += GetName( aName );
				pNName = ParseName( aName );
				}
				bRef = TRUE;
				break;
			case 'V' :
				{
					nType |= MAN_TYPE_CLASS;
					ByteString aName = rString.Copy( ++nPos );
					if (isdigit( c = aName.GetChar( 0 )))
					{
						pNName = new NName; int i = 0;
						do
						{
							if ( !isdigit(c)) break;
							int nRef = (int)c-48;
							ByteString* pStr = pNameList->GetObject(nRef);
							pNName->AddScope( pStr );
						}
						while((c = aName.GetChar( ++i )) != '@');

					}
					else
					{
						nPos += GetName( aName );
						pNName = ParseName( aName );
					}
				}
				bRef = TRUE;
				break;
			case 'W' :
				{
					if ( rString.GetChar( ++nPos ) == '4' )
					{
						nType |= MAN_TYPE_ENUM;
						ByteString aName = rString.Copy( ++nPos );
						nPos += GetName( aName );
						pNName = ParseName( aName );
					}

				bRef = TRUE;
				}
				break;

			case 'Z' :
				delete pType;
				return (DecoType*) NULL;
				break;
			default:
				fprintf(stderr, "%c : unknown type\n",c );
				delete pType;
				return (DecoType*) NULL;
		}
		pType->AddType( nType );
		if ( pNName )
		{
			pType->AddType( MAN_TYPE_USER );
			pType->SetUserType( pNName );
		}
	}
	if ( bRef &&  !bInRet )
		pTypeList->Insert( pType, LIST_APPEND );
	return pType;
}

/*
 *
 * formats: blah@@ or bla@1@
 *
 */

USHORT DecoName::GetName( ByteString& rString )
{
	USHORT nEnd = 0;

	// template ?
	if (rString.GetChar( 0 ) == '?' && rString.GetChar( 1 ) == '$' )
		nEnd = GetTemplate( rString );

	// reference ?
	if ( isdigit(rString.GetChar( 0 ) ) )
		return ( nEnd = rString.Search('@') + 1 );

	// get the name
	nEnd = rString.Search('@', nEnd );
	ByteString atst1 = rString.Copy(nEnd);
	if ( rString.GetChar( nEnd+1 ) != '@' )
	{
		nEnd = rString.Search('@', nEnd );
		atst1 = rString.Copy(nEnd);
		if ( nEnd == STRING_NOTFOUND )
			fprintf( stderr, "Error while GetName\n");
		char c;
		while ( 1 )
		{
			c = rString.GetChar( ++nEnd );
			atst1 = rString.Copy(nEnd);
			if ( c == '@' )
			{
				if ((c = rString.GetChar( nEnd+1 )) == '@' )
					return nEnd + 2;
				else
					return nEnd+1;
				break;
			}
		}
	}
	else
		nEnd+=2;

	return nEnd;
}

NName* DecoName::ParseName( ByteString& rString )
{
	USHORT nNext = 0; USHORT nEnd = 0;
	NName* pNName = 0x0;
	BOOL bRef = FALSE;

	// test if name contains template
	if (rString.GetChar( 0 ) == '?' && rString.GetChar( 1 ) == '$' )
	{
		// Parse Template
		nNext += GetTemplate( rString.Copy());
		pNName = ParseTemplate( rString.Copy());

		// adjust the String containing the name
		rString = rString.Copy( nNext );
	}

	// test if reference
	if ( isdigit( rString.GetChar( 0 ) ))
		bRef = TRUE;

	if ( !pNName )
	{
		nEnd = rString.Search('@'); nEnd++;
		ByteString* pName = new ByteString (rString.Copy( 0, nEnd-1 ));
		pNName = new NName;
		char c = (*pName).GetChar( 0 ); int i=0;
		if ( isdigit(c))
		{
			do
			{
				if ( !isdigit(c)) break;
				int nRef = c - 48;
				ByteString* pStr = pNameList->GetObject(nRef);
				pNName->AddScope( pStr );
				i++;
			}
			while ((c = (*pName).GetChar( i )) != '@' );
		}
		else
		{
			pNName->AddScope( pName );

			// update Name Reference List
			pNameList->Insert( pName, LIST_APPEND );
		}
	}

	// if bRef job is done
	if ( bRef )
		return pNName;

	while ( (nNext = rString.Search( '@', nEnd )) != STRING_NOTFOUND )
	{
		ByteString* pStr = new ByteString( rString.Copy( nEnd, nNext-nEnd ));
		if ( *pStr != "" )
		{
			// test if reference
			char c = (*pStr).GetChar( 0 ); int i=0;
			if ( isdigit(c))
			{
				do
				{
					if ( !isdigit(c)) break;
					int nRef = (int)c-48;
					ByteString* pStr = pNameList->GetObject(nRef);
					pNName->AddScope( pStr );
				}
				while((c = (*pStr).GetChar( ++i )) != '@');
			}
			else
			{
				pNName->AddScope( pStr );
				pNameList->Insert( pStr, LIST_APPEND );
			}
		}
		else
			return pNName;
		if ( rString.GetChar( nNext ) == '@' )
			return pNName;
		nEnd = nNext;
	}
	return pNName;
}


USHORT DecoName::GetTemplate( ByteString& rString )
{
	USHORT nEnd = 0;

	nEnd = rString.Search("@@@", nEnd+1 );
	nEnd += 3;

	return nEnd;
}

NName* DecoName::ParseTemplate( ByteString& rString )
{
	USHORT nEnd = 0;

	// first we get the usertype
	USHORT nNext = rString.Search('@', nEnd+1 );
	ByteString aStr = rString.Copy( nEnd, nNext - nEnd );
	ByteString* pStr = new ByteString( aStr.Copy(2));
	NName* pNName = new NName( pStr );

	NName* pTempName = ParseName( rString.Copy(++nNext) );
	pNName->SetTemplate( pTempName );

	return pNName;
}

USHORT DecoName::GetAccess(ByteString& rString)
{
	USHORT nEnd = 0;

	if ( rString.GetChar( 0 ) == 'Y' || rString.GetChar( 0 ) == 'S' )
		nEnd = 2;
	else
		nEnd = 3;
	return nEnd;
}

void DecoName::ParseAccess( ByteString& rString )
{
	BOOL bStatic = FALSE;
	char c = rString.GetChar( 0 );

	switch (c)
	{
		case 'A' :
			nAccessType = MAN_TYPE_PRIVATE;
			break;
		case 'E' :
			nAccessType |= MAN_TYPE_PRIVATE;
			nAccessType |= MAN_TYPE_VIRTUAL;
			break;
		case 'I' :
			nAccessType |= MAN_TYPE_PROTECTED;
			break;
		case 'M' :
			nAccessType |= MAN_TYPE_PROTECTED;
			nAccessType |= MAN_TYPE_VIRTUAL;
			break;
		case 'Q' :
			nAccessType |= MAN_TYPE_PUBLIC;
			break;
		case 'U' :
			nAccessType |= MAN_TYPE_PUBLIC;
			nAccessType |= MAN_TYPE_VIRTUAL;
			break;
		case 'S' :
			nAccessType |= MAN_TYPE_PUBLIC;
			nAccessType |= MAN_TYPE_STATIC;
			bStatic = TRUE;
			break;
		case 'Y' :
			nAccessType |= MAN_TYPE_FUNCTION;
			break;
		default:
			// unknown
			fprintf( stderr, "Error : %c unknown access type\n", c);
	}

	c = rString.GetChar( 1 );
	switch (c)
	{
		case 'B' :
			nCalling |= MAN_TYPE_CONST;
		case 'A' :
			nCalling |= MAN_TYPE_THISCALL;
			break;
		case 'G' :
			nCalling |= MAN_TYPE_STDCALL;
			break;
		case '6' :
			nCalling |= MAN_TYPE_VTABLE;
			break;
		default:
			// unknown
			fprintf( stderr, "Error : %c unknown calling convention\n",c);
	}
	if (!( nAccessType & MAN_TYPE_FUNCTION ) && (!bStatic))
	{
		c = rString.GetChar( 2 );
		switch (c)
		{
			case 'E' :
				nCalling |= MAN_TYPE_CLASS;
				break;
			case 'H' :
				nCalling |= MAN_TYPE_FUNCTION;
				nCalling |= MAN_TYPE_CDECL;
				break;
		default:
			// unknown
			fprintf( stderr, "Error : %c unknown \n", c);
		}
	}
}

void DecoName::PrintRefs()
{
	USHORT i;
	USHORT nCount = pNameList->Count();
	for ( i=0; i< nCount; i++ )
	{
		ByteString* pStr = pNameList->GetObject(i);
		fprintf( stderr, "Ref Name %d : %s\n", i, pStr->GetBuffer());
	}
	nCount = pTypeList->Count();
	for ( i=0; i< nCount; i++ )
	{
		DecoType* pType = pTypeList->GetObject(i);
		ByteString aStr = PrintType( pType->GetType(), pType );
		fprintf( stderr, "Ref Type %d : %s\n", i, aStr.GetBuffer());
	}

}
