/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_appmac.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:03:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <mac_start.h>
#include <AppleEvents.h>
#include <AERegistry.h>
#include <mac_end.h>

#pragma hdrstop

#include "app.hxx"
#include "appdata.hxx"
#include "objsh.hxx"
namespace binfilter {


//========================================================================

/*?*/ pascal OSErr MyHandleDOSC( AppleEvent *messagein, AppleEvent*, long /* refIn */ )
/*?*/ {
/*?*/ 	SfxApplication *pSfxAppl = SFX_APP();
/*?*/ 	String	sAEDescString;
/*?*/ 	String	sBasicCmd;
/*?*/ 	AEDesc	aScriptCommand;
/*?*/ 	OSErr	aErr;
/*?*/ 
/*?*/ 	DBG_WARNING( "MyHandleDOSC startet" ) ;
/*?*/ 	aScriptCommand.descriptorType = typeNull;
/*?*/ 	aScriptCommand.dataHandle = nil;
/*?*/ 		// typeIntlText kommt, aber typeChar wird gewuenscht
/*?*/ 	aErr = AEGetParamDesc( messagein, keyDirectObject, typeChar, &aScriptCommand );
/*?*/ 	if (aScriptCommand.descriptorType == typeChar)
/*?*/ 	{	USHORT	aCmdLength;
/*?*/ 
/*?*/ 		if (aScriptCommand.dataHandle != 0L && (aCmdLength=GetHandleSize(aScriptCommand.dataHandle))>0L)
/*?*/ 		{
/*?*/ 			HLock(aScriptCommand.dataHandle);
/*?*/ 			sAEDescString = String((const char*)*(aScriptCommand.dataHandle),aCmdLength);
/*?*/ 			HUnlock(aScriptCommand.dataHandle);
/*?*/ 			sBasicCmd  = '[';
/*?*/ 			sBasicCmd += sAEDescString;
/*?*/ 			sBasicCmd += ']';
/*?*/ 			if (pSfxAppl)
/*?*/ 			{
/*?*/ 				long aBasicErr = pSfxAppl->DdeExecute(sBasicCmd);
/*?*/ 				if (aBasicErr == 0L)
/*?*/ 				{	// DBG_ASSERT( !aBasicErr, "Basic Fehler: aBasicErr == 0L" ) ;
/*?*/ 					DBG_WARNING( "Basic Fehler: aBasicErr == 0L" ) ;
/*?*/ 				}
/*?*/ 			}
/*?*/ 		}
/*?*/ 	}
/*?*/ 	else
/*?*/ 	if (aScriptCommand.descriptorType == typeIntlText)
/*?*/ 	{	DBG_ERROR( "CommandStringType == typeIntlText!!!" ) ;
/*?*/ 	}
/*?*/ 	else
/*?*/ 	{	DBG_ERROR( "Which dog ates my CommandString???" ) ;
/*?*/ 	}
/*?*/ 	aErr = AEDisposeDesc( &aScriptCommand );
/*?*/ 	return noErr;
/*?*/ }
/*?*/ 
/*?*/ void InstallAppleScriptHdl();
/*?*/ 
/*?*/ void InstallAppleScriptHdl()
/*?*/ {
/*?*/ 	AEEventHandlerUPP pProcPtr;
/*?*/ 	OSErr nErr;
/*?*/ 
/*?*/ 	pProcPtr = NewAEEventHandlerProc( MyHandleDOSC );
/*?*/ 	nErr = AEInstallEventHandler( kAEMiscStandards, kAEDoScript,
/*?*/ 								  pProcPtr, 0, false );
/*?*/ }

/*
typeIntlTexttext in a specific language
and script system
A typeIntlText descriptor record contains identifiers for the language and script system of text followed by the text itself.
Description	The dataHandle field of a typeIntlText descriptor record contains the following:
n	a 2-byte script code that identifies the script system of the text
n	a 2-byte language code that identifies the language of the text
n	the characters in the text (a series of either 1- or 2-byte characters; the script system determines whether the characters are 1 or 2 bytes in length)
The language and script system must be the same for all the characters of the text.
The integer codes used to specify script systems and languages are defined in the header files for the Script Manager. For information about these codes, see Chapter 14, Worldwide Software Overview, in Inside Macintosh, Volume VI.

Data Size	Variable
*/

}
