//                                               -*- C++ -*-
/**
 *  @file  HaltonSequence.hxx
 *  @brief Implementation of the Halton sequence
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy$
 *  @date:   $LastChangedDate$
 *  Id:      $Id$
 */

#ifndef OPENTURNS_HALTONSEQUENCE_HXX
#define OPENTURNS_HALTONSEQUENCE_HXX

#include <stdint.h>
#include "LowDiscrepancySequenceImplementation.hxx"
#include "Collection.hxx"

namespace OpenTURNS
{
  namespace Base
  {
    namespace Stat
    {
      /**
       * @class HaltonSequence
       */

      class HaltonSequence :
	public LowDiscrepancySequenceImplementation
      {
	CLASSNAME;

      public:

	// the initial seed
	static const UnsignedLong InitialSeed;

	typedef LowDiscrepancySequenceImplementation::NumericalPoint NumericalPoint;
      private:
	typedef Type::Collection<uint64_t>                           UInt64Collection;

      public:

	/** Constructor with parameters */
	explicit HaltonSequence(const UnsignedLong dimension = 1);

	/** Virtual constructor */
	virtual HaltonSequence * clone() const;

	/** Initialize the sequence */
	void initialize(const UnsignedLong dimension);

	/** Generate a quasi-random vector of numbers uniformly distributed over [0, 1[ */
	using LowDiscrepancySequenceImplementation::generate;
	NumericalPoint generate();

	/** String converter */
	String __repr__() const;

      private:
	/** Compute the n first prime numbers */
	static UInt64Collection ComputeFirstPrimeNumbers(const UnsignedLong n);

	/** Base for the generation of the sequence */
	UInt64Collection base_;

	/** Current seed into the sequence */
	uint64_t seed_;

      }; /* class HaltonSequence */

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_HALTONSEQUENCE_HXX */
