//                                               -*- C++ -*-
/**
 *  @file  t_AbdoRackwitz_nonlinear.cxx
 *  @brief The test file of class AbdoRackwitz for solving a nonlinear problem
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: t_AbdoRackwitz_nonlinear.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include <iostream>
#include <cmath>
#include <sstream>
#include <iomanip>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalMathFunction.hxx"
#include "Exception.hxx"
#include "AbdoRackwitz.hxx"
#include "NearestPointAlgorithm.hxx"
#include "NonCenteredFiniteDifferenceGradient.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Base::Optim;
using namespace OT::Base::Diff;

String printNumericalPoint(const NumericalPoint & point, const UnsignedLong digits)
{
  OSS oss;
  oss << "[";
  NumericalScalar eps(pow(0.1, digits));
  for (UnsignedLong i = 0; i < point.getDimension(); i++)
    {
      oss << std::fixed << std::setprecision(digits) << (i==0 ? "" : ",") << Bulk<double>((fabs(point[i]) < eps) ? fabs(point[i]) : point[i]);
    }
  oss << "]";
  return oss;
}

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    try {
      // Test function operator ()
      NumericalMathFunction levelFunction("TestOptimNonLinear");
      // Activate the cache as we will use an analytical method
      levelFunction.enableCache();
      // Add a finite difference gradient to the function, as Abdo Rackwitz algorithm
      // needs it
      NonCenteredFiniteDifferenceGradient myGradient(1e-7, levelFunction.getEvaluationImplementation());
      fullprint << "myGradient=" << myGradient << std::endl;
      /** Substitute the gradient */
      levelFunction.setGradientImplementation(new NonCenteredFiniteDifferenceGradient(myGradient));
      AbdoRackwitz::SpecificParameters specific;
      NumericalPoint startingPoint(4, 0.0);
      AbdoRackwitz myAlgorithm(specific, levelFunction);
      myAlgorithm.setStartingPoint(startingPoint);
      myAlgorithm.setLevelValue(-0.5);
      fullprint << "myAlgorithm = " << myAlgorithm << std::endl;
      myAlgorithm.run();
      fullprint << "result = " << printNumericalPoint(myAlgorithm.getResult().getMinimizer(), 4) << std::endl;
      fullprint << "evaluation calls number=" << levelFunction.getEvaluationCallsNumber() << std::endl;
      fullprint << "gradient   calls number=" << levelFunction.getGradientCallsNumber() << std::endl;
      fullprint << "hessian    calls number=" << levelFunction.getHessianCallsNumber() << std::endl;
    }
    catch (NoWrapperFileFoundException & ex) {
      throw TestFailed(ex.__repr__());
    }


  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
