// SWIG file ConfidenceInterval.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-11-09 17:38:15 +0100 (lun. 09 nov. 2009) $
// Id : $Id: ConfidenceInterval.i 1403 2009-11-09 16:38:15Z dutka $

%{
#include "ConfidenceInterval.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Base::Stat::ConfidenceInterval>
  {
    typedef _PySequence_ Type;
  };

  template <>
  inline
  OpenTURNS::Base::Stat::ConfidenceInterval
  convert<_PySequence_,OpenTURNS::Base::Stat::ConfidenceInterval>(PyObject * pyObj)
  {
    check<_PySequence_>( pyObj );
    if (PySequence_Fast_GET_SIZE( pyObj ) != 2) 
      throw Base::Common::InvalidArgumentException(HERE) << "Sequence passed as argument is not a pair (NumericalScalar, NumericalScalar)";
    PyObject * item_0 = PySequence_Fast_GET_ITEM( pyObj, 0 );
    check<_PyFloat_>( item_0 );
    PyObject * item_1 = PySequence_Fast_GET_ITEM( pyObj, 1 );
    check<_PyFloat_>( item_1 );
    return Base::Stat::ConfidenceInterval( convert<_PyFloat_,NumericalScalar>( item_0 ),
			                   convert<_PyFloat_,NumericalScalar>( item_1 ) );
  }


} /* namespace OpenTURNS */

%}

%include ConfidenceInterval.hxx
namespace OpenTURNS{ namespace Base { namespace Stat {

%extend ConfidenceInterval {

ConfidenceInterval(const ConfidenceInterval & other) { return new OpenTURNS::Base::Stat::ConfidenceInterval(other); }

ConfidenceInterval(PyObject * pyObj)
{
 return new OpenTURNS::Base::Stat::ConfidenceInterval( OpenTURNS::convert<OpenTURNS::_PySequence_,OpenTURNS::Base::Stat::ConfidenceInterval>(pyObj) );
}

}

}}}
