//                                               -*- C++ -*-
/**
 *  @file  FiniteDifferenceStep.hxx
 *  @brief Interface for finite difference steps
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: slama $
 *  @date:   $LastChangedDate: 2008-11-19 16:10:42 +0100 (mer, 19 nov 2008) $
 *  Id:      $Id: FiniteDifferenceStep.hxx 1023 2008-11-19 15:10:42Z slama $
 */

#ifndef OPENTURNS_FINITEDIFFERENCESTEP_HXX
#define OPENTURNS_FINITEDIFFERENCESTEP_HXX

#include "TypedInterfaceObject.hxx"
#include "FiniteDifferenceStepImplementation.hxx"

BEGIN_NAMESPACE_OPENTURNS



class FiniteDifferenceStep
  : public TypedInterfaceObject<FiniteDifferenceStepImplementation>
{
  CLASSNAME;
public:

  /** Default constructor */
  FiniteDifferenceStep();

  /** Parameters constructor */
  explicit FiniteDifferenceStep(const NumericalPoint & eps);

  /** Constructor from implementation */
  FiniteDifferenceStep(const FiniteDifferenceStepImplementation & implementation);

#ifndef SWIG
  /** Constructor from implementation pointer */
  FiniteDifferenceStep(const Implementation & p_implementation);
#endif
  /** String converter */
  String __repr__() const;

  /** Epsilon accessor */
  void setEpsilon(const NumericalPoint & epsilon);
  NumericalPoint getEpsilon() const;

  /** Compute step */
  NumericalPoint operator()(const NumericalPoint & inP) const;

};

END_NAMESPACE_OPENTURNS





#endif

