//                                               -*- C++ -*-
/**
 *  @file  HistoryStrategy.hxx
 *  @brief
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: HistoryStrategy.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_HISTORYSTRATEGY_HXX
#define OPENTURNS_HISTORYSTRATEGY_HXX

#include "HistoryStrategyImplementation.hxx"
#include "Pointer.hxx"
#include "TypedInterfaceObject.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class HistoryStrategy
 */

class HistoryStrategy
  : public TypedInterfaceObject<HistoryStrategyImplementation>
{

  CLASSNAME;

public:

  typedef Pointer<HistoryStrategyImplementation> Implementation;

  /** Default constructor */
  explicit HistoryStrategy();

  /** Constructor with parameters */
  HistoryStrategy(const HistoryStrategyImplementation & implementation);

  /** Constructor with parameters */
  HistoryStrategy(Implementation & p_implementation);

  /** Store the point according to the strategy */
  void store(const NumericalPoint & point);
  void store(const NumericalSample & sample);


  /** Reset the history storage through the isInitialized_ flag */
  void reset();

  /** History sample accessor */
  NumericalSample getSample() const;

  /** String converter */
  String __repr__() const;

} ; /* class HistoryStrategy */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_HISTORYSTRATEGY_HXX */
