//                                               -*- C++ -*-
/**
 *  @file  csv_parser_state.hxx
 *  @brief The definition of the internal state of the CSV parser
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: csv_parser_state.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_CSV_PARSER_STATE_HXX
#define OPENTURNS_CSV_PARSER_STATE_HXX

#include <string>
#include "NumericalPoint.hxx"
#include "Description.hxx"

BEGIN_NAMESPACE_OPENTURNS



struct CSVParserState
{

  enum FieldType { NotSet, RealField, StringField };

  FieldType                     Type;
  std::string                   St;
  double                        Val;
  bool                          errors;
  NumericalPoint                Point;
  Description                   Header;
  FileName                      theFileName;

  CSVParserState() : Type(NotSet),St(),Val(0.),errors(false),Point(),Header(),theFileName() {}

}; /* end struct CSVParserState */


END_NAMESPACE_OPENTURNS


#endif /* OPENTURNS_CSV_PARSER_STATE_HXX */
