//                                               -*- C++ -*-
/**
 *  @file  UsualDistribution.cxx
 *  @brief Abstract top-level class for all standard distributions
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: UsualDistribution.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include "UsualDistribution.hxx"

BEGIN_NAMESPACE_OPENTURNS



CLASSNAMEINIT(UsualDistribution);

/* Default constructor */
UsualDistribution::UsualDistribution(const String & name)
  : DistributionImplementation(name)
{
  // Nothing to do
}

/* Virtual constructor */
UsualDistribution * UsualDistribution::clone() const
{
  return new UsualDistribution(*this);
}

/* String converter */
String UsualDistribution::__repr__() const {
  OSS oss;
  oss << "class=" << UsualDistribution::GetClassName();
  return oss;
}

/* Tell if the distribution is elliptical */
Bool UsualDistribution::isElliptical() const
{
  return false;
}

/* Tell if the distribution is continuous */
Bool UsualDistribution::isContinuous() const
{
  return false;
}




END_NAMESPACE_OPENTURNS
