//                                               -*- C++ -*-
/**
 *  @file  UsualRandomVector.hxx
 *  @brief An implementation class for distribution-based random vectors
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: UsualRandomVector.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_USUALRANDOMVECTOR_HXX
#define OPENTURNS_USUALRANDOMVECTOR_HXX

#include "OTprivate.hxx"
#include "RandomVectorImplementation.hxx"
#include "Distribution.hxx"

BEGIN_NAMESPACE_OPENTURNS





/**
 * @class UsualRandomVector
 *
 * An implementation class for distribution-based random vectors
 */
class UsualRandomVector
  : public RandomVectorImplementation
{
  CLASSNAME;

public:

  /** Some typedefs to ease reading */


  /** Default constructor */
  UsualRandomVector(const Distribution & distribution,
                    const String & name = DefaultName);


  /** Virtual constructor */
  UsualRandomVector * clone() const;

  /** String converter */
  String __repr__() const;


  /* Here is the interface that all derived class must implement */

  /** Dimension accessor */
  UnsignedLong getDimension() const;

  /** Realization accessor */
  NumericalPoint getRealization() const;

  /** Numerical sample accessor */
  NumericalSample getNumericalSample(UnsignedLong size) const;

  /** Mean accessor */
  NumericalPoint getMean() const;

  /** Covariance accessor */
  CovarianceMatrix getCovariance() const;

  /** Get the random vector corresponding to the i-th marginal component */
  UsualRandomVector * getMarginal(const UnsignedLong i) const;

  /** Get the marginal random vector corresponding to indices components */
  UsualRandomVector * getMarginal(const Indices & indices) const;

  /** Distribution accessor */
  Distribution getDistribution() const;

  /** Method save() stores the object through the StorageManager */
  void save(Advocate & adv) const;

  /** Method load() reloads the object from the StorageManager */
  void load(Advocate & adv);

protected:

  friend class Factory<UsualRandomVector>;

  /** Default constructor */
  UsualRandomVector(const String & name = DefaultName) : RandomVectorImplementation(name) {};

private:

  /** The distribution the vector follows */
  Distribution distribution_;

}; /* class UsualRandomVector */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_USUALRANDOMVECTOR_HXX */
