###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for avahi FEDORA-2007-018
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861059);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "FEDORA", value: "2007-018");
  script_cve_id("CVE-2006-6870", "CVE-2006-5461");
  script_name( "Fedora Update for avahi FEDORA-2007-018");
  desc = "

  Vulnerability Insight:
  Avahi is a system which facilitates service discovery on
  a local network -- this means that you can plug your laptop or
  computer into a network and instantly be able to view other people who
  you can chat with, find printers to print to or find files being
  shared. This kind of technology is already found in MacOS X (branded
  'Rendezvous', 'Bonjour' and sometimes 'ZeroConf') and is very
  convenient.


  Affected Software/OS:
  avahi on Fedora Core 5

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-January/msg00035.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of avahi");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC5")
{

  if(isrpmvuln(pkg:"avahi", rpm:"avahi~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/avahi-debuginfo", rpm:"x86_64/debug/avahi-debuginfo~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/avahi-compat-howl", rpm:"x86_64/avahi-compat-howl~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/avahi-compat-libdns_sd-devel", rpm:"x86_64/avahi-compat-libdns_sd-devel~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/avahi-tools", rpm:"x86_64/avahi-tools~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/avahi-glib", rpm:"x86_64/avahi-glib~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/avahi", rpm:"x86_64/avahi~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/avahi-qt3", rpm:"x86_64/avahi-qt3~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/avahi-qt3-devel", rpm:"x86_64/avahi-qt3-devel~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/avahi-devel", rpm:"x86_64/avahi-devel~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/avahi-compat-libdns_sd", rpm:"x86_64/avahi-compat-libdns_sd~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/avahi-sharp", rpm:"x86_64/avahi-sharp~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/avahi-compat-howl-devel", rpm:"x86_64/avahi-compat-howl-devel~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/avahi-glib-devel", rpm:"x86_64/avahi-glib-devel~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/avahi-sharp", rpm:"i386/avahi-sharp~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/avahi-compat-howl", rpm:"i386/avahi-compat-howl~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/avahi-compat-howl-devel", rpm:"i386/avahi-compat-howl-devel~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/avahi-glib-devel", rpm:"i386/avahi-glib-devel~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/avahi-tools", rpm:"i386/avahi-tools~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/avahi", rpm:"i386/avahi~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/avahi-glib", rpm:"i386/avahi-glib~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/avahi-devel", rpm:"i386/avahi-devel~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/avahi-qt3", rpm:"i386/avahi-qt3~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/avahi-compat-libdns_sd", rpm:"i386/avahi-compat-libdns_sd~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/avahi-qt3-devel", rpm:"i386/avahi-qt3-devel~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/avahi-compat-libdns_sd-devel", rpm:"i386/avahi-compat-libdns_sd-devel~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/avahi-debuginfo", rpm:"i386/debug/avahi-debuginfo~0.6.11~3.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}