###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_oxid_eshop_unauth_write_vuln.nasl 4614 2009-09-10 16:37:41Z sep $
#
# OXID eShop Community Edition Unauthorized Write Access Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900935);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3113");
  script_name("OXID eShop Community Edition Unauthorized Write Access Vulnerability");
  desc = "
  Overview: This host is installed with OXID eShop Community Edition
  and is prone to unauthorized access vulnerability.

  Vulnerability Insight:
  User supplied data passed to and unspecified variable is not sanitised
  before processing.

  Impact:
  Successful exploitation will allow remote attackers to gain unauthorized
  write access to product reviews via specially crafted URLs.

  Impact Level: Application

  Affected Software/OS:
  OXID eShop Community Edition version 4.x through 4.1.1

  Fix: Upgrade to version 4.1.2
  http://www.oxidforge.org/wiki/Category:Downloads

  References:
  http://en.securitylab.ru/nvd/385007.php
  http://www.oxidforge.org/wiki/Security_bulletins/2009-002

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of OXID eShop Community Edition");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_oxid_eshop_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

eshopPort = get_http_port(default:80);
if(!eshopPort)
{
  exit(0);
}

eshopVer = get_kb_item("www/" + eshopPort + "/OXID-eShop");

if(!isnull(eshopVer))
{
  eshopVer = eregmatch(pattern:"^(.+) under (/.*)$", string:eshopVer);
  if(eshopVer[1] != NULL)
  {
    if(version_in_range(version:eshopVer[1], test_version:"4.0",
                                            test_version2:"4.1.1")){
      security_warning(eshopPort);
    }
  }
}
