# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory SUSE-SA:2009:024 (cups)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63889);
 script_cve_id("CVE-2009-0146", "CVE-2009-0147", "CVE-2009-0163", "CVE-2009-0165", "CVE-2009-0166", "CVE-2009-0799", "CVE-2009-0800", "CVE-2009-1179", "CVE-2009-1180", "CVE-2009-1181", "CVE-2009-1182", "CVE-2009-1183");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "SuSE Security Advisory SUSE-SA:2009:024 (cups)";
 script_name(name);

 desc = "The remote host is missing updates announced in
advisory SUSE-SA:2009:024.

The Common Unix Printing System, CUPS, is a printing server for unix-like
operating systems. It allows a local user to print documents as well as
remote users via port 631/tcp.

There were two security vulnerabilities fixed in cups.

The first one can be triggered by a specially crafted tiff file. This
file could lead to an integer overflow in the 'imagetops' filter which
caused an heap overflow later.
This bug is probably exploitable remotely by users having remote access
to the CUPS server and allows the execution of arbitrary code with the
privileges of the cupsd process. (CVE-2009-0163)

The second issue affects the JBIG2 decoding of the 'pdftops' filter.
The JBIG2 decoding routines are vulnerable to various software failure
types like integer and buffer overflows and it is believed to be exploit-
able remotely to execute arbitrary code with the privileges of the cupsd
process.
(CVE-2009-0146, CVE-2009-0147, CVE-2009-0165, CVE-2009-0166, CVE-2009-0799,
CVE-2009-0800, CVE-2009-1179, CVE-2009-1180, CVE-2009-1181, CVE-2009-1182,
CVE-2009-1183)

Solution:
Update your system with the packages as indicated in
the referenced security advisory.

https://secure1.securityspace.com/smysecure/catid.html?in=SUSE-SA:2009:024

Risk factor : High";

 script_description(desc);

 summary = "SuSE Security Advisory SUSE-SA:2009:024 (cups)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "SuSE Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"cups-debuginfo", rpm:"cups-debuginfo~1.3.9~7.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-debugsource", rpm:"cups-debugsource~1.3.9~7.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups", rpm:"cups~1.3.9~7.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.3.9~7.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.3.9~7.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.3.9~7.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-debuginfo", rpm:"cups-debuginfo~1.3.7~25.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-debugsource", rpm:"cups-debugsource~1.3.7~25.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups", rpm:"cups~1.3.7~25.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.3.7~25.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.3.7~25.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.3.7~25.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups", rpm:"cups~1.2.12~22.21", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.2.12~22.21", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.2.12~22.21", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.2.12~22.21", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs-64bit", rpm:"cups-libs-64bit~1.3.9~7.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs-64bit", rpm:"cups-libs-64bit~1.3.7~25.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs-64bit", rpm:"cups-libs-64bit~1.2.12~22.21", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs-32bit", rpm:"cups-libs-32bit~1.3.9~7.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs-32bit", rpm:"cups-libs-32bit~1.3.7~25.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs-32bit", rpm:"cups-libs-32bit~1.2.12~22.21", rls:"openSUSE10.3")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
