/***********************************/ 
/* oroborus (c) Ken Lynch Jan 2001 */ 
/* Distributed under the GPL       */ 
/* See LICENSE for more details    */ 
/***********************************/ 
 
#include "oroborus.h" 
 
/* 
 * 
 * Get motif hints (returns NULL if hints not set by client) 
 * 
 */ 

PropMwmHints *get_mwm_hints(Window w) 
{ 
  Atom real_type; 
  int real_format; 
  unsigned long items_read, items_left; 
  PropMwmHints *data=NULL; 
 
#ifdef DEBUG 
  printf("get_mwm_hints\n"); 
#endif 
 
  if(XGetWindowProperty(dpy, w, motif[MOTIF_WM_HINTS], 0L, 20L, False, motif[MOTIF_WM_HINTS], &real_type, &real_format, &items_read, &items_left, (unsigned char **) &data)==Success)
    return data; 
  else 
    return NULL; 
} 
 
/* 
 * 
 * Set ICCCM window state 
 * 
 */ 
void set_wm_state(Window w, int state) 
{ 
  CARD32 data[2]; 
 
#ifdef DEBUG 
  printf("set_wm_state\n"); 
#endif 
 
  data[0]=state; 
  data[1]=None; 
 
  XChangeProperty(dpy, w, icccm[WM_STATE], icccm[WM_STATE], 32, PropModeReplace, (unsigned char *)data, 2); 
} 
 
/* 
 * 
 * Get ICCCM window state 
 * 
 */ 

long get_wm_state(Window w) 
{ 
  Atom real_type; 
  int real_format; 
  unsigned long items_read, items_left; 
  long *data=NULL, state = WithdrawnState; 
 
#ifdef DEBUG 
  printf("get_wm_state\n"); 
#endif 
 
  if(XGetWindowProperty(dpy, w, icccm[WM_STATE], 0L, 2L, False, icccm[WM_STATE], &real_type, &real_format, &items_read, &items_left, (unsigned char **)&data)==Success && items_read) 
  { 
    state=*data; 
    XFree(data); 
  } 
  return state; 
} 
 
/* 
 * 
 * Set GNOME hint 
 * 
 */ 

void set_gnome_hint(Window w, int a, long value) 
{ 
#ifdef DEBUG 
  printf("set_gnome_hint\n"); 
#endif 
 
#ifdef WORKSPACE_SUPPORT 
  if(a==WIN_WORKSPACE && (value<0 || value>=config.workspace_count)) return; 
  if(a==WIN_WORKSPACE_COUNT && value<=0) return; 
#endif 
 
  XChangeProperty(dpy, w, gnome[a], XA_CARDINAL, 32, PropModeReplace, (unsigned char *)&value, 1); 
} 
 
/* 
 * 
 * Get GNOME hint 
 * 
 */ 
long get_gnome_hint(Window w, int a) 
{ 
  Atom real_type; 
  int real_format; 
  unsigned long items_read, items_left; 
  long *data=NULL, value=0; 
 
#ifdef DEBUG 
  printf("get_gnome_hint\n"); 
#endif 
 
  if(a==WIN_LAYER) value=WIN_LAYER_NORMAL; 
 
  if(XGetWindowProperty(dpy, w, gnome[a], 0L, 1L, False, XA_CARDINAL, &real_type, &real_format, &items_read, &items_left, (unsigned char **)&data)==Success && items_read) 
  { 
    value=*data; 
    XFree(data); 
  } 
  return value; 
} 
 
/* 
 * 
 * Update GNOME client list 
 * 
 */ 

void update_gnome_client_list() 
{ 
  Client *c; 
  CARD32 *wins=NULL; 
  long i; 
 
#ifdef DEBUG 
  printf("update_client_list\n"); 
#endif 
 
  if((wins=malloc(sizeof(CARD32)*client_count))==NULL)
  { 
    fprintf(stderr, "%s: Memory allocation failed in function update_gnome_client.\n", PROGNAME); 
    exit(1);
  }
 
  c=client_list; 
  for(i=0;i<client_count;i++) 
  { 
    wins[i]=c->window; 
    c=c->next; 
  } 
 
  XChangeProperty(dpy, root, gnome[WIN_CLIENT_LIST], XA_CARDINAL, 32, PropModeReplace, (unsigned char *)wins, client_count); 
   
  if(wins) free(wins); 
} 
