/***********************************/ 
/* oroborus (c) Ken Lynch Jan 2001 */ 
/* Distributed under the GPL       */ 
/* See LICENSE for more details    */ 
/***********************************/ 
 
#include "oroborus.h" 
 
/* 
 * 
 * Print out X errors 
 * 
 */ 

int handle_xerror(Display *dpy, XErrorEvent *err) 
{ 
  char msg[1024]; 
 
#ifdef DEBUG 
  printf("handle_xerror\n"); 
#endif 
 
  switch(err->error_code) 
  { 
  case BadAccess:  
    if(err->resourceid==root)
    {
      fprintf(stderr, "%s: Another window manger is running.\n", PROGNAME);
      exit(1);
    }
    break; 
  case BadWindow: 
  case BadDrawable: 
  case BadMatch: 
    break; 
  default: 
    XGetErrorText(dpy, err->error_code, msg, 1024); 
    fprintf(stderr, "%s: X Error (%#lx): %s.\n", PROGNAME, err->resourceid, msg); 
  } 
  return 0; 
} 

/*
 *
 * Add directory to font path
 *
 */

void add_dir_to_font_path(char *font_dir)
{
  char **font_path, **new_font_path, *file_name;
  int npaths;
  FILE *file;

#ifdef DEBUG
  printf("add_dir_to_font_path\n");
#endif

  if((file_name=malloc(strlen(font_dir)+strlen("fonts.dir")+2))==NULL)
  {
    fprintf(stderr, "%s: Memory allocation failed in function add_dir_to_font_path.\n", PROGNAME);
    exit(1);
  }

  if((file=fopen(file_name, "r")))
  {
    fclose(file);
    font_path=XGetFontPath(dpy, &npaths);
    if((new_font_path=malloc(sizeof(char *)*(npaths+1)))==NULL)
    {
      fprintf(stderr, "%s: Memory allocation failed in function add_dir_to_font_path.\n", PROGNAME);
      exit(1);
    }
    memcpy(new_font_path, font_path, sizeof(char*)*npaths);
    new_font_path[npaths]=font_dir;
    XSetFontPath(dpy, new_font_path, npaths+1);
    XFreeFontPath(font_path);
    free(new_font_path);
  }
}

/*
 *
 * Remove directory from font path
 *
 */

void rem_dir_from_font_path(char *font_dir)
{
  char **font_path, **new_font_path;
  int npaths, i, j=0;

#ifdef DEBUG
  printf("rem_dir_from_font_path\n");
#endif

  font_path=XGetFontPath(dpy, &npaths);
  if((new_font_path=malloc(sizeof(char *)*npaths))==NULL)
  {
    fprintf(stderr, "%s: Memory allocation failed in function rem_dir_from_font_path.\n", PROGNAME);
    exit(1);
  }
  for(i=0;i<npaths;i++)
  {
    if(strcmp(font_path[i], font_dir))
      new_font_path[j++]=font_path[i];
  }
  XSetFontPath(dpy, new_font_path, j);
  XFreeFontPath(font_path);
  free(new_font_path);
}

/* 
 * 
 * Get mouse x any y 
 * 
 */ 

void get_mouse_xy(int *x, int *y) 
{ 
  Window w1, w2; 
  int wx, wy, mask; 
 
#ifdef DEBUG 
  printf("get_mouse_xy\n"); 
#endif 
 
  XQueryPointer(dpy, root, &w1, &w2, x, y, &wx, &wy, &mask); 
} 
 
/* 
 * 
 * Get window under pointer 
 * 
 */ 

Window get_pointer_win(Window w) 
{ 
  Window w1, w2; 
  int x, y, wx, wy, mask; 
 
#ifdef DEBUG 
  printf("get_pointer_win\n"); 
#endif 
 
  XQueryPointer(dpy, w, &w1, &w2, &x, &y, &wx, &wy, &mask); 
  return w2; 
} 
 
/* 
 * 
 * Get window parent 
 * 
 */ 

Window get_window_parent(Window win) 
{ 
  Window parent, dummyw, *windows=NULL; 
  int count; 
 
#ifdef DEBUG 
  printf("get_window_parent\n"); 
#endif 
 
  XQueryTree(dpy, win, &dummyw, &parent, &windows, &count); 
  if(windows) XFree(windows); 
  return parent; 
} 
 
/* 
 * 
 * Screen width 
 * 
 */ 
int screen_width(int head) 
{ 
#ifdef DEBUG 
  printf("screen_width\n"); 
#endif 
 
#ifdef XINERAMA_SUPPORT 
  if(xinerama) 
    return xinerama_screens[head].width; 
#endif /* XINERAMA */ 
  return XDisplayWidth(dpy, screen); 
} 
 
/* 
 * 
 * Screen height 
 * 
 */ 

int screen_height(int head) 
{ 
#ifdef DEBUG 
  printf("screen_height\n"); 
#endif 
 
#ifdef XINERAMA_SUPPORT 
  if(xinerama) 
    return xinerama_screens[head].height; 
#endif /* XINERAMA */ 
  return XDisplayHeight(dpy, screen); 
} 
 
/* 
 * 
 * Screen x 
 * 
 */ 

int screen_x(int head) 
{ 
#ifdef DEBUG 
  printf("screen_x\n"); 
#endif 
 
#ifdef XINERAMA_SUPPORT 
  if(xinerama) 
    return xinerama_screens[head].x_org; 
#endif /* XINERAMA */ 
  return 0; 
} 
 
/* 
 * 
 * Screen y 
 * 
 */ 

int screen_y(int head) 
{ 
#ifdef DEBUG 
  printf("screen_y\n"); 
#endif 
 
#ifdef XINERAMA_SUPPORT 
  if(xinerama) 
    return xinerama_screens[head].y_org; 
#endif /* XINERAMA */ 
  return 0; 
} 
 
#ifdef XINERAMA_SUPPORT 
/* 
 * 
 * Find head 
 * 
 */ 

int find_head(int x, int y) 
{ 
  int head, cx, cy, dx, dy, min_dist_sqr, dist_sqr, closest_head; 
 
#ifdef DEBUG 
  printf("find_head\n"); 
#endif 
 
  for(head=0;head<xinerama_heads;head++) 
  { 
    if(x>=xinerama_screens[head].x_org && x<xinerama_screens[head].x_org+xinerama_screens[head].width && y>=xinerama_screens[head].y_org && y<xinerama_screens[head].y_org+xinerama_screens[head].height) 
      return head; 
  } 
  
#ifdef DEBUG 
  printf("  no head found, looking for nearest head...\n"); 
#endif 
  
  /* No head found, return closest */ 
  cx=xinerama_screens[0].x_org+(xinerama_screens[0].width/2); 
  cy=xinerama_screens[0].y_org+(xinerama_screens[0].height/2); 
 
  dx=x-cx; 
  dy=y-cy; 
  min_dist_sqr=(dx*dx)+(dy*dy); 
  closest_head=0; 
 
  for(head=1;head<xinerama_heads;head++) 
  { 
    cx=xinerama_screens[head].x_org+(xinerama_screens[head].width/2); 
    cy=xinerama_screens[head].y_org+(xinerama_screens[head].height/2); 
 
    dx=x-cx; 
    dy=y-cy; 
    dist_sqr=(dx*dx)+(dy*dy); 
     
    if(dist_sqr<min_dist_sqr) 
    { 
      closest_head=head; 
      min_dist_sqr=dist_sqr; 
    } 
  } 
 
  return closest_head; 
} 
#endif /* XINERAMA */ 
 
#ifdef I18N_SUPPORT 
/* 
 * 
 * some wrapper functions for I18N 
 * 
 */ 

Status XGetWMNameWrapper(Display *dpy, Window window, XTextProperty *text_prop) 
{  
  int status; 
  char **list; 
  int num; 
  
  status = XGetWMName(dpy, window, text_prop); 
  if (!status || !text_prop->value || text_prop->nitems <= 0) 
    return 0; 
  if (text_prop->encoding == XA_STRING) 
    return 1; 
   
  text_prop->nitems = strlen((char *)text_prop->value); 
  status = XmbTextPropertyToTextList(dpy, text_prop, &list, &num); 
   
  if (status >= Success && num > 0 && *list)
  { 
    if(text_prop->value) XFree(text_prop->value); 
    text_prop->value = (unsigned char*)strdup(*list); 
    text_prop->nitems = strlen(*list); 
    if(list) XFreeStringList(list); 
    return 1; 
  } 
   
  return 0; 
} 
 
Status XFetchNameWrapper(Display *dpy, Window window, char **name) 
{  
  XTextProperty text_prop; 
   
  if (XGetWMNameWrapper(dpy, window, &text_prop) != 0)
  { 
    if (text_prop.value && text_prop.nitems > 0)
    { 
      *name = (char *)text_prop.value; 
      return 1; 
    } 
  } 
  *name = NULL; 
  return 0; 
} 
 
XFontSet XLoadQueryFontWrapper(Display *dpy, const char *font_name) 
{ 
  char **miss, *def=NULL; 
  int n_miss; 
  char *base_font_name_list=NULL; 
  int font_name_list_length; 
  XFontSet _fontset; 
 
  font_name_list_length = strlen(font_name) + 3; 
  base_font_name_list = (char *) malloc(sizeof(char) * font_name_list_length); 
  if (!base_font_name_list)
  { 
    fprintf(stderr, "%s: Memory allocation failed in function XLoadQueryFontWrapper.\n", PROGNAME);
    exit(1);
  }
  sprintf(base_font_name_list, "%s,*", font_name); 
  _fontset = XCreateFontSet(dpy, base_font_name_list, &miss, &n_miss, &def); 
  if (!_fontset)
  {
    free(base_font_name_list);
    return NULL;
  }
  if (n_miss)
  { 
    int j; 
    fprintf(stderr, "%s: XLoadQueryFontWrapper(): missing charset(s)\n", PROGNAME); 
    for (j=0; j<n_miss; j++)  
      fprintf(stderr, "\t%s\n", miss[j]); 
    XFreeStringList(miss); 
  } 
  free(base_font_name_list);
  return _fontset; 
} 
#endif /* I18N */ 
