/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.io.Serializable;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.javagroups.JChannel;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.Transport;
import org.javagroups.View;
import org.javagroups.blocks.PullPushAdapter;
import org.javagroups.util.Promise;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConnectTest
extends TestCase {
    JChannel channel;
    final int TIMES = 10;
    String props;
    static /* synthetic */ Class class$org$javagroups$tests$ConnectTest;

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    void doIt(int times) {
        int i = 0;
        while (i < times) {
            System.out.println("\nAttempt #" + (i + 1));
            System.out.print("Connecting to channel: ");
            try {
                this.channel.connect("ConnectTest");
                System.out.println("-- connected --");
            }
            catch (Exception e) {
                System.out.println("-- connection failed --");
                System.err.println(e);
            }
            System.out.print("Disconnecting from channel: ");
            this.channel.disconnect();
            System.out.println("-- disconnected --");
            ++i;
        }
    }

    public void testConnectAndDisconnect() throws Exception {
        System.out.print("Creating channel: ");
        this.channel = new JChannel(this.props);
        System.out.println("-- created --");
        this.doIt(10);
        System.out.print("Closing channel: ");
        this.channel.close();
        System.out.println("-- closed --");
        this.channel.close();
        System.out.println("Remaining threads are:");
        Util.printThreads();
    }

    public void testDisconnectConnectOne() throws Exception {
        this.channel = new JChannel(this.props);
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup2");
        View view = this.channel.getView();
        ConnectTest.assertEquals((int)1, (int)view.size());
        ConnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
    }

    public void testDisconnectConnectTwo() throws Exception {
        JChannel coordinator = new JChannel(this.props);
        coordinator.connect("testgroup");
        View view = coordinator.getView();
        System.out.println("-- view for coordinator: " + view);
        this.channel = new JChannel(this.props);
        this.channel.connect("testgroup1");
        view = this.channel.getView();
        System.out.println("-- view for channel: " + view);
        this.channel.disconnect();
        this.channel.connect("testgroup");
        view = this.channel.getView();
        System.out.println("-- view for channel: " + view);
        ConnectTest.assertEquals((int)2, (int)view.size());
        ConnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
        ConnectTest.assertTrue((boolean)view.containsMember(coordinator.getLocalAddress()));
        coordinator.close();
    }

    public void testDisconnectConnectSendTwo() throws Exception {
        Promise msgPromise = new Promise();
        JChannel coordinator = new JChannel(this.props);
        coordinator.connect("testgroup");
        PullPushAdapter ppa = new PullPushAdapter((Transport)coordinator, new PromisedMessageListener(msgPromise));
        ppa.start();
        this.channel = new JChannel(this.props);
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup");
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        Message msg = (Message)msgPromise.getResult(20000L);
        boolean bl = false;
        if (msg != null) {
            bl = true;
        }
        ConnectTest.assertTrue((boolean)bl);
        ConnectTest.assertEquals((Object)"payload", (Object)msg.getObject());
        ppa.stop();
        coordinator.close();
    }

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class clazz = class$org$javagroups$tests$ConnectTest;
        if (clazz == null) {
            clazz = class$org$javagroups$tests$ConnectTest = ConnectTest.class$("[Lorg.javagroups.tests.ConnectTest;", false);
        }
        stringArray[0] = clazz.getName();
        String[] testCaseName = stringArray;
        TestRunner.main((String[])testCaseName);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.TIMES = 10;
        this.props = "UDP(mcast_addr=228.8.8.8;mcast_port=45566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=4096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=false)";
    }

    public ConnectTest(String name) {
        super(name);
        this.this();
    }

    private class PromisedMessageListener
    implements MessageListener {
        private Promise promise;

        public byte[] getState() {
            return null;
        }

        public void receive(Message msg) {
            this.promise.setResult(msg);
        }

        public void setState(byte[] state) {
        }

        public PromisedMessageListener(Promise promise) {
            this.promise = promise;
        }
    }
}

