/*
*
* Copyright (C) 2004, 2005, 2006 Mekensleep
*
* Mekensleep
* 24 rue vieille du temple
* 75004 Paris
*       licensing@mekensleep.com
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA.
*
* Authors:
*  Igor Kravtchenko <igor@tsarevitch.org>
*
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef USE_NPROFILE
#include <nprofile/profile.h>
#else  // USE_NPROFILE
#define NPROFILE_SAMPLE(a)
#endif // USE_NPROFILE

#include <osgCal/ImageCache>

#include <osg/Notify>
#include <osgDB/FileNameUtils>

namespace osgCal {

static std::map<std::string, ReadImageFunctor*> g_fn2rif;

osgDB::ReaderWriter::ReadResult ReadImageFunctor::doRead(osgDB::ReaderWriter &_rw) const
{
	_stream.seekg(0, std::ios::beg); // be sure we begin (again) at position 0
	return _rw.readImage((std::istream&)_stream, _options);
}

void* ImageCache::getOrLoadBinary(const std::string &_filename)
{
	ReadImageFunctor *rif = getOrCreateRIF(_filename);
	if (!rif)
		return NULL;

	return 0; //(void*) rif->_stream.str().c_str();
}

osg::Image* ImageCache::loadImage(const std::string &_filename)
{
	ReadImageFunctor *rif = getOrCreateRIF(_filename);

	osg::Image *img = NULL;

	if (rif) {
		osgDB::ReaderWriter *rw = osgDB::Registry::instance()->getReaderWriterForExtension(osgDB::getLowerCaseFileExtension(_filename));
		if (!rw) {
			osg::notify(osg::FATAL) << "ImageCache:: not any OSG plugin to load " << _filename << std::endl;
			return NULL;
		}
		osgDB::ReaderWriter::ReadResult res = rif->doRead(*rw);
		img = res.getImage();
		if (!img) {
			osg::notify(osg::FATAL) << "ImageCache:: OSG plugin failed to load " << _filename << std::endl;
			return NULL;
		}
		img->ref();
	}

	return img;
}

void ImageCache::removeImage(const std::string &_filename)
{
	std::map<std::string, ReadImageFunctor*>::iterator it = g_fn2rif.find(_filename);

	if (it != g_fn2rif.end()) {
		ReadImageFunctor *rif = it->second;
		delete rif;
		g_fn2rif.erase(it);
	}
	else {
		osg::notify(osg::NOTICE) << "ImageCache:: cannot remove " << _filename << " (doesn't exist in memory)" << std::endl;
	}
}

ReadImageFunctor* ImageCache::getOrCreateRIF(const std::string &_filename)
{
	std::map<std::string, ReadImageFunctor*>::iterator it = g_fn2rif.find(_filename);

	if (it != g_fn2rif.end()) {
		ReadImageFunctor *rif = it->second;
		return rif;
	}

	FILE *file = fopen(_filename.c_str(), "rb");
	if (!file) {
		osg::notify(osg::FATAL) << "ImageCache:: cannot open " << _filename << std::endl;
		return NULL;
	}

	fseek(file, 0, SEEK_END);
	int filesize = ftell(file);
	if (!filesize) {
		osg::notify(osg::FATAL) << "ImageCache:: " << _filename << " is an empty file (0 byte)" << std::endl;
		return NULL;
	}
	fseek(file, 0, SEEK_SET);

	ReadImageFunctor *rif = new ReadImageFunctor(_filename, NULL);
	char *ptr = new char[filesize];
	fread(ptr, 1, filesize, file);
	fclose(file);

	std::string str(ptr, filesize);
	rif->_stream.str(str);

	/*
	memorystream *st = new memorystream(rif->_ptr, filesize);
	((std::istream&)rif->_stream).rdbuf(st);
	rif->_memstream = st;
	*/

//	int pos = rif->_stream.tellg();
	//char toto[18];
	//rif->_stream.read(toto, 18);

	delete [] ptr;

	g_fn2rif[_filename] = rif;

	return rif;
}

}
