/*-
 * Copyright (c) 1992-1995 Sxren Schmidt
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer
 *    in this position and unchanged.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software withough specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *	$\Id: kbdtables.h,v 1.29 1995/03/28 21:30:13 sos Exp $
 */

#define SET8 0x80       	/* set eight bit on */

#ifdef DKKEYMAP
keymap_t key_map = { 0x6C,	/* DK iso8859 keymap */
/*                                                            alt
 * scan                          cntrl          alt    alt   cntrl
 * code     base   shift  cntrl  shift   alt   shift  cntrl  shift  spcl  flgs
 * ---------------------------------------------------------------------------
 */
/* sc=00 */  NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=01 */ 0x1B,  0x1B,  0x1B,  0x1B,  0x1B,  0x1B,   DBG,  0x1B,  0x02, 0x00,
/* sc=02 */  '1',   '!',   NOP,   NOP,   '1',   '!',   NOP,   NOP,  0x33, 0x00,
/* sc=03 */  '2',   '"',  0x00,  0x00,   '@',   '@',  0x00,  0x00,  0x00, 0x00,
/* sc=04 */  '3',   '#',   NOP,   NOP,  0x9E,   '#',   NOP,   NOP,  0x33, 0x00,
/* sc=05 */  '4',  0xA4,   NOP,   NOP,   '$',  0xA4,   NOP,   NOP,  0x33, 0x00,
/* sc=06 */  '5',   '%',   NOP,   NOP,   '5',   '%',   NOP,   NOP,  0x33, 0x00,
/* sc=07 */  '6',   '&',   NOP,   NOP,   '6',   '&',   NOP,   NOP,  0x33, 0x00,
/* sc=08 */  '7',   '/',   NOP,   NOP,   '{',   '/',   NOP,   NOP,  0x33, 0x00,
/* sc=09 */  '8',   '(',  0x1B,  0x1B,   '[',   '(',  0x1B,  0x1B,  0x00, 0x00,
/* sc=0a */  '9',   ')',  0x1D,  0x1D,   ']',   ')',  0x1D,  0x1D,  0x00, 0x00,
/* sc=0b */  '0',   '=',   NOP,   NOP,   '}',   '=',   NOP,   NOP,  0x33, 0x00,
/* sc=0c */  '+',   '?',   NOP,   NOP,   '+',   '?',   NOP,   NOP,  0x33, 0x00,
/* sc=0d */  '\'',  '`',   NOP,   NOP,   '|',   '`',   NOP,   NOP,  0x33, 0x00,
/* sc=0e */ 0x08,  0x08,  0x7F,  0x7F,  0x08,  0x08,  0x7F,  0x7F,  0x00, 0x00,
/* sc=0f */ 0x09,  BTAB,   NOP,   NOP,  0x09,  BTAB,   NOP,   NOP,  0x77, 0x00,
/* sc=10 */  'q',   'Q',  0x11,  0x11,   'q',   'Q',  0x11,  0x11,  0x00, 0x01,
/* sc=11 */  'w',   'W',  0x17,  0x17,   'w',   'W',  0x17,  0x17,  0x00, 0x01,
/* sc=12 */  'e',   'E',  0x05,  0x05,   'e',   'E',  0x05,  0x05,  0x00, 0x01,
/* sc=13 */  'r',   'R',  0x12,  0x12,   'r',   'R',  0x12,  0x12,  0x00, 0x01,
/* sc=14 */  't',   'T',  0x14,  0x14,   't',   'T',  0x14,  0x14,  0x00, 0x01,
/* sc=15 */  'y',   'Y',  0x19,  0x19,   'y',   'Y',  0x19,  0x19,  0x00, 0x01,
/* sc=16 */  'u',   'U',  0x15,  0x15,   'u',   'U',  0x15,  0x15,  0x00, 0x01,
/* sc=17 */  'i',   'I',  0x09,  0x09,   'i',   'I',  0x09,  0x09,  0x00, 0x01,
/* sc=18 */  'o',   'O',  0x0F,  0x0F,   'o',   'O',  0x0F,  0x0F,  0x00, 0x01,
/* sc=19 */  'p',   'P',  0x10,  0x10,   'p',   'P',  0x10,  0x10,  0x00, 0x01,
/* sc=1a */ 0xE5,  0xC5,   NOP,   NOP,  0x86,  0x8F,   NOP,   NOP,  0x33, 0x01,
/* sc=1b */  '"',   '^',  0x1E,  0x1E,   '~',   '^',  0x1E,  0x1E,  0x00, 0x00,
/* sc=1c */ 0x0D,  0x0D,  0x0A,  0x0A,  0x0D,  0x0D,  0x0A,  0x0A,  0x00, 0x00,
/* sc=1d */ LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  0xFF, 0x00,
/* sc=1e */  'a',   'A',  0x01,  0x01,   'a',   'A',  0x01,  0x01,  0x00, 0x01,
/* sc=1f */  's',   'S',  0x13,  0x13,   's',   'S',  0x13,  0x13,  0x00, 0x01,
/* sc=20 */  'd',   'D',  0x04,  0x04,   'd',   'D',  0x04,  0x04,  0x00, 0x01,
/* sc=21 */  'f',   'F',  0x06,  0x06,   'f',   'F',  0x06,  0x06,  0x00, 0x01,
/* sc=22 */  'g',   'G',  0x07,  0x07,   'g',   'G',  0x07,  0x07,  0x00, 0x01,
/* sc=23 */  'h',   'H',  0x08,  0x08,   'h',   'H',  0x08,  0x08,  0x00, 0x01,
/* sc=24 */  'j',   'J',  0x0A,  0x0A,   'j',   'J',  0x0A,  0x0A,  0x00, 0x01,
/* sc=25 */  'k',   'K',  0x0B,  0x0B,   'k',   'K',  0x0B,  0x0B,  0x00, 0x01,
/* sc=26 */  'l',   'L',  0x0C,  0x0C,   'l',   'L',  0x0C,  0x0C,  0x00, 0x01,
/* sc=27 */ 0xE6,  0xC6,   NOP,   NOP,  0x91,  0x92,   NOP,   NOP,  0x33, 0x01,
/* sc=28 */ 0xF8,  0xD8,   NOP,   NOP,  0x9B,  0x9D,   NOP,   NOP,  0x33, 0x01,
/* sc=29 */ 0xBD,  0xA7,   NOP,   NOP,  0xBD,  0xA7,   NOP,   NOP,  0x33, 0x00,
/* sc=2a */  LSH,   LSH,   LSH,   LSH,   LSH,   LSH,   LSH,   LSH,  0xFF, 0x00,
/* sc=2b */  '\'',  '*',   NOP,   NOP,   '\'',  '*',   NOP,   NOP,  0x33, 0x00,
/* sc=2c */  'z',   'Z',  0x1A,  0x1A,   'z',   'Z',  0x1A,  0x1A,  0x00, 0x01,
/* sc=2d */  'x',   'X',  0x18,  0x18,   'x',   'X',  0x18,  0x18,  0x00, 0x01,
/* sc=2e */  'c',   'C',  0x03,  0x03,   'c',   'C',  0x03,  0x03,  0x00, 0x01,
/* sc=2f */  'v',   'V',  0x16,  0x16,   'v',   'V',  0x16,  0x16,  0x00, 0x01,
/* sc=30 */  'b',   'B',  0x02,  0x02,   'b',   'B',  0x02,  0x02,  0x00, 0x01,
/* sc=31 */  'n',   'N',  0x0E,  0x0E,   'n',   'N',  0x0E,  0x0E,  0x00, 0x01,
/* sc=32 */  'm',   'M',  0x0D,  0x0D,   'm',   'M',  0x0D,  0x0D,  0x00, 0x01,
/* sc=33 */  ',',   ';',   NOP,   NOP,   ',',   ';',   NOP,   NOP,  0x33, 0x00,
/* sc=34 */  '.',   ':',   NOP,   NOP,   '.',   ':',   NOP,   NOP,  0x33, 0x00,
/* sc=35 */  '-',   '_',  0x1F,  0x1F,   '-',   '_',  0x1F,  0x1F,  0x00, 0x00,
/* sc=36 */  RSH,   RSH,   RSH,   RSH,   RSH,   RSH,   RSH,   RSH,  0xFF, 0x00,
/* sc=37 */  '*',   '*',   '*',   '*',   '*',   '*',   '*',   '*',  0x00, 0x00,
/* sc=38 */ LALT,  LALT,  LALT,  LALT,  LALT,  LALT,  LALT,  LALT,  0xFF, 0x00,
/* sc=39 */  ' ',   ' ',  0x00,   ' ',   ' ',   ' ',  SUSP,   ' ',  0x02, 0x00,
/* sc=3a */  CLK,   CLK,   CLK,   CLK,   CLK,   CLK,   CLK,   CLK,  0xFF, 0x00,
/* sc=3b */ F( 1), F(13), F(25), F(37), S( 1), S(11), S( 1), S(11), 0xFF, 0x00,
/* sc=3c */ F( 2), F(14), F(26), F(38), S( 2), S(12), S( 2), S(12), 0xFF, 0x00,
/* sc=3d */ F( 3), F(15), F(27), F(39), S( 3), S(13), S( 3), S(13), 0xFF, 0x00,
/* sc=3e */ F( 4), F(16), F(28), F(40), S( 4), S(14), S( 4), S(14), 0xFF, 0x00,
/* sc=3f */ F( 5), F(17), F(29), F(41), S( 5), S(15), S( 5), S(15), 0xFF, 0x00,
/* sc=40 */ F( 6), F(18), F(30), F(42), S( 6), S(16), S( 6), S(16), 0xFF, 0x00,
/* sc=41 */ F( 7), F(19), F(31), F(43), S( 7), S( 7), S( 7), S( 7), 0xFF, 0x00,
/* sc=42 */ F( 8), F(20), F(32), F(44), S( 8), S( 8), S( 8), S( 8), 0xFF, 0x00,
/* sc=43 */ F( 9), F(21), F(33), F(45), S( 9), S( 9), S( 9), S( 9), 0xFF, 0x00,
/* sc=44 */ F(10), F(22), F(34), F(46), S(10), S(10), S(10), S(10), 0xFF, 0x00,
/* sc=45 */  NLK,   NLK,   NLK,   NLK,   NLK,   NLK,   NLK,   NLK,  0xFF, 0x00,
/* sc=46 */  SLK,   SLK,   SLK,   SLK,   SLK,   SLK,   SLK,   SLK,  0xFF, 0x00,
/* sc=47 */ F(49),  '7',   '7',   '7',   '7',   '7',   '7',   '7',  0x80, 0x02,
/* sc=48 */ F(50),  '8',   '8',   '8',   '8',   '8',   '8',   '8',  0x80, 0x02,
/* sc=49 */ F(51),  '9',   '9',   '9',   '9',   '9',   '9',   '9',  0x80, 0x02,
/* sc=4a */ F(52),  '-',   '-',   '-',   '-',   '-',   '-',   '-',  0x80, 0x02,
/* sc=4b */ F(53),  '4',   '4',   '4',   '4',   '4',   '4',   '4',  0x80, 0x02,
/* sc=4c */ F(54),  '5',   '5',   '5',   '5',   '5',   '5',   '5',  0x80, 0x02,
/* sc=4d */ F(55),  '6',   '6',   '6',   '6',   '6',   '6',   '6',  0x80, 0x02,
/* sc=4e */ F(56),  '+',   '+',   '+',   '+',   '+',   '+',   '+',  0x80, 0x02,
/* sc=4f */ F(57),  '1',   '1',   '1',   '1',   '1',   '1',   '1',  0x80, 0x02,
/* sc=50 */ F(58),  '2',   '2',   '2',   '2',   '2',   '2',   '2',  0x80, 0x02,
/* sc=51 */ F(59),  '3',   '3',   '3',   '3',   '3',   '3',   '3',  0x80, 0x02,
/* sc=52 */ F(60),  '0',   '0',   '0',   '0',   '0',   '0',   '0',  0x80, 0x02,
/* sc=53 */ 0x7F,   '.',   '.',   '.',   '.',   '.',   RBT,   RBT,  0x03, 0x02,
/* sc=54 */  NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=55 */  NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=56 */  '<',   '>',  0x1C,  0x1C,   '\\',  '>',  0x1C,  0x1C,  0x00, 0x00,
/* sc=57 */ F(11), F(23), F(35), F(47), S(11), S(11), S(11), S(11), 0xFF, 0x00,
/* sc=58 */ F(12), F(24), F(36), F(48), S(12), S(12), S(12), S(12), 0xFF, 0x00,
/* sc=59 */ 0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0x00, 0x02,
/* sc=5a */ RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  0xFF, 0x00,
/* sc=5b */  '/',   '/',   '/',   '/',   '/',   '/',   '/',   '/',  0x00, 0x00,
/* sc=5c */ NEXT,   NOP,   DBG,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=5d */ RALT,  RALT,  RALT,  RALT,  RALT,  RALT,  RALT,  RALT,  0xFF, 0x00,
/* sc=5e */ F(49), F(49), F(49), F(49), F(49), F(49), F(49), F(49), 0xFF, 0x00,
/* sc=5f */ F(50), F(50), F(50), F(50), F(50), F(50), F(50), F(50), 0xFF, 0x00,
/* sc=60 */ F(51), F(51), F(51), F(51), F(51), F(51), F(51), F(51), 0xFF, 0x00,
/* sc=61 */ F(53), F(53), F(53), F(53), F(53), F(53), F(53), F(53), 0xFF, 0x00,
/* sc=62 */ F(55), F(55), F(55), F(55), F(55), F(55), F(55), F(55), 0xFF, 0x00,
/* sc=63 */ F(57), F(57), F(57), F(57), F(57), F(57), F(57), F(57), 0xFF, 0x00,
/* sc=64 */ F(58), F(58), F(58), F(58), F(58), F(58), F(58), F(58), 0xFF, 0x00,
/* sc=65 */ F(59), F(59), F(59), F(59), F(59), F(59), F(59), F(59), 0xFF, 0x00,
/* sc=66 */ F(60), F(60), F(60), F(60), F(60), F(60), F(60), F(60), 0xFF, 0x00,
/* sc=67 */ F(61), F(61), F(61), F(61), F(61), F(61),  RBT,  F(61), 0xFF, 0x00,
/* sc=68 */  SLK,   SLK,   SLK,   SLK,   SLK,   SLK,   SLK,   SLK,  0xFF, 0x00,
/* sc=69 */ F(62), F(62), F(62), F(62), F(62), F(62), F(62), F(62), 0xFF, 0x00,
/* sc=6a */ F(63), F(63), F(63), F(63), F(63), F(63), F(63), F(63), 0xFF, 0x00,
/* sc=6b */ F(64), F(64), F(64), F(64), F(64), F(64), F(64), F(64), 0xFF, 0x00,
};
#endif

#ifdef UKKEYMAP
keymap_t key_map = { 0x6C,	/* uk iso8859 keymap */
/*                                                            alt
 * scan                          cntrl          alt    alt   cntrl
 * code     base   shift  cntrl  shift   alt   shift  cntrl  shift  spcl  flgs
 * ---------------------------------------------------------------------------
 */
/* sc=00 */  NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=01 */ 0x1B,  0x1B,  0x1B,  0x1B,  0x1B,  0x1B,   DBG,  0x1B,  0x02, 0x00,
/* sc=02 */  '1',   '!',   NOP,   NOP,   '`',   '`',   NOP,   NOP,  0x33, 0x00,
/* sc=03 */  '2',   '"',  0x00,  0x00,   '@',   '@',  0x00,  0x00,  0x00, 0x00,
/* sc=04 */  '3',  0xA3,   NOP,   NOP,   '#',   '#',   NOP,   NOP,  0x33, 0x00,
/* sc=05 */  '4',   '$',   NOP,   NOP,   '4',   '$',   NOP,   NOP,  0x33, 0x00,
/* sc=06 */  '5',   '%',   NOP,   NOP,   '5',   '%',   NOP,   NOP,  0x33, 0x00,
/* sc=07 */  '6',   '^',  0x1E,  0x1E,   '^',   '^',  0x1E,  0x1E,  0x00, 0x00,
/* sc=08 */  '7',   '&',   NOP,   NOP,   '[',   '[',  0x1B,  0x1B,  0x30, 0x00,
/* sc=09 */  '8',   '*',   NOP,   NOP,   '8',   '*',   NOP,   NOP,  0x33, 0x00,
/* sc=0a */  '9',   '(',   NOP,   NOP,   ']',   ']',  0x1D,  0x1D,  0x30, 0x00,
/* sc=0b */  '0',   ')',   NOP,   NOP,   '{',   '{',   NOP,   NOP,  0x33, 0x00,
/* sc=0c */  '-',   '_',  0x1F,  0x1F,   '|',   '|',  0x1F,  0x1F,  0x00, 0x00,
/* sc=0d */  '=',   '+',   NOP,   NOP,   '}',   '}',   NOP,   NOP,  0x33, 0x00,
/* sc=0e */ 0x08,  0x08,  0x7F,  0x7F,  0x08,  0x08,  0x7F,  0x7F,  0x00, 0x00,
/* sc=0f */ 0x09,  BTAB,   NOP,   NOP,  0x09,  BTAB,   NOP,   NOP,  0x77, 0x00,
/* sc=10 */  'q',   'Q',  0x11,  0x11,   'q',   'Q',  0x11,  0x11,  0x00, 0x01,
/* sc=11 */  'w',   'W',  0x17,  0x17,   'w',   'W',  0x17,  0x17,  0x00, 0x01,
/* sc=12 */  'e',   'E',  0x05,  0x05,   'e',   'E',  0x05,  0x05,  0x00, 0x01,
/* sc=13 */  'r',   'R',  0x12,  0x12,   'r',   'R',  0x12,  0x12,  0x00, 0x01,
/* sc=14 */  't',   'T',  0x14,  0x14,   't',   'T',  0x14,  0x14,  0x00, 0x01,
/* sc=15 */  'y',   'Y',  0x19,  0x19,   'y',   'Y',  0x19,  0x19,  0x00, 0x01,
/* sc=16 */  'u',   'U',  0x15,  0x15,   'u',   'U',  0x15,  0x15,  0x00, 0x01,
/* sc=17 */  'i',   'I',  0x09,  0x09,   'i',   'I',  0x09,  0x09,  0x00, 0x01,
/* sc=18 */  'o',   'O',  0x0F,  0x0F,   'o',   'O',  0x0F,  0x0F,  0x00, 0x01,
/* sc=19 */  'p',   'P',  0x10,  0x10,   'p',   'P',  0x10,  0x10,  0x00, 0x01,
/* sc=1a */  '[',   '{',  0x1B,  0x1B,   '[',   '{',  0x1B,  0x1B,  0x00, 0x00,
/* sc=1b */  ']',   '}',  0x1D,  0x1D,   ']',   '}',  0x1D,  0x1D,  0x00, 0x00,
/* sc=1c */ 0x0D,  0x0D,  0x0A,  0x0A,  0x0D,  0x0D,  0x0A,  0x0A,  0x00, 0x00,
/* sc=1d */ LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  0xFF, 0x00,
/* sc=1e */  'a',   'A',  0x01,  0x01,   'a',   'A',  0x01,  0x01,  0x00, 0x01,
/* sc=1f */  's',   'S',  0x13,  0x13,   's',   'S',  0x13,  0x13,  0x00, 0x01,
/* sc=20 */  'd',   'D',  0x04,  0x04,   'd',   'D',  0x04,  0x04,  0x00, 0x01,
/* sc=21 */  'f',   'F',  0x06,  0x06,   'f',   'F',  0x06,  0x06,  0x00, 0x01,
/* sc=22 */  'g',   'G',  0x07,  0x07,   'g',   'G',  0x07,  0x07,  0x00, 0x01,
/* sc=23 */  'h',   'H',  0x08,  0x08,   'h',   'H',  0x08,  0x08,  0x00, 0x01,
/* sc=24 */  'j',   'J',  0x0A,  0x0A,   'j',   'J',  0x0A,  0x0A,  0x00, 0x01,
/* sc=25 */  'k',   'K',  0x0B,  0x0B,   'k',   'K',  0x0B,  0x0B,  0x00, 0x01,
/* sc=26 */  'l',   'L',  0x0C,  0x0C,   'l',   'L',  0x0C,  0x0C,  0x00, 0x01,
/* sc=27 */  ';',   ':',   NOP,   NOP,   ';',   ':',   NOP,   NOP,  0x33, 0x00,
/* sc=28 */  '\'',  '@',  0x00,  0x00,   '\'',  '@',  0x00,  0x00,  0x00, 0x00,
/* sc=29 */  '\\',  '|',  0x1C,  0x1C,   '\\',  '\\', 0x1C,  0x1C,  0x00, 0x00,
/* sc=2a */  LSH,   LSH,   LSH,   LSH,   LSH,   LSH,   LSH,   LSH,  0xFF, 0x00,
/* sc=2b */  '#',   '~',   NOP,   NOP,   '~',   '~',   NOP,   NOP,  0x33, 0x00,
/* sc=2c */  'z',   'Z',  0x1A,  0x1A,   'z',   'Z',  0x1A,  0x1A,  0x00, 0x01,
/* sc=2d */  'x',   'X',  0x18,  0x18,   'x',   'X',  0x18,  0x18,  0x00, 0x01,
/* sc=2e */  'c',   'C',  0x03,  0x03,   'c',   'C',  0x03,  0x03,  0x00, 0x01,
/* sc=2f */  'v',   'V',  0x16,  0x16,   'v',   'V',  0x16,  0x16,  0x00, 0x01,
/* sc=30 */  'b',   'B',  0x02,  0x02,   'b',   'B',  0x02,  0x02,  0x00, 0x01,
/* sc=31 */  'n',   'N',  0x0E,  0x0E,   'n',   'N',  0x0E,  0x0E,  0x00, 0x01,
/* sc=32 */  'm',   'M',  0x0D,  0x0D,   'm',   'M',  0x0D,  0x0D,  0x00, 0x01,
/* sc=33 */  ',',   '<',   NOP,   NOP,   ',',   '<',   NOP,   NOP,  0x33, 0x00,
/* sc=34 */  '.',   '>',   NOP,   NOP,   '.',   '>',   NOP,   NOP,  0x33, 0x00,
/* sc=35 */  '/',   '?',   NOP,   NOP,   '/',   '?',   NOP,   NOP,  0x33, 0x00,
/* sc=36 */  RSH,   RSH,   RSH,   RSH,   RSH,   RSH,   RSH,   RSH,  0xFF, 0x00,
/* sc=37 */  '*',   '*',  0x0A,  0x0A,   '*',   '*',  0x0A,  0x0A,  0x33, 0x00,
/* sc=38 */ LALT,  LALT,  LALT,  LALT,  LALT,  LALT,  LALT,  LALT,  0xFF, 0x00,
/* sc=39 */  ' ',   ' ',  0x00,   ' ',   ' ',   ' ',  SUSP,   ' ',  0x02, 0x00,
/* sc=3a */  CLK,   CLK,   CLK,   CLK,   CLK,   CLK,   CLK,   CLK,  0xFF, 0x00,
/* sc=3b */ F( 1), F(13), F(25), F(37), S( 1), S(11), S( 1), S(11), 0xFF, 0x00,
/* sc=3c */ F( 2), F(14), F(26), F(38), S( 2), S(12), S( 2), S(12), 0xFF, 0x00,
/* sc=3d */ F( 3), F(15), F(27), F(39), S( 3), S(13), S( 3), S(13), 0xFF, 0x00,
/* sc=3e */ F( 4), F(16), F(28), F(40), S( 4), S(14), S( 4), S(14), 0xFF, 0x00,
/* sc=3f */ F( 5), F(17), F(29), F(41), S( 5), S(15), S( 5), S(15), 0xFF, 0x00,
/* sc=40 */ F( 6), F(18), F(30), F(42), S( 6), S(16), S( 6), S(16), 0xFF, 0x00,
/* sc=41 */ F( 7), F(19), F(31), F(43), S( 7), S( 7), S( 7), S( 7), 0xFF, 0x00,
/* sc=42 */ F( 8), F(20), F(32), F(44), S( 8), S( 8), S( 8), S( 8), 0xFF, 0x00,
/* sc=43 */ F( 9), F(21), F(33), F(45), S( 9), S( 9), S( 9), S( 9), 0xFF, 0x00,
/* sc=44 */ F(10), F(22), F(34), F(46), S(10), S(10), S(10), S(10), 0xFF, 0x00,
/* sc=45 */  NLK,   NLK,  0x13,  0x13,   NLK,   NLK,  0x13,  0x13,  0xCC, 0x00,
/* sc=46 */  SLK,   SLK,  0x7F,  0x7F,   SLK,   SLK,  0x7F,  0x7F,  0xCC, 0x00,
/* sc=47 */ F(49),  '7',   '7',   '7',   '7',   '7',   '7',   '7',  0x80, 0x02,
/* sc=48 */ F(50),  '8',   '8',   '8',   '8',   '8',   '8',   '8',  0x80, 0x02,
/* sc=49 */ F(51),  '9',   '9',   '9',   '9',   '9',   '9',   '9',  0x80, 0x02,
/* sc=4a */ F(52),  '-',  0x1F,  0x1F,   '-',   '-',   '-',   '-',  0x80, 0x02,
/* sc=4b */ F(53),  '4',   '4',   '4',   '4',   '4',   '4',   '4',  0x80, 0x02,
/* sc=4c */ F(54),  '5',   '5',   '5',   '5',   '5',   '5',   '5',  0x80, 0x02,
/* sc=4d */ F(55),  '6',  0x1E,  0x1E,   '6',   '6',   '6',   '6',  0x80, 0x02,
/* sc=4e */ F(56),  '+',   '+',   '+',   '+',   '+',   '+',   '+',  0x80, 0x02,
/* sc=4f */ F(57),  '1',   '1',   '1',   '1',   '1',   '1',   '1',  0x80, 0x02,
/* sc=50 */ F(58),  '2',   '2',   '2',   '2',   '2',   '2',   '2',  0x80, 0x02,
/* sc=51 */ F(59),  '3',   '3',   '3',   '3',   '3',   '3',   '3',  0x80, 0x02,
/* sc=52 */ F(60),  '0',   '0',   '0',   '0',   '0',   '0',   '0',  0x80, 0x02,
/* sc=53 */ 0x7F,   '.',   '.',   '.',   '.',   '.',   RBT,   RBT,  0x03, 0x02,
/* sc=54 */  NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=55 */  NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=56 */  '\\',  '|',  0x1C,  0x1C,   '\\',  '|',  0x1C,  0x1C,  0x00, 0x00,
/* sc=57 */ F(11), F(23), F(35), F(47), S(11), S(11), S(11), S(11), 0xFF, 0x00,
/* sc=58 */ F(12), F(24), F(36), F(48), S(12), S(12), S(12), S(12), 0xFF, 0x00,
/* sc=59 */ 0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0xFF, 0x02,
/* sc=5a */ RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  0xFF, 0x00,
/* sc=5b */  '/',   '/',   '/',   '/',   '/',   '/',   '/',   '/',  0x00, 0x02,
/* sc=5c */ NEXT,   NOP,   DBG,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=5d */ RALT,  RALT,  RALT,  RALT,  RALT,  RALT,  RALT,  RALT,  0xFF, 0x00,
/* sc=5e */ F(49), F(49), F(49), F(49), F(49), F(49), F(49), F(49), 0xFF, 0x00,
/* sc=5f */ F(50), F(50), F(50), F(50), F(50), F(50), F(50), F(50), 0xFF, 0x00,
/* sc=60 */ F(51), F(51), F(51), F(51), F(51), F(51), F(51), F(51), 0xFF, 0x00,
/* sc=61 */ F(53), F(53), F(53), F(53), F(53), F(53), F(53), F(53), 0xFF, 0x00,
/* sc=62 */ F(55), F(55), F(55), F(55), F(55), F(55), F(55), F(55), 0xFF, 0x00,
/* sc=63 */ F(57), F(57), F(57), F(57), F(57), F(57), F(57), F(57), 0xFF, 0x00,
/* sc=64 */ F(58), F(58), F(58), F(58), F(58), F(58), F(58), F(58), 0xFF, 0x00,
/* sc=65 */ F(59), F(59), F(59), F(59), F(59), F(59), F(59), F(59), 0xFF, 0x00,
/* sc=66 */ F(60), F(60), F(60), F(60), F(60), F(60), F(60), F(60), 0xFF, 0x00,
/* sc=67 */ F(61), F(61), F(61), F(61), F(61), F(61),  RBT,  F(61), 0xFF, 0x00,
/* sc=68 */  SLK,   SLK,   SLK,   SLK,   SLK,   SLK,   SLK,   SLK,  0xFF, 0x00,
/* sc=69 */ F(62), F(62), F(62), F(62), F(62), F(62), F(62), F(62), 0xFF, 0x00,
/* sc=6a */ F(63), F(63), F(63), F(63), F(63), F(63), F(63), F(63), 0xFF, 0x00,
/* sc=6b */ F(64), F(64), F(64), F(64), F(64), F(64), F(64), F(64), 0xFF, 0x00,
};
#endif

#ifdef GRKEYMAP
keymap_t key_map = { 0x6C,	/* german iso8859 keymap */
/*                                                            alt
 * scan                          cntrl          alt    alt   cntrl
 * code     base   shift  cntrl  shift   alt   shift  cntrl  shift  spcl  flgs
 * ---------------------------------------------------------------------------
 */
/* sc=00 */  NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=01 */ 0x1B,  0x1B,  0x1B,  0x1B,  0x1B,  0x1B,   DBG,  0x1B,  0x02, 0x00,
/* sc=02 */  '1',   '!',   NOP,   NOP,   '`',   '`',   NOP,   NOP,  0x33, 0x00,
/* sc=03 */  '2',   '"',  0x00,  0x00,   '@',   '@',  0x00,  0x00,  0x00, 0x00,
/* sc=04 */  '3',  0xA7,   NOP,   NOP,   '#',   '#',   NOP,   NOP,  0x33, 0x00,
/* sc=05 */  '4',   '$',   NOP,   NOP,   '4',   '$',   NOP,   NOP,  0x33, 0x00,
/* sc=06 */  '5',   '%',   NOP,   NOP,   '5',   '%',   NOP,   NOP,  0x33, 0x00,
/* sc=07 */  '6',   '&',  0x1E,  0x1E,   '^',   '^',  0x1E,  0x1E,  0x00, 0x00,
/* sc=08 */  '7',   '/',  0x1B,  0x1B,   '[',   '[',  0x1B,  0x1B,  0x00, 0x00,
/* sc=09 */  '8',   '(',   NOP,   NOP,   '8',   '(',   NOP,   NOP,  0x33, 0x00,
/* sc=0a */  '9',   ')',  0x1D,  0x1D,   ']',   ']',  0x1D,  0x1D,  0x00, 0x00,
/* sc=0b */  '0',   '=',   NOP,   NOP,   '{',   '{',   NOP,   NOP,  0x33, 0x00,
/* sc=0c */ 0xDF,   '?',   NOP,   NOP,   '|',   '|',   NOP,   NOP,  0x33, 0x00,
/* sc=0d */ 0x92,  0x93,   NOP,   NOP,   '\'',  '`',   NOP,   NOP,  0x33, 0x00,
/* sc=0e */ 0x08,  0x08,  0x7F,  0x7F,  0x08,  0x08,  0x7F,  0x7F,  0x00, 0x00,
/* sc=0f */ 0x09,  BTAB,   NOP,   NOP,  0x09,  BTAB,   NOP,   NOP,  0x77, 0x00,
/* sc=10 */  'q',   'Q',  0x11,  0x11,   'q',   'Q',  0x11,  0x11,  0x00, 0x01,
/* sc=11 */  'w',   'W',  0x17,  0x17,   'w',   'W',  0x17,  0x17,  0x00, 0x01,
/* sc=12 */  'e',   'E',  0x05,  0x05,   'e',   'E',  0x05,  0x05,  0x00, 0x01,
/* sc=13 */  'r',   'R',  0x12,  0x12,   'r',   'R',  0x12,  0x12,  0x00, 0x01,
/* sc=14 */  't',   'T',  0x14,  0x14,   't',   'T',  0x14,  0x14,  0x00, 0x01,
/* sc=15 */  'z',   'Z',  0x1A,  0x1A,   'z',   'Z',  0x1A,  0x1A,  0x00, 0x01,
/* sc=16 */  'u',   'U',  0x15,  0x15,   'u',   'U',  0x15,  0x15,  0x00, 0x01,
/* sc=17 */  'i',   'I',  0x09,  0x09,   'i',   'I',  0x09,  0x09,  0x00, 0x01,
/* sc=18 */  'o',   'O',  0x0F,  0x0F,   'o',   'O',  0x0F,  0x0F,  0x00, 0x01,
/* sc=19 */  'p',   'P',  0x10,  0x10,   'p',   'P',  0x10,  0x10,  0x00, 0x01,
/* sc=1a */ 0xFC,  0xDC,  0x1B,  0x1B,   '[',   '{',  0x1B,  0x1B,  0x00, 0x01,
/* sc=1b */  '+',   '*',  0x1D,  0x1D,   ']',   '}',  0x1D,  0x1D,  0x00, 0x00,
/* sc=1c */ 0x0D,  0x0D,  0x0A,  0x0A,  0x0D,  0x0D,  0x0A,  0x0A,  0x00, 0x00,
/* sc=1d */ LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  0xFF, 0x00,
/* sc=1e */  'a',   'A',  0x01,  0x01,   'a',   'A',  0x01,  0x01,  0x00, 0x01,
/* sc=1f */  's',   'S',  0x13,  0x13,   's',   'S',  0x13,  0x13,  0x00, 0x01,
/* sc=20 */  'd',   'D',  0x04,  0x04,   'd',   'D',  0x04,  0x04,  0x00, 0x01,
/* sc=21 */  'f',   'F',  0x06,  0x06,   'f',   'F',  0x06,  0x06,  0x00, 0x01,
/* sc=22 */  'g',   'G',  0x07,  0x07,   'g',   'G',  0x07,  0x07,  0x00, 0x01,
/* sc=23 */  'h',   'H',  0x08,  0x08,   'h',   'H',  0x08,  0x08,  0x00, 0x01,
/* sc=24 */  'j',   'J',  0x0A,  0x0A,   'j',   'J',  0x0A,  0x0A,  0x00, 0x01,
/* sc=25 */  'k',   'K',  0x0B,  0x0B,   'k',   'K',  0x0B,  0x0B,  0x00, 0x01,
/* sc=26 */  'l',   'L',  0x0C,  0x0C,   'l',   'L',  0x0C,  0x0C,  0x00, 0x01,
/* sc=27 */ 0xF6,  0xD6,   NOP,   NOP,  0xF6,  0xD6,   NOP,   NOP,  0x33, 0x01,
/* sc=28 */ 0xE4,  0xC4,   NOP,   NOP,  0xE4,  0xC4,   NOP,   NOP,  0x33, 0x01,
/* sc=29 */  '<',   '>',  0x1C,  0x1C,   '\\',  '|',  0x1C,  0x1C,  0x00, 0x00,
/* sc=2a */  LSH,   LSH,   LSH,   LSH,   LSH,   LSH,   LSH,   LSH,  0xFF, 0x00,
/* sc=2b */  '#',   '^',  0x1E,  0x1E,   '`',   '~',  0x1E,  0x1E,  0x00, 0x00,
/* sc=2c */  'y',   'Y',  0x19,  0x19,   'y',   'Y',  0x19,  0x19,  0x00, 0x01,
/* sc=2d */  'x',   'X',  0x18,  0x18,   'x',   'X',  0x18,  0x18,  0x00, 0x01,
/* sc=2e */  'c',   'C',  0x03,  0x03,   'c',   'C',  0x03,  0x03,  0x00, 0x01,
/* sc=2f */  'v',   'V',  0x16,  0x16,   'v',   'V',  0x16,  0x16,  0x00, 0x01,
/* sc=30 */  'b',   'B',  0x02,  0x02,   'b',   'B',  0x02,  0x02,  0x00, 0x01,
/* sc=31 */  'n',   'N',  0x0E,  0x0E,   'n',   'N',  0x0E,  0x0E,  0x00, 0x01,
/* sc=32 */  'm',   'M',  0x0D,  0x0D,   'm',   'M',  0x0D,  0x0D,  0x00, 0x01,
/* sc=33 */  ',',   ';',   NOP,   NOP,   ',',   ';',   NOP,   NOP,  0x33, 0x00,
/* sc=34 */  '.',   ':',   NOP,   NOP,   '.',   ':',   NOP,   NOP,  0x33, 0x00,
/* sc=35 */  '-',   '_',  0x1F,  0x1F,   '-',   '_',  0x1F,  0x1F,  0x00, 0x00,
/* sc=36 */  RSH,   RSH,   RSH,   RSH,   RSH,   RSH,   RSH,   RSH,  0xFF, 0x00,
/* sc=37 */  '*',   '*',  0x0A,  0x0A,   '*',   '*',  0x0A,  0x0A,  0x33, 0x00,
/* sc=38 */ LALT,  LALT,  LALT,  LALT,  LALT,  LALT,  LALT,  LALT,  0xFF, 0x00,
/* sc=39 */  ' ',   ' ',  0x00,   ' ',   ' ',   ' ',  SUSP,   ' ',  0x02, 0x00,
/* sc=3a */  CLK,   CLK,   CLK,   CLK,   CLK,   CLK,   CLK,   CLK,  0xFF, 0x00,
/* sc=3b */ F( 1), F(13), F(25), F(37), S( 1), S(11), S( 1), S(11), 0xFF, 0x00,
/* sc=3c */ F( 2), F(14), F(26), F(38), S( 2), S(12), S( 2), S(12), 0xFF, 0x00,
/* sc=3d */ F( 3), F(15), F(27), F(39), S( 3), S(13), S( 3), S(13), 0xFF, 0x00,
/* sc=3e */ F( 4), F(16), F(28), F(40), S( 4), S(14), S( 4), S(14), 0xFF, 0x00,
/* sc=3f */ F( 5), F(17), F(29), F(41), S( 5), S(15), S( 5), S(15), 0xFF, 0x00,
/* sc=40 */ F( 6), F(18), F(30), F(42), S( 6), S(16), S( 6), S(16), 0xFF, 0x00,
/* sc=41 */ F( 7), F(19), F(31), F(43), S( 7), S( 7), S( 7), S( 7), 0xFF, 0x00,
/* sc=42 */ F( 8), F(20), F(32), F(44), S( 8), S( 8), S( 8), S( 8), 0xFF, 0x00,
/* sc=43 */ F( 9), F(21), F(33), F(45), S( 9), S( 9), S( 9), S( 9), 0xFF, 0x00,
/* sc=44 */ F(10), F(22), F(34), F(46), S(10), S(10), S(10), S(10), 0xFF, 0x00,
/* sc=45 */  NLK,   NLK,  0x13,  0x13,   NLK,   NLK,  0x13,  0x13,  0xCC, 0x00,
/* sc=46 */  SLK,   SLK,  0x7F,  0x7F,   SLK,   SLK,  0x7F,  0x7F,  0xCC, 0x00,
/* sc=47 */ F(49),  '7',   '7',   '7',   '7',   '7',   '7',   '7',  0x80, 0x02,
/* sc=48 */ F(50),  '8',   '8',   '8',   '8',   '8',   '8',   '8',  0x80, 0x02,
/* sc=49 */ F(51),  '9',   '9',   '9',   '9',   '9',   '9',   '9',  0x80, 0x02,
/* sc=4a */ F(52),  '-',  0x1F,  0x1F,   '-',   '-',   '-',   '-',  0x80, 0x02,
/* sc=4b */ F(53),  '4',   '4',   '4',   '4',   '4',   '4',   '4',  0x80, 0x02,
/* sc=4c */ F(54),  '5',   '5',   '5',   '5',   '5',   '5',   '5',  0x80, 0x02,
/* sc=4d */ F(55),  '6',  0x1E,  0x1E,   '6',   '6',   '6',   '6',  0x80, 0x02,
/* sc=4e */ F(56),  '+',   '+',   '+',   '+',   '+',   '+',   '+',  0x80, 0x02,
/* sc=4f */ F(57),  '1',   '1',   '1',   '1',   '1',   '1',   '1',  0x80, 0x02,
/* sc=50 */ F(58),  '2',   '2',   '2',   '2',   '2',   '2',   '2',  0x80, 0x02,
/* sc=51 */ F(59),  '3',   '3',   '3',   '3',   '3',   '3',   '3',  0x80, 0x02,
/* sc=52 */ F(60),  '0',   '0',   '0',   '0',   '0',   '0',   '0',  0x80, 0x02,
/* sc=53 */ 0x7F,   '.',   '.',   '.',   '.',   '.',   RBT,   RBT,  0x03, 0x02,
/* sc=54 */ 0x1F,  0x1F,  0x1F,  0x1F,  0x1F,  0x1F,  0x1F,  0x1F,  0x00, 0x00,
/* sc=55 */  NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=56 */  NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=57 */ F(11), F(23), F(35), F(47), S(11), S(11), S(11), S(11), 0xFF, 0x00,
/* sc=58 */ F(12), F(24), F(36), F(48), S(12), S(12), S(12), S(12), 0xFF, 0x00,
/* sc=59 */ 0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0xFF, 0x02,
/* sc=5a */ RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  0xFF, 0x00,
/* sc=5b */  '/',   '/',   '/',   '/',   '/',   '/',   '/',   '/',  0x00, 0x02,
/* sc=5c */ NEXT,   NOP,   DBG,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=5d */ RALT,  RALT,  RALT,  RALT,  RALT,  RALT,  RALT,  RALT,  0xFF, 0x00,
/* sc=5e */ F(49), F(49), F(49), F(49), F(49), F(49), F(49), F(49), 0xFF, 0x00,
/* sc=5f */ F(50), F(50), F(50), F(50), F(50), F(50), F(50), F(50), 0xFF, 0x00,
/* sc=60 */ F(51), F(51), F(51), F(51), F(51), F(51), F(51), F(51), 0xFF, 0x00,
/* sc=61 */ F(53), F(53), F(53), F(53), F(53), F(53), F(53), F(53), 0xFF, 0x00,
/* sc=62 */ F(55), F(55), F(55), F(55), F(55), F(55), F(55), F(55), 0xFF, 0x00,
/* sc=63 */ F(57), F(57), F(57), F(57), F(57), F(57), F(57), F(57), 0xFF, 0x00,
/* sc=64 */ F(58), F(58), F(58), F(58), F(58), F(58), F(58), F(58), 0xFF, 0x00,
/* sc=65 */ F(59), F(59), F(59), F(59), F(59), F(59), F(59), F(59), 0xFF, 0x00,
/* sc=66 */ F(60), F(60), F(60), F(60), F(60), F(60), F(60), F(60), 0xFF, 0x00,
/* sc=67 */ F(61), F(61), F(61), F(61), F(61), F(61),  RBT,  F(61), 0xFF, 0x00,
/* sc=68 */  SLK,   SLK,   SLK,   SLK,   SLK,   SLK,   SLK,   SLK,  0xFF, 0x00,
/* sc=69 */ F(62), F(62), F(62), F(62), F(62), F(62), F(62), F(62), 0xFF, 0x00,
/* sc=6a */ F(63), F(63), F(63), F(63), F(63), F(63), F(63), F(63), 0xFF, 0x00,
/* sc=6b */ F(64), F(64), F(64), F(64), F(64), F(64), F(64), F(64), 0xFF, 0x00,
};
#endif

#ifdef SWKEYMAP
keymap_t key_map = { 0x6C,	/* swedish iso8859 keymap */
/*                                                            alt
 * scan                          cntrl          alt    alt   cntrl
 * code     base   shift  cntrl  shift   alt   shift  cntrl  shift  spcl  flgs
 * ---------------------------------------------------------------------------
 */
/* sc=00 */  NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=01 */ 0x1B,  0x1B,  0x1B,  0x1B,  0x1B,  0x1B,   DBG,  0x1B,  0x02, 0x00,
/* sc=02 */  '1',   '!',   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0x3F, 0x00,
/* sc=03 */  '2',   '"',  0x00,  0x00,   '@',   '@',  0x00,  0x00,  0x00, 0x00,
/* sc=04 */  '3',   '#',   NOP,   NOP,  0xA3,   NOP,   NOP,   NOP,  0x37, 0x00,
/* sc=05 */  '4',   '$',   NOP,   NOP,  0xA4,   NOP,   NOP,   NOP,  0x37, 0x00,
/* sc=06 */  '5',   '%',   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0x3F, 0x00,
/* sc=07 */  '6',   '&',   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0x3F, 0x00,
/* sc=08 */  '7',   '/',   NOP,   NOP,   '{',   NOP,   NOP,   NOP,  0x37, 0x00,
/* sc=09 */  '8',   '(',   NOP,   NOP,   '[',   NOP,   NOP,   NOP,  0x37, 0x00,
/* sc=0a */  '9',   ')',   NOP,   NOP,   ']',   NOP,   NOP,   NOP,  0x37, 0x00,
/* sc=0b */  '0',   '=',   NOP,   NOP,   '}',   NOP,   NOP,   NOP,  0x37, 0x00,
/* sc=0c */  '+',   '?',   NOP,   NOP,   '\\',  NOP,  0x1C,   NOP,  0x35, 0x00,
/* sc=0d */ 0x180,  '`',   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0x3F, 0x00,
/* sc=0e */ 0x08,  0x08,  0x7F,  0x7F,  0x08,  0x08,  0x7F,  0x7F,  0x00, 0x00,
/* sc=0f */ 0x09,  BTAB,   NOP,   NOP,  0x09,  BTAB,   NOP,   NOP,  0x77, 0x00,
/* sc=10 */  'q',   'Q',  0x11,  0x11,   'q',   'Q',  0x11,  0x11,  0x00, 0x01,
/* sc=11 */  'w',   'W',  0x17,  0x17,   'w',   'W',  0x17,  0x17,  0x00, 0x01,
/* sc=12 */  'e',   'E',  0x05,  0x05,   'e',   'E',  0x05,  0x05,  0x00, 0x01,
/* sc=13 */  'r',   'R',  0x12,  0x12,   'r',   'R',  0x12,  0x12,  0x00, 0x01,
/* sc=14 */  't',   'T',  0x14,  0x14,   't',   'T',  0x14,  0x14,  0x00, 0x01,
/* sc=15 */  'y',   'Y',  0x19,  0x19,   'y',   'Y',  0x19,  0x19,  0x00, 0x01,
/* sc=16 */  'u',   'U',  0x15,  0x15,   'u',   'U',  0x15,  0x15,  0x00, 0x01,
/* sc=17 */  'i',   'I',  0x09,  0x09,   'i',   'I',  0x09,  0x09,  0x00, 0x01,
/* sc=18 */  'o',   'O',  0x0F,  0x0F,   'o',   'O',  0x0F,  0x0F,  0x00, 0x01,
/* sc=19 */  'p',   'P',  0x10,  0x10,   'p',   'P',  0x10,  0x10,  0x00, 0x01,
/* sc=1a */ 0xE5,  0xC5,   NOP,   NOP,   '}',   ']',   NOP,   NOP,  0x33, 0x01,
/* sc=1b */ 0xA8,   '^',   NOP,   NOP,   '~',   NOP,   NOP,   NOP,  0x37, 0x00,
/* sc=1c */ 0x0D,  0x0D,  0x0A,  0x0A,  0x0D,  0x0D,  0x0A,  0x0A,  0x00, 0x00,
/* sc=1d */ LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  0xFF, 0x00,
/* sc=1e */  'a',   'A',  0x01,  0x01,   'a',   'A',  0x01,  0x01,  0x00, 0x01,
/* sc=1f */  's',   'S',  0x13,  0x13,   's',   'S',  0x13,  0x13,  0x00, 0x01,
/* sc=20 */  'd',   'D',  0x04,  0x04,   'd',   'D',  0x04,  0x04,  0x00, 0x01,
/* sc=21 */  'f',   'F',  0x06,  0x06,   'f',   'F',  0x06,  0x06,  0x00, 0x01,
/* sc=22 */  'g',   'G',  0x07,  0x07,   'g',   'G',  0x07,  0x07,  0x00, 0x01,
/* sc=23 */  'h',   'H',  0x08,  0x08,   'h',   'H',  0x08,  0x08,  0x00, 0x01,
/* sc=24 */  'j',   'J',  0x0A,  0x0A,   'j',   'J',  0x0A,  0x0A,  0x00, 0x01,
/* sc=25 */  'k',   'K',  0x0B,  0x0B,   'k',   'K',  0x0B,  0x0B,  0x00, 0x01,
/* sc=26 */  'l',   'L',  0x0C,  0x0C,   'l',   'L',  0x0C,  0x0C,  0x00, 0x01,
/* sc=27 */ 0xF6,  0xD6,   NOP,   NOP,   '|',   '\\',  NOP,   NOP,  0x33, 0x01,
/* sc=28 */ 0xE4,  0xC4,   NOP,   NOP,   '{',   '[',   NOP,   NOP,  0x33, 0x01,
/* sc=29 */ 0xA7,  0xBD,   NOP,   NOP,   '\\',  '|',   NOP,   NOP,  0x33, 0x00,
/* sc=2a */  LSH,   LSH,   LSH,   LSH,   LSH,   LSH,   LSH,   LSH,  0xFF, 0x00,
/* sc=2b */  '\'',  '*',   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0x3F, 0x00,
/* sc=2c */  'z',   'Z',  0x1A,  0x1A,   'z',   'Z',  0x1A,  0x1A,  0x00, 0x01,
/* sc=2d */  'x',   'X',  0x18,  0x18,   'x',   'X',  0x18,  0x18,  0x00, 0x01,
/* sc=2e */  'c',   'C',  0x03,  0x03,   'c',   'C',  0x03,  0x03,  0x00, 0x01,
/* sc=2f */  'v',   'V',  0x16,  0x16,   'v',   'V',  0x16,  0x16,  0x00, 0x01,
/* sc=30 */  'b',   'B',  0x02,  0x02,   'b',   'B',  0x02,  0x02,  0x00, 0x01,
/* sc=31 */  'n',   'N',  0x0E,  0x0E,   'n',   'N',  0x0E,  0x0E,  0x00, 0x01,
/* sc=32 */  'm',   'M',  0x0D,  0x0D,   'm',   'M',  0x0D,  0x0D,  0x00, 0x01,
/* sc=33 */  ',',   ';',   NOP,   NOP,   NOP,   '<',   NOP,   NOP,  0x3B, 0x00,
/* sc=34 */  '.',   ':',   NOP,   NOP,   NOP,   '>',   NOP,   NOP,  0x3B, 0x00,
/* sc=35 */  '-',   '_',  0x1F,   NOP,   '/',   '?',   NOP,   NOP,  0x13, 0x00,
/* sc=36 */  RSH,   RSH,   RSH,   RSH,   RSH,   RSH,   RSH,   RSH,  0xFF, 0x00,
/* sc=37 */  '*',   '*',  0x0A,  0x0A,   '*',   '*',  0x0A,  0x0A,  0x33, 0x00,
/* sc=38 */ LALT,  LALT,  LALT,  LALT,  LALT,  LALT,  LALT,  LALT,  0xFF, 0x00,
/* sc=39 */  ' ',   ' ',  0x00,   ' ',   ' ',   ' ',  SUSP,   ' ',  0x02, 0x00,
/* sc=3a */  CLK,   CLK,   CLK,   CLK,   CLK,   CLK,   CLK,   CLK,  0xFF, 0x00,
/* sc=3b */ F( 1), F(13), F(25), F(37), S( 1), S(11), S( 1), S(11), 0xFF, 0x00,
/* sc=3c */ F( 2), F(14), F(26), F(38), S( 2), S(12), S( 2), S(12), 0xFF, 0x00,
/* sc=3d */ F( 3), F(15), F(27), F(39), S( 3), S(13), S( 3), S(13), 0xFF, 0x00,
/* sc=3e */ F( 4), F(16), F(28), F(40), S( 4), S(14), S( 4), S(14), 0xFF, 0x00,
/* sc=3f */ F( 5), F(17), F(29), F(41), S( 5), S(15), S( 5), S(15), 0xFF, 0x00,
/* sc=40 */ F( 6), F(18), F(30), F(42), S( 6), S(16), S( 6), S(16), 0xFF, 0x00,
/* sc=41 */ F( 7), F(19), F(31), F(43), S( 7), S( 7), S( 7), S( 7), 0xFF, 0x00,
/* sc=42 */ F( 8), F(20), F(32), F(44), S( 8), S( 8), S( 8), S( 8), 0xFF, 0x00,
/* sc=43 */ F( 9), F(21), F(33), F(45), S( 9), S( 9), S( 9), S( 9), 0xFF, 0x00,
/* sc=44 */ F(10), F(22), F(34), F(46), S(10), S(10), S(10), S(10), 0xFF, 0x00,
/* sc=45 */  NLK,   NLK,  0x13,  0x13,   NLK,   NLK,  0x13,  0x13,  0xCC, 0x00,
/* sc=46 */  SLK,   SLK,  0x7F,  0x7F,   SLK,   SLK,  0x7F,  0x7F,  0xCC, 0x00,
/* sc=47 */ F(49),  '7',   '7',   '7',   '7',   '7',   '7',   '7',  0x80, 0x02,
/* sc=48 */ F(50),  '8',   '8',   '8',   '8',   '8',   '8',   '8',  0x80, 0x02,
/* sc=49 */ F(51),  '9',   '9',   '9',   '9',   '9',   '9',   '9',  0x80, 0x02,
/* sc=4a */ F(52),  '-',  0x1F,  0x1F,   '-',   '-',   '-',   '-',  0x80, 0x02,
/* sc=4b */ F(53),  '4',   '4',   '4',   '4',   '4',   '4',   '4',  0x80, 0x02,
/* sc=4c */ F(54),  '5',   '5',   '5',   '5',   '5',   '5',   '5',  0x80, 0x02,
/* sc=4d */ F(55),  '6',  0x1E,  0x1E,   '6',   '6',   '6',   '6',  0x80, 0x02,
/* sc=4e */ F(56),  '+',   '+',   '+',   '+',   '+',   '+',   '+',  0x80, 0x02,
/* sc=4f */ F(57),  '1',   '1',   '1',   '1',   '1',   '1',   '1',  0x80, 0x02,
/* sc=50 */ F(58),  '2',   '2',   '2',   '2',   '2',   '2',   '2',  0x80, 0x02,
/* sc=51 */ F(59),  '3',   '3',   '3',   '3',   '3',   '3',   '3',  0x80, 0x02,
/* sc=52 */ F(60),  '0',   '0',   '0',   '0',   '0',   '0',   '0',  0x80, 0x02,
/* sc=53 */ 0x7F,   '.',   '.',   '.',   '.',   '.',   RBT,   RBT,  0x03, 0x02,
/* sc=54 */ 0x1F,  0x1F,  0x1F,  0x1F,  0x1F,  0x1F,  0x1F,  0x1F,  0x00, 0x00,
/* sc=55 */  NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=56 */  '<',   '>',   NOP,   NOP,   '|',   NOP,   NOP,   NOP,  0x37, 0x00,
/* sc=57 */ F(11), F(23), F(35), F(47), S(11), S(11), S(11), S(11), 0xFF, 0x00,
/* sc=58 */ F(12), F(24), F(36), F(48), S(12), S(12), S(12), S(12), 0xFF, 0x00,
/* sc=59 */ 0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0xFF, 0x02,
/* sc=5a */ RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  0xFF, 0x00,
/* sc=5b */  '/',   '/',   '/',   '/',   '/',   '/',   '/',   '/',  0x00, 0x02,
/* sc=5c */ NEXT,   NOP,   DBG,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=5d */ RALT,  RALT,  RALT,  RALT,  RALT,  RALT,  RALT,  RALT,  0xFF, 0x00,
/* sc=5e */ F(49), F(49), F(49), F(49), F(49), F(49), F(49), F(49), 0xFF, 0x00,
/* sc=5f */ F(50), F(50), F(50), F(50), F(50), F(50), F(50), F(50), 0xFF, 0x00,
/* sc=60 */ F(51), F(51), F(51), F(51), F(51), F(51), F(51), F(51), 0xFF, 0x00,
/* sc=61 */ F(53), F(53), F(53), F(53), F(53), F(53), F(53), F(53), 0xFF, 0x00,
/* sc=62 */ F(55), F(55), F(55), F(55), F(55), F(55), F(55), F(55), 0xFF, 0x00,
/* sc=63 */ F(57), F(57), F(57), F(57), F(57), F(57), F(57), F(57), 0xFF, 0x00,
/* sc=64 */ F(58), F(58), F(58), F(58), F(58), F(58), F(58), F(58), 0xFF, 0x00,
/* sc=65 */ F(59), F(59), F(59), F(59), F(59), F(59), F(59), F(59), 0xFF, 0x00,
/* sc=66 */ F(60), F(60), F(60), F(60), F(60), F(60), F(60), F(60), 0xFF, 0x00,
/* sc=67 */ F(61), F(61), F(61), F(61), F(61), F(61),  RBT,  F(61), 0xFF, 0x00,
/* sc=68 */  SLK,   SLK,   SLK,   SLK,   SLK,   SLK,   SLK,   SLK,  0xFF, 0x00,
/* sc=69 */ F(62), F(62), F(62), F(62), F(62), F(62), F(62), F(62), 0xFF, 0x00,
/* sc=6a */ F(63), F(63), F(63), F(63), F(63), F(63), F(63), F(63), 0xFF, 0x00,
/* sc=6b */ F(64), F(64), F(64), F(64), F(64), F(64), F(64), F(64), 0xFF, 0x00,
};
#endif

#ifdef RUKEYMAP
keymap_t key_map = { 0xEC,        /* keys number */
/*                                                                          alt
 * scan                          cntrl                alt        alt       cntrl
 * code     base   shift  cntrl  shift     alt       shift      cntrl      shift    spcl  flgs
 * -------------------------------------------------------------------------------------------
 */
/* sc=00 */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=01 */ 0x1B,  0x1B,   NOP,   NOP,  SET8|0x1B, SET8|0x1B,    DBG,       NOP,    0x33, 0x00,
/* sc=02 */  '1',   '!',   NOP,   NOP,  SET8|'1',  SET8|'!',     NOP,       NOP,    0x33, 0x00,
/* sc=03 */  '2',   '@',  0x00,  0x00,  SET8|'2',  SET8|'@',  SET8|0x00, SET8|0x00, 0x00, 0x00,
/* sc=04 */  '3',   '#',   NOP,   NOP,  SET8|'3',  SET8|'#',     NOP,       NOP,    0x33, 0x00,
/* sc=05 */  '4',   '$',   NOP,   NOP,  SET8|'4',  SET8|'$',     NOP,       NOP,    0x33, 0x00,
/* sc=06 */  '5',   '%',   NOP,   NOP,  SET8|'5',  SET8|'%',     NOP,       NOP,    0x33, 0x00,
/* sc=07 */  '6',   '^',  0x1E,  0x1E,  SET8|'6',  SET8|'^',  SET8|0x1E, SET8|0x1E, 0x00, 0x00,
/* sc=08 */  '7',   '&',   NOP,   NOP,  SET8|'7',  SET8|'&',     NOP,       NOP,    0x33, 0x00,
/* sc=09 */  '8',   '*',   NOP,   NOP,  SET8|'8',  SET8|'*',     NOP,       NOP,    0x33, 0x00,
/* sc=0a */  '9',   '(',   NOP,   NOP,  SET8|'9',  SET8|'(',     NOP,       NOP,    0x33, 0x00,
/* sc=0b */  '0',   ')',   NOP,   NOP,  SET8|'0',  SET8|')',     NOP,       NOP,    0x33, 0x00,
/* sc=0c */  '-',   '_',  0x1F,  0x1F,  SET8|'-',  SET8|'_',  SET8|0x1F, SET8|0x1F, 0x00, 0x00,
/* sc=0d */  '=',   '+',   NOP,   NOP,  SET8|'=',  SET8|'+',     NOP,       NOP,    0x33, 0x00,
/* sc=0e */ 0x08,  0x08,  0x7F,  0x7F,  SET8|0x08, SET8|0x08, SET8|0x7F, SET8|0x7F, 0x00, 0x00,
/* sc=0f */ 0x09,  BTAB,   NOP,   NOP,  SET8|0x09,   BTAB,       NOP,       NOP,    0x77, 0x00,
/* sc=10 */  'q',   'Q',  0x11,  0x11,  SET8|'q',  SET8|'Q',  SET8|0x11, SET8|0x11, 0x00, 0x01,
/* sc=11 */  'w',   'W',  0x17,  0x17,  SET8|'w',  SET8|'W',  SET8|0x17, SET8|0x17, 0x00, 0x01,
/* sc=12 */  'e',   'E',  0x05,  0x05,  SET8|'e',  SET8|'E',  SET8|0x05, SET8|0x05, 0x00, 0x01,
/* sc=13 */  'r',   'R',  0x12,  0x12,  SET8|'r',  SET8|'R',  SET8|0x12, SET8|0x12, 0x00, 0x01,
/* sc=14 */  't',   'T',  0x14,  0x14,  SET8|'t',  SET8|'T',  SET8|0x14, SET8|0x14, 0x00, 0x01,
/* sc=15 */  'y',   'Y',  0x19,  0x19,  SET8|'y',  SET8|'Y',  SET8|0x19, SET8|0x19, 0x00, 0x01,
/* sc=16 */  'u',   'U',  0x15,  0x15,  SET8|'u',  SET8|'U',  SET8|0x15, SET8|0x15, 0x00, 0x01,
/* sc=17 */  'i',   'I',  0x09,  0x09,  SET8|'i',  SET8|'I',  SET8|0x09, SET8|0x09, 0x00, 0x01,
/* sc=18 */  'o',   'O',  0x0F,  0x0F,  SET8|'o',  SET8|'O',  SET8|0x0F, SET8|0x0F, 0x00, 0x01,
/* sc=19 */  'p',   'P',  0x10,  0x10,  SET8|'p',  SET8|'P',  SET8|0x10, SET8|0x10, 0x00, 0x01,
/* sc=1a */  '[',   '{',  0x1B,  0x1B,  SET8|'[',  SET8|'{',  SET8|0x1B, SET8|0x1B, 0x00, 0x00,
/* sc=1b */  ']',   '}',  0x1D,  0x1D,  SET8|']',  SET8|'}',  SET8|0x1D, SET8|0x1D, 0x00, 0x00,
/* sc=1c */ 0x0D,  0x0D,  0x0A,  0x0A,  SET8|0x0D, SET8|0x0D, SET8|0x0A, SET8|0x0A, 0x00, 0x00,
/* sc=1d */ LCTR,  LCTR,  LCTR,  LCTR,    LCTR,      LCTR,      LCTR,      LCTR,    0xFF, 0x00,
/* sc=1e */  'a',   'A',  0x01,  0x01,  SET8|'a',  SET8|'A',  SET8|0x01, SET8|0x01, 0x00, 0x01,
/* sc=1f */  's',   'S',  0x13,  0x13,  SET8|'s',  SET8|'S',  SET8|0x13, SET8|0x13, 0x00, 0x01,
/* sc=20 */  'd',   'D',  0x04,  0x04,  SET8|'d',  SET8|'D',  SET8|0x04, SET8|0x04, 0x00, 0x01,
/* sc=21 */  'f',   'F',  0x06,  0x06,  SET8|'f',  SET8|'F',  SET8|0x06, SET8|0x06, 0x00, 0x01,
/* sc=22 */  'g',   'G',  0x07,  0x07,  SET8|'g',  SET8|'G',  SET8|0x07, SET8|0x07, 0x00, 0x01,
/* sc=23 */  'h',   'H',  0x08,  0x08,  SET8|'h',  SET8|'H',  SET8|0x08, SET8|0x08, 0x00, 0x01,
/* sc=24 */  'j',   'J',  0x0A,  0x0A,  SET8|'j',  SET8|'J',  SET8|0x0A, SET8|0x0A, 0x00, 0x01,
/* sc=25 */  'k',   'K',  0x0B,  0x0B,  SET8|'k',  SET8|'K',  SET8|0x0B, SET8|0x0B, 0x00, 0x01,
/* sc=26 */  'l',   'L',  0x0C,  0x0C,  SET8|'l',  SET8|'L',  SET8|0x0C, SET8|0x0C, 0x00, 0x01,
/* sc=27 */  ';',   ':',   NOP,   NOP,  SET8|';',  SET8|':',     NOP,       NOP,    0x33, 0x00,
/* sc=28 */  '\'',  '"',   NOP,   NOP,  SET8|'\'', SET8|'"',     NOP,       NOP,    0x33, 0x00,
/* sc=29 */  '`',   '~',   NOP,   NOP,  SET8|'`',  SET8|'~',     NOP,       NOP,    0x33, 0x00,
/* sc=2a */  LSH,   LSH,   LSH,   LSH,     LSH,       LSH,       LSH,       LSH,    0xFF, 0x00,
/* sc=2b */  '\\',  '|',  0x1C,  0x1C,  SET8|'\\', SET8|'|',  SET8|0x1C, SET8|0x1C, 0x00, 0x00,
/* sc=2c */  'z',   'Z',  0x1A,  0x1A,  SET8|'z',  SET8|'Z',  SET8|0x1A, SET8|0x1A, 0x00, 0x01,
/* sc=2d */  'x',   'X',  0x18,  0x18,  SET8|'x',  SET8|'X',  SET8|0x18, SET8|0x18, 0x00, 0x01,
/* sc=2e */  'c',   'C',  0x03,  0x03,  SET8|'c',  SET8|'C',  SET8|0x03, SET8|0x03, 0x00, 0x01,
/* sc=2f */  'v',   'V',  0x16,  0x16,  SET8|'v',  SET8|'V',  SET8|0x16, SET8|0x16, 0x00, 0x01,
/* sc=30 */  'b',   'B',  0x02,  0x02,  SET8|'b',  SET8|'B',  SET8|0x02, SET8|0x02, 0x00, 0x01,
/* sc=31 */  'n',   'N',  0x0E,  0x0E,  SET8|'n',  SET8|'N',  SET8|0x0E, SET8|0x0E, 0x00, 0x01,
/* sc=32 */  'm',   'M',  0x0D,  0x0D,  SET8|'m',  SET8|'M',  SET8|0x0D, SET8|0x0D, 0x00, 0x01,
/* sc=33 */  ',',   '<',   NOP,   NOP,  SET8|',',  SET8|'<',     NOP,       NOP,    0x33, 0x00,
/* sc=34 */  '.',   '>',   NOP,   NOP,  SET8|'.',  SET8|'>',     NOP,       NOP,    0x33, 0x00,
/* sc=35 */  '/',   '?',   NOP,   NOP,  SET8|'/',  SET8|'?',     NOP,       NOP,    0x33, 0x00,
/* sc=36 */  RSH,   RSH,   RSH,   RSH,     RSH,       RSH,       RSH,       RSH,    0xFF, 0x00,
/* sc=37 */  '*',   '*',  0x0A,  0x0A,  SET8|'*',  SET8|'*',  SET8|0x0A, SET8|0x0A, 0x00, 0x00,
/* sc=38 */ LALT,  LALT,  LALT,  LALT,    LALT,      LALT,      LALT,      LALT,    0xFF, 0x00,
/* sc=39 */  ' ',   ' ',  0x00,   ' ',  SET8|' ',  SET8|' ',  SET8|' ',  SET8|' ',  0x00, 0x00,
/* sc=3a */  ALK,   CLK,   CLK,   CLK,     CLK,       CLK,       CLK,       CLK,    0xFF, 0x00,
/* sc=3b */ F( 1), F(13), F(25), F(37),   S( 1),     S(11),     S( 1),     S(11),   0xFF, 0x00,
/* sc=3c */ F( 2), F(14), F(26), F(38),   S( 2),     S(12),     S( 2),     S(12),   0xFF, 0x00,
/* sc=3d */ F( 3), F(15), F(27), F(39),   S( 3),     S(13),     S( 3),     S(13),   0xFF, 0x00,
/* sc=3e */ F( 4), F(16), F(28), F(40),   S( 4),     S(14),     S( 4),     S(14),   0xFF, 0x00,
/* sc=3f */ F( 5), F(17), F(29), F(41),   S( 5),     S(15),     S( 5),     S(15),   0xFF, 0x00,
/* sc=40 */ F( 6), F(18), F(30), F(42),   S( 6),     S(16),     S( 6),     S(16),   0xFF, 0x00,
/* sc=41 */ F( 7), F(19), F(31), F(43),   S( 7),     S( 7),     S( 7),     S( 7),   0xFF, 0x00,
/* sc=42 */ F( 8), F(20), F(32), F(44),   S( 8),     S( 8),     S( 8),     S( 8),   0xFF, 0x00,
/* sc=43 */ F( 9), F(21), F(33), F(45),   S( 9),     S( 9),     S( 9),     S( 9),   0xFF, 0x00,
/* sc=44 */ F(10), F(22), F(34), F(46),   S(10),     S(10),     S(10),     S(10),   0xFF, 0x00,
/* sc=45 */  NLK,   NLK,   NLK,   NLK,     NLK,       NLK,       NLK,       NLK,    0xFF, 0x00,
/* sc=46 */  SLK,   SLK,   SLK,   SLK,     SLK,       SLK,       SLK,       SLK,    0xFF, 0x00,
/* sc=47 */ F(49),  '7',   '7',   '7',  SET8|'7',  SET8|'7',  SET8|'7',  SET8|'7',  0x80, 0x02,
/* sc=48 */ F(50),  '8',   '8',   '8',  SET8|'8',  SET8|'8',  SET8|'8',  SET8|'8',  0x80, 0x02,
/* sc=49 */ F(51),  '9',   '9',   '9',  SET8|'9',  SET8|'9',  SET8|'9',  SET8|'9',  0x80, 0x02,
/* sc=4a */ F(52),  '-',   '-',   '-',  SET8|'-',  SET8|'-',  SET8|'-',  SET8|'-',  0x80, 0x02,
/* sc=4b */ F(53),  '4',   '4',   '4',  SET8|'4',  SET8|'4',  SET8|'4',  SET8|'4',  0x80, 0x02,
/* sc=4c */ F(54),  '5',   '5',   '5',  SET8|'5',  SET8|'5',  SET8|'5',  SET8|'5',  0x80, 0x02,
/* sc=4d */ F(55),  '6',   '6',   '6',  SET8|'6',  SET8|'6',  SET8|'6',  SET8|'6',  0x80, 0x02,
/* sc=4e */ F(56),  '+',   '+',   '+',  SET8|'+',  SET8|'+',  SET8|'+',  SET8|'+',  0x80, 0x02,
/* sc=4f */ F(57),  '1',   '1',   '1',  SET8|'1',  SET8|'1',  SET8|'1',  SET8|'1',  0x80, 0x02,
/* sc=50 */ F(58),  '2',   '2',   '2',  SET8|'2',  SET8|'2',  SET8|'2',  SET8|'2',  0x80, 0x02,
/* sc=51 */ F(59),  '3',   '3',   '3',  SET8|'3',  SET8|'3',  SET8|'3',  SET8|'3',  0x80, 0x02,
/* sc=52 */ F(60),  '0',   '0',   '0',  SET8|'0',  SET8|'0',  SET8|'0',  SET8|'0',  0x80, 0x02,
/* sc=53 */ 0x7F,   '.',   '.',   '.',  SET8|'.',  SET8|'.',     RBT,       RBT,    0x03, 0x02,
/* sc=54 */  ALK,   ALK,   ALK,   ALK,     ALK,       ALK,       ALK,       ALK,    0xFF, 0x00,
/* sc=55 */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=56 */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=57 */ F(11), F(23), F(35), F(47),   S(11),     S(11),     S(11),     S(11),   0xFF, 0x00,
/* sc=58 */ F(12), F(24), F(36), F(48),   S(12),     S(12),     S(12),     S(12),   0xFF, 0x00,
/* sc=59 */ 0x0D,  0x0D,  0x0A,  0x0A,  SET8|0x0D, SET8|0x0D, SET8|0x0A, SET8|0x0A, 0x00, 0x00,
/* sc=5a */ RCTR,  RCTR,  RCTR,  RCTR,    RCTR,      RCTR,      RCTR,      RCTR,    0xFF, 0x00,
/* sc=5b */  '/',   '/',   NOP,   NOP,  SET8|'/',  SET8|'/',     NOP,       NOP,    0x33, 0x00,
/* sc=5c */ NEXT,   NOP,   DBG,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=5d */ RALT,  RALT,  RALT,  RALT,    RALT,      RALT,      RALT,      RALT,    0xFF, 0x00,
/* sc=5e */ F(49), F(49), F(49), F(49),   F(49),     F(49),     F(49),     F(49),   0xFF, 0x00,
/* sc=5f */ F(50), F(50), F(50), F(50),   F(50),     F(50),     F(50),     F(50),   0xFF, 0x00,
/* sc=60 */ F(51), F(51), F(51), F(51),   F(51),     F(51),     F(51),     F(51),   0xFF, 0x00,
/* sc=61 */ F(53), F(53), F(53), F(53),   F(53),     F(53),     F(53),     F(53),   0xFF, 0x00,
/* sc=62 */ F(55), F(55), F(55), F(55),   F(55),     F(55),     F(55),     F(55),   0xFF, 0x00,
/* sc=63 */ F(57), F(57), F(57), F(57),   F(57),     F(57),     F(57),     F(57),   0xFF, 0x00,
/* sc=64 */ F(58), F(58), F(58), F(58),   F(58),     F(58),     F(58),     F(58),   0xFF, 0x00,
/* sc=65 */ F(59), F(59), F(59), F(59),   F(59),     F(59),     F(59),     F(59),   0xFF, 0x00,
/* sc=66 */ F(60), F(60), F(60), F(60),   F(60),     F(60),     F(60),     F(60),   0xFF, 0x00,
/* sc=67 */ F(61), F(61), F(61), F(61),   F(61),     F(61),      RBT,      F(61),   0xFF, 0x00,
/* sc=68 */  SLK,   SLK,   SLK,   SLK,     SLK,       SLK,       SLK,       SLK,    0xFF, 0x00,
/* sc=69 */ F(62), F(62), F(62), F(62),   F(62),     F(62),     F(62),     F(62),   0xFF, 0x00,
/* sc=6a */ F(63), F(63), F(63), F(63),   F(63),     F(63),     F(63),     F(63),   0xFF, 0x00,
/* sc=6b */ F(64), F(64), F(64), F(64),   F(64),     F(64),     F(64),     F(64),   0xFF, 0x00,
/* sc=6c */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=6d */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=6e */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=6f */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=70 */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=71 */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=72 */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=73 */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=74 */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=75 */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=76 */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=77 */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=78 */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=79 */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=7a */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=7b */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=7c */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=7d */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=7e */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=7f */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* extended (ALTGR LOCK keys) */
/* sc=00 */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=01 */ 0x1B,  0x1B,   NOP,   NOP,  SET8|0x1B, SET8|0x1B,    DBG,       NOP,    0x33, 0x00,
/* sc=02 */  '!',   '1',   NOP,   NOP,  SET8|'1',  SET8|'!',     NOP,       NOP,    0x33, 0x00,
/* sc=03 */  '"',   '2',  0x00,  0x00,  SET8|'2',  SET8|'@',  SET8|0x00, SET8|0x00, 0x00, 0x00,
/* sc=04 */  '\'',  '3',   NOP,   NOP,  SET8|'3',  SET8|'#',     NOP,       NOP,    0x33, 0x00,
/* sc=05 */  ';',   '4',   NOP,   NOP,  SET8|'4',  SET8|'$',     NOP,       NOP,    0x33, 0x00,
/* sc=06 */  ':',   '5',   NOP,   NOP,  SET8|'5',  SET8|'%',     NOP,       NOP,    0x33, 0x00,
/* sc=07 */  ',',   '6',  0x1E,  0x1E,  SET8|'6',  SET8|'^',  SET8|0x1E, SET8|0x1E, 0x00, 0x00,
/* sc=08 */  '.',   '7',   NOP,   NOP,  SET8|'7',  SET8|'&',     NOP,       NOP,    0x33, 0x00,
/* sc=09 */  '*',   '8',   NOP,   NOP,  SET8|'8',  SET8|'*',     NOP,       NOP,    0x33, 0x00,
/* sc=0a */  '(',   '9',   NOP,   NOP,  SET8|'9',  SET8|'(',     NOP,       NOP,    0x33, 0x00,
/* sc=0b */  ')',   '0',   NOP,   NOP,  SET8|'0',  SET8|')',     NOP,       NOP,    0x33, 0x00,
/* sc=0c */  '-',   '_',  0x1F,  0x1F,  SET8|'-',  SET8|'_',  SET8|0x1F, SET8|0x1F, 0x00, 0x00,
/* sc=0d */  '=',   '+',   NOP,   NOP,  SET8|'=',  SET8|'+',     NOP,       NOP,    0x33, 0x00,
/* sc=0e */ 0x08,  0x08,  0x7F,  0x7F,  SET8|0x08, SET8|0x08, SET8|0x7F, SET8|0x7F, 0x00, 0x00,
/* sc=0f */ 0x09,  BTAB,   NOP,   NOP,  SET8|0x09,   BTAB,       NOP,       NOP,    0x77, 0x00,
/* sc=10 */ 0xca,  0xea,  0x11,  0x11,  SET8|'q',  SET8|'Q',  SET8|0x11, SET8|0x11, 0x00, 0x01,
/* sc=11 */ 0xc3,  0xe3,  0x17,  0x17,  SET8|'w',  SET8|'W',  SET8|0x17, SET8|0x17, 0x00, 0x01,
/* sc=12 */ 0xd5,  0xf5,  0x05,  0x05,  SET8|'e',  SET8|'E',  SET8|0x05, SET8|0x05, 0x00, 0x01,
/* sc=13 */ 0xcb,  0xeb,  0x12,  0x12,  SET8|'r',  SET8|'R',  SET8|0x12, SET8|0x12, 0x00, 0x01,
/* sc=14 */ 0xc5,  0xe5,  0x14,  0x14,  SET8|'t',  SET8|'T',  SET8|0x14, SET8|0x14, 0x00, 0x01,
/* sc=15 */ 0xce,  0xee,  0x19,  0x19,  SET8|'y',  SET8|'Y',  SET8|0x19, SET8|0x19, 0x00, 0x01,
/* sc=16 */ 0xc7,  0xe7,  0x15,  0x15,  SET8|'u',  SET8|'U',  SET8|0x15, SET8|0x15, 0x00, 0x01,
/* sc=17 */ 0xdb,  0xfb,  0x09,  0x09,  SET8|'i',  SET8|'I',  SET8|0x09, SET8|0x09, 0x00, 0x01,
/* sc=18 */ 0xdd,  0xfd,  0x0F,  0x0F,  SET8|'o',  SET8|'O',  SET8|0x0F, SET8|0x0F, 0x00, 0x01,
/* sc=19 */ 0xda,  0xfa,  0x10,  0x10,  SET8|'p',  SET8|'P',  SET8|0x10, SET8|0x10, 0x00, 0x01,
/* sc=1a */ 0xc8,  0xe8,  0x1B,  0x1B,  SET8|'[',  SET8|'{',  SET8|0x1B, SET8|0x1B, 0x00, 0x01,
/* sc=1b */ 0xdf,  0xff,  0x1D,  0x1D,  SET8|']',  SET8|'}',  SET8|0x1D, SET8|0x1D, 0x00, 0x01,
/* sc=1c */ 0x0D,  0x0D,  0x0A,  0x0A,  SET8|0x0D, SET8|0x0D, SET8|0x0A, SET8|0x0A, 0x00, 0x00,
/* sc=1d */ LCTR,  LCTR,  LCTR,  LCTR,    LCTR,      LCTR,      LCTR,      LCTR,    0xFF, 0x00,
/* sc=1e */ 0xc6,  0xe6,  0x01,  0x01,  SET8|'a',  SET8|'A',  SET8|0x01, SET8|0x01, 0x00, 0x01,
/* sc=1f */ 0xd9,  0xf9,  0x13,  0x13,  SET8|'s',  SET8|'S',  SET8|0x13, SET8|0x13, 0x00, 0x01,
/* sc=20 */ 0xd7,  0xf7,  0x04,  0x04,  SET8|'d',  SET8|'D',  SET8|0x04, SET8|0x04, 0x00, 0x01,
/* sc=21 */ 0xc1,  0xe1,  0x06,  0x06,  SET8|'f',  SET8|'F',  SET8|0x06, SET8|0x06, 0x00, 0x01,
/* sc=22 */ 0xd0,  0xf0,  0x07,  0x07,  SET8|'g',  SET8|'G',  SET8|0x07, SET8|0x07, 0x00, 0x01,
/* sc=23 */ 0xd2,  0xf2,  0x08,  0x08,  SET8|'h',  SET8|'H',  SET8|0x08, SET8|0x08, 0x00, 0x01,
/* sc=24 */ 0xcf,  0xef,  0x0A,  0x0A,  SET8|'j',  SET8|'J',  SET8|0x0A, SET8|0x0A, 0x00, 0x01,
/* sc=25 */ 0xcc,  0xec,  0x0B,  0x0B,  SET8|'k',  SET8|'K',  SET8|0x0B, SET8|0x0B, 0x00, 0x01,
/* sc=26 */ 0xc4,  0xe4,  0x0C,  0x0C,  SET8|'l',  SET8|'L',  SET8|0x0C, SET8|0x0C, 0x00, 0x01,
/* sc=27 */ 0xd6,  0xf6,   NOP,   NOP,  SET8|';',  SET8|':',     NOP,       NOP,    0x33, 0x01,
/* sc=28 */ 0xdc,  0xfc,   NOP,   NOP,  SET8|'\'', SET8|'"',     NOP,       NOP,    0x33, 0x01,
/* sc=29 */ 0xa3,  0xb3,   NOP,   NOP,  SET8|'`',  SET8|'~',     NOP,       NOP,    0x33, 0x01,
/* sc=2a */  LSH,   LSH,   LSH,   LSH,     LSH,       LSH,       LSH,       LSH,    0xFF, 0x00,
/* sc=2b */ '\\',   '|',  0x1C,  0x1C,  SET8|'\\', SET8|'|',  SET8|0x1C, SET8|0x1C, 0x00, 0x00,
/* sc=2c */ 0xd1,  0xf1,  0x1A,  0x1A,  SET8|'z',  SET8|'Z',  SET8|0x1A, SET8|0x1A, 0x00, 0x01,
/* sc=2d */ 0xde,  0xfe,  0x18,  0x18,  SET8|'x',  SET8|'X',  SET8|0x18, SET8|0x18, 0x00, 0x01,
/* sc=2e */ 0xd3,  0xf3,  0x03,  0x03,  SET8|'c',  SET8|'C',  SET8|0x03, SET8|0x03, 0x00, 0x01,
/* sc=2f */ 0xcd,  0xed,  0x16,  0x16,  SET8|'v',  SET8|'V',  SET8|0x16, SET8|0x16, 0x00, 0x01,
/* sc=30 */ 0xc9,  0xe9,  0x02,  0x02,  SET8|'b',  SET8|'B',  SET8|0x02, SET8|0x02, 0x00, 0x01,
/* sc=31 */ 0xd4,  0xf4,  0x0E,  0x0E,  SET8|'n',  SET8|'N',  SET8|0x0E, SET8|0x0E, 0x00, 0x01,
/* sc=32 */ 0xd8,  0xf8,  0x0D,  0x0D,  SET8|'m',  SET8|'M',  SET8|0x0D, SET8|0x0D, 0x00, 0x01,
/* sc=33 */ 0xc2,  0xe2,   NOP,   NOP,  SET8|',',  SET8|'<',     NOP,       NOP,    0x33, 0x01,
/* sc=34 */ 0xc0,  0xe0,   NOP,   NOP,  SET8|'.',  SET8|'>',     NOP,       NOP,    0x33, 0x01,
/* sc=35 */  '/',   '?',   NOP,   NOP,  SET8|'/',  SET8|'?',     NOP,       NOP,    0x33, 0x00,
/* sc=36 */  RSH,   RSH,   RSH,   RSH,     RSH,       RSH,       RSH,       RSH,    0xFF, 0x00,
/* sc=37 */  '*',   '*',  0x0A,  0x0A,  SET8|'*',  SET8|'*',  SET8|0x0A, SET8|0x0A, 0x00, 0x00,
/* sc=38 */ LALT,  LALT,  LALT,  LALT,    LALT,      LALT,      LALT,      LALT,    0xFF, 0x00,
/* sc=39 */  ' ',   ' ',  0x00,   ' ',  SET8|' ',  SET8|' ',  SET8|' ',  SET8|' ',  0x00, 0x00,
/* sc=3a */  ALK,   CLK,   CLK,   CLK,     CLK,       CLK,       CLK,       CLK,    0xFF, 0x00,
/* sc=3b */ F( 1), F(13), F(25), F(37),   S( 1),     S(11),     S( 1),     S(11),   0xFF, 0x00,
/* sc=3c */ F( 2), F(14), F(26), F(38),   S( 2),     S(12),     S( 2),     S(12),   0xFF, 0x00,
/* sc=3d */ F( 3), F(15), F(27), F(39),   S( 3),     S(13),     S( 3),     S(13),   0xFF, 0x00,
/* sc=3e */ F( 4), F(16), F(28), F(40),   S( 4),     S(14),     S( 4),     S(14),   0xFF, 0x00,
/* sc=3f */ F( 5), F(17), F(29), F(41),   S( 5),     S(15),     S( 5),     S(15),   0xFF, 0x00,
/* sc=40 */ F( 6), F(18), F(30), F(42),   S( 6),     S(16),     S( 6),     S(16),   0xFF, 0x00,
/* sc=41 */ F( 7), F(19), F(31), F(43),   S( 7),     S( 7),     S( 7),     S( 7),   0xFF, 0x00,
/* sc=42 */ F( 8), F(20), F(32), F(44),   S( 8),     S( 8),     S( 8),     S( 8),   0xFF, 0x00,
/* sc=43 */ F( 9), F(21), F(33), F(45),   S( 9),     S( 9),     S( 9),     S( 9),   0xFF, 0x00,
/* sc=44 */ F(10), F(22), F(34), F(46),   S(10),     S(10),     S(10),     S(10),   0xFF, 0x00,
/* sc=45 */  NLK,   NLK,   NLK,   NLK,     NLK,       NLK,       NLK,       NLK,    0xFF, 0x00,
/* sc=46 */  SLK,   SLK,   SLK,   SLK,     SLK,       SLK,       SLK,       SLK,    0xFF, 0x00,
/* sc=47 */ F(49),  '7',   '7',   '7',  SET8|'7',  SET8|'7',  SET8|'7',  SET8|'7',  0x80, 0x02,
/* sc=48 */ F(50),  '8',   '8',   '8',  SET8|'8',  SET8|'8',  SET8|'8',  SET8|'8',  0x80, 0x02,
/* sc=49 */ F(51),  '9',   '9',   '9',  SET8|'9',  SET8|'9',  SET8|'9',  SET8|'9',  0x80, 0x02,
/* sc=4a */ F(52),  '-',   '-',   '-',  SET8|'-',  SET8|'-',  SET8|'-',  SET8|'-',  0x80, 0x02,
/* sc=4b */ F(53),  '4',   '4',   '4',  SET8|'4',  SET8|'4',  SET8|'4',  SET8|'4',  0x80, 0x02,
/* sc=4c */ F(54),  '5',   '5',   '5',  SET8|'5',  SET8|'5',  SET8|'5',  SET8|'5',  0x80, 0x02,
/* sc=4d */ F(55),  '6',   '6',   '6',  SET8|'6',  SET8|'6',  SET8|'6',  SET8|'6',  0x80, 0x02,
/* sc=4e */ F(56),  '+',   '+',   '+',  SET8|'+',  SET8|'+',  SET8|'+',  SET8|'+',  0x80, 0x02,
/* sc=4f */ F(57),  '1',   '1',   '1',  SET8|'1',  SET8|'1',  SET8|'1',  SET8|'1',  0x80, 0x02,
/* sc=50 */ F(58),  '2',   '2',   '2',  SET8|'2',  SET8|'2',  SET8|'2',  SET8|'2',  0x80, 0x02,
/* sc=51 */ F(59),  '3',   '3',   '3',  SET8|'3',  SET8|'3',  SET8|'3',  SET8|'3',  0x80, 0x02,
/* sc=52 */ F(60),  '0',   '0',   '0',  SET8|'0',  SET8|'0',  SET8|'0',  SET8|'0',  0x80, 0x02,
/* sc=53 */ 0x7F,   '.',   '.',   '.',  SET8|'.',  SET8|'.',     RBT,       RBT,    0x03, 0x02,
/* sc=54 */  ALK,   ALK,   ALK,   ALK,     ALK,       ALK,       ALK,       ALK,    0xFF, 0x00,
/* sc=55 */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=56 */  NOP,   NOP,   NOP,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=57 */ F(11), F(23), F(35), F(47),   S(11),     S(11),     S(11),     S(11),   0xFF, 0x00,
/* sc=58 */ F(12), F(24), F(36), F(48),   S(12),     S(12),     S(12),     S(12),   0xFF, 0x00,
/* sc=59 */ 0x0D,  0x0D,  0x0A,  0x0A,  SET8|0x0D, SET8|0x0D, SET8|0x0A, SET8|0x0A, 0x00, 0x00,
/* sc=5a */ RCTR,  RCTR,  RCTR,  RCTR,    RCTR,      RCTR,      RCTR,      RCTR,    0xFF, 0x00,
/* sc=5b */  '/',   '/',   NOP,   NOP,  SET8|'/',  SET8|'/',     NOP,       NOP,    0x33, 0x00,
/* sc=5c */ NEXT,   NOP,   DBG,   NOP,     NOP,       NOP,       NOP,       NOP,    0xFF, 0x00,
/* sc=5d */ RALT,  RALT,  RALT,  RALT,    RALT,      RALT,      RALT,      RALT,    0xFF, 0x00,
/* sc=5e */ F(49), F(49), F(49), F(49),   F(49),     F(49),     F(49),     F(49),   0xFF, 0x00,
/* sc=5f */ F(50), F(50), F(50), F(50),   F(50),     F(50),     F(50),     F(50),   0xFF, 0x00,
/* sc=60 */ F(51), F(51), F(51), F(51),   F(51),     F(51),     F(51),     F(51),   0xFF, 0x00,
/* sc=61 */ F(53), F(53), F(53), F(53),   F(53),     F(53),     F(53),     F(53),   0xFF, 0x00,
/* sc=62 */ F(55), F(55), F(55), F(55),   F(55),     F(55),     F(55),     F(55),   0xFF, 0x00,
/* sc=63 */ F(57), F(57), F(57), F(57),   F(57),     F(57),     F(57),     F(57),   0xFF, 0x00,
/* sc=64 */ F(58), F(58), F(58), F(58),   F(58),     F(58),     F(58),     F(58),   0xFF, 0x00,
/* sc=65 */ F(59), F(59), F(59), F(59),   F(59),     F(59),     F(59),     F(59),   0xFF, 0x00,
/* sc=66 */ F(60), F(60), F(60), F(60),   F(60),     F(60),     F(60),     F(60),   0xFF, 0x00,
/* sc=67 */ F(61), F(61), F(61), F(61),   F(61),     F(61),      RBT,      F(61),   0xFF, 0x00,
/* sc=68 */  SLK,   SLK,   SLK,   SLK,     SLK,       SLK,       SLK,       SLK,    0xFF, 0x00,
/* sc=69 */ F(62), F(62), F(62), F(62),   F(62),     F(62),     F(62),     F(62),   0xFF, 0x00,
/* sc=6a */ F(63), F(63), F(63), F(63),   F(63),     F(63),     F(63),     F(63),   0xFF, 0x00,
/* sc=6b */ F(64), F(64), F(64), F(64),   F(64),     F(64),     F(64),     F(64),   0xFF, 0x00,
};

#endif

#if !defined(DKKEYMAP) && !defined(UKKEYMAP) && !defined(GRKEYMAP) && !defined(SWKEYMAP) && !defined(RUKEYMAP)
keymap_t key_map = { 0x6C,	/* US iso8859 keymap */
/*                                                            alt
 * scan                          cntrl          alt    alt   cntrl
 * code     base   shift  cntrl  shift   alt   shift  cntrl  shift  spcl  flgs
 * ---------------------------------------------------------------------------
 */
/* sc=00 */  NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=01 */ 0x1B,  0x1B,  0x1B,  0x1B,  0x1B,  0x1B,   DBG,  0x1B,  0x02, 0x00,
/* sc=02 */  '1',   '!',   NOP,   NOP,   '1',   '!',   NOP,   NOP,  0x33, 0x00,
/* sc=03 */  '2',   '@',  0x00,  0x00,   '2',   '@',  0x00,  0x00,  0x00, 0x00,
/* sc=04 */  '3',   '#',   NOP,   NOP,   '3',   '#',   NOP,   NOP,  0x33, 0x00,
/* sc=05 */  '4',   '$',   NOP,   NOP,   '4',   '$',   NOP,   NOP,  0x33, 0x00,
/* sc=06 */  '5',   '%',   NOP,   NOP,   '5',   '%',   NOP,   NOP,  0x33, 0x00,
/* sc=07 */  '6',   '^',  0x1E,  0x1E,   '6',   '^',  0x1E,  0x1E,  0x00, 0x00,
/* sc=08 */  '7',   '&',   NOP,   NOP,   '7',   '&',   NOP,   NOP,  0x33, 0x00,
/* sc=09 */  '8',   '*',   NOP,   NOP,   '8',   '*',   NOP,   NOP,  0x33, 0x00,
/* sc=0a */  '9',   '(',   NOP,   NOP,   '9',   '(',   NOP,   NOP,  0x33, 0x00,
/* sc=0b */  '0',   ')',   NOP,   NOP,   '0',   ')',   NOP,   NOP,  0x33, 0x00,
/* sc=0c */  '-',   '_',  0x1F,  0x1F,   '-',   '_',  0x1F,  0x1F,  0x00, 0x00,
/* sc=0d */  '=',   '+',   NOP,   NOP,   '=',   '+',   NOP,   NOP,  0x33, 0x00,
/* sc=0e */ 0x08,  0x08,  0x7F,  0x7F,  0x08,  0x08,  0x7F,  0x7F,  0x00, 0x00,
/* sc=0f */ 0x09,  BTAB,   NOP,   NOP,  0x09,  BTAB,   NOP,   NOP,  0x77, 0x00,
/* sc=10 */  'q',   'Q',  0x11,  0x11,   'q',   'Q',  0x11,  0x11,  0x00, 0x01,
/* sc=11 */  'w',   'W',  0x17,  0x17,   'w',   'W',  0x17,  0x17,  0x00, 0x01,
/* sc=12 */  'e',   'E',  0x05,  0x05,   'e',   'E',  0x05,  0x05,  0x00, 0x01,
/* sc=13 */  'r',   'R',  0x12,  0x12,   'r',   'R',  0x12,  0x12,  0x00, 0x01,
/* sc=14 */  't',   'T',  0x14,  0x14,   't',   'T',  0x14,  0x14,  0x00, 0x01,
/* sc=15 */  'y',   'Y',  0x19,  0x19,   'y',   'Y',  0x19,  0x19,  0x00, 0x01,
/* sc=16 */  'u',   'U',  0x15,  0x15,   'u',   'U',  0x15,  0x15,  0x00, 0x01,
/* sc=17 */  'i',   'I',  0x09,  0x09,   'i',   'I',  0x09,  0x09,  0x00, 0x01,
/* sc=18 */  'o',   'O',  0x0F,  0x0F,   'o',   'O',  0x0F,  0x0F,  0x00, 0x01,
/* sc=19 */  'p',   'P',  0x10,  0x10,   'p',   'P',  0x10,  0x10,  0x00, 0x01,
/* sc=1a */  '[',   '{',  0x1B,  0x1B,   '[',   '{',  0x1B,  0x1B,  0x00, 0x00,
/* sc=1b */  ']',   '}',  0x1D,  0x1D,   ']',   '}',  0x1D,  0x1D,  0x00, 0x00,
/* sc=1c */ 0x0D,  0x0D,  0x0A,  0x0A,  0x0D,  0x0D,  0x0A,  0x0A,  0x00, 0x00,
/* sc=1d */ LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  LCTR,  0xFF, 0x00,
/* sc=1e */  'a',   'A',  0x01,  0x01,   'a',   'A',  0x01,  0x01,  0x00, 0x01,
/* sc=1f */  's',   'S',  0x13,  0x13,   's',   'S',  0x13,  0x13,  0x00, 0x01,
/* sc=20 */  'd',   'D',  0x04,  0x04,   'd',   'D',  0x04,  0x04,  0x00, 0x01,
/* sc=21 */  'f',   'F',  0x06,  0x06,   'f',   'F',  0x06,  0x06,  0x00, 0x01,
/* sc=22 */  'g',   'G',  0x07,  0x07,   'g',   'G',  0x07,  0x07,  0x00, 0x01,
/* sc=23 */  'h',   'H',  0x08,  0x08,   'h',   'H',  0x08,  0x08,  0x00, 0x01,
/* sc=24 */  'j',   'J',  0x0A,  0x0A,   'j',   'J',  0x0A,  0x0A,  0x00, 0x01,
/* sc=25 */  'k',   'K',  0x0B,  0x0B,   'k',   'K',  0x0B,  0x0B,  0x00, 0x01,
/* sc=26 */  'l',   'L',  0x0C,  0x0C,   'l',   'L',  0x0C,  0x0C,  0x00, 0x01,
/* sc=27 */  ';',   ':',   NOP,   NOP,   ';',   ':',   NOP,   NOP,  0x33, 0x00,
/* sc=28 */  '\'',  '"',   NOP,   NOP,   '\'',  '"',   NOP,   NOP,  0x33, 0x00,
/* sc=29 */  '`',   '~',   NOP,   NOP,   '`',   '~',   NOP,   NOP,  0x33, 0x00,
/* sc=2a */  LSH,   LSH,   LSH,   LSH,   LSH,   LSH,   LSH,   LSH,  0xFF, 0x00,
/* sc=2b */  '\\',  '|',  0x1C,  0x1C,   '\\',  '|',  0x1C,  0x1C,  0x00, 0x00,
/* sc=2c */  'z',   'Z',  0x1A,  0x1A,   'z',   'Z',  0x1A,  0x1A,  0x00, 0x01,
/* sc=2d */  'x',   'X',  0x18,  0x18,   'x',   'X',  0x18,  0x18,  0x00, 0x01,
/* sc=2e */  'c',   'C',  0x03,  0x03,   'c',   'C',  0x03,  0x03,  0x00, 0x01,
/* sc=2f */  'v',   'V',  0x16,  0x16,   'v',   'V',  0x16,  0x16,  0x00, 0x01,
/* sc=30 */  'b',   'B',  0x02,  0x02,   'b',   'B',  0x02,  0x02,  0x00, 0x01,
/* sc=31 */  'n',   'N',  0x0E,  0x0E,   'n',   'N',  0x0E,  0x0E,  0x00, 0x01,
/* sc=32 */  'm',   'M',  0x0D,  0x0D,   'm',   'M',  0x0D,  0x0D,  0x00, 0x01,
/* sc=33 */  ',',   '<',   NOP,   NOP,   ',',   '<',   NOP,   NOP,  0x33, 0x00,
/* sc=34 */  '.',   '>',   NOP,   NOP,   '.',   '>',   NOP,   NOP,  0x33, 0x00,
/* sc=35 */  '/',   '?',   NOP,   NOP,   '/',   '?',   NOP,   NOP,  0x33, 0x00,
/* sc=36 */  RSH,   RSH,   RSH,   RSH,   RSH,   RSH,   RSH,   RSH,  0xFF, 0x00,
/* sc=37 */  '*',   '*',  0x0A,  0x0A,   '*',   '*',  0x0A,  0x0A,  0x33, 0x00,
/* sc=38 */ LALT,  LALT,  LALT,  LALT,  LALT,  LALT,  LALT,  LALT,  0xFF, 0x00,
/* sc=39 */  ' ',   ' ',  0x00,   ' ',   ' ',   ' ',  SUSP,   ' ',  0x02, 0x00,
/* sc=3a */  CLK,   CLK,   CLK,   CLK,   CLK,   CLK,   CLK,   CLK,  0xFF, 0x00,
/* sc=3b */ F( 1), F(13), F(25), F(37), S( 1), S(11), S( 1), S(11), 0xFF, 0x00,
/* sc=3c */ F( 2), F(14), F(26), F(38), S( 2), S(12), S( 2), S(12), 0xFF, 0x00,
/* sc=3d */ F( 3), F(15), F(27), F(39), S( 3), S(13), S( 3), S(13), 0xFF, 0x00,
/* sc=3e */ F( 4), F(16), F(28), F(40), S( 4), S(14), S( 4), S(14), 0xFF, 0x00,
/* sc=3f */ F( 5), F(17), F(29), F(41), S( 5), S(15), S( 5), S(15), 0xFF, 0x00,
/* sc=40 */ F( 6), F(18), F(30), F(42), S( 6), S(16), S( 6), S(16), 0xFF, 0x00,
/* sc=41 */ F( 7), F(19), F(31), F(43), S( 7), S( 7), S( 7), S( 7), 0xFF, 0x00,
/* sc=42 */ F( 8), F(20), F(32), F(44), S( 8), S( 8), S( 8), S( 8), 0xFF, 0x00,
/* sc=43 */ F( 9), F(21), F(33), F(45), S( 9), S( 9), S( 9), S( 9), 0xFF, 0x00,
/* sc=44 */ F(10), F(22), F(34), F(46), S(10), S(10), S(10), S(10), 0xFF, 0x00,
/* sc=45 */  NLK,   NLK,   NLK,   NLK,   NLK,   NLK,   NLK,   NLK,  0xFF, 0x00,
/* sc=46 */  SLK,   SLK,   SLK,   SLK,   SLK,   SLK,   SLK,   SLK,  0xFF, 0x00,
/* sc=47 */ F(49),  '7',   '7',   '7',   '7',   '7',   '7',   '7',  0x80, 0x02,
/* sc=48 */ F(50),  '8',   '8',   '8',   '8',   '8',   '8',   '8',  0x80, 0x02,
/* sc=49 */ F(51),  '9',   '9',   '9',   '9',   '9',   '9',   '9',  0x80, 0x02,
/* sc=4a */ F(52),  '-',   '-',   '-',   '-',   '-',   '-',   '-',  0x80, 0x02,
/* sc=4b */ F(53),  '4',   '4',   '4',   '4',   '4',   '4',   '4',  0x80, 0x02,
/* sc=4c */ F(54),  '5',   '5',   '5',   '5',   '5',   '5',   '5',  0x80, 0x02,
/* sc=4d */ F(55),  '6',   '6',   '6',   '6',   '6',   '6',   '6',  0x80, 0x02,
/* sc=4e */ F(56),  '+',   '+',   '+',   '+',   '+',   '+',   '+',  0x80, 0x02,
/* sc=4f */ F(57),  '1',   '1',   '1',   '1',   '1',   '1',   '1',  0x80, 0x02,
/* sc=50 */ F(58),  '2',   '2',   '2',   '2',   '2',   '2',   '2',  0x80, 0x02,
/* sc=51 */ F(59),  '3',   '3',   '3',   '3',   '3',   '3',   '3',  0x80, 0x02,
/* sc=52 */ F(60),  '0',   '0',   '0',   '0',   '0',   '0',   '0',  0x80, 0x02,
/* sc=53 */ 0x7F,   '.',   '.',   '.',   '.',   '.',   RBT,   RBT,  0x03, 0x02,
/* sc=54 */  NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=55 */  NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=56 */  NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=57 */ F(11), F(23), F(35), F(47), S(11), S(11), S(11), S(11), 0xFF, 0x00,
/* sc=58 */ F(12), F(24), F(36), F(48), S(12), S(12), S(12), S(12), 0xFF, 0x00,
/* sc=59 */ 0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0x0D,  0x00, 0x00,
/* sc=5a */ RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  RCTR,  0xFF, 0x00,
/* sc=5b */  '/',   '/',   '/',   '/',   '/',   '/',   '/',   '/',  0x00, 0x00,
/* sc=5c */ NEXT,   NOP,   DBG,   NOP,   NOP,   NOP,   NOP,   NOP,  0xFF, 0x00,
/* sc=5d */ RALT,  RALT,  RALT,  RALT,  RALT,  RALT,  RALT,  RALT,  0xFF, 0x00,
/* sc=5e */ F(49), F(49), F(49), F(49), F(49), F(49), F(49), F(49), 0xFF, 0x00,
/* sc=5f */ F(50), F(50), F(50), F(50), F(50), F(50), F(50), F(50), 0xFF, 0x00,
/* sc=60 */ F(51), F(51), F(51), F(51), F(51), F(51), F(51), F(51), 0xFF, 0x00,
/* sc=61 */ F(53), F(53), F(53), F(53), F(53), F(53), F(53), F(53), 0xFF, 0x00,
/* sc=62 */ F(55), F(55), F(55), F(55), F(55), F(55), F(55), F(55), 0xFF, 0x00,
/* sc=63 */ F(57), F(57), F(57), F(57), F(57), F(57), F(57), F(57), 0xFF, 0x00,
/* sc=64 */ F(58), F(58), F(58), F(58), F(58), F(58), F(58), F(58), 0xFF, 0x00,
/* sc=65 */ F(59), F(59), F(59), F(59), F(59), F(59), F(59), F(59), 0xFF, 0x00,
/* sc=66 */ F(60), F(60), F(60), F(60), F(60), F(60), F(60), F(60), 0xFF, 0x00,
/* sc=67 */ F(61), F(61), F(61), F(61), F(61), F(61),  RBT,  F(61), 0xFF, 0x00,
/* sc=68 */  SLK,   SLK,   SLK,   SLK,   SLK,   SLK,   SLK,   SLK,  0xFF, 0x00,
/* sc=69 */ F(62), F(62), F(62), F(62), F(62), F(62), F(62), F(62), 0xFF, 0x00,
/* sc=6a */ F(63), F(63), F(63), F(63), F(63), F(63), F(63), F(63), 0xFF, 0x00,
/* sc=6b */ F(64), F(64), F(64), F(64), F(64), F(64), F(64), F(64), 0xFF, 0x00,
};

#endif

fkeytab_t fkey_tab[96] = {
/* 01-04 */	{"\033[M", 3}, {"\033[N", 3}, {"\033[O", 3}, {"\033[P", 3},
/* 05-08 */	{"\033[Q", 3}, {"\033[R", 3}, {"\033[S", 3}, {"\033[T", 3},
/* 09-12 */	{"\033[U", 3}, {"\033[V", 3}, {"\033[W", 3}, {"\033[X", 3},
/* 13-16 */	{"\033[Y", 3}, {"\033[Z", 3}, {"\033[a", 3}, {"\033[b", 3},
/* 17-20 */	{"\033[c", 3}, {"\033[d", 3}, {"\033[e", 3}, {"\033[f", 3},
/* 21-24 */	{"\033[g", 3}, {"\033[h", 3}, {"\033[i", 3}, {"\033[j", 3},
/* 25-28 */	{"\033[k", 3}, {"\033[l", 3}, {"\033[m", 3}, {"\033[n", 3},
/* 29-32 */	{"\033[o", 3}, {"\033[p", 3}, {"\033[q", 3}, {"\033[r", 3},
/* 33-36 */	{"\033[s", 3}, {"\033[t", 3}, {"\033[u", 3}, {"\033[v", 3},
/* 37-40 */	{"\033[w", 3}, {"\033[x", 3}, {"\033[y", 3}, {"\033[z", 3},
/* 41-44 */	{"\033[@", 3}, {"\033[[", 3}, {"\033[\\",3}, {"\033[]", 3},
/* 45-48 */     {"\033[^", 3}, {"\033[_", 3}, {"\033[`", 3}, {"\033[{", 3},
/* 49-52 */	{"\033[H", 3}, {"\033[A", 3}, {"\033[I", 3}, {"-"     , 1},
/* 53-56 */	{"\033[D", 3}, {"\033[E", 3}, {"\033[C", 3}, {"+"     , 1},
/* 57-60 */	{"\033[F", 3}, {"\033[B", 3}, {"\033[G", 3}, {"\033[L", 3},
/* 61-64 */	{"\177", 1},   {"\033[J", 3}, {"\033[~", 3}, {"\033[}", 3},
/* 65-68 */	{"", 0}      , {"", 0}      , {"", 0}      , {"", 0}      ,
/* 69-72 */	{"", 0}      , {"", 0}      , {"", 0}      , {"", 0}      ,
/* 73-76 */	{"", 0}      , {"", 0}      , {"", 0}      , {"", 0}      ,
/* 77-80 */	{"", 0}      , {"", 0}      , {"", 0}      , {"", 0}      ,
/* 81-84 */	{"", 0}      , {"", 0}      , {"", 0}      , {"", 0}      ,
/* 85-88 */	{"", 0}      , {"", 0}      , {"", 0}      , {"", 0}      ,
/* 89-92 */	{"", 0}      , {"", 0}      , {"", 0}      , {"", 0}      ,
/* 93-96 */	{"", 0}      , {"", 0}      , {"", 0}      , {"", 0}
};
