'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS1963L 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.TP
.B DS1963L
256 byte Monetary iButton
.SH SYNOPSIS
Non-volatile R/W memory with counters
.PP
.B 1A
[.]XXXXXXXXXXXX[XX][/[
.B pages/count.[0-15|ALL]
|
.B memory
|
.B pages/page.[0-15|ALL]
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 1A
.SH SPECIAL PROPERTIES
.SS page/count.[0-15|ALL]
.I read-only, unsigned
.br
Each write to the memory page increments the counter. An application can tell if the memory has been changed by another process.
.P
Only 4 pages are actually connected to counters:
.TP
Counter1
.I page/counter.12
.TP
Counter2
.I page/counter.13
.TP
Counter3
.I page/counter.14
.TP
Counter4
.I page/counter.15
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS1963L
The
.B DS1963L (3)
is used for read/write storage. It's main advantage is for audit trails (i.e. a digital purse). Each write to pages 12-15 will increment the read-only counter.
.I OWFS
system handles this automatically.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://datasheets.maxim-ic.com/en/ds/DS1963L.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
