
/**
 * ownCloud App Framework - v0.0.1
 *
 * Copyright (c) 2014 - Bernhard Posselt <dev@bernhard-posselt.com>
 *
 * This file is licensed under the Affero General Public License version 3 or later.
 * See the COPYING-README file
 *
 */


// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  angular.module('OC', []).config([
    '$httpProvider', function($httpProvider) {
      return $httpProvider.defaults.headers.common['requesttoken'] = oc_requesttoken;
    }
  ]);

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  angular.module('OC').filter('ocRemoveTags', function() {
    return function(input, tagsToRemove) {
      var regex, replaceRegex, tag, _i, _len;
      if (tagsToRemove == null) {
        tagsToRemove = null;
      }
      if (angular.isArray(tagsToRemove)) {
        for (_i = 0, _len = tagsToRemove.length; _i < _len; _i++) {
          tag = tagsToRemove[_i];
          replaceRegex = '(</?' + tag + '[^>]*>)';
          regex = new RegExp(replaceRegex, 'ig');
          input = input.replace(regex, '');
        }
      } else if (tagsToRemove !== null) {
        replaceRegex = '(</?' + tagsToRemove + '[^>]*>)';
        regex = new RegExp(replaceRegex, 'ig');
        input = input.replace(regex, '');
      }
      return input;
    };
  });

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  angular.module('OC').filter('ocSanitizeURL', function() {
    return function(input) {
      var regex;
      regex = new RegExp('^(https?:\\/\\/)?' + '((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.)+[a-z]{2,}|' + '((\\d{1,3}\\.){3}\\d{1,3}))' + '(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*' + '(\\?[;&a-z\\d%_.~+=-]*)?' + '.*$', 'i', 'i');
      if (regex.test(input)) {
        return input;
      } else {
        return '';
      }
    };
  });

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  angular.module('OC').directive('ocClickFocus', [
    '$timeout', function($timeout) {
      return function(scope, elm, attr) {
        var options;
        options = scope.$eval(attr.ocClickFocus);
        if (angular.isDefined(options) && angular.isDefined(options.selector)) {
          return elm.click(function() {
            if (angular.isDefined(options.timeout)) {
              return $timeout(function() {
                return $(options.selector).focus();
              }, options.timeout);
            } else {
              return $(options.selector).focus();
            }
          });
        }
      };
    }
  ]);

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  angular.module('OC').directive('ocClickSlideToggle', [
    '$rootScope', function($rootScope) {
      return function(scope, elm, attr) {
        var cssClass, options, slideArea;
        options = scope.$eval(attr.ocClickSlideToggle);
        if (angular.isDefined(options) && angular.isDefined(options.selector)) {
          slideArea = $(options.selector);
        } else {
          slideArea = elm;
        }
        if (angular.isDefined(options) && angular.isDefined(options.cssClass)) {
          cssClass = options.cssClass;
        } else {
          cssClass = false;
        }
        elm.click(function() {
          if (slideArea.is(':visible') && !slideArea.is(':animated')) {
            slideArea.slideUp();
            if (cssClass !== false) {
              return elm.removeClass('opened');
            }
          } else {
            slideArea.slideDown();
            if (cssClass !== false) {
              return elm.addClass('opened');
            }
          }
        });
        if (angular.isDefined(options) && angular.isDefined(options.hideOnFocusLost) && options.hideOnFocusLost) {
          $(document.body).click(function() {
            return $rootScope.$broadcast('ocLostFocus');
          });
          $rootScope.$on('ocLostFocus', function(scope, params) {
            if (params !== slideArea) {
              if (slideArea.is(':visible') && !slideArea.is(':animated')) {
                slideArea.slideUp();
                if (cssClass !== false) {
                  return elm.removeClass('opened');
                }
              }
            }
          });
          slideArea.click(function(e) {
            $rootScope.$broadcast('ocLostFocus', slideArea);
            return e.stopPropagation();
          });
          return elm.click(function(e) {
            $rootScope.$broadcast('ocLostFocus', slideArea);
            return e.stopPropagation();
          });
        }
      };
    }
  ]);

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  angular.module('OC').directive('ocDraggable', function() {
    return function(scope, elm, attr) {
      var options;
      options = scope.$eval(attr.ocDraggable);
      if (angular.isDefined(options)) {
        return elm.draggable(options);
      } else {
        return elm.draggable();
      }
    };
  });

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  angular.module('OC').directive('ocForwardClick', function() {
    return function(scope, elm, attr) {
      var options;
      options = scope.$eval(attr.ocForwardClick);
      if (angular.isDefined(options) && angular.isDefined(options.selector)) {
        return $(elm).click(function() {
          return $(options.selector).trigger('click');
        });
      }
    };
  });

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */


/*
This directive can be bound on an input element with type file
When a file is input, the content will be passed to the given function as
$fileContent parameter
 */

(function() {
  angular.module('OC').directive('ocReadFile', [
    '$rootScope', function($rootScope) {
      return function(scope, elm, attr) {
        return elm.change(function() {
          var file, reader;
          file = elm[0].files[0];
          reader = new FileReader();
          reader.onload = function(e) {
            elm[0].value = null;
            scope.$fileContent = e.target.result;
            return scope.$apply(attr.ocReadFile);
          };
          return reader.readAsText(file);
        });
      };
    }
  ]);

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  angular.module('OC').directive('ocTooltip', function() {
    return function(scope, elm, attr) {
      return elm.tooltip();
    };
  });

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  angular.module('OC').factory('_Loading', function() {
    var Loading;
    Loading = (function() {
      function Loading() {
        this._count = 0;
      }

      Loading.prototype.increase = function() {
        return this._count += 1;
      };

      Loading.prototype.decrease = function() {
        return this._count -= 1;
      };

      Loading.prototype.getCount = function() {
        return this._count;
      };

      Loading.prototype.isLoading = function() {
        return this._count > 0;
      };

      return Loading;

    })();
    return Loading;
  });

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  angular.module('OC').factory('_Model', function() {
    var Model;
    Model = (function() {
      function Model() {
        this._data = [];
        this._dataMap = {};
        this._filterCache = {};
      }

      Model.prototype.handle = function(data) {

        /*
        			Redirects to add method
         */
        var item, _i, _len, _results;
        _results = [];
        for (_i = 0, _len = data.length; _i < _len; _i++) {
          item = data[_i];
          _results.push(this.add(item));
        }
        return _results;
      };

      Model.prototype.add = function(data, clearCache) {
        if (clearCache == null) {
          clearCache = true;
        }

        /*
        			Adds a new entry or updates an entry if the id exists already
         */
        if (clearCache) {
          this._invalidateCache();
        }
        if (angular.isDefined(this._dataMap[data.id])) {
          return this.update(data, clearCache);
        } else {
          this._data.push(data);
          return this._dataMap[data.id] = data;
        }
      };

      Model.prototype.update = function(data, clearCache) {
        var entry, key, value, _results;
        if (clearCache == null) {
          clearCache = true;
        }

        /*
        			Update an entry by searching for its id
         */
        if (clearCache) {
          this._invalidateCache();
        }
        entry = this.getById(data.id);
        _results = [];
        for (key in data) {
          value = data[key];
          if (key === 'id') {
            continue;
          } else {
            _results.push(entry[key] = value);
          }
        }
        return _results;
      };

      Model.prototype.getById = function(id) {

        /*
        			Return an entry by its id
         */
        return this._dataMap[id];
      };

      Model.prototype.getAll = function() {

        /*
        			Returns all stored entries
         */
        return this._data;
      };

      Model.prototype.removeById = function(id, clearCache) {
        var counter, data, entry, _i, _len, _ref;
        if (clearCache == null) {
          clearCache = true;
        }

        /*
        			Remove an entry by id
         */
        _ref = this._data;
        for (counter = _i = 0, _len = _ref.length; _i < _len; counter = ++_i) {
          entry = _ref[counter];
          if (entry.id === id) {
            this._data.splice(counter, 1);
            data = this._dataMap[id];
            delete this._dataMap[id];
            if (clearCache) {
              this._invalidateCache();
            }
            return data;
          }
        }
      };

      Model.prototype.clear = function() {

        /*
        			Removes all cached elements
         */
        this._data.length = 0;
        this._dataMap = {};
        return this._invalidateCache();
      };

      Model.prototype._invalidateCache = function() {
        return this._filterCache = {};
      };

      Model.prototype.get = function(query) {

        /*
        			Calls, caches and returns filtered results
         */
        var hash;
        hash = query.hashCode();
        if (!angular.isDefined(this._filterCache[hash])) {
          this._filterCache[hash] = query.exec(this._data);
        }
        return this._filterCache[hash];
      };

      Model.prototype.size = function() {

        /*
        			Return the number of all stored entries
         */
        return this._data.length;
      };

      return Model;

    })();
    return Model;
  });

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  angular.module('OC').factory('Notification', function() {
    return OC.Notification;
  });

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  angular.module('OC').factory('_NotImplementedError', function() {
    var NotImplementedError;
    NotImplementedError = (function() {
      function NotImplementedError(_msg) {
        this._msg = _msg;
      }

      NotImplementedError.prototype.getMessage = function() {
        return this._msg;
      };

      return NotImplementedError;

    })();
    return NotImplementedError;
  });

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  angular.module('OC').factory('_Publisher', function() {
    var Publisher;
    Publisher = (function() {
      function Publisher() {
        this._subscriptions = {};
      }

      Publisher.prototype.subscribeObjectTo = function(object, name) {
        var _base;
        (_base = this._subscriptions)[name] || (_base[name] = []);
        return this._subscriptions[name].push(object);
      };

      Publisher.prototype.publishDataTo = function(data, name) {
        var subscriber, _i, _len, _ref, _results;
        _ref = this._subscriptions[name] || [];
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          subscriber = _ref[_i];
          _results.push(subscriber.handle(data));
        }
        return _results;
      };

      return Publisher;

    })();
    return Publisher;
  });

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  angular.module('OC').factory('_BiggerThanQuery', [
    '_Query', function(_Query) {
      var BiggerThanQuery;
      BiggerThanQuery = (function(_super) {
        __extends(BiggerThanQuery, _super);

        function BiggerThanQuery(_field, _value) {
          var name;
          this._field = _field;
          this._value = _value;
          name = 'biggerthan';
          BiggerThanQuery.__super__.constructor.call(this, name, [this._field, this._value]);
        }

        BiggerThanQuery.prototype.exec = function(data) {
          var entry, filtered, _i, _len;
          filtered = [];
          for (_i = 0, _len = data.length; _i < _len; _i++) {
            entry = data[_i];
            if (entry[this._field] > this._value) {
              filtered.push(entry);
            }
          }
          return filtered;
        };

        return BiggerThanQuery;

      })(_Query);
      return BiggerThanQuery;
    }
  ]);

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  angular.module('OC').factory('_BiggerThanEqualQuery', [
    '_Query', function(_Query) {
      var BiggerThanEqualQuery;
      BiggerThanEqualQuery = (function(_super) {
        __extends(BiggerThanEqualQuery, _super);

        function BiggerThanEqualQuery(_field, _value) {
          var name;
          this._field = _field;
          this._value = _value;
          name = 'biggerthanequal';
          BiggerThanEqualQuery.__super__.constructor.call(this, name, [this._field, this._value]);
        }

        BiggerThanEqualQuery.prototype.exec = function(data) {
          var entry, filtered, _i, _len;
          filtered = [];
          for (_i = 0, _len = data.length; _i < _len; _i++) {
            entry = data[_i];
            if (entry[this._field] >= this._value) {
              filtered.push(entry);
            }
          }
          return filtered;
        };

        return BiggerThanEqualQuery;

      })(_Query);
      return BiggerThanEqualQuery;
    }
  ]);

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  angular.module('OC').factory('_ContainsQuery', [
    '_Query', function(_Query) {
      var ContainsQuery;
      ContainsQuery = (function(_super) {
        __extends(ContainsQuery, _super);

        function ContainsQuery(_field, _value, _caseInsensitive) {
          var name;
          this._field = _field;
          this._value = _value;
          this._caseInsensitive = _caseInsensitive != null ? _caseInsensitive : false;
          name = 'contains';
          ContainsQuery.__super__.constructor.call(this, name, [this._field, this._value, this._caseInsensitive]);
        }

        ContainsQuery.prototype.exec = function(data) {
          var entry, field, filtered, _i, _len;
          filtered = [];
          if (this._caseInsensitive) {
            this._value = this._value.toLowerCase();
          }
          for (_i = 0, _len = data.length; _i < _len; _i++) {
            entry = data[_i];
            if (this._caseInsensitive) {
              field = entry[this._field].toLowerCase();
            } else {
              field = entry[this._field];
            }
            if (field.indexOf(this._value) !== -1) {
              filtered.push(entry);
            }
          }
          return filtered;
        };

        return ContainsQuery;

      })(_Query);
      return ContainsQuery;
    }
  ]);

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  angular.module('OC').factory('_DoesNotContainQuery', [
    '_Query', function(_Query) {
      var DoesNotContainQuery;
      DoesNotContainQuery = (function(_super) {
        __extends(DoesNotContainQuery, _super);

        function DoesNotContainQuery(_field, _value, _caseInsensitive) {
          var name;
          this._field = _field;
          this._value = _value;
          this._caseInsensitive = _caseInsensitive != null ? _caseInsensitive : false;
          name = 'doesnotcontain';
          DoesNotContainQuery.__super__.constructor.call(this, name, [this._field, this._value, this._caseInsensitive]);
        }

        DoesNotContainQuery.prototype.exec = function(data) {
          var entry, field, filtered, _i, _len;
          filtered = [];
          if (this._caseInsensitive) {
            this._value = this._value.toLowerCase();
          }
          for (_i = 0, _len = data.length; _i < _len; _i++) {
            entry = data[_i];
            if (this._caseInsensitive) {
              field = entry[this._field].toLowerCase();
            } else {
              field = entry[this._field];
            }
            if (field.indexOf(this._value) === -1) {
              filtered.push(entry);
            }
          }
          return filtered;
        };

        return DoesNotContainQuery;

      })(_Query);
      return DoesNotContainQuery;
    }
  ]);

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  angular.module('OC').factory('_EqualQuery', [
    '_Query', function(_Query) {
      var EqualQuery;
      EqualQuery = (function(_super) {
        __extends(EqualQuery, _super);

        function EqualQuery(_field, _value, _caseInsensitive) {
          var name;
          this._field = _field;
          this._value = _value;
          this._caseInsensitive = _caseInsensitive != null ? _caseInsensitive : false;
          name = 'equal';
          EqualQuery.__super__.constructor.call(this, name, [this._field, this._value, this._caseInsensitive]);
        }

        EqualQuery.prototype.exec = function(data) {
          var entry, equal, field, _i, _len;
          equal = [];
          if (this._caseInsensitive) {
            this._value = this._value.toLowerCase();
          }
          for (_i = 0, _len = data.length; _i < _len; _i++) {
            entry = data[_i];
            if (this._caseInsensitive) {
              field = entry[this._field].toLowerCase();
            } else {
              field = entry[this._field];
            }
            if (field === this._value) {
              equal.push(entry);
            }
          }
          return equal;
        };

        return EqualQuery;

      })(_Query);
      return EqualQuery;
    }
  ]);

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  angular.module('OC').factory('_LessThanQuery', [
    '_Query', function(_Query) {
      var LessThanQuery;
      LessThanQuery = (function(_super) {
        __extends(LessThanQuery, _super);

        function LessThanQuery(_field, _value) {
          var name;
          this._field = _field;
          this._value = _value;
          name = 'lessthan';
          LessThanQuery.__super__.constructor.call(this, name, [this._field, this._value]);
        }

        LessThanQuery.prototype.exec = function(data) {
          var entry, filtered, _i, _len;
          filtered = [];
          for (_i = 0, _len = data.length; _i < _len; _i++) {
            entry = data[_i];
            if (entry[this._field] < this._value) {
              filtered.push(entry);
            }
          }
          return filtered;
        };

        return LessThanQuery;

      })(_Query);
      return LessThanQuery;
    }
  ]);

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  angular.module('OC').factory('_LessThanEqualQuery', [
    '_Query', function(_Query) {
      var LessThanEqualQuery;
      LessThanEqualQuery = (function(_super) {
        __extends(LessThanEqualQuery, _super);

        function LessThanEqualQuery(_field, _value) {
          var name;
          this._field = _field;
          this._value = _value;
          name = 'lessthanequal';
          LessThanEqualQuery.__super__.constructor.call(this, name, [this._field, this._value]);
        }

        LessThanEqualQuery.prototype.exec = function(data) {
          var entry, filtered, _i, _len;
          filtered = [];
          for (_i = 0, _len = data.length; _i < _len; _i++) {
            entry = data[_i];
            if (entry[this._field] <= this._value) {
              filtered.push(entry);
            }
          }
          return filtered;
        };

        return LessThanEqualQuery;

      })(_Query);
      return LessThanEqualQuery;
    }
  ]);

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  angular.module('OC').factory('_MaximumQuery', [
    '_Query', function(_Query) {
      var MaximumQuery;
      MaximumQuery = (function(_super) {
        __extends(MaximumQuery, _super);

        function MaximumQuery(_field) {
          var name;
          this._field = _field;
          name = 'maximum';
          MaximumQuery.__super__.constructor.call(this, name, [this._field]);
        }

        MaximumQuery.prototype.exec = function(data) {
          var entry, maximum, _i, _len;
          maximum = void 0;
          for (_i = 0, _len = data.length; _i < _len; _i++) {
            entry = data[_i];
            if (angular.isUndefined(maximum) || entry[this._field] > maximum[this._field]) {
              maximum = entry;
            }
          }
          return maximum;
        };

        return MaximumQuery;

      })(_Query);
      return MaximumQuery;
    }
  ]);

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  angular.module('OC').factory('_MinimumQuery', [
    '_Query', function(_Query) {
      var MinimumQuery;
      MinimumQuery = (function(_super) {
        __extends(MinimumQuery, _super);

        function MinimumQuery(_field) {
          var name;
          this._field = _field;
          name = 'minimum';
          MinimumQuery.__super__.constructor.call(this, name, [this._field]);
        }

        MinimumQuery.prototype.exec = function(data) {
          var entry, minimum, _i, _len;
          minimum = void 0;
          for (_i = 0, _len = data.length; _i < _len; _i++) {
            entry = data[_i];
            if (angular.isUndefined(minimum) || entry[this._field] < minimum[this._field]) {
              minimum = entry;
            }
          }
          return minimum;
        };

        return MinimumQuery;

      })(_Query);
      return MinimumQuery;
    }
  ]);

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  angular.module('OC').factory('_Query', [
    '_NotImplementedError', function(_NotImplementedError) {
      var Query;
      Query = (function() {
        function Query(_name, _args) {
          this._name = _name;
          this._args = _args != null ? _args : [];
        }

        Query.prototype.exec = function(data) {
          throw new _NotImplementedError('Not implemented');
        };

        Query.prototype.hashCode = function(filter) {
          var arg, hash, _i, _len, _ref;
          hash = this._name;
          _ref = this._args;
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            arg = _ref[_i];
            if (angular.isString(arg)) {
              arg = arg.replace(/_/gi, '__');
            }
            hash += '_' + arg;
          }
          return hash;
        };

        return Query;

      })();
      return Query;
    }
  ]);

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  angular.module('OC').factory('_UnequalQuery', [
    '_Query', function(_Query) {
      var UnequalQuery;
      UnequalQuery = (function(_super) {
        __extends(UnequalQuery, _super);

        function UnequalQuery(_field, _value, _caseInsensitive) {
          var name;
          this._field = _field;
          this._value = _value;
          this._caseInsensitive = _caseInsensitive != null ? _caseInsensitive : false;
          name = 'unequal';
          UnequalQuery.__super__.constructor.call(this, name, [this._field, this._value, this._caseInsensitive]);
        }

        UnequalQuery.prototype.exec = function(data) {
          var entry, equal, field, _i, _len;
          equal = [];
          if (this._caseInsensitive) {
            this._value = this._value.toLowerCase();
          }
          for (_i = 0, _len = data.length; _i < _len; _i++) {
            entry = data[_i];
            if (this._caseInsensitive) {
              field = entry[this._field].toLowerCase();
            } else {
              field = entry[this._field];
            }
            if (field !== this._value) {
              equal.push(entry);
            }
          }
          return equal;
        };

        return UnequalQuery;

      })(_Query);
      return UnequalQuery;
    }
  ]);

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  angular.module('OC').factory('_Request', function() {
    var Request;
    Request = (function() {
      function Request(_$http, _publisher) {
        this._$http = _$http;
        this._publisher = _publisher;
        this._initialized = false;
        this._shelvedRequests = [];
        this._initialized = true;
        this._executeShelvedRequests();
        this._shelvedRequests = [];
      }

      Request.prototype.request = function(route, data) {
        var defaultConfig, defaultData, url;
        if (data == null) {
          data = {};
        }

        /*
        			Wrapper to do a normal request to the server. This needs to
        			be done to hook the publisher into the requests and to handle
        			requests, that come in before routes have been loaded
        
        			route: the routename data can contain the following
        			data.routeParams: object with parameters for the route
        			data.data: ajax data objec which is passed to PHP
        			data.onSuccess: callback for successful requests
        			data.onFailure: callback for failed requests
        			data.config: a config which should be passed to $http
         */
        defaultData = {
          routeParams: {},
          data: {},
          onSuccess: function() {},
          onFailure: function() {},
          config: {}
        };
        angular.extend(defaultData, data);
        if (!this._initialized) {
          this._shelveRequest(route, defaultData);
          return;
        }
        if(angular.isUndefined(OC.generateUrl)){
          OC.generateUrl = function(url, params) {
            var _build = function (text, vars) {
              return text.replace(/{([^{}]*)}/g,
                function (a, b) {
                  var r = vars[b];
                  return typeof r === 'string' || typeof r === 'number' ? r : a;
                }
                );
            };
            if (url.charAt(0) !== '/') {
              url = '/' + url;
            }
            return OC.webroot + '/index.php' + _build(url, params);
          }
        }


        url = OC.generateUrl(route, defaultData.routeParams);
        defaultConfig = {
          url: url,
          data: defaultData.data
        };
        angular.extend(defaultConfig, defaultData.config);
        if (defaultConfig.method === 'GET') {
          defaultConfig.params = defaultConfig.data;
        }
        return this._$http(defaultConfig).success((function(_this) {
          return function(data, status, headers, config) {
            var name, value, _ref;
            _ref = data.data;
            for (name in _ref) {
              value = _ref[name];
              _this._publisher.publishDataTo(value, name);
            }
            return defaultData.onSuccess(data, status, headers, config);
          };
        })(this)).error(function(data, status, headers, config) {
          return defaultData.onFailure(data, status, headers, config);
        });
      };

      Request.prototype.post = function(route, data) {
        if (data == null) {
          data = {};
        }

        /*
        			Request shortcut which sets the method to POST
         */
        data.config || (data.config = {});
        data.config.method = 'POST';
        return this.request(route, data);
      };

      Request.prototype.get = function(route, data) {
        if (data == null) {
          data = {};
        }

        /*
        			Request shortcut which sets the method to GET
         */
        data.config || (data.config = {});
        data.config.method = 'GET';
        return this.request(route, data);
      };

      Request.prototype.put = function(route, data) {
        if (data == null) {
          data = {};
        }

        /*
        			Request shortcut which sets the method to GET
         */
        data.config || (data.config = {});
        data.config.method = 'PUT';
        return this.request(route, data);
      };

      Request.prototype["delete"] = function(route, data) {
        if (data == null) {
          data = {};
        }

        /*
        			Request shortcut which sets the method to GET
         */
        data.config || (data.config = {});
        data.config.method = 'DELETE';
        return this.request(route, data);
      };

      Request.prototype._shelveRequest = function(route, data) {

        /*
        			Saves requests for later if the routes have not been loaded
         */
        var request;
        request = {
          route: route,
          data: data
        };
        return this._shelvedRequests.push(request);
      };

      Request.prototype._executeShelvedRequests = function() {

        /*
        			Run all saved requests that were done before routes were fully
        			loaded
         */
        var r, _i, _len, _ref, _results;
        _ref = this._shelvedRequests;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          r = _ref[_i];
          _results.push(this.request(r.route, r.data));
        }
        return _results;
      };

      return Request;

    })();
    return Request;
  });

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  angular.module('OC').factory('Router', function() {
    return OC.Router;
  });

}).call(this);

// Generated by CoffeeScript 1.7.1

/*

ownCloud - App Framework

@author Bernhard Posselt
@copyright 2012 Bernhard Posselt dev@bernhard-posselt.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU AFFERO GENERAL PUBLIC LICENSE
License as published by the Free Software Foundation; either
version 3 of the License, or any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU AFFERO GENERAL PUBLIC LICENSE for more details.

You should have received a copy of the GNU Affero General Public
License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
  angular.module('OC').factory('Utils', function() {
    return OC;
  });

}).call(this);

