
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: disc.h,v 1.11 2005/11/17 08:46:27 mschwerin Exp $
 *
 */

#ifndef HAVE_DISC_H
#define HAVE_DISC_H

#include "oxine.h"

typedef enum {
    DISC_NO_INFO,
    DISC_NO_DISC,
    DISC_AUDIO,
    DISC_DVD_VIDEO,
    DISC_DVD_AUDIO,
    DISC_VCD,
    DISC_SVCD,
    DISC_DATA
} disc_type_t;

int disc_is_mounted (const char *mountpoint);

int disc_mount (const char *mountpoint);
int disc_umount (const char *mountpoint);

int disc_close (const char *mountpoint);
int disc_eject (const char *mountpoint);

int disc_is_in (const char *device);
disc_type_t disc_get_type (const char *device, const char *mountpoint);

void disc_autoscan_load (playlist_t * playlist, const char *mrl);
void disc_autoscan_read (filelist_t * filelist);

#ifdef HAVE_DISC_POLLING
void disc_start_polling (oxine_t * oxine);
void disc_stop_polling (oxine_t * oxine);
#endif

#endif
