#!/usr/bin/env python
# coding=utf-8

##    Qemulator - a qemu gui written in python and GTK/Glade.
##    Copyright (C) 2006  rainer haage
##
##    This program is free software; you can redistribute it and/or
##    modify it under the terms of the GNU General Public License
##    as published by the Free Software Foundation; either version 2
##    of the License, or (at your option) any later version.
##    
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##    
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
from os import path
import os
import sys
import pickle
import time
import gobject
import qemulator

try:
    import pygtk
    pygtk.require("2.0")
    
except:
      print "pygtk 2.0 is not installed"
try:
    import gtk
    import gtk.glade
    
except:
    print "gtk and/or glade is not installed - exiting..."
    sys.exit(1)
    
try:
    import gettext
    import locale
except:
    print "locale and/or gettext for language support not installed"
    sys.exit(1)        
    
current_path = os.path.realpath(__file__)
basedir = os.path.dirname(os.path.realpath(__file__))
if not os.path.exists(os.path.join(basedir, "main.py")):
    if os.path.exists(os.path.join(os.getcwd(), "main.py")):
        basedir = os.getcwd()
sys.path.insert(0, basedir)   

basedir = basedir.replace ( '/bin', '' ) 
basedir = basedir.replace ( '/lib/qemulator', '' )

APP = 'Qemulator'
#DIR = 'locale'
DIR = basedir + '/share/locale'
#print "DIR: " + DIR
locale.setlocale(locale.LC_ALL, '')
gettext.bindtextdomain(APP, DIR)
gettext.textdomain(APP)
_ = gettext.gettext

gtk.glade.bindtextdomain(APP, DIR)
gtk.glade.textdomain(APP)
tooltips = gtk.Tooltips() 

homedir = os.path.expanduser('~/.qemulator')
configdir = homedir + "/config"
libdir = basedir + "/lib/qemulator"
class Configuration:
    def __init__(self, callback_func=None):
        self.settings_autoshow = True
        self.settings_autohide = True
        self.settings_usetray = True
        self.settings_closetotray = False
        self.settings_controlmon_totray = False
        self.settings_controlmon_ministart = False
        self.settings_controlmon_ontop = False
        self.settings_controlmon_autostart = False
        self.default_iconsize = 32
        self.imagespath = ""
        self.callback_func = callback_func
        self.settings = qemulator.load_settings()
        print "loaded settings in config dialog"

        if self.settings.has_key("default_iconsize"):
            self.default_iconsize = self.settings["default_iconsize"]        
        
        if self.settings.has_key("imagespath"):
            self.imagespath = self.settings["imagespath"]
        
        if self.settings.has_key("settings_autoshow"):
            self.settings_autoshow = self.settings["settings_autoshow"]
        if self.settings.has_key("settings_autohide"):        
            self.settings_autohide = self.settings["settings_autohide"]
        
        if self.settings.has_key("usetray"):
            self.settings_usetray = self.settings["usetray"]
        if self.settings.has_key("closetotray"):        
            self.settings_closetotray = self.settings["closetotray"]
            
        if self.settings.has_key("controlmon_totray"):
            self.settings_controlmon_totray = self.settings["controlmon_totray"]
        if self.settings.has_key("controlmon_ministart"):        
            self.settings_controlmon_ministart = self.settings["controlmon_ministart"]
                  
        if self.settings.has_key("controlmon_ontop"):
            self.settings_controlmon_ontop = self.settings["controlmon_ontop"]
        
        if self.settings.has_key("controlmon_autostart"):        
            self.settings_controlmon_autostart = self.settings["controlmon_autostart"]
                
        self.gladefile = libdir + "/qemulator.glade"
        self.dialog_settings = gtk.glade.XML(self.gladefile, "dialog_settings", APP)
        
        self.treeview_cdromdrives = self.dialog_settings.get_widget("treeview_cdromdrives")
        self.treeview_qemupaths = self.dialog_settings.get_widget("treeview_qemupaths")
        
        self.filechooserbutton_imagesdir = self.dialog_settings.get_widget("filechooserbutton_imagesdir") 

        model = self.create_model_cdromdrives(self.settings["cdromdrives"])
        self.treeview_cdromdrives.set_model(model)
        self.add_columns_cdromdrives(self.treeview_cdromdrives, model) 

        qmodel = self.create_model_qemupaths(self.settings["qemuapps"])
        self.treeview_qemupaths.set_model(qmodel)
        self.add_columns_qemupaths(self.treeview_qemupaths, qmodel) 

        self.checkbutton_autoshow_settings = self.dialog_settings.get_widget("checkbutton_autoshow_settings")
        self.checkbutton_autohide_settings = self.dialog_settings.get_widget("checkbutton_autohide_settings")
        self.spinbutton_iconsize = self.dialog_settings.get_widget("spinbutton_iconsize")

        self.checkbutton_autoshow_settings.set_active(self.settings_autoshow)
        self.checkbutton_autohide_settings.set_active(self.settings_autohide)
        self.spinbutton_iconsize.set_value(int(self.default_iconsize))

        self.checkbutton_tray_enable = self.dialog_settings.get_widget("checkbutton_tray_enable")
        self.checkbutton_totray = self.dialog_settings.get_widget("checkbutton_totray")

        self.checkbutton_tray_enable.set_active(self.settings_usetray)
        self.checkbutton_totray.set_active(self.settings_closetotray)
        
        self.checkbutton_controlmon_totray = self.dialog_settings.get_widget("checkbutton_controlmon_totray")          
        self.checkbutton_controlmon_totray.set_active(self.settings_controlmon_totray)
        
        self.checkbutton_controlmon_minimized = self.dialog_settings.get_widget("checkbutton_controlmon_minimized")        
        self.checkbutton_controlmon_minimized.set_active(self.settings_controlmon_ministart)
        
        self.checkbutton_controlmon_autostart = self.dialog_settings.get_widget("checkbutton_controlmon_autostart")
        self.checkbutton_controlmon_autostart.set_active(self.settings_controlmon_autostart)
        
        self.checkbutton_controlmon_ontop = self.dialog_settings.get_widget("checkbutton_controlmon_ontop") 
        self.checkbutton_controlmon_ontop.set_active(self.settings_controlmon_ontop)
        
        self.treeview_settings_hotkeys = self.dialog_settings.get_widget("treeview_settings_hotkeys")        
        
        hmodel = self.create_model_hotkeys(self.settings["monitor_hotkeys"])
        self.treeview_settings_hotkeys.set_model(hmodel)
        self.add_columns_hotkeys(self.treeview_settings_hotkeys, hmodel) 
        
        self.entry_vncviewer = self.dialog_settings.get_widget("entry_vncviewer")
        if self.settings.has_key("helperapps_vncviewer"):
            self.entry_vncviewer.set_text(self.settings["helperapps_vncviewer"])
        
        self.entry_vncpassfile = self.dialog_settings.get_widget("entry_vncpassfile")    
        if self.settings.has_key("helperapps_vncpassfile"):
            self.entry_vncpassfile.set_text(self.settings["helperapps_vncpassfile"])
        
        self.entry_imageviewer = self.dialog_settings.get_widget("entry_imageviewer")   
        self.checkbutton_imageviewer_default = self.dialog_settings.get_widget("checkbutton_imageviewer_default")
        self.button_imageviewer = self.dialog_settings.get_widget("button_imageviewer")
        
        if self.settings.has_key("helperapps_imageviewer"):
            #print "imageviewer isset: " + str(self.settings["helperapps_imageviewer"])
            self.entry_imageviewer.set_text(self.settings["helperapps_imageviewer"])
            if self.settings["helperapps_imageviewer"] != '':
                #print "imageviewer hascontent: " + str(self.settings["helperapps_imageviewer"])
                self.checkbutton_imageviewer_default.set_active(False)
                self.entry_imageviewer.set_sensitive(True)
                self.button_imageviewer.set_sensitive(True)
            else:
                #print "imageviewer has no content"
                self.checkbutton_imageviewer_default.set_active(True)
                self.entry_imageviewer.set_sensitive(False)
                self.button_imageviewer.set_sensitive(False)
        else:
            #print "imageviewer is not set"
            self.checkbutton_imageviewer_default.set_active(True)
            self.entry_imageviewer.set_sensitive(False)
            self.button_imageviewer.set_sensitive(False)
                    
        #if self.settings.has_key("helperapps_imageviewer") and self.settings["helperapps_imageviewer"] != '':
        #    self.entry_imageviewer.set_text(self.settings["helperapps_imageviewer"])
                    
        self.entry_audioplayer = self.dialog_settings.get_widget("entry_audioplayer")  
        self.checkbutton_audioplayer_default = self.dialog_settings.get_widget("checkbutton_audioplayer_default")
        self.button_audioplayer = self.dialog_settings.get_widget("button_audioplayer")
          
        if self.settings.has_key("helperapps_audioplayer"):
            self.entry_audioplayer.set_text(self.settings["helperapps_audioplayer"])                        
                  
        if self.settings.has_key("helperapps_audioplayer"):
            #print "imageviewer isset: " + str(self.settings["helperapps_imageviewer"])
            self.entry_audioplayer.set_text(self.settings["helperapps_audioplayer"])
            if self.settings["helperapps_audioplayer"] != '':
                #print "imageviewer hascontent: " + str(self.settings["helperapps_imageviewer"])
                self.checkbutton_audioplayer_default.set_active(False)
                self.entry_audioplayer.set_sensitive(True)
                self.button_audioplayer.set_sensitive(True)
            else:
                #print "imageviewer has no content"
                self.checkbutton_audioplayer_default.set_active(True)
                self.entry_audioplayer.set_sensitive(False)
                self.button_audioplayer.set_sensitive(False)
        else:
            #print "imageviewer is not set"
            self.checkbutton_audioplayer_default.set_active(True)
            self.entry_audioplayer.set_sensitive(False)
            self.button_audioplayer.set_sensitive(False)
            
        self.settings['audioenvironment'] = 'Default'
                              
        dic = {"on_dialog_settings_response" : self.settings_response
            , "on_treeview_cdromdrives_cursor_changed" : self.settings_get_cdromdevice
            , "on_button_settings_add_cdevice_clicked" : self.settings_add_cdromdevice
            , "on_button_settings_rem_cdevice_clicked" : self.settings_remove_cdromdevice
            , "on_treeview_qemupaths_cursor_changed" : self.settings_get_qemupath
            , "on_button_settings_add_qemubin_clicked" : self.settings_add_qemupath
            , "on_button_settings_rem_qemubin_clicked" : self.settings_remove_qemupath
            , "on_treeview_settings_hotkeys_cursor_changed" : self.settings_get_hotkey
            , "on_button_settings_add_hotkey_clicked" : self.settings_add_hotkey
            , "on_button_settings_rem_hotkey_clicked" : self.settings_remove_hotkey            
            , "on_treeview_settings_hotkeys_drag_drop" : self.settings_sort_hotkeys
            , "on_button_vncviewer_clicked" : self.fileChooser_settings
            , "on_button_vncpasswd_clicked" : self.fileChooser_settings
            , "on_button_imageviewer_clicked" : self.fileChooser_settings
            , "on_button_audioplayer_clicked" : self.fileChooser_settings
            
            , "on_checkbutton_imageviewer_default_toggled" : self.checkbutton_imageviewer_default_toggled
            , "on_checkbutton_audioplayer_default_toggled" : self.checkbutton_audioplayer_default_toggled
        }
        self.dialog_settings.signal_autoconnect(dic)
    
        if self.imagespath != "":
            self.filechooserbutton_imagesdir.set_filename(self.imagespath)              
        else:
            self.filechooserbutton_imagesdir.set_filename("")      
        print "initial images path: " + self.imagespath
        
    def checkbutton_imageviewer_default_toggled(self, widget):
        state = widget.get_active()
        if state == True:
            self.entry_imageviewer.set_text('')
            self.entry_imageviewer.set_sensitive(False)
            self.button_imageviewer.set_sensitive(False)
        else:
            #self.entry_imageviewer.set_text('')
            self.entry_imageviewer.set_sensitive(True)  
            self.button_imageviewer.set_sensitive(True)   
            
    def checkbutton_audioplayer_default_toggled(self, widget):
        state = widget.get_active()
        if state == True:
            self.entry_audioplayer.set_text('')
            self.entry_audioplayer.set_sensitive(False)
            self.button_audioplayer.set_sensitive(False)
        else:
            #self.entry_imageviewer.set_text('')
            self.entry_audioplayer.set_sensitive(True)  
            self.button_audioplayer.set_sensitive(True)                    
        
    def fileChooser_settings(self, widget):
        print "file chooser launched from widget: " + str(widget.name)
        self.callerwidget = str(widget.name)
        self.filechooserdialog_settings = gtk.glade.XML(self.gladefile, "filechooserdialog_openimage", APP)         
        
        dic = {"on_filechooserdialog_openimage_response" : self.fileChooser_settings_response
        }
        self.filechooserdialog_settings.signal_autoconnect(dic) 
        
    def fileChooser_settings_response(self, widget, response, *entry):
        entrytext = str(widget.name)
        #print 'entry: ' + entrytext
        if response == gtk.RESPONSE_OK:
            file = widget.get_filename ()
            filename = str(file)
            if self.callerwidget == "button_vncviewer":
                self.entry_vncviewer.set_text(filename)
            elif self.callerwidget == "button_vncpasswd":
                self.entry_vncpassfile.set_text(filename)     
            elif self.callerwidget == "button_imageviewer":
                self.entry_imageviewer.set_text(filename) 
            elif self.callerwidget == "button_audioplayer":
                self.entry_audioplayer.set_text(filename) 
            else:
                pass
            self.callerwidget = None                                               
            widget.destroy ()
            return file      
        elif response == gtk.RESPONSE_CANCEL:
            widget.destroy ()   
            return None               
        return None
                
    #def settings_get_cdromdevice(self, widget, path, view_column):
    def settings_get_cdromdevice(self, widget, *event):
        model, iter = widget.get_selection().get_selected()
        row = model[iter]
        item = row[0]
        #print "widget: " + str(widget)
        self.settings_set_currentcdromdev(row)    
        
    def settings_set_currentcdromdev(self, device_list):
    
            nameinput = self.dialog_settings.get_widget("entry_settings_cdevicename")
            devinput = self.dialog_settings.get_widget("entry_settings_cdevicepath")
            
            nameinput.set_text(device_list[0])
            devinput.set_text(device_list[1])  

    def settings_add_cdromdevice(self, widget):
            #print "new cdromdevice"
            name = self.dialog_settings.get_widget("entry_settings_cdevicename").get_text()
            dev = self.dialog_settings.get_widget("entry_settings_cdevicepath").get_text()
            cdromlist = self.dialog_settings.get_widget("treeview_cdromdrives")
            model = cdromlist.get_model()
            model.append(row=(name, dev))
            #print "device: " + name + " : " + dev 
            try:
                self.settings["cdromdrives"].append((name, dev))
                #self.bookmarks.append((name, entry_path))
            except:
                self.settings["cdromdrives"] = [(name, dev)]
        
    def settings_remove_cdromdevice(self, widget):
        cdromlist = self.dialog_settings.get_widget("treeview_cdromdrives")
        name = self.dialog_settings.get_widget("entry_settings_cdevicename").get_text()
        dev = self.dialog_settings.get_widget("entry_settings_cdevicepath").get_text()
        #print 'name: ' + str(name)
        #print 'dev: ' + str(dev)
        entryindex = self.settings_search_cdromdevice(cdromlist, str(dev), "index")
        entry_name = name
        
        if entryindex != "None":
            model = cdromlist.get_model()
            selectIter = model.get_iter(entryindex)
            #print str(selectIter)
            #print "entryindex" + str(entryindex)
            model.remove(selectIter)
            self.settings["cdromdrives"].remove((name, dev))
            self.dialog_settings.get_widget("entry_settings_cdevicename").set_text("")
            self.dialog_settings.get_widget("entry_settings_cdevicepath").set_text("")
        else:
            print "no enty " + str(name)  + " found"
        return str(entry_name) 
    
    def settings_search_cdromdevice(self, widget, searchstring, returnval):
        ct = 0
        outct = "None"
        bmmodel = widget.get_model()
        #print "bmmodel: " + str(bmmodel)
        for row in bmmodel:
            if searchstring == row[1]:
                #print "brow: " + row[0]
                #print "bct: " + str(ct)
                if returnval == "index":
                    outct = ct
                else:
                    outct = row[0]
                
            ct = ct + 1      
        #print "result for cdrom device search: " + str(outct)            
        return outct               
    
## Functions for the settings dialog        
    def create_model_cdromdrives(self, data):
        store = gtk.ListStore(gobject.TYPE_STRING,
                          gobject.TYPE_STRING)
        for item in data:
            iter = store.append()
            itempath = item[0]
            itemname = item[1]
            #print itempath
            #print itemname
            store.set(iter, 0, item[0], 1, item[1])
        return store    

    def add_columns_cdromdrives(self, treeview, model):
    
        renderer = gtk.CellRendererToggle()
        column = gtk.TreeViewColumn(_('Name'), gtk.CellRendererText(), text=0)
        column2 = gtk.TreeViewColumn(_('Device'), gtk.CellRendererText(), text=1)
        treeview.append_column(column)   
        treeview.append_column(column2) 
        
    def create_model_qemupaths(self, data):
        store = gtk.ListStore(gobject.TYPE_STRING,
                          gobject.TYPE_STRING)
        for item in data:
            iter = store.append()
            itempath = item[0]
            itemname = item[1]
            #print itempath
            #print itemname
            store.set(iter, 0, item[0], 1, item[1])
        return store        
        
    def add_columns_qemupaths(self, treeview, model):
    
        renderer = gtk.CellRendererToggle()
        column = gtk.TreeViewColumn('Name', gtk.CellRendererText(), text=0)
        column2 = gtk.TreeViewColumn('Path', gtk.CellRendererText(), text=1)
        treeview.append_column(column)   
        treeview.append_column(column2)  
        
    def create_model_hotkeys(self, data):
        store = gtk.ListStore(gobject.TYPE_STRING)
        for item in data:
            iter = store.append()
            store.set(iter, 0, item)
        return store        
        
    def add_columns_hotkeys(self, treeview, model):
    
        renderer = gtk.CellRendererToggle()
        column = gtk.TreeViewColumn('Key combination', gtk.CellRendererText(), text=0)
        treeview.append_column(column)   

    def settings_get_qemupath1(self, widget, path, view_column):

        model = widget.get_model()
        row = model[path]
        item = row[0]
        #print "item: %s" %item
        self.settings_set_currentqemupath(row)
        
    def settings_get_qemupath(self, widget, *event):
        model, iter = widget.get_selection().get_selected()
        row = model[iter]
        item = row[0]
        self.settings_set_currentqemupath(row)          
        
    def settings_set_currentqemupath(self, device_list):
    
            nameinput = self.dialog_settings.get_widget("entry_settings_qemuname")
            devinput = self.dialog_settings.get_widget("entry_settings_qemupath")
            
            nameinput.set_text(device_list[0])
            devinput.set_text(device_list[1])  
    
    def settings_add_qemupath(self, widget):
            print "new qemupath"
            name = self.dialog_settings.get_widget("entry_settings_qemuname").get_text()
            path = self.dialog_settings.get_widget("entry_settings_qemupath").get_text()
            qemulist = self.dialog_settings.get_widget("treeview_qemupaths")
            model = qemulist.get_model()
            model.append(row=(name, path))
            print "qemuapp: " + name + " : " + path
            
            try:
                self.settings["qemuapps"].append((name, path))
            except:
                self.settings["qemuapps"] = [(name, path)]    
                
    def settings_remove_qemupath(self, widget):
        qemulist = self.dialog_settings.get_widget("treeview_qemupaths")
        name = self.dialog_settings.get_widget("entry_settings_qemuname").get_text()
        path = self.dialog_settings.get_widget("entry_settings_qemupath").get_text()
        #print 'name: ' + str(name)
        #print 'path: ' + str(path)
        entryindex = self.settings_search_cdromdevice(qemulist, str(path), "index")
        entry_name = name
        
        if entryindex != "None":
            model = qemulist.get_model()
            selectIter = model.get_iter(entryindex)
            #print str(selectIter)
            #print "entryindex" + str(entryindex)
            model.remove(selectIter)
            self.settings["qemuapps"].remove((name, path))
            self.dialog_settings.get_widget("entry_settings_qemuname").set_text("")
            self.dialog_settings.get_widget("entry_settings_qemupath").set_text("")
        else:
            print "no enty " + str(name)  + " found"
        return str(entry_name)
    
    def settings_get_hotkey(self, widget, *event):
        model, iter = widget.get_selection().get_selected()
        row = model[iter]
        item = row[0]
        self.settings_set_currenthotkey(row)    
    
    def settings_set_currenthotkey(self, keystring):
            input = self.dialog_settings.get_widget("entry_settings_hotkey")
            input.set_text(keystring[0])

    def settings_add_hotkey(self, widget):
            #print "new hotkey"
            name = self.dialog_settings.get_widget("entry_settings_hotkey").get_text()
            model = self.treeview_settings_hotkeys.get_model()
            model.append(row=(name,))
            #print "hotkey: " + name
            try:
                self.settings["monitor_hotkeys"].append(name)
                #self.bookmarks.append((name, entry_path))
            except:
                self.settings["monitor_hotkeys"] = [name]    
                
    def settings_remove_hotkey(self, widget):
        model, iter = self.treeview_settings_hotkeys.get_selection().get_selected()
        row = model[iter]
        item = row[0]
        name = str(item)
        print "model: " + str(model)
        #print "model0: " + str(model[0])
        print "row: " + str(row)
        print "iter: " + str(iter)
        #print "iter0: " + str(iter[0])
        print "item: " + str(item)
        #print "entryindex: " + str(entryindex)
        print "name: " + str(name)
        entry_name = name
        
        if iter != None:
            model.remove(iter)
            self.settings["monitor_hotkeys"].remove((name))
            self.dialog_settings.get_widget("entry_settings_hotkey").set_text("")
        else:
            print "no enty " + str(name)  + " found"
        return str(entry_name)   
    def settings_sort_hotkeys(self, *widget):
        print "reorder hotkeys" + str(widget)
        self.settings["monitor_hotkeys"] = []
        time.sleep(0.2)
        model = self.treeview_settings_hotkeys.get_model() 
        for row in model:
            name = row[0] 
            self.settings["monitor_hotkeys"].append(name)
            print "row: " + name  
        
    def settings_response(self, widget, response, *entry):
    
        if response == gtk.RESPONSE_OK or response == gtk.RESPONSE_APPLY:
            value_iconsize = self.spinbutton_iconsize.get_text()
            c = 0
            while value_iconsize == "" and c < 100:
                c = c + 1
            iconsize = int(value_iconsize)
            
            self.settings["settings_autoshow"] = self.checkbutton_autoshow_settings.get_active()
            self.settings["settings_autohide"] = self.checkbutton_autohide_settings.get_active()
            self.settings["default_iconsize"] = iconsize
            self.settings["usetray"] = self.checkbutton_tray_enable.get_active()
            self.settings["closetotray"] = self.checkbutton_totray.get_active()
            self.settings["controlmon_totray"] = self.checkbutton_controlmon_totray.get_active()
            self.settings["controlmon_ministart"] = self.checkbutton_controlmon_minimized.get_active()
            self.settings["controlmon_ontop"] = self.checkbutton_controlmon_ontop.get_active()
            self.settings["controlmon_autostart"] = self.checkbutton_controlmon_autostart.get_active()
            self.settings["helperapps_vncviewer"] = self.entry_vncviewer.get_text()
            self.settings["helperapps_vncpassfile"] = self.entry_vncpassfile.get_text()
            self.settings["helperapps_imageviewer"] = self.entry_imageviewer.get_text()
            self.settings["helperapps_audioplayer"] = self.entry_audioplayer.get_text()
            
            selpath = self.filechooserbutton_imagesdir.get_filename()
            defaultpath = path.abspath(selpath)
            self.settings["imagespath"] = defaultpath
            print "default images path: " + defaultpath

            storetofile(self.settings, "mainsettings")
            print "settings saved!"
            #self.refresh_ilist()
            time.sleep(0.2)
            if self.callback_func != None:
                self.callback_func()
        
        #print 'entrypath: ' + entry_path
        if response == gtk.RESPONSE_OK:
            print "settings stored"
            widget.destroy ()
                
        if response == gtk.RESPONSE_CANCEL:
            print "aborted!"        
            widget.destroy ()    

def storetofile(indata, filename):
    #print "storefile: " + filename
    dumpf = open(configdir + "/" + filename ,"w")        
    pickle.dump(indata, dumpf)
    dumpf.close()
## Universal Function to open the pickle'd configfiles        
def getfromfile(filename):
    try:
        abs_path = path.abspath(configdir + "/" + filename)
        #print "mainload opened file absolute path: " + abs_path
        dumpf = open( abs_path ,"r")       
        outdata = pickle.load(dumpf)
        dumpf.close()
        return outdata        
    except:
        outdata  = { }
        print "no config file"
        return outdata               