/*
 * QViewingModeDialog.cpp
 * $Id:
 *
 * Copyright (C) 2001 Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description : Simple dialog to manage view modes of the objects



// Qt
///////
#include <qdialog.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qlayout.h>


// Own
////////
#include "QViewingModeDialog.h"



    
QSceneTreeDrawable::ViewingMode QViewingModeDialog::getViewingMode(int x, int y, QSceneTreeDrawable::ViewingMode mode,
								   QWidget* parent, const char* name)
{
  QDialog qDialog(parent, name, true); 

  qDialog.resize( 132, 183 );
  qDialog.move(x, y);

  qDialog.setCaption( QObject::tr( "Select Viewing Mode" ) );
  QVBoxLayout *QViewingModeDialogLayout = new QVBoxLayout( &qDialog ); 
  QViewingModeDialogLayout->setSpacing( 6 );
  QViewingModeDialogLayout->setMargin( 6 );
  
  QButtonGroup *pqViewingMode = new QButtonGroup( &qDialog, "m_pqViewingMode" );
  pqViewingMode->setTitle( QObject::tr( "Viewing Mode" ) );
  pqViewingMode->setColumnLayout(0, Qt::Vertical );
  pqViewingMode->layout()->setSpacing( 0 );
  pqViewingMode->layout()->setMargin( 0 );

  QVBoxLayout* pqViewingModeLayout = new QVBoxLayout( pqViewingMode->layout() );
  pqViewingModeLayout->setAlignment( Qt::AlignTop );
  pqViewingModeLayout->setSpacing( 6 );
  pqViewingModeLayout->setMargin( 11 );

  QRadioButton *m_pqHidden = new QRadioButton( pqViewingMode, "m_pqHidden" );
  m_pqHidden->setText( QObject::tr( "Hidden" ) );
  pqViewingModeLayout->addWidget( m_pqHidden );
  QViewingModeDialogLayout->addWidget( pqViewingMode );

  QRadioButton *m_pqDisabled = new QRadioButton( pqViewingMode, "m_pqDisabled" );
  m_pqDisabled->setText( QObject::tr( "Disabled" ) );
  pqViewingModeLayout->addWidget( m_pqDisabled );

  QRadioButton *m_pqNormal = new QRadioButton( pqViewingMode, "m_pqNormal" );
  m_pqNormal->setText( QObject::tr( "Normal" ) );
  m_pqNormal->setChecked( TRUE );
  pqViewingModeLayout->addWidget( m_pqNormal );

  QRadioButton *m_pqHighlighted = new QRadioButton( pqViewingMode, "m_pqHighlighted" );
  m_pqHighlighted->setText( QObject::tr( "Highlighted" ) );
  pqViewingModeLayout->addWidget( m_pqHighlighted );

  QRadioButton *m_pqBoxed = new QRadioButton( pqViewingMode, "m_pqBoxd" );
  m_pqBoxed->setText( QObject::tr( "Boxed" ) );
  pqViewingModeLayout->addWidget( m_pqBoxed );

  QPushButton *pqClose = new QPushButton( &qDialog, "pqClose" );
  pqClose->setText( QObject::tr( "Close" ) );
  QViewingModeDialogLayout->addWidget( pqClose );

  // signals and slots connections
  QObject::connect( pqClose, SIGNAL( clicked() ), &qDialog, SLOT( accept() ) );

  switch (mode) {
  case QSceneTreeDrawable::normal:
    m_pqNormal->setChecked(true);
    break;
  case QSceneTreeDrawable::disabled:
    m_pqDisabled->setChecked(true);
    break;
  case QSceneTreeDrawable::highlighted:
    m_pqHighlighted->setChecked(true);
    break;
  case QSceneTreeDrawable::hidden:
    m_pqHidden->setChecked(true);
    break;
  case QSceneTreeDrawable::boxed:
    m_pqBoxed->setChecked(true);
    break;
  default:
    break;
  }

  qDialog.exec();

  if (m_pqNormal->isChecked())
    return QSceneTreeDrawable::normal;
  if (m_pqDisabled->isChecked())
    return QSceneTreeDrawable::disabled;
  if (m_pqHighlighted->isChecked())
    return QSceneTreeDrawable::highlighted;
  if (m_pqHidden->isChecked())
    return QSceneTreeDrawable::hidden;
  //if (m_pqHidden->isChecked())
    return QSceneTreeDrawable::boxed;
}
