/***************************************************************************
                          configfile.cpp  -   QGrid
                             -------------------
    begin                : Fri Jan 12 13:46:56 CET 2001
    copyright            : (C) 2001 by Johan Maes - ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "configfile.h"
#include <stdlib.h>
#include <fstream.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

configurationFile configFile;

configurationFile::configurationFile()
{
	optionList.setAutoDelete( TRUE );     // delete items when they are removed
	changed=FALSE;
}


int  configurationFile::processLine( QString &s,QString &OptN, QString &OptV)
{
  int pos,result;
  QString temp;
  temp=s.copy();  // uses deep copy while we will change s
  s=s.stripWhiteSpace(); // eliminate whitespaces at the beginning and the end
  if ((pos=s.find('#'))!=-1)
    {
    s.truncate(pos);
    temp=temp.right(temp.length()-pos);  // temp contains comment
    }
  else
    {
      temp="";
    }
  if ((pos=s.find('='))!=-1)
    {
      OptN=s.left(pos);
      OptN=OptN.stripWhiteSpace(); // eliminate whitespaces at the beginning and the end
      OptV=s.right(s.length()-pos-1);
      OptV=OptV.stripWhiteSpace(); // eliminate whitespaces at the beginning and the end
      result=1;
      //	  cout <<" detected " << OptN << "..  "<< OptV <<endl;   // for debug
    }
  else
    {
      OptN="";
      OptV="";
      result=0;
    }
  s=temp;
  return result;
}

configOption *configurationFile::optionCheck(QString OptN, QString OptV, bool toUpdate)
{
  configOption *co;
  for ( co=optionList.first(); co!= 0; co=optionList.next() )
    {
     if (OptN==co->name())
       {
	 if (toUpdate==TRUE)
	   {
	     co->setvalstr(OptV);
	   }
	 co->setstored(TRUE);
	 return co;
       }
    }
  return NULL;
} 

bool configurationFile::readFile (const char * name, const char *path)
{
#define BUFLEN 255
  char buff[BUFLEN+1];
  char ch;
  QFileInfo t;
  QDir ConfigDir;
  QString home;
  QString OptN;
  QString OptV;
  QString s;
  configOption *co;
  configFileName.setFile(name);

  if(path==NULL)
    {
      // try to find it in the local directory
      ConfigDir.setPath(getenv("PWD"));
      configFileName.setFile(ConfigDir,name);
      if (!configFileName.exists())
	{
	  //try to find it in the HOME directory
	  ConfigDir.setPath(getenv("HOME"));
	  configFileName.setFile(ConfigDir,name); 
	  if (!configFileName.exists())
	    {
	      //end of search
	      ConfigDir.setPath(getenv("HOME")); //revert to local directory
	      configFileName.setFile(ConfigDir,name);
	    }
	}
    }
  else
    {
      ConfigDir.setPath(path);
      configFileName.setFile(ConfigDir,name); 
    }
  if (!configFileName.exists())
    {
      //      debug("fn=%s",(const char *)configFileName.filePath());
      changed=TRUE;     
      ofstream inf(configFileName.filePath());
      inf.close(); //make one
      return TRUE;
    }
  ifstream inf(configFileName.filePath());
  do
    {
      // only accept registered values
      inf.get(buff,BUFLEN,'\n');
      inf.get(ch);     //get rid of the delimiter in the stream
      s=buff;
      if(processLine(s,OptN,OptV)==1)
	{
	  optionCheck (OptN,OptV,TRUE);
	}      	 
    }
  

  while(!inf.eof());
  for ( co=optionList.first(); co!= 0; co=optionList.next() )
    {
      if (co->IsStored()==FALSE)
	{
	  changed=TRUE; // we have registered options that are not in the configfile
	}
    }
  inf.close();
  return TRUE;  
}


bool configurationFile::readOption(const char * s,int &i)
{
  QString OptV;
  configOption *co;
  if ((co=optionCheck (s,OptV,FALSE))!=NULL)
    {
      i=co->getvali();
      return TRUE;
    }
  debug("%s - illegal read option",s);
  return FALSE;
}

bool configurationFile::readOption(const char * s,float &i)
{
  QString OptV;
  configOption *co;
  if ((co=optionCheck (s,OptV,FALSE))!=NULL)
    {
      i=co->getvalf();
      return TRUE;
    }
  debug("%s - illegal read option",s);
  return FALSE;
}


bool configurationFile::readOption(const char * s,bool &b)
{
  QString OptV;
  configOption *co;
  if ((co=optionCheck (s,OptV,FALSE))!=NULL)
    {
      b=(bool)co->getvalf();
      return TRUE;
    }
  debug("%s - illegal read option",s);
  return FALSE;
}









const char * configurationFile::readOption(const char * s)
{
  QString OptV;
  configOption *co;
  if ((co=optionCheck (s,OptV,FALSE))!=NULL)
    {
      return (co->getvalstr());      
    }
  debug("%s - illegal read option",s);
  return NULL;
}

bool  configurationFile::saveFile()
{
 
#define BUFLEN 255  
  char buff[BUFLEN+1];
  char ch;
  char *tn;
  QFileInfo tempname;     
  QString OptN;
  QString OptV;
  QString s;
  configOption *co;
  tempname.setFile(tn=tempnam(configDir.path(),"qsstv"));
  ifstream inf(configFileName.filePath());
  if (inf.fail())
    {
      return FALSE;
    }
  ofstream of(tempname.filePath());
  if (of.fail())
    {
      inf.close();
      return FALSE;
    }
  for ( co=optionList.first(); co!= 0; co=optionList.next() )
    {
     co->setstored(FALSE);
    }

 do
    {
      inf.get(buff,BUFLEN,'\n');
      inf.get(ch);     //get rid of the delimiter in the stream
      s=buff;
      if (inf.eof())
	{
	  break;
	}
      if (processLine(s,OptN,OptV)==0)
	{
	  of<< s << endl;   // simply store the comment
	}
      else
	{
	  if((co=optionCheck(OptN,OptV,FALSE))!=NULL)
	    {
	      of<< OptN << '=' << co->getvalstr() << ' ' << s <<endl;   // store valid option and comment
	    }
	  else
	    {
	      // invalid option
	      
	      of<< "#  *** invalid option *** " << OptN << '=' << OptV <<' '<<  s <<endl;
	    }

	}
     }
 while(1);
 // we will add option not stored yet
 
  for ( co=optionList.first(); co!= 0; co=optionList.next() )
    {
     if (!co->IsStored())
       {
	 of << co->name() <<"="<<co->getvalstr()<<endl;
       }
    }
  of.close();
  inf.close();

  ifstream infa(tempname.filePath());
  if (infa.fail())
    {
      return FALSE;
    }
  ofstream ofa(configFileName.filePath());
  if (ofa.fail())
    {
      infa.close();
      return FALSE;
    }
  do
    {
      infa.get(buff,BUFLEN,'\n');
      infa.get(ch);
      if (infa.eof())
	{
	  break;
	}
       ofa<< buff << endl;   // simply copy
    }
  while (1);

  infa.close();
  ofa.close();
  unlink(tn);
  free(tn);

  return TRUE;
}


void configurationFile::registerOption(const char *name, const char *def)
{
  optionList.append(new configOption(name,def));
}




void configurationFile::setOption(const char *s,const char *t)
{
 QString OptN;
 QString OptV;
 OptN=s;
 OptV=t;
 if(optionCheck (OptN,OptV,TRUE))
   {
     changed=TRUE;
   }
else
  {
  debug("%s - illegal set option",s);
  }     	 
}



void configurationFile::setOption(const char *s,int t)
{
 QString OptN;
 QString OptV;
 OptN=s; 
 OptV.setNum(t);
 if(optionCheck (OptN,OptV,TRUE))
   {
     changed=TRUE;
   }
 else
   {
     debug("%s - illegal set option",s);
   }     	       	 
}

void configurationFile::setOption(const char *s,float t)
{
 QString OptN;
 QString OptV;
 OptN=s; 
 OptV.setNum(t);
if(optionCheck (OptN,OptV,TRUE))
   {
     changed=TRUE;
   }
 else
   {
     debug("%s - illegal set option",s);
   }     	 
}




