/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2005-2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#include <stdio.h>
#include <stdlib.h>

#include <transport.h>
#include <qpx_mmc.h>
#include <common_functions.h>

#include "media_check_pioneer.h"

int pioneer_send_pi_scan_command(drive_info* drive, int lba, unsigned char nECC)
{
/*
CDB:
00000000  3B 02 E1 00 00 00 00 00 20 00                     ;...... .      

Data Sent:
00000000  FF 01 00 00 03 00 01 00 00 01 00 00 00 00 08 00   ...............
00000010  00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00   ................
*/
	int i;
	for (i=0; i<32; i++) drive->rd_buf[i]=0;
	drive->rd_buf[0] = 0xFF;
	drive->rd_buf[1] = 0x01;
	drive->rd_buf[4] = ((lba >> 16) & 0xFF) + 3;
	drive->rd_buf[5] = (lba >> 8) & 0xFF;
	drive->rd_buf[6] = (lba) & 0xFF;
//	drive->rd_buf[6] = 0x01;

	drive->rd_buf[9] =  (nECC >> 4 ) & 0xFF;
//	drive->rd_buf[10] = 0x80;
	drive->rd_buf[10] = (nECC << 4 ) & 0xFF;
	drive->rd_buf[14] = nECC;

//	printf("Pioneer SCAN PI CMD data:");
//	for (i=0; i<32; i++) {
//	    if (!(i%0x10)) printf("\n");
//	    printf(" 0x%02X",drive->rd_buf[i] & 0xFF);
//	}
	printf("\n");
	drive->cmd_clear();
	drive->cmd[0] = 0x3B;
	drive->cmd[1] = 0x02;
	drive->cmd[2] = 0xE1;
	drive->cmd[8] = 0x20;
	if ((drive->err=drive->cmd.transport(WRITE,drive->rd_buf,32))) {
		sperror ("pioneer_send_scan_pi_command",drive->err); return 1;
	}
	return 0;
}

int pioneer_read_error_info(drive_info* drive)
{
/*
CDB:
00000000  3C 02 E1 00 00 00 00 00 20 00                     <...... .      

Data Received:
00000000  04 00 00 00 00 IF IF 00 08 10 00 00 00 IE IE 00   ................
00000010  08 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00   ................
*/
	int i;
	for (i=0; i<32; i++) drive->rd_buf[i]=0;
	drive->cmd_clear();
	drive->cmd[0] = 0x3C;
	drive->cmd[1] = 0x02;
	drive->cmd[2] = 0xE1;
	drive->cmd[8] = 0x20;
	if ((drive->err=drive->cmd.transport(READ,drive->rd_buf,32))) {
		sperror ("pioneer_read_error_info",drive->err); return 1;
	}
	printf("Read error info RSP data:");
	for (i=0; i<32; i++) {
	    if (!(i%0x10)) printf("\n");
	    printf(" 0x%02X",drive->rd_buf[i] & 0xFF);
	}
	printf("\n");
	return 0;
}

int pioneer_pie_do_eight_ecc_blocks(drive_info* drive, int* lba, int* pie)
{
	const char interval = 8;
//	int err_pie_s=0,
	int err_pie=0;
//	int err_pif_s=0,
	int err_pif=0;
//	for (int i=0; i<8; i++){
//		pioneer_send_pi_scan_command(drive, *lba+16*i);
		pioneer_send_pi_scan_command(drive, *lba, interval);
		pioneer_read_error_info(drive);
		err_pif = ((drive->rd_buf[5]  << 8) & 0xFF00) | (drive->rd_buf[6] & 0xFF);
		err_pie = ((drive->rd_buf[13] << 8) & 0xFF00) | (drive->rd_buf[14] & 0xFF);
//		err_pie_s += err_pie;
//		err_pif_s += err_pif;
//		printf("LBA: %06X, PIE: %5d, PIF: %5d\r", *lba+16*i, err_pie, err_pif);
		printf("LBA: %06X, PIE: %5d, PIF: %5d\n", *lba, err_pie, err_pif);
//	}
//	printf("LBA: %06X, PIE: %5d, PIF: %5d (8ECC PIE: %5d, 8ECC PIF: %5d)\n",*lba,err_pie,err_pif, err_pie_s, err_pif_s);
	*pie = err_pie - err_pif;
//	*pif = err_pie / 200;
//	*pif = err_pif;

	*lba+= 16*interval;
	return 0;
}

int pioneer_pif_do_one_ecc_block(drive_info* drive, int* lba, int* pif)
{
	const char interval = 8;
//	int err_pie_s=0,
	int err_pie=0;
//	int err_pif_s=0,
	int err_pif=0;
//	for (int i=0; i<2; i++){
//		pioneer_send_pi_scan_command(drive, lba+16*i);
		pioneer_send_pi_scan_command(drive, *lba, interval);
		pioneer_read_error_info(drive);
		err_pif = ((drive->rd_buf[5]  << 8) & 0xFF00) | (drive->rd_buf[6] & 0xFF);
		err_pie = ((drive->rd_buf[13] << 8) & 0xFF00) | (drive->rd_buf[14] & 0xFF);
//		err_pie_s += err_pie;
//		err_pif_s += err_pif;
//		printf("LBA: %06X, PIE: %5d, PIF: %5d\r", lba+16*i, err_pie, err_pif);
//	}
	printf("LBA: %06X, PIE: %5d, PIF: %5d\n",*lba,err_pie,err_pif);
//	*pie = err_pie - err_pif;
	*pif = err_pie / 100;

	*lba+= 16*interval;
	return 0;
}

int pioneer_dummy_start(drive_info* drive)
{
	printf("PIONEER media check: first try, you can see unexpected rezults!\n");
	drive->err = 0;
	return 0;
}

int pioneer_dummy(drive_info* drive)
{
	drive->err = 0;
	return 0;
}

scan_commands commands_list_pioneer = {
	NULL, NULL, NULL,
	NULL, NULL, NULL,
	pioneer_dummy_start,	pioneer_pie_do_eight_ecc_blocks,pioneer_dummy,
	pioneer_dummy_start,	pioneer_pif_do_one_ecc_block,	pioneer_dummy,
	NULL, NULL, NULL,
	NULL, NULL, NULL,
};

scan_commands commands_pioneer()  { return commands_list_pioneer; }
