#ifndef QPPDOPTIONITEM_H
#define	QPPDOPTIONITEM_H

#include "qppdbaseitem.h"

class QPPDOptionItem : public QPPDBaseItem
{
public:
	QPPDOptionItem(global_ppd_file_t *ppd, ppd_option_t *option, QListViewItem *parent, bool changeable = true);
	~QPPDOptionItem();

	void updateText();
	void markChoices(global_ppd_file_t *ppd);
	void updateChoices(global_ppd_file_t *ppd);
	void getCupsOptions(int& num_options, cups_option_t **options, bool incldef = false);
	void setupDict(QDict<QPPDBaseItem>& dict) const;
	void setCurrentChoice(int index);
	void setCurrentChoice(ppd_choice_t *ch);
	void updateConflict();

	virtual void paintText(QPainter *p, const QColorGroup& cg, int r);

public:
	ppd_option_t	*option_;
	ppd_choice_t	*currentchoice_;
	bool		changeable_;
};

#endif
