#ifndef QPPDWIDGET_H
#define	QPPDWIDGET_H

#include <qwidget.h>
#include <cups/ppd.h>
#include <cups/cups.h>
#include "globalppd.h"

class QPPDView;
class QPPDOptionView;

class QPPDWidget : public QWidget
{
public:
	QPPDWidget(QWidget *parent = 0, const char *name = 0);
	~QPPDWidget();

	void initialize(global_ppd_file_t *ppd, cups_dest_t *dest = 0);
	void markChoices(global_ppd_file_t *ppd);
	void updateChoices(global_ppd_file_t *ppd);
	void getCupsOptions(int& num_options, cups_option_t **options, bool incldef = false);
	void setAllowNonChangeable(bool on = true);
	bool allowNonChangeable() const;
	bool hasConflict();

private:
	QPPDView	*ppdview_;
	QPPDOptionView	*ppdoptview_;
};

#endif
