/*
 * Mike Glover
 * mpg4@duluoz.net
 *
 * Johan Ekenberg
 * johan@ekenberg.nu
 *
 * parse.h
 *
 */
#ifndef INCLUDE_QUOTATOOL_PARSE
#define INCLUDE_QUOTATOOL_PARSE 1

#include <config.h>

#include <time.h>

struct _argdata_t {
  char *id;
  char *qfile;
  short id_type;
  short silent;
  short noaction;

  char *block_hard;
  char *block_soft;
  char *block_grace;
  short block_reset;

  char *inode_hard;
  char *inode_soft;
  char *inode_grace;
  short inode_reset;
};
typedef struct _argdata_t argdata_t;


argdata_t *   parse_commandline   (int argc, char **argv);
time_t        parse_timespan      (time_t orig, char *string);
uint          parse_size          (uint orig, char *string);


#endif /* INCLUDE_QUOTATOOL_PARSE */
