;;; tc-bushu.el --- bushu henkan on T-Code

;; Copyright (C) 1996-2001 Kaoru Maeda, Yasushi Saito and Akira Kitajima.

;; Author: Kaoru Maeda <maeda@src.ricoh.co.jp>
;;	Yasushi Saito <yasushi@is.s.u-tokyo.ac.jp>
;;	Akira Kitajima <kitajima@isc.osakac.ac.jp>
;; Maintainer: Akira Kitajima
;; Created: 15 Sep 2001
;; Version: $Id: tc-bushu.el,v 2.36 2002/03/27 02:04:41 kitajima Exp $
;; Keywords: wp

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.

;;; Code:

(require 'tc)
(require 'tc-site)

(defcustom tcode-bushu-sequence-sensitive t
  "* nilǤʤ硢¤ˤäƹʸͥ٤Ѥ롣"
  :type 'boolean :group 'tcode)

(defcustom tcode-bushu-prioritized-chars nil
  "* ͥ٤Ʊͥ褵ʸΥꥹȡ
ʸǻꤹ롣"
  :type 'string :group 'tcode)

(defvar tcode-bushu-reverse-dictionary-name
  (tcode-get-file-path "bushu.rev")
  "հΥѥ̾")
(defconst tcode-bushu-reverse-buffer-name " *tcode: bushu reverse dictionary*")

(defvar tcode-bushu-expand-file-name
  (tcode-get-file-path "bushu.expand"))
(defconst tcode-bushu-expand-buffer-name " *tcode: bushu expand*")

(defvar tcode-bushu-index-file-name
  (tcode-get-file-path "bushu.index"))
(defconst tcode-bushu-index-buffer-name " *tcode: bushu index*")

(defvar tcode-bushu-functions
  '(tcode-bushu-complete-compose-set
    tcode-bushu-complete-diff-set
    tcode-bushu-strong-compose-set
    tcode-bushu-strong-diff-set
    tcode-bushu-common-set
    tcode-bushu-weak-compose-set
    tcode-bushu-weak-diff-set))

(defvar tcode-bushu-list nil)

(defvar tcode-bushu-use-cache t)

;;;
;;; Ѵδܥǡ
;;;

(defun tcode-bushu-search (str)
  "ߤΥХåեΡ STR ǻϤޤԤΤǽΤΤ򸫤Ĥ롣"
  (let ((min (point-min))
	(max (point-max))
	kouho)
    (or (catch 'found
	  (and (eobp)
	       (forward-line -1))
	  (while (< min max)
	    (cond ((string< (setq kouho
				  (buffer-substring (progn
						      (beginning-of-line)
						      (point))
						    (save-excursion
						      (end-of-line)
						      (point))))
			    str)
		   (forward-line 1)
		   (goto-char (ash (+ (setq min (point)) max) -1)))
		  ((string< str kouho)
		   (goto-char (ash (+ min (setq max (point))) -1)))
		  ((throw 'found t)))))
	(progn
	  (beginning-of-line)
	  (looking-at (regexp-quote str))))))

(defun tcode-bushu-parse-entry ()
  "ߤιԤʸΥꥹȤȤ֤
ݥȤϹ˰ư롣"
  (if (eobp)
      nil
    (tcode-string-to-char-list
	     (buffer-substring (point)
			       (progn (end-of-line) (point))))))

(defun tcode-bushu-for-char (char)
  "CHARΥꥹȤ֤"
  (let* ((str (char-to-string char))
	 (cache (get (intern-soft str tcode-stroke-table) 'bushu)))
    (or (and cache
	     tcode-bushu-use-cache
	     (tcode-string-to-char-list cache))
	(save-excursion
	  (set-buffer (get-buffer tcode-bushu-index-buffer-name))
	  (if (tcode-bushu-search str)
	      (progn
		(put (intern str tcode-stroke-table) 'bushu str)
		(list char))
	    (set-buffer (get-buffer tcode-bushu-expand-buffer-name))
	    (if (tcode-bushu-search str)
		(let ((bushu-list (cdr (tcode-bushu-parse-entry))))
		  (put (intern str tcode-stroke-table)
		       'bushu
		       (mapconcat 'char-to-string bushu-list ""))
		  bushu-list)
	      (put (intern str tcode-stroke-table) 'bushu str)
	      (list char)))))))

(defun tcode-count (elt list)
  "LISTELTο֤"
  (length (delq nil
		(mapcar (lambda (e)
			  (if (eq e elt)
			      e))
			list))))

(defun tcode-bushu-included-char-list (bushu &optional n)
  "BUSHU  N İʾޤʸΥꥹȤ֤Nά N = 1 Ȥߤʤ"
  (let* ((str (char-to-string bushu))
	 (cache (get (intern-soft str tcode-stroke-table) 'index)))
    (or (and (null n)
	     cache
	     tcode-bushu-use-cache
	     (tcode-string-to-char-list cache))
	(save-excursion
	  (set-buffer (get-buffer tcode-bushu-index-buffer-name))
	  (if (tcode-bushu-search str)
	      (let ((char-list (tcode-bushu-parse-entry)))
		(if (and n (> n 1))
		    ;; count bushu
		    (delq nil
			  (mapcar
			   (lambda (l)
			     (if (>= (tcode-count bushu
						  (tcode-bushu-for-char l))
				     n)
				 l))
			   char-list))
		  (put (intern str tcode-stroke-table)
		       'index
		       (mapconcat 'char-to-string char-list ""))
		  char-list))
	    (list bushu))))))

(defun tcode-bushu-same-set-p (list1 list2)
  "LIST1LIST2Ʊ礫ɤɽҸ졣
ƱǤʣϡƱޤޤƤʤȤϤߤʤʤ"
  (if (and list1 list2)
      (catch 'done
	(let ((l1 (copy-sequence list1))
	      (l2 (copy-sequence list2)))
	  (while l1
	    (let* ((e (car l1))
		   (c1 (tcode-count e l1))
		   (c2 (tcode-count e l2)))
	      (if (/= c1 c2)
		  (throw 'done nil))
	      (setq l1 (delq e l1)
		    l2 (delq e l2))))
	  (null l2)))
    (and (null list1)
	 (null list2))))

(defun tcode-char-list-for-bushu (bushu-list)
  "BUSHU-LISTǹν롣"
  (let ((bushu (car bushu-list)))
    (delq nil
	  (mapcar
	   (lambda (kouho)
	     (if (tcode-bushu-same-set-p (tcode-bushu-for-char kouho)
					 bushu-list)
		 kouho))
	   (tcode-bushu-included-char-list bushu
					   (tcode-count bushu bushu-list))))))

(defun tcode-uniq (list)
  (let ((l (copy-sequence list))
	u)
    (while l
      (let ((e (car l)))
	(setq u (cons e u)
	      l (delq e l))))
    (reverse u)))

;;;
;;; Ѵѥǡκե
;;;

(defun tcode-bushu-add-to-index (char component)
  (save-excursion
    (set-buffer (get-buffer tcode-bushu-index-buffer-name))
    (mapcar (lambda (bushu)
	      (if (tcode-bushu-search (char-to-string bushu))
		  (unless (memq char (cdr (tcode-bushu-parse-entry)))
		    (insert char))
		(insert bushu char ?\n)))
	    (tcode-uniq component))))

(defun tcode-bushu-make-index ()
  (tcode-set-work-buffer tcode-bushu-expand-buffer-name
			 tcode-bushu-expand-file-name)
  (let ((coding-system (and (boundp 'buffer-file-coding-system)
			    buffer-file-coding-system))
	(noe (count-lines (point-min) (point-max)))
	(count 0))
    (save-excursion
      (set-buffer (get-buffer-create tcode-bushu-index-buffer-name))
      (erase-buffer)
      (or (not (boundp 'buffer-file-coding-system))
	  (set-buffer-file-coding-system coding-system)))
    (goto-char (point-min))
    (while (not (eobp))
      (message "κ(%d%%)..." (/ (* 100 count) noe))
      (let ((entry (tcode-bushu-parse-entry)))
	(setq count (1+ count))
	(if entry
	    (tcode-bushu-add-to-index (car entry) (cdr entry))))
      (forward-line 1))
    (tcode-save-buffer tcode-bushu-index-buffer-name
		       tcode-bushu-index-file-name t)
    (message "κ(100%%)...λ")))

(defun tcode-bushu-expand-add-entry (char component)
  (save-excursion
    (set-buffer (get-buffer tcode-bushu-expand-buffer-name))
    (if (not (tcode-bushu-search (char-to-string char)))
	(insert char (mapconcat 'char-to-string component "") ?\n)
      (end-of-line)
      (insert (mapconcat 'char-to-string component "")))))

(defun tcode-bushu-expand-char (char trace)
  (if (memq char tcode-bushu-list)
      (list char)
    (let ((str (char-to-string char)))
      (save-excursion
	(set-buffer (get-buffer tcode-bushu-expand-buffer-name))
	(tcode-bushu-search str)
	(let ((entry (tcode-bushu-parse-entry)))
	  (if (and entry (= char (car entry)))
	      ;; ǤŸѤ
	      (cdr entry)
	    ;; ŸϤޤ
	    (set-buffer (get-buffer tcode-bushu-reverse-buffer-name))
	    (if trace
		(tcode-bushu-search str)
	      (beginning-of-line))
	    (let ((entry (tcode-bushu-parse-entry)))
	      (if (and entry (= char (car entry)))
		  ;; ŸǤ
		  (let ((component
			 (apply 'nconc
				(mapcar
				 (lambda (bushu)
				   (if (memq bushu trace)
				       ;; ۴ĤƤ
				       (list ? bushu)
				     (tcode-bushu-expand-char
				      bushu
				      (cons bushu trace))))
				 (cdr entry)))))
		    (tcode-bushu-expand-add-entry char component)
		    component)
		;; ŸǤʤ = 
		(setq tcode-bushu-list (cons char tcode-bushu-list))
		(list char)))))))))

;;; obsolete
(defun tcode-bushu-expand-all ()
  "ʸˤĤơν롣"
  (tcode-set-work-buffer tcode-bushu-reverse-buffer-name
			 tcode-bushu-reverse-dictionary-name
			 t)
  (let ((bushu-expand-buf (get-buffer-create tcode-bushu-expand-buffer-name))
	(coding-system (and (boundp 'buffer-file-coding-system)
			    buffer-file-coding-system))
	(noe (count-lines (point-min) (point-max)))
	(count 0))
    (save-excursion
      (set-buffer bushu-expand-buf)
      (erase-buffer)
      (or (not (boundp 'buffer-file-coding-system))
	  (set-buffer-file-coding-system coding-system)))
    (goto-char (point-min))
    (setq tcode-bushu-list nil)
    (while (not (eobp))
      (message "Ÿ(%d%%)..." (/ (* 100 count) noe))
      (let ((entry (tcode-bushu-parse-entry)))
	(setq count (1+ count))
	(if entry
	    (tcode-bushu-expand-char (car entry) nil)))
      (forward-line 1))
    (tcode-save-buffer tcode-bushu-expand-buffer-name
		       tcode-bushu-expand-file-name t)
    (message "Ÿ(100%%)...λ")))

(defun tcode-bushu-load-dictionary (&optional force)
  "Ѵɤ߹ࡣ
Ǥɤ߹ޤƤϲ⤷ʤ
FORCEnilǤʤϺɤ߹ߤ롣"
  (interactive "P")
  (save-excursion
    ;; BEGIN obsolete (backward compatibility)
    (if (file-newer-than-file-p tcode-bushu-reverse-dictionary-name
 				tcode-bushu-expand-file-name)
 	(tcode-bushu-expand-all))
    ;; END obsolete (backward compatibility)
    (tcode-set-work-buffer tcode-bushu-expand-buffer-name
			   tcode-bushu-expand-file-name)
    (if (file-newer-than-file-p tcode-bushu-expand-file-name
				tcode-bushu-index-file-name)
	(tcode-bushu-make-index)
      (tcode-set-work-buffer tcode-bushu-index-buffer-name
			     tcode-bushu-index-file-name))))

;;; obsolete
(defun tcode-bushu-convert-dic-to-rev ()
  "ߤΥХåեˤdicǡrevѴ롣"
  (interactive)
  (let ((buf (get-buffer-create "*tcode: dic to rev*")))
    (save-excursion
      (set-buffer buf)
      (erase-buffer))
    (goto-char (point-min))
    (setq tcode-bushu-list nil)
    (message "Ѵ...")
    (while (not (eobp))
      (let ((entry (tcode-bushu-parse-entry)))
	(if entry
	    (save-excursion
	      (let ((str (mapconcat 'char-to-string
				    (list (car (cdr (cdr entry)))
					  (car entry)
					  (car (cdr entry)))
				    "")))
		(set-buffer buf)
		(tcode-bushu-search str)
		(insert str ?\n)))))
      (forward-line 1))
    (message "Ѵ...λ")
    (pop-to-buffer buf)))

;;;
;;; ѴѴܱ黻
;;;

(defun tcode-intersection (list1 list2)
  "LIST1LIST2ȤνѤ֤
ƱǤʣ϶̤롣
֤ͤˤǤ¤LIST1˴Ť"
  (let ((l1 (copy-sequence list1))
	(l2 (copy-sequence list2))
	intersection)
    (while (and l1 l2)
      (let* ((e (car l1))
	     (c1 (tcode-count e l1))
	     (c2 (tcode-count e l2))
	     (n (min c1 c2)))
	(if (> n 0)
	    (setq intersection (nconc intersection (make-list n e))))
	(setq l1 (delq e l1)
	      l2 (delq e l2))))
    intersection))

(defun tcode-complement-intersection (list1 list2)
  (if list2
      (let ((l1 (copy-sequence list1))
	    (l2 (copy-sequence list2))
	    ci)
	(while (and l1 l2)
	  (let* ((e (car l1))
		 (c1 (tcode-count e l1))
		 (c2 (tcode-count e l2))
		 (diff (abs (- c1 c2))))
	    (if (> diff 0)
		(setq ci (nconc ci (make-list diff e))))
	    (setq l1 (delq e l1)
		  l2 (delq e l2))))
	(nconc ci l1 l2))
    list1))

(defun tcode-subtract-set (list1 list2)
  (if list2
      (let ((l1 (copy-sequence list1))
	    (l2 (copy-sequence list2))
	    ci)
	(while (and l1 l2)
	  (let* ((e (car l1))
		 (c1 (tcode-count e l1))
		 (c2 (tcode-count e l2))
		 (diff (abs (- c1 c2))))
	    (if (> diff 0)
		(setq ci (nconc ci (make-list diff e))))
	    (setq l1 (delq e l1)
		  l2 (delq e l2))))
	(nconc l1 ci))
    list1))

(defun tcode-bushu-superset (bushu-list)
  "ʬ礬BUSHU-LISTǤν롣"
  (let* ((bl (copy-sequence bushu-list))
	 (bushu (car bl))
	 (superset (tcode-bushu-included-char-list bushu
						   (tcode-count bushu bl))))
    (while (and superset
		(setq bl (delq bushu bl)))
      (setq bushu (car bl)
	    superset (tcode-intersection
		      (tcode-bushu-included-char-list bushu
						      (tcode-count bushu bl))
		      superset)))
    superset))

(defun tcode-bushu-higher-priority-p (bushu1 bushu2 ref default)
  "REFȤơBUSHU1BUSHU2¤˶ᤤɤ
ȽǤǤʤäꡢɬפʤDEFAULT֤"
  (if tcode-bushu-sequence-sensitive
      (catch 'done
	(while (and ref bushu1 bushu2)
	  (let ((b1 (car bushu1))
		(b2 (car bushu2))
		(r (car ref)))
	    (cond ((and (= r b1)
			(/= r b2))
		   (throw 'done t))
		  ((and (/= r b1)
			(= r b2))
		   (throw 'done nil))
		  ((and (/= r b1)
			(/= r b2))
		   (throw 'done default)))
	    (setq bushu1 (cdr bushu1)
		  bushu2 (cdr bushu2)
		  ref (cdr ref))))
	default)
    default))

(defun tcode-bushu-priority-level (char)
  "CHARѿ`tcode-bushu-prioritized-chars'βܤˤ뤫֤
ʤ nil ֤"
  (if tcode-bushu-prioritized-chars
      (let* ((priority-list
	      (string-to-char-list tcode-bushu-prioritized-chars))
	     (char-list (memq char priority-list)))
	(if char-list
	    (- (length priority-list) (length char-list) -1)))))

(defun tcode-easier-stroke-p (s1 s2)
  (if (= (length s1) (length s2))
      ;; Ȥꤢʤθ
      ;; ۡݥǤ䤹ʤɹθ٤
      (let ((evfunc (lambda (a)
		      (let ((v (/ a 10)))
			(if (>= v 3)
			    1
			  (ash v 1))))))
	(> (apply '+ (mapcar evfunc s1))
	   (apply '+ (mapcar evfunc s2))))
    (< (length s1) (length s2))))

(defun tcode-bushu-less-p (char1 char2 &optional many)
  "CHAR1CHAR2ͥ٤⤤?
ͳѿBUSHU-LISTǻꤵ줿ꥹȤȤ롣
MANYnilξ硢Ʊͥ٤ǤϡBUSHU-LIST˴ޤޤʤ
οʤͥ褵롣
nilǤʤ¿ͥ褵롣"
  (let* ((bushu1 (tcode-bushu-for-char char1))
	 (bushu2 (tcode-bushu-for-char char2))
	 (i1 (tcode-intersection bushu1 bushu-list))
	 (i2 (tcode-intersection bushu2 bushu-list))
	 (l1 (- (length bushu1) (length i1)))
	 (l2 (- (length bushu2) (length i2))))
    (if (= (length i1) (length i2))
	(if (= l1 l2)
	    (let ((p1 (tcode-bushu-priority-level char1))
		  (p2 (tcode-bushu-priority-level char2)))
	      (cond (p1
		     (if p2
			 (< p1 p2)
		       t))
		    (p2
		     nil)
		    (t
		     (tcode-bushu-higher-priority-p
		      i1
		      i2
		      (tcode-intersection bushu-list (nconc bushu1 bushu2))
		      (let ((s1 (tcode-stroke-for-char
				 (char-to-string char1)))
			    (s2 (tcode-stroke-for-char
				 (char-to-string char2))))
			(cond ((and s1 s2)
			       (tcode-easier-stroke-p s1 s2))
			      (s1
			       t)
			      (s2
			       nil)
			      (t
			       (< char1 char2))))))))
	  (if many
	      (> l1 l2)
	    (< l1 l2)))
      (> (length i1) (length i2)))))

(defun tcode-bushu-complete-compose-set (char-list)
  (let ((bushu-list (apply 'nconc (mapcar 'tcode-bushu-for-char char-list))))
    (sort (tcode-subtract-set (tcode-char-list-for-bushu bushu-list)
			      char-list)
	  'tcode-bushu-less-against-seqence-p)))

(defun tcode-bushu-strong-compose-set (char-list)
  (let* ((bushu-list (apply 'nconc (mapcar 'tcode-bushu-for-char char-list)))
	 (r (tcode-bushu-superset bushu-list)))
    (catch 'not-found
      (mapcar (lambda (c)
		(unless (setq r (delq c r))
		  (throw 'not-found nil)))
	      char-list)
      (sort r 'tcode-bushu-less-p))))

(defun tcode-bushu-less-against-seqence-p (char1 char2)
  (let ((p1 (tcode-bushu-priority-level char1))
	(p2 (tcode-bushu-priority-level char2)))
    (cond (p1
	   (if p2
	       (< p1 p2)
	     t))
	  (p2
	   nil)
	  (t
	   (tcode-bushu-higher-priority-p (tcode-bushu-for-char char1)
					  (tcode-bushu-for-char char2)
					  bushu-list
					  (< char1 char2))))))

(defun tcode-bushu-all-compose-set (char-list &optional bushu-list)
  (let ((char (car char-list))
	(rest (cdr char-list)))
    (tcode-uniq
     (delq char
	   (apply 'nconc
		  (mapcar
		   (if rest
		       (lambda (bushu)
			 (tcode-bushu-all-compose-set rest
						      (cons bushu bushu-list)))
		     (lambda (bushu)
		       (tcode-bushu-superset (cons bushu bushu-list))))
		   (tcode-bushu-for-char char)))))))

(defun tcode-bushu-weak-compose-set (char-list)
  (let ((bushu-list (apply 'nconc (mapcar 'tcode-bushu-for-char char-list))))
    (sort (tcode-subtract-set (tcode-bushu-all-compose-set char-list)
			      (tcode-bushu-strong-compose-set char-list))
	  'tcode-bushu-less-p)))

(defun tcode-bushu-subset (bushu-list)
  (delq nil
	(mapcar
	 (lambda (char)
	   (let* ((bushu (tcode-bushu-for-char char)))
	     (unless (tcode-subtract-set bushu bushu-list)
	       char)))
	 (tcode-uniq (apply 'nconc
			    (mapcar 'tcode-bushu-included-char-list
				    (tcode-uniq bushu-list)))))))

(defun tcode-bushu-less-or-many-p (char1 char2)
  (tcode-bushu-less-p char1 char2 t))

(defun tcode-bushu-strong-diff-set (char-list &optional bushu-list complete)
  (let* ((char (car char-list))
	 (rest (cdr char-list))
	 (bushu (tcode-bushu-for-char char))
	 (i (if bushu-list
		(tcode-intersection bushu bushu-list)
	      bushu)))
    (if i
	(let* ((d1 (tcode-complement-intersection bushu i))
	       (d2 (tcode-complement-intersection bushu-list i)))
	  (if (or (and d1 d2)
		  (and (null d1)
		       (null d2)))
	      nil
	    (if rest
		(tcode-bushu-strong-diff-set rest (or d1 d2))
	      (let ((r (if complete
			   (tcode-char-list-for-bushu (or d1 d2))
			 (tcode-bushu-subset (or d1 d2)))))
		(catch 'not-found
		  (mapcar (lambda (c)
			    (unless (setq r (delq c r))
			      (throw 'not-found nil)))
			  char-list)
		  (sort r 'tcode-bushu-less-or-many-p))))))
      nil)))

(defun tcode-bushu-complete-diff-set (char-list)
  (tcode-bushu-strong-diff-set char-list nil t))

(defun tcode-bushu-all-diff-set (char-list &optional bushu-list common-list)
  (let* ((char (car char-list))
	 (rest (cdr char-list))
	 (bushu (tcode-bushu-for-char char))
	 (i (if bushu-list
		(tcode-intersection bushu bushu-list)
	      bushu)))
    (if i
	(let* ((d1 (tcode-complement-intersection bushu i))
	       (d2 (tcode-complement-intersection bushu-list i)))
	  (if rest
	      (delq char (tcode-bushu-all-diff-set rest
						   (nconc d1 d2)
						   (nconc i common-list)))
	    (tcode-uniq
	     (delq char (apply 'nconc
			       (mapcar
				(lambda (bushu)
				  (let ((cl (copy-sequence common-list)))
				    (tcode-bushu-subset
				     (append d1 d2 (delq bushu cl)))))
				common-list))))))
      nil)))

(defun tcode-bushu-weak-diff-set (char-list)
  (let ((bushu-list (tcode-bushu-for-char (car char-list))))
    (sort (tcode-subtract-set (tcode-bushu-all-diff-set char-list)
			      (tcode-bushu-strong-diff-set char-list))
	  'tcode-bushu-less-or-many-p)))

(defun tcode-bushu-common-set (char-list)
  (let ((bushu-list (tcode-bushu-for-char (car char-list))))
    (catch 'not-found
      (mapcar
       (lambda (c)
	 (unless (setq bushu-list
		       (tcode-intersection bushu-list
					   (tcode-bushu-for-char c)))
	   (throw 'not-found nil)))
       (cdr char-list))
      (let ((kouho (tcode-bushu-subset bushu-list)))
	(mapcar (lambda (c)
		  (if (memq c kouho)
		      (setq kouho (delq c kouho))))
		char-list)
	(sort kouho 'tcode-bushu-less-or-many-p)))))

;;;
;;; Ѵѥ󥿥ե
;;;

;;;###autoload
(defun tcode-bushu-compose (char1 char2)
  "CHAR1CHAR2롣"
  (tcode-bushu-load-dictionary)
  (let* ((str (concat (char-to-string char1)
		      (char-to-string char2)))
	 (cache (get (intern-soft str tcode-stroke-table) 'compose)))
    (or (and tcode-bushu-use-cache
	     cache)
	(let* ((char-list (list char1 char2))
	       (selected-char (catch 'found
				(mapcar
				 (lambda (function)
				   (let ((r (funcall function char-list)))
				     (if r
					 (throw 'found (car r)))))
				 tcode-bushu-functions)
				nil)))
	  (when selected-char
	    (put (intern str tcode-stroke-table) 'compose selected-char)
	    selected-char)))))

(defun tcode-bushu-compose-interactively (char-list)
  "CHAR-LISTȤŪ˹롣"
  (tcode-bushu-load-dictionary)
  (let ((kouho-list (apply 'nconc (mapcar (lambda (function)
					    (funcall function char-list))
					  tcode-bushu-functions))))
    (if kouho-list
	(tcode-bushu-select (tcode-uniq kouho-list) char-list)
      (ding))))

(defun tcode-compose-chars (&optional arg)
  "ݥȤ2ʸ롣"
  (interactive "*P")
  (tcode-bushu-init 2)
  (let ((context (tcode-get-context 2)))
    (if (/= (length context) 2)
	(ding)
      (let* ((prev-char (tcode-2-to-1 (tcode-string-to-char
				       (cdr (car (cdr context))))))
	     (prev-prev-char (tcode-2-to-1 (tcode-string-to-char
					    (cdr (car context)))))
	     (kanji (if (or arg current-prefix-arg)
			(progn
			  (setq prefix-arg nil
				current-prefix-arg nil)
			  (tcode-bushu-compose-interactively
			   (list prev-prev-char prev-char)))
		      (tcode-bushu-compose prev-prev-char prev-char)))
	     (p2 (car (car context))))
	(if kanji
	    (progn
	      (setq tcode-bushu-occurrence (1+ tcode-bushu-occurrence)
		    kanji (char-to-string kanji))
	      (delete-region p2 (point))
	      (tcode-insert kanji)
	      (and tcode-auto-help
		   (tcode-display-direct-stroke kanji)
		   (tcode-auto-remove-help-char))
	      (setq tcode-help-char kanji))
	  (ding))))))

(defun tcode-bushu-prompt (char-list kouho-list)
  (if (> (length kouho-list) 1)
      (message "%s => %c [%s]"
	       (mapconcat 'char-to-string char-list "")
	       (car kouho-list)
	       (mapconcat 'char-to-string (cdr kouho-list) ""))
    (message "%s => %c"
	     (mapconcat 'char-to-string char-list "")
	     (car kouho-list))))

(defun tcode-bushu-select (kouho-list char-list)
  (tcode-bushu-prompt char-list kouho-list)
  (let* ((char (read-char))
	 (nok (length kouho-list))
	 (current-kouho 0))
    (catch 'done
      (while (cond ((>= (tcode-get-key-address char) 0)
		    ;; 󥯥󥿥Ѵ
		    (let* ((next-chars (tcode-input-method char))
			   (kouho (tcode-bushu-compose-interactively
				   (append char-list
					   (mapcar 'tcode-2-to-1
						   next-chars)))))
		      (if kouho
			  (throw 'done kouho))
		      t))
		   ((= char ?\r)
		    ;; 
		    (throw 'done (nth current-kouho kouho-list)))
		   ((= char ?\C-?)
		    ;; 
		    (throw 'done nil))
		   ((or (= char ? )
			(= char ?>))
		    ;; 
		    (setq current-kouho (% (1+ current-kouho) nok)))
		   ((= char ?<)
		    ;; 
		    (setq current-kouho (1- (if (<= current-kouho 0)
						nok
					      current-kouho))))
		   (t
		    (ding)))
	(tcode-bushu-prompt char-list (nthcdr current-kouho kouho-list))
	(setq char (read-char))))))

;;;
;;; ַѴ
;;;

(defun tcode-bushu-start ()
  "ַѴϤ롣"
  (tcode-bushu-init 2)
  (unless (get-buffer tcode-bushu-index-buffer-name)
    (error "Bushu dictionary not ready."))
  (setq tcode-bushu-nest (cons (set-marker (make-marker) (point))
			       tcode-bushu-nest))
  (insert ""))

(defun tcode-bushu-end ()
  "¦Ѵλ롣"
  (when tcode-bushu-nest
    (let ((p (car tcode-bushu-nest)))
      (setq tcode-bushu-nest (cdr tcode-bushu-nest))
      (save-excursion
	(goto-char p)
	(when (looking-at "")
	  (delete-char 1))))))

(defun tcode-do-prefix-bushu (char)
  (if (or (null tcode-bushu-nest)
	  (null char))
      char
    (let* ((context (tcode-get-context 2))
	   (car-context (car context))
	   (cadr-context (car (cdr context)))
	   (prev-char (cdr cadr-context))
	   (prev-prev-char (cdr car-context))
	   (p (car car-context)))
      (if (and prev-char
	       prev-prev-char
	       (string= "" prev-prev-char)
	       (memq p (mapcar 'marker-position tcode-bushu-nest))
	       (not (string= prev-char "")))
	  (let ((kanji (tcode-bushu-compose (tcode-string-to-char prev-char)
					    char)))
	    (if kanji
		(progn
		  ;; Ѵ
		  (delete-region p (point))
		  (while (and tcode-bushu-nest
			      (/= p (marker-position (car tcode-bushu-nest))))
		    (tcode-bushu-end))
		  (tcode-bushu-end)
		  (setq tcode-bushu-occurrence (1+ tcode-bushu-occurrence)
			tcode-help-char char)
		  (and tcode-auto-help
		       (tcode-display-direct-stroke (char-to-string kanji)))
		  (tcode-do-prefix-bushu kanji))
	      (ding)
	      nil))
	;; Ѵκ
	char))))

;;;
;;; Ѵϥޥ
;;;

;;;###autoload
(defun tcode-bushu-henkan ()
  "Ѵ򳫻Ϥ롣"
  (interactive "*")
  (if tcode-use-postfix-bushu-as-default
      (tcode-compose-chars)
    (tcode-bushu-start)))

;;;###autoload
(defun tcode-bushu-henkan-interactively ()
  (interactive "*")
  (tcode-compose-chars t))

;;;###autoload
(defun tcode-bushu-another-henkan ()
  "`tcode-use-postfix-bushu-as-default' ȤϵդѴ򳫻Ϥ롣"
  (interactive "*")
  (if tcode-use-postfix-bushu-as-default
      (tcode-bushu-start)
    (tcode-compose-chars)))

;;;###autoload
(defun tcode-compose-char-interactively ()
  "ݥȤ1ʸȤŪ롣"
  (interactive "*")
  (tcode-bushu-init 2)
  (let ((context (tcode-get-context 1)))
    (if (/= (length context) 1)
	(ding)
      (let* ((prev-char (tcode-string-to-char (cdr (car context))))
	     (kanji (tcode-bushu-compose-interactively (list prev-char)))
	     (p2 (car (car context))))
	(if kanji
	    (progn
	      (setq tcode-bushu-occurrence (1+ tcode-bushu-occurrence)
		    kanji (char-to-string kanji))
	      (delete-region p2 (point))
	      (tcode-insert kanji)
	      (and tcode-auto-help
		   (tcode-display-direct-stroke kanji)
		   (tcode-auto-remove-help-char))
	      (setq tcode-help-char kanji))
	  (ding))))))

(provide 'tc-bushu)

;;; tc-bushu.el ends here
