#!/bin/sh
#
#	tardy - a tar post-processor
#	Copyright (C) 2003 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the g(un)zip functionality
#

umask 022

USER=${USER:-${LOGNAME:-`whoami`}}

work=/tmp/$$
PAGER=cat
export PAGER

here=`pwd`
if test $? -ne 0 ; then exit 1; fi

if test "$1" != "" ; then bin="$here/$1/bin"; else bin="$here/bin"; fi

pass()
{
	set +x
	echo PASSED 1>&2
	cd $here
	find $work -type d -user $USER -exec chmod u+w {} \;
	rm -rf $work
	exit 0
}
fail()
{
	set +x
	echo 'FAILED test of the g(un)zip functionality' 1>&2
	cd $here
	find $work -type d -user $USER -exec chmod u+w {} \;
	rm -rf $work
	exit 1
}
no_result()
{
	set +x
	echo 'NO RESULT for test of the g(un)zip functionality' 1>&2
	cd $here
	find $work -type d -user $USER -exec chmod u+w {} \;
	rm -rf $work
	exit 2
}
trap \"no_result\" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then no_result; fi
cd $work
if test $? -ne 0 ; then no_result; fi

#
# test the g(un)zip functionality
#
mkdir tst
if test $? -ne 0 ; then no_result; fi
echo xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx > tst/hello
if test $? -ne 0 ; then no_result; fi
cat tst/hello tst/hello > tst/hello2
if test $? -ne 0 ; then no_result; fi
cat tst/hello2 tst/hello2 > tst/hello3
if test $? -ne 0 ; then no_result; fi
cat tst/hello3 tst/hello3 > tst/hello4
if test $? -ne 0 ; then no_result; fi
cat tst/hello4 tst/hello4 > tst/hello5
if test $? -ne 0 ; then no_result; fi
cat tst/hello5 tst/hello5 > tst/hello6
if test $? -ne 0 ; then no_result; fi
cat tst/hello6 tst/hello6 > tst/hello7
if test $? -ne 0 ; then no_result; fi

tar cf tst.tar tst
if test $? -ne 0 ; then no_result; fi

$bin/tardy -gzip -rp=tst -p=tst2 tst.tar tst2.tar 
if test $? -ne 0 ; then fail; fi

$bin/tardy -gunzip tst2.tar tst3.tar 
if test $? -ne 0 ; then fail; fi

tar xf tst3.tar
if test $? -ne 0 ; then no_result; fi

cmp tst/hello7 tst2/hello7 || fail

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
