/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.HistogramWindow;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;

public class HistogramWindowPanel
extends JPanel
implements Printable,
ParaProfImageInterface {
    private ParaProfTrial ppTrial = null;
    private HistogramWindow window = null;
    private Vector data = null;
    private int xPanelSize;
    private int yPanelSize;
    private int[] bins;
    private int maxInAnyBin;
    private double maxValue;
    private double minValue;
    private int xOffset;
    private double binWidth;
    private int lastHeaderEndPosition = 0;

    public HistogramWindowPanel(ParaProfTrial paraProfTrial, HistogramWindow histogramWindow) {
        this.ppTrial = paraProfTrial;
        this.window = histogramWindow;
        this.setToolTipText("ParaProf histogram window!");
        this.setBackground(Color.white);
        this.xPanelSize = 600;
        this.yPanelSize = 400;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            if ((n -= this.xOffset) < 0 || n > 550) {
                return null;
            }
            int n2 = 550 / this.window.getNumBins();
            int n3 = n / n2;
            if (n3 < 0 || n3 > this.window.getNumBins() - 1) {
                return null;
            }
            String string = UtilFncs.getOutputString((int)this.window.units(), (double)(this.minValue + (double)n3 * this.binWidth), (int)5);
            String string2 = UtilFncs.getOutputString((int)this.window.units(), (double)(this.minValue + (double)(n3 + 1) * this.binWidth), (int)5);
            return "<html>Number of threads: " + this.bins[n3] + "<br>Range minimum: " + string + "<br>Range maximum: " + string2 + "</html>";
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.renderIt((Graphics2D)graphics, true, false, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            this.window.closeThisWindow();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.xPanelSize, this.yPanelSize);
            this.renderIt((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            new ParaProfErrorDialog(exception);
            return 1;
        }
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = this.getSize();
        boolean bl3 = false;
        if (bl2) {
            dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        } else {
            dimension.setSize(dimension.getWidth(), dimension.getHeight());
        }
        return dimension;
    }

    private void processData() throws ParaProfException {
        this.data = this.window.getData();
        this.maxValue = 0.0;
        this.minValue = 0.0;
        PPFunctionProfile pPFunctionProfile = null;
        int n = 0;
        boolean bl = true;
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            pPFunctionProfile = (PPFunctionProfile)enumeration.nextElement();
            ++n;
            double d = ParaProfUtils.getValue(pPFunctionProfile, this.window.getValueType(), false);
            if (bl) {
                this.minValue = d;
                bl = false;
            }
            this.maxValue = Math.max(this.maxValue, d);
            this.minValue = Math.min(this.minValue, d);
        }
        int n2 = this.window.getNumBins();
        double d = this.maxValue / (double)n2;
        this.binWidth = (this.maxValue - this.minValue) / (double)n2;
        this.bins = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.bins[n3] = 0;
            ++n3;
        }
        int n4 = 0;
        Enumeration enumeration2 = this.data.elements();
        block2: while (enumeration2.hasMoreElements()) {
            pPFunctionProfile = (PPFunctionProfile)enumeration2.nextElement();
            double d2 = ParaProfUtils.getValue(pPFunctionProfile, this.window.getValueType(), false);
            int n5 = 0;
            while (n5 < n2) {
                if (d2 <= this.minValue + this.binWidth * (double)(n5 + 1)) {
                    int n6 = n5;
                    this.bins[n6] = this.bins[n6] + 1;
                    ++n4;
                    continue block2;
                }
                ++n5;
            }
        }
        this.maxInAnyBin = 0;
        int n7 = 0;
        while (n7 < n2) {
            this.maxInAnyBin = Math.max(this.maxInAnyBin, this.bins[n7]);
            ++n7;
        }
    }

    public void renderIt(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) throws ParaProfException {
        Object object;
        this.processData();
        Font font = new Font(this.ppTrial.getPreferences().getParaProfFont(), this.ppTrial.getPreferences().getFontStyle(), this.ppTrial.getPreferences().getFontSize());
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int n = 0;
        if (bl3) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Insets insets = this.getInsets();
            String string = this.window.getHeaderString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "'\n'");
            while (stringTokenizer.hasMoreTokens()) {
                AttributedString attributedString = new AttributedString(stringTokenizer.nextToken());
                attributedString.addAttribute(TextAttribute.FONT, font);
                AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                object = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                float f = this.getSize().width - insets.left - insets.right;
                float f2 = insets.left;
                float f3 = insets.right;
                while (((LineBreakMeasurer)object).getPosition() < attributedCharacterIterator.getEndIndex()) {
                    TextLayout textLayout = ((LineBreakMeasurer)object).nextLayout(f);
                    textLayout.draw(graphics2D, f2, n += this.ppTrial.getPreferences().getBarSpacing());
                    f2 = insets.left;
                }
            }
            this.lastHeaderEndPosition = n;
            n += this.ppTrial.getPreferences().getBarSpacing();
        }
        int n2 = fontMetrics.getMaxAscent();
        int n3 = fontMetrics.getMaxDescent();
        int n4 = 550 / this.bins.length;
        graphics2D.setColor(Color.black);
        graphics2D.drawString("# Threads", 3, n + n2);
        n = n + n2 * 2 + 3;
        this.xOffset = 0;
        int n5 = 0;
        while (n5 < 10) {
            double d = (double)(10 - n5) * (double)this.maxInAnyBin / 10.0;
            object = UtilFncs.formatDouble((double)d, (int)4);
            int n6 = fontMetrics.stringWidth((String)object);
            this.xOffset = Math.max(this.xOffset, n6);
            ++n5;
        }
        this.xOffset += 25;
        int n7 = 0;
        while (n7 < 10) {
            double d = (double)(10 - n7) * (double)this.maxInAnyBin / 10.0;
            String string = UtilFncs.formatDouble((double)d, (int)4);
            int n8 = fontMetrics.stringWidth(string);
            graphics2D.drawLine(this.xOffset - 5, n + n7 * 40, this.xOffset, n + n7 * 40);
            graphics2D.drawString(string, 15, n + 5 + n7 * 40);
            ++n7;
        }
        int n9 = n4 / 10 / 2;
        int n10 = n4 * this.bins.length + this.xOffset + 4 - n9;
        graphics2D.drawLine(this.xOffset, 400 + n, this.xOffset, n);
        graphics2D.drawLine(this.xOffset, 400 + n, n10, 400 + n);
        int n11 = 1;
        while (n11 < this.bins.length + 1) {
            graphics2D.drawLine(this.xOffset + 4 + n11 * n4 - n9, 400 + n, this.xOffset + 4 + n11 * n4 - n9, 405 + n);
            ++n11;
        }
        String string = "Max Value = " + UtilFncs.getOutputString((int)this.window.units(), (double)this.maxValue, (int)5);
        int n12 = fontMetrics.stringWidth(string);
        graphics2D.drawString("Min Value = " + UtilFncs.getOutputString((int)this.window.units(), (double)this.minValue, (int)5), this.xOffset, 420 + n);
        graphics2D.drawString(string, n10 - n12, 420 + n);
        this.xPanelSize = n10 + 10;
        int n13 = 0;
        while (n13 < this.bins.length) {
            if (this.bins[n13] != 0) {
                double d = this.bins[n13];
                double d2 = d / (double)this.maxInAnyBin * 100.0;
                int n14 = (int)d2;
                if (n14 < 1) {
                    n14 = 1;
                }
                int n15 = n4 - n4 / 10;
                if (n4 < 10) {
                    n15 = n4;
                }
                if (n15 < 1) {
                    n15 = 1;
                }
                graphics2D.setColor(Color.red);
                graphics2D.fillRect(this.xOffset + 4 + n13 * n4, 400 + n - n14 * 4, n15, n14 * 4);
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(this.xOffset + 4 + n13 * n4, 400 + n - n14 * 4, n15, n14 * 4);
            }
            ++n13;
        }
        int n16 = Math.max(this.xPanelSize, this.lastHeaderEndPosition);
        int n17 = 420 + n;
        boolean bl4 = false;
        if (n16 != this.xPanelSize || n17 != this.yPanelSize) {
            this.xPanelSize = n16;
            this.yPanelSize = n17;
            this.revalidate();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize + 10, this.yPanelSize + 10);
    }
}

