/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.barchart;

import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.barchart.LegendModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class LegendPanel
extends JPanel {
    private LegendModel model;
    private int xPanelSize;
    private int yPanelSize;
    private int leftMargin = 3;
    private int rightMargin = 50;

    public LegendPanel(LegendModel legendModel) {
        this.model = legendModel;
        this.setBackground(Color.white);
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.draw((Graphics2D)graphics);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private void draw(Graphics2D graphics2D) {
        Object object;
        int n;
        int n2 = ParaProf.preferencesWindow.getFontSize();
        Font font = ParaProf.preferencesWindow.getFont();
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int n3 = n = fontMetrics.getHeight() - n2;
        int n4 = 0;
        while (n4 < this.model.getNumElements()) {
            String string = this.model.getLabel(n4);
            object = this.model.getColor(n4);
            graphics2D.setColor((Color)object);
            graphics2D.fillRect(this.leftMargin, n3, n2, n2);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(this.leftMargin, n3, n2, n2);
            graphics2D.drawString(string, this.leftMargin + n2 + 5, n3 + n2);
            n3 = n3 + n2 + n;
            ++n4;
        }
        if (n3 + n > this.yPanelSize) {
            this.xPanelSize = 0;
            int n5 = 0;
            while (n5 < this.model.getNumElements()) {
                object = this.model.getLabel(n5);
                this.xPanelSize = Math.max(this.xPanelSize, fontMetrics.stringWidth((String)object) + n2 + this.rightMargin);
                ++n5;
            }
            this.yPanelSize = n3 + n;
            this.setMinimumSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.setPreferredSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.revalidate();
        }
    }

    public void setModel(LegendModel legendModel) {
        this.model = legendModel;
    }
}

