[comment {-*- tcl -*- doctools manpage}]
[manpage_begin doctoc_fmt n 1.0]
[copyright {2003-2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Documentation tools}]
[titledesc {Specification of a simple Tcl Markup Language for Tables of Contents}]
[description]
[para]

This document specifies version 1 of a text format for tables of
contents. The name of this format is [term doctoc] and it provides all
the necessary commands to write a table of contents for a group of
documents.

It is intended to complement both the [term doctools] format for
writing documentation and the [term docidx] format for writing keyword
indices.

The formal specifications for these two formats can be found in the
companion documents [term doctools_fmt] and [term docidx_fmt].

A third companion document describes the package

[package doctools::toc], which provides commands for the processing of
text in [term doctoc] format.

[para]

Like for the formats [term doctools] and [term docidx] a generic
framework for the conversion of [term doctoc] to any number of
different output formats is provided.

This framework is provided by the package [package doctools::toc].

[para]

Anyone who wishes to write a toc formatting engine which plugs into
this framework has to read the document [term doctoc_api]. This is the
formal specification of the API between the framework and its engines.


[section {FORMAT SPECIFICATION}]


[subsection OVERVIEW]

While [term doctools] is similar to LaTeX [term doctoc] is only
superficially so. Input written in this format consists of a series of
markup commands, which may be separated by whitespace. Other text is
not allowed. The best comparison would be to imagine a LaTeX document
with all regular text removed.

[para]

The format used to mark commands is different from LaTeX however. All
text between matching pairs of [lb] and [rb] is a command, possibly
with arguments. Note that both brackets have to be on the same line
for a command to be recognized.

[subsection {GRAMMAR}]

The overall syntax of a table of contents is best captured in a formal
context-free grammar. Our notation for the grammar is EBNF. Strings
will stand for markup commands, however their arguments (if they have
any) are not part of the grammar. Our grammar contains lexical
elements as well.

[para]

First we specify the whitespace at the lexical level, which also
includes comments.

[para]
[example {
    COMMENT  ::= "comment"
    WHITE    ::= { '\n' | '\t' | ' ' | '\r' | COMMENT }
}]
[para]

Then we define rules for all the keywords. Here we introduce our
knowledge that all commands can be separated by whitespace, and also
that the inclusion of other files may happen essentially everywhere,
like the definition of document variables. The content of any included
file has to fit into the including file according to the location in
the grammar the inclusion is at.

[para]
[example {
    BEGIN     ::= "toc_begin"      WHITE DEFUN
    END       ::= "toc_end"        WHITE
    DIV_START ::= "division_start" WHITE DEFUN
    DIV_END   ::= "division_end"   WHITE DEFUN
    ITEM      ::= "item"           WHITE DEFUN

    INCLUDE  ::= "include"         WHITE
    VSET     ::= "vset"            WHITE

    DEFUN    ::= { INCLUDE | VSET }
}]
[para]

At last we can specify the whole table of contents.

[para]
[example {
    TOC      ::= DEFUN BEGIN CONTENTS END

    CONTENTS ::= (ITEMS | SECTIONS)
    ITEMS    ::= ITEM { ITEM }
    SECTIONS ::= SECTION { SECTION }
    SECTION  ::= DIV_START CONTENTS DIV_END
}]


[subsection COMMANDS]

Here we specify the commands used in the grammar. Some commands
specified here were not used in the grammar at all. The usage of these
commands is confined to the arguments of other commands.

[list_begin definitions]

[call [cmd comment] [arg text]]

This command declares that the argument [arg text] is a comment.


[call [cmd include] [arg filename]]

This command loads the contents of the file [arg filename] for
processing at its own place.


[call [cmd vset] [arg varname] [arg value] ]

This form of the command sets the document variable [arg varname] to
the specified [arg value]. It does not generate output. It is this
form the grammar is refering to.


[call [cmd vset] [arg varname]]

This form of the command returns the value associated with the
document variable [arg varname]. This form is not used by the grammar
and restricted to usage in the arguments of other commands.


[call [cmd lb]]

This command adds a left bracket to the output. Its usage is
restricted to the arguments of other commands.


[call [cmd rb]]

This command adds a right bracket to the output. Its usage is
restricted to the arguments of other commands.


[call [cmd toc_begin] [arg text] [arg title]]

This is the command to start a table of contents.

[nl]

The [arg text] argument provides a label for the whole group of
documents the index refers to. Often this is the name of the package
(or extension) the documents belong to.

The [arg title] argument provides the overall title text for the index.


[call [cmd toc_end]]

This is the command to close a table of contents.


[call [cmd division_start] [arg text] [opt [arg symfile]]]

This command opens a section in the table of contents.  Its
counterpart is [cmd division_end]. Together they allow a user to give
a table of contents additional structure.

[nl]

The title of the new section is provided by the argument [arg text].

[nl]

If the symbolic filename [arg symfile] is present then the section
title should link to the referenced document, if links are supported
by the output format.


[call [cmd division_end]]

This command closes a section. See [cmd division_start] above for the
detailed explanation.


[call [cmd item] [arg file] [arg text] [arg desc]]

This command adds an individual element to the table of contents. Each
such element refers to a document. The document is specified through
the symbolic name [arg file]. The [arg text] argument is used to label
the reference, whereas the [arg desc] provides a short descriptive
text of that document.

[nl]

The symbolic names are used to preserve the convertibility of this
format to any output format. The actual name of the file will be
inserted by the chosen formatting engine when converting the
input. This will be based on a mapping from symbolic to actual names
given to the engine.

[list_end]


[section NOTES]

It is possible to generate a table of contents in [term doctoc] format
automatically from a collection of documents in [term doctools]
format. All is needed is a special doctools formatting engine which
extracts the relevant metadata and some glue code to convert this data
to [term doctoc].

[para]

The application [cmd dtplite] is an example for this.


[section EXAMPLE]

The example is a table of contents for all manpages in the module 
[term base64].

[para]
[example {
[toc_begin Base64 {Table Of Contents}]
    [item base64.man   base64   {Procedures to encode and decode base64}
    [item uuencode.man uuencode {encode/decoding a binary file}]
    [item yencode.man  yencode  {encode/decoding a binary file}]
[toc_end]
}]


[see_also doctools::toc doctoc_api doctools_fmt doctoc_fmt]
[keywords doctoc toc {table of contents} keywords documentation]
[keywords markup {generic markup} TMML HTML nroff LaTeX]
[manpage_end]
