/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (tcpprep_opts.c)
 *  
 *  It has been AutoGen-ed  Thursday May 15, 2008 at 08:51:15 AM PDT
 *  From the definitions    tcpprep_opts.def
 *  and the template file   options
 *
 * Generated from AutoOpts 30:0:5 templates.
 */

/*
 *  This file was produced by an AutoOpts template.  AutoOpts is a
 *  copyrighted work.  This source file is not encumbered by AutoOpts
 *  licensing, but is provided under the licensing terms chosen by the
 *  tcpprep author or copyright holder.  AutoOpts is licensed under
 *  the terms of the LGPL.  The redistributable library (``libopts'') is
 *  licensed under the terms of either the LGPL or, at the users discretion,
 *  the BSD license.  See the AutoOpts and/or libopts sources for details.
 *
 * This source file is copyrighted and licensed under the following terms:
 *
 * tcpprep copyright 2000-2008 Aaron Turner - all rights reserved
 *
 * tcpprep is free software copyrighted by Aaron Turner.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name ``Aaron Turner'' nor the name of any other
 *    contributor may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 * 
 * tcpprep IS PROVIDED BY Aaron Turner ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL Aaron Turner OR ANY OTHER CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#include <limits.h>
#include <stdio.h>
#define OPTION_CODE_COMPILE 1
#include "tcpprep_opts.h"

#ifdef  __cplusplus
extern "C" {
#endif
tSCC zCopyright[] =
       "tcpprep copyright (c) 2000-2008 Aaron Turner, all rights reserved";
tSCC zCopyrightNotice[] =
       "tcpprep is free software copyrighted by Aaron Turner.\n\n\
Redistribution and use in source and binary forms, with or without\n\
modification, are permitted provided that the following conditions\n\
are met:\n\
1. Redistributions of source code must retain the above copyright\n\
   notice, this list of conditions and the following disclaimer.\n\
2. Redistributions in binary form must reproduce the above copyright\n\
   notice, this list of conditions and the following disclaimer in the\n\
   documentation and/or other materials provided with the distribution.\n\
3. Neither the name ``Aaron Turner'' nor the name of any other\n\
   contributor may be used to endorse or promote products derived\n\
   from this software without specific prior written permission.\n\n\
tcpprep IS PROVIDED BY Aaron Turner ``AS IS'' AND ANY EXPRESS\n\
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n\
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n\
ARE DISCLAIMED.  IN NO EVENT SHALL Aaron Turner OR ANY OTHER CONTRIBUTORS\n\
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\n\
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF\n\
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR\n\
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,\n\
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR\n\
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF\n\
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";
extern tUsageProc optionUsage;

/*
 *  global included definitions
 */
#include "defines.h"
#include "common.h"
#include "config.h"
#include "tcpprep.h"
#include <stdlib.h>
#include <string.h>
extern tcpprep_opt_t options;


#ifndef NULL
#  define NULL 0
#endif
#ifndef EXIT_SUCCESS
#  define  EXIT_SUCCESS 0
#endif
#ifndef EXIT_FAILURE
#  define  EXIT_FAILURE 1
#endif
/*
 *  Dbug option description:
 */
#ifdef DEBUG
tSCC    zDbugText[] =
        "Enable debugging output";
tSCC    zDbug_NAME[]               = "DBUG";
tSCC    zDbug_Name[]               = "dbug";
#define zDbugDefaultArg              ((char const*)0)
#define DBUG_FLAGS       (OPTST_DISABLED | OPTST_IMM \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

#else   /* disable Dbug */
#define VALUE_OPT_DBUG NO_EQUIVALENT
#define DBUG_FLAGS       (OPTST_OMITTED | OPTST_NO_INIT)
#define zDbugDefaultArg NULL
#define zDbugText       NULL
#define zDbug_NAME      NULL
#define zDbug_Name      NULL
#endif  /* DEBUG */

/*
 *  Auto option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zAutoText[] =
        "Auto-split mode";
tSCC    zAuto_NAME[]               = "AUTO";
tSCC    zAuto_Name[]               = "auto";
static const int
    aAutoCantList[] = {
    INDEX_OPT_CIDR,
    INDEX_OPT_PORT,
    INDEX_OPT_REGEX,
    INDEX_OPT_MAC, NO_EQUIVALENT };
#define AUTO_FLAGS       (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Cidr option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zCidrText[] =
        "CIDR-split mode";
tSCC    zCidr_NAME[]               = "CIDR";
tSCC    zCidr_Name[]               = "cidr";
static const int
    aCidrCantList[] = {
    INDEX_OPT_AUTO,
    INDEX_OPT_PORT,
    INDEX_OPT_REGEX,
    INDEX_OPT_MAC, NO_EQUIVALENT };
#define CIDR_FLAGS       (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Regex option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zRegexText[] =
        "Regex-split mode";
tSCC    zRegex_NAME[]              = "REGEX";
tSCC    zRegex_Name[]              = "regex";
static const int
    aRegexCantList[] = {
    INDEX_OPT_AUTO,
    INDEX_OPT_PORT,
    INDEX_OPT_CIDR,
    INDEX_OPT_MAC, NO_EQUIVALENT };
#define REGEX_FLAGS       (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Port option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zPortText[] =
        "Port-split mode";
tSCC    zPort_NAME[]               = "PORT";
tSCC    zPort_Name[]               = "port";
static const int
    aPortCantList[] = {
    INDEX_OPT_AUTO,
    INDEX_OPT_REGEX,
    INDEX_OPT_CIDR,
    INDEX_OPT_MAC, NO_EQUIVALENT };
#define PORT_FLAGS       (OPTST_DISABLED)

/*
 *  Mac option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zMacText[] =
        "Source MAC split mode";
tSCC    zMac_NAME[]                = "MAC";
tSCC    zMac_Name[]                = "mac";
static const int
    aMacCantList[] = {
    INDEX_OPT_AUTO,
    INDEX_OPT_REGEX,
    INDEX_OPT_CIDR,
    INDEX_OPT_PORT, NO_EQUIVALENT };
#define MAC_FLAGS       (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Reverse option description:
 */
tSCC    zReverseText[] =
        "Matches to be client instead of server";
tSCC    zReverse_NAME[]            = "REVERSE";
tSCC    zReverse_Name[]            = "reverse";
#define REVERSE_FLAGS       (OPTST_DISABLED)

/*
 *  Comment option description:
 */
tSCC    zCommentText[] =
        "Embeded cache file comment";
tSCC    zComment_NAME[]            = "COMMENT";
tSCC    zComment_Name[]            = "comment";
#define COMMENT_FLAGS       (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  No_Arg_Comment option description:
 */
tSCC    zNo_Arg_CommentText[] =
        "Do not embed any cache file comment";
tSCC    zNo_Arg_Comment_NAME[]     = "NO_ARG_COMMENT";
tSCC    zNo_Arg_Comment_Name[]     = "no-arg-comment";
#define NO_ARG_COMMENT_FLAGS       (OPTST_DISABLED)

/*
 *  Include option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zIncludeText[] =
        "Include only packets matching rule";
tSCC    zInclude_NAME[]            = "INCLUDE";
tSCC    zInclude_Name[]            = "include";
static const int
    aIncludeCantList[] = {
    INDEX_OPT_EXCLUDE, NO_EQUIVALENT };
#define INCLUDE_FLAGS       (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Exclude option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zExcludeText[] =
        "Exclude any packet matching this rule";
tSCC    zExclude_NAME[]            = "EXCLUDE";
tSCC    zExclude_Name[]            = "exclude";
static const int
    aExcludeCantList[] = {
    INDEX_OPT_INCLUDE, NO_EQUIVALENT };
#define EXCLUDE_FLAGS       (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Cachefile option description:
 */
tSCC    zCachefileText[] =
        "Output cache file";
tSCC    zCachefile_NAME[]          = "CACHEFILE";
tSCC    zCachefile_Name[]          = "cachefile";
#define CACHEFILE_FLAGS       (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Pcap option description:
 */
tSCC    zPcapText[] =
        "Input pcap file to process";
tSCC    zPcap_NAME[]               = "PCAP";
tSCC    zPcap_Name[]               = "pcap";
#define PCAP_FLAGS       (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Print_Comment option description:
 */
tSCC    zPrint_CommentText[] =
        "Print embedded comment in the specified cache file";
tSCC    zPrint_Comment_NAME[]      = "PRINT_COMMENT";
tSCC    zPrint_Comment_Name[]      = "print-comment";
#define PRINT_COMMENT_FLAGS       (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Print_Info option description:
 */
tSCC    zPrint_InfoText[] =
        "Print basic info from the specified cache file";
tSCC    zPrint_Info_NAME[]         = "PRINT_INFO";
tSCC    zPrint_Info_Name[]         = "print-info";
#define PRINT_INFO_FLAGS       (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Print_Stats option description:
 */
tSCC    zPrint_StatsText[] =
        "Print statistical information about the specified cache file";
tSCC    zPrint_Stats_NAME[]        = "PRINT_STATS";
tSCC    zPrint_Stats_Name[]        = "print-stats";
#define PRINT_STATS_FLAGS       (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Services option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zServicesText[] =
        "Load services file for server ports";
tSCC    zServices_NAME[]           = "SERVICES";
tSCC    zServices_Name[]           = "services";
static const int
    aServicesMustList[] = {
    INDEX_OPT_PORT, NO_EQUIVALENT };
#define SERVICES_FLAGS       (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Nonip option description:
 */
tSCC    zNonipText[] =
        "Send non-IP traffic out server interface";
tSCC    zNonip_NAME[]              = "NONIP";
tSCC    zNonip_Name[]              = "nonip";
#define NONIP_FLAGS       (OPTST_DISABLED)

/*
 *  Ratio option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zRatioText[] =
        "Ratio of client to server packets";
tSCC    zRatio_NAME[]              = "RATIO";
tSCC    zRatio_Name[]              = "ratio";
tSCC    zRatioDefaultArg[]           = "2.0";
static const int
    aRatioMustList[] = {
    INDEX_OPT_AUTO, NO_EQUIVALENT };
#define RATIO_FLAGS       (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Minmask option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zMinmaskText[] =
        "Minimum network mask length in auto mode";
tSCC    zMinmask_NAME[]            = "MINMASK";
tSCC    zMinmask_Name[]            = "minmask";
#define zMinmaskDefaultArg           ((char const*)30)
static const int
    aMinmaskMustList[] = {
    INDEX_OPT_AUTO, NO_EQUIVALENT };
#define MINMASK_FLAGS       (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/*
 *  Maxmask option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zMaxmaskText[] =
        "Maximum network mask length in auto mode";
tSCC    zMaxmask_NAME[]            = "MAXMASK";
tSCC    zMaxmask_Name[]            = "maxmask";
#define zMaxmaskDefaultArg           ((char const*)8)
static const int
    aMaxmaskMustList[] = {
    INDEX_OPT_AUTO, NO_EQUIVALENT };
#define MAXMASK_FLAGS       (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/*
 *  Verbose option description:
 */
#ifdef ENABLE_VERBOSE
tSCC    zVerboseText[] =
        "Print decoded packets via tcpdump to STDOUT";
tSCC    zVerbose_NAME[]            = "VERBOSE";
tSCC    zVerbose_Name[]            = "verbose";
#define VERBOSE_FLAGS       (OPTST_DISABLED | OPTST_IMM)

#else   /* disable Verbose */
#define VALUE_OPT_VERBOSE NO_EQUIVALENT
#define VERBOSE_FLAGS       (OPTST_OMITTED | OPTST_NO_INIT)
#define zVerboseText       NULL
#define zVerbose_NAME      NULL
#define zVerbose_Name      NULL
#endif  /* ENABLE_VERBOSE */

/*
 *  Decode option description with
 *  "Must also have options" and "Incompatible options":
 */
#ifdef ENABLE_VERBOSE
tSCC    zDecodeText[] =
        "Arguments passed to tcpdump decoder";
tSCC    zDecode_NAME[]             = "DECODE";
tSCC    zDecode_Name[]             = "decode";
static const int
    aDecodeMustList[] = {
    INDEX_OPT_VERBOSE, NO_EQUIVALENT };
#define DECODE_FLAGS       (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

#else   /* disable Decode */
#define VALUE_OPT_DECODE NO_EQUIVALENT
#define DECODE_FLAGS       (OPTST_OMITTED | OPTST_NO_INIT)
#define aDecodeMustList   NULL
#define zDecodeText       NULL
#define zDecode_NAME      NULL
#define zDecode_Name      NULL
#endif  /* ENABLE_VERBOSE */

/*
 *  Version option description:
 */
tSCC    zVersionText[] =
        "Print version information";
tSCC    zVersion_NAME[]            = "VERSION";
tSCC    zVersion_Name[]            = "version";
#define VERSION_FLAGS       (OPTST_DISABLED)

/*
 *  Less_Help option description:
 */
tSCC    zLess_HelpText[] =
        "Display less usage information and exit";
tSCC    zLess_Help_NAME[]          = "LESS_HELP";
tSCC    zLess_Help_Name[]          = "less-help";
#define LESS_HELP_FLAGS       (OPTST_DISABLED | OPTST_IMM)

/*
 *  Help/More_Help option descriptions:
 */
tSCC zHelpText[]       = "Display usage information and exit";
tSCC zHelp_Name[]      = "help";

tSCC zMore_HelpText[]  = "Extended usage information passed thru pager";
tSCC zMore_Help_Name[] = "more-help";

/*
 *  Save/Load_Opts option description:
 */
tSCC zSave_OptsText[]     = "Save the option state to a config file";
tSCC zSave_Opts_Name[]    = "save-opts";

tSCC zLoad_OptsText[]     = "Load options from a config file";
tSCC zLoad_Opts_NAME[]    = "LOAD_OPTS";

tSCC zNotLoad_Opts_Name[] = "no-load-opts";
tSCC zNotLoad_Opts_Pfx[]  = "no";
#define zLoad_Opts_Name   (zNotLoad_Opts_Name + 3)
/*
 *  Declare option callback procedures
 */
#ifdef DEBUG
  static tOptProc doOptDbug;
#else /* not DEBUG */
# define doOptDbug NULL
#endif /* def/not DEBUG */
extern tOptProc
    optionPagedUsage;
static tOptProc
    doOptAuto,           doOptCidr,           doOptComment,
    doOptExclude,        doOptInclude,        doOptLess_Help,
    doOptMac,            doOptMaxmask,        doOptMinmask,
    doOptNo_Arg_Comment, doOptNonip,          doOptPort,
    doOptRegex,          doOptServices,       doOptVersion,
    doUsageOpt;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Define the Tcpprep Option Descriptions.
 */
static tOptDesc optDesc[ OPTION_CT ] = {
  {  /* entry idx, value */ 0, VALUE_OPT_DBUG,
     /* equiv idx, value */ 0, VALUE_OPT_DBUG,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ DBUG_FLAGS, 0,
     /* last opt argumnt */ { zDbugDefaultArg },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptDbug,
     /* desc, NAME, name */ zDbugText, zDbug_NAME, zDbug_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 1, VALUE_OPT_AUTO,
     /* equiv idx, value */ 1, VALUE_OPT_AUTO,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ AUTO_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aAutoCantList,
     /* option proc      */ doOptAuto,
     /* desc, NAME, name */ zAutoText, zAuto_NAME, zAuto_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 2, VALUE_OPT_CIDR,
     /* equiv idx, value */ 2, VALUE_OPT_CIDR,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ CIDR_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aCidrCantList,
     /* option proc      */ doOptCidr,
     /* desc, NAME, name */ zCidrText, zCidr_NAME, zCidr_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 3, VALUE_OPT_REGEX,
     /* equiv idx, value */ 3, VALUE_OPT_REGEX,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ REGEX_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aRegexCantList,
     /* option proc      */ doOptRegex,
     /* desc, NAME, name */ zRegexText, zRegex_NAME, zRegex_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 4, VALUE_OPT_PORT,
     /* equiv idx, value */ 4, VALUE_OPT_PORT,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ PORT_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aPortCantList,
     /* option proc      */ doOptPort,
     /* desc, NAME, name */ zPortText, zPort_NAME, zPort_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 5, VALUE_OPT_MAC,
     /* equiv idx, value */ 5, VALUE_OPT_MAC,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ MAC_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aMacCantList,
     /* option proc      */ doOptMac,
     /* desc, NAME, name */ zMacText, zMac_NAME, zMac_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 6, VALUE_OPT_REVERSE,
     /* equiv idx, value */ 6, VALUE_OPT_REVERSE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ REVERSE_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zReverseText, zReverse_NAME, zReverse_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 7, VALUE_OPT_COMMENT,
     /* equiv idx, value */ 7, VALUE_OPT_COMMENT,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ COMMENT_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptComment,
     /* desc, NAME, name */ zCommentText, zComment_NAME, zComment_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 8, VALUE_OPT_NO_ARG_COMMENT,
     /* equiv idx, value */ 8, VALUE_OPT_NO_ARG_COMMENT,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ NO_ARG_COMMENT_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptNo_Arg_Comment,
     /* desc, NAME, name */ zNo_Arg_CommentText, zNo_Arg_Comment_NAME, zNo_Arg_Comment_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 9, VALUE_OPT_INCLUDE,
     /* equiv idx, value */ 9, VALUE_OPT_INCLUDE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ INCLUDE_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aIncludeCantList,
     /* option proc      */ doOptInclude,
     /* desc, NAME, name */ zIncludeText, zInclude_NAME, zInclude_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 10, VALUE_OPT_EXCLUDE,
     /* equiv idx, value */ 10, VALUE_OPT_EXCLUDE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ EXCLUDE_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aExcludeCantList,
     /* option proc      */ doOptExclude,
     /* desc, NAME, name */ zExcludeText, zExclude_NAME, zExclude_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 11, VALUE_OPT_CACHEFILE,
     /* equiv idx, value */ 11, VALUE_OPT_CACHEFILE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ CACHEFILE_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zCachefileText, zCachefile_NAME, zCachefile_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 12, VALUE_OPT_PCAP,
     /* equiv idx, value */ 12, VALUE_OPT_PCAP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ PCAP_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zPcapText, zPcap_NAME, zPcap_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 13, VALUE_OPT_PRINT_COMMENT,
     /* equiv idx, value */ 13, VALUE_OPT_PRINT_COMMENT,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ PRINT_COMMENT_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zPrint_CommentText, zPrint_Comment_NAME, zPrint_Comment_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 14, VALUE_OPT_PRINT_INFO,
     /* equiv idx, value */ 14, VALUE_OPT_PRINT_INFO,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ PRINT_INFO_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zPrint_InfoText, zPrint_Info_NAME, zPrint_Info_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 15, VALUE_OPT_PRINT_STATS,
     /* equiv idx, value */ 15, VALUE_OPT_PRINT_STATS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ PRINT_STATS_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zPrint_StatsText, zPrint_Stats_NAME, zPrint_Stats_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 16, VALUE_OPT_SERVICES,
     /* equiv idx, value */ 16, VALUE_OPT_SERVICES,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ SERVICES_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ aServicesMustList, NULL,
     /* option proc      */ doOptServices,
     /* desc, NAME, name */ zServicesText, zServices_NAME, zServices_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 17, VALUE_OPT_NONIP,
     /* equiv idx, value */ 17, VALUE_OPT_NONIP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ NONIP_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptNonip,
     /* desc, NAME, name */ zNonipText, zNonip_NAME, zNonip_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 18, VALUE_OPT_RATIO,
     /* equiv idx, value */ 18, VALUE_OPT_RATIO,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ RATIO_FLAGS, 0,
     /* last opt argumnt */ { zRatioDefaultArg },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ aRatioMustList, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zRatioText, zRatio_NAME, zRatio_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 19, VALUE_OPT_MINMASK,
     /* equiv idx, value */ 19, VALUE_OPT_MINMASK,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ MINMASK_FLAGS, 0,
     /* last opt argumnt */ { zMinmaskDefaultArg },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ aMinmaskMustList, NULL,
     /* option proc      */ doOptMinmask,
     /* desc, NAME, name */ zMinmaskText, zMinmask_NAME, zMinmask_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 20, VALUE_OPT_MAXMASK,
     /* equiv idx, value */ 20, VALUE_OPT_MAXMASK,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ MAXMASK_FLAGS, 0,
     /* last opt argumnt */ { zMaxmaskDefaultArg },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ aMaxmaskMustList, NULL,
     /* option proc      */ doOptMaxmask,
     /* desc, NAME, name */ zMaxmaskText, zMaxmask_NAME, zMaxmask_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 21, VALUE_OPT_VERBOSE,
     /* equiv idx, value */ 21, VALUE_OPT_VERBOSE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VERBOSE_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zVerboseText, zVerbose_NAME, zVerbose_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 22, VALUE_OPT_DECODE,
     /* equiv idx, value */ 22, VALUE_OPT_DECODE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ DECODE_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ aDecodeMustList, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zDecodeText, zDecode_NAME, zDecode_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 23, VALUE_OPT_VERSION,
     /* equiv idx, value */ 23, VALUE_OPT_VERSION,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VERSION_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptVersion,
     /* desc, NAME, name */ zVersionText, zVersion_NAME, zVersion_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 24, VALUE_OPT_LESS_HELP,
     /* equiv idx, value */ 24, VALUE_OPT_LESS_HELP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ LESS_HELP_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptLess_Help,
     /* desc, NAME, name */ zLess_HelpText, zLess_Help_NAME, zLess_Help_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_HELP, VALUE_OPT_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_IMM | OPTST_NO_INIT, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doUsageOpt,
     /* desc, NAME, name */ zHelpText, NULL, zHelp_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_MORE_HELP, VALUE_OPT_MORE_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_IMM | OPTST_NO_INIT, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ optionPagedUsage,
     /* desc, NAME, name */ zMore_HelpText, NULL, zMore_Help_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_SAVE_OPTS, VALUE_OPT_SAVE_OPTS,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_SET_ARGTYPE(OPARG_TYPE_STRING)
                          | OPTST_ARG_OPTIONAL | OPTST_NO_INIT, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zSave_OptsText, NULL, zSave_Opts_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_LOAD_OPTS, VALUE_OPT_LOAD_OPTS,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, NOLIMIT, 0,
     /* opt state flags  */ OPTST_SET_ARGTYPE(OPARG_TYPE_STRING) \
			  | OPTST_DISABLE_IMM, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionLoadOpt,
     /* desc, NAME, name */ zLoad_OptsText, zLoad_Opts_NAME, zLoad_Opts_Name,
     /* disablement strs */ zNotLoad_Opts_Name, zNotLoad_Opts_Pfx }
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Define the Tcpprep Option Environment
 */
tSCC   zPROGNAME[]   = "TCPPREP";
tSCC   zUsageTitle[] =
"tcpprep (tcpprep) - Create a tcpreplay cache cache file from a pcap file.\n\
USAGE:  %s [ -<flag> [<val>] | --<name>[{=| }<val>] ]...\n";
tSCC   zRcName[]     = ".tcppreprc";
tSCC*  apzHomeList[] = {
       "$$/",
       NULL };

#define zBugsAddr NULL
tSCC   zExplain[]     = "\n\
tcpprep is a ``pcap(3)'' file pre-processor which creates a cache\n\
file which provides \"rules\" for ``tcprewrite(1)'' and ``tcpreplay(1)''\n\
on how to process and send packets.\n";
tSCC    zDetail[]     = "\n\
The basic operation of tcpreplay is to resend all packets from the\n\
input file(s) out a single file.  Tcpprep processes a pcap file and \n\
applies a set of user-specified rules to create a cache file which \n\
tells tcpreplay wether or not to send each packet and which interface the\n\
packet should be sent out of.\n\n\
For more details, please see the Tcpreplay Manual at:\n\
http://tcpreplay.synfin.net/trac/wiki/manual\n";
#define zFullVersion    NULL
/* extracted from /opt/local/share/autogen/optcode.tpl near line 428 */

#if defined(ENABLE_NLS)
# define OPTPROC_BASE OPTPROC_TRANSLATE
  static tOptionXlateProc translate_option_strings;
#else
# define OPTPROC_BASE OPTPROC_NONE
# define translate_option_strings NULL
#endif /* ENABLE_NLS */

#define tcpprep_full_usage NULL
#define tcpprep_short_usage NULL
tOptions tcpprepOptions = {
    OPTIONS_STRUCT_VERSION,
    0, NULL,                    /* original argc + argv    */
    ( OPTPROC_BASE
    + OPTPROC_ERRSTOP
    + OPTPROC_SHORTOPT
    + OPTPROC_LONGOPT
    + OPTPROC_NO_REQ_OPT
    + OPTPROC_NO_ARGS
    + OPTPROC_GNUUSAGE
    + OPTPROC_HAS_IMMED ),
    0, NULL,                    /* current option index, current option */
    NULL,         NULL,         zPROGNAME,
    zRcName,      zCopyright,   zCopyrightNotice,
    zFullVersion, apzHomeList,  zUsageTitle,
    zExplain,     zDetail,      optDesc,
    zBugsAddr,                  /* address to send bugs to */
    NULL, NULL,                 /* extensions/saved state  */
    optionUsage,       /* usage procedure */
    translate_option_strings,   /* translation procedure */
    /*
     *  Indexes to special options
     */
    { INDEX_OPT_MORE_HELP,
      INDEX_OPT_SAVE_OPTS,
      NO_EQUIVALENT /* index of '-#' option */,
      NO_EQUIVALENT /* index of default opt */
    },
    29 /* full option count */, 25 /* user option count */,
    tcpprep_full_usage, tcpprep_short_usage
};

/*
 *  Create the static procedure(s) declared above.
 */
static void
doUsageOpt(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    USAGE( EXIT_SUCCESS );
}

/* * * * * * *
 *
 *   For the dbug option, when DEBUG is #define-d.
 */
#ifdef DEBUG
static void
doOptDbug(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    static const struct {const int rmin, rmax;} rng[ 1 ] = {
        { 0, 5 } };
    int val;
    int ix;
    char const* pzIndent = "\t\t\t\t  ";
    extern FILE* option_usage_fp;

    if (pOptDesc == NULL) /* usage is requesting range list
                             option_usage_fp has already been set */
        goto emit_ranges;

    val = atoi( pOptDesc->optArg.argString );
    for (ix = 0; ix < 1; ix++) {
        if (val < rng[ix].rmin)
            continue;  /* ranges need not be ordered. */
        if (val == rng[ix].rmin)
            goto valid_return;
        if (rng[ix].rmax == INT_MIN)
            continue;
        if (val <= rng[ix].rmax)
            goto valid_return;
    }

    option_usage_fp = stderr;
    fprintf(stderr, _("%s error:  %s option value ``%s''is out of range.\n"),
            pOptions->pzProgName, pOptDesc->pz_Name, pOptDesc->optArg.argString);
    pzIndent = "\t";

  emit_ranges:
    fprintf( option_usage_fp, _("%sit must lie in the range: %d to %d\n"),
             pzIndent, rng[0].rmin, rng[0].rmax );
    if (pOptDesc == NULL)
        return;

    USAGE( EXIT_FAILURE );
    /* NOTREACHED */
    return;

  valid_return:
    pOptDesc->optArg.argInt = val;
}
#endif /* defined DEBUG */

/* * * * * * *
 *
 *   For the auto option.
 */
static void
doOptAuto(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    /* extracted from tcpprep_opts.def, line 89 */
    
    options.mode = AUTO_MODE;
    if (strcmp(OPT_ARG(AUTO), "bridge") == 0) {
        options.automode = BRIDGE_MODE;
    }
    else if (strcmp(OPT_ARG(AUTO), "router") == 0) {
        options.automode = ROUTER_MODE;
    }
    else if (strcmp(OPT_ARG(AUTO), "client") == 0) {
        options.automode = CLIENT_MODE;
    }
    else if (strcmp(OPT_ARG(AUTO), "server") == 0) {
        options.automode = SERVER_MODE;
    }
    else if (strcmp(OPT_ARG(AUTO), "first") == 0) {
        options.automode = FIRST_MODE;
    }
    else {
        errx(1, "Invalid auto mode type: %s", OPT_ARG(AUTO));
    }
}

/* * * * * * *
 *
 *   For the cidr option.
 */
static void
doOptCidr(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    /* extracted from tcpprep_opts.def, line 161 */
  
    char *cidr = safe_strdup(OPT_ARG(CIDR));
    options.mode = CIDR_MODE;
    if (!parse_cidr(&options.cidrdata, cidr, ","))
        errx(1, "Unable to parse CIDR map: %s", OPT_ARG(CIDR));
    free(cidr);

}

/* * * * * * *
 *
 *   For the regex option.
 */
static void
doOptRegex(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    /* extracted from tcpprep_opts.def, line 187 */
    
    int regex_error;
    char ebuf[EBUF_SIZE];
    
    options.mode = REGEX_MODE;
    if ((regex_error = regcomp(&options.preg, OPT_ARG(REGEX), 
        REG_EXTENDED|REG_NOSUB))) {
        regerror(regex_error, &options.preg, ebuf, EBUF_SIZE);
        errx(1, "Unable to compile regex: %s", ebuf);
    }
    
}

/* * * * * * *
 *
 *   For the port option.
 */
static void
doOptPort(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    /* extracted from tcpprep_opts.def, line 215 */
    
    options.mode = PORT_MODE;
    
}

/* * * * * * *
 *
 *   For the mac option.
 */
static void
doOptMac(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    /* extracted from tcpprep_opts.def, line 236 */

options.mode = MAC_MODE;
options.maclist = safe_strdup(OPT_ARG(MAC));


}

/* * * * * * *
 *
 *   For the comment option.
 */
static void
doOptComment(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    /* extracted from tcpprep_opts.def, line 269 */

    /* our comment_len is only 16bit - myargs[] */
    if (strlen(OPT_ARG(COMMENT)) > ((1 << 16) - 1 - MYARGS_LEN))
                errx(1, "Comment length %d is longer then max allowed (%d)", 
                strlen(OPT_ARG(COMMENT)), (1 << 16) - 1 - MYARGS_LEN);
    
    /* save the comment */
    options.comment = (char *)safe_malloc(strlen(OPT_ARG(COMMENT)) + 1);
    strcpy(options.comment, OPT_ARG(COMMENT));
    
}

/* * * * * * *
 *
 *   For the no-arg-comment option.
 */
static void
doOptNo_Arg_Comment(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    /* extracted from tcpprep_opts.def, line 291 */

options.nocomment = 1;
}

/* * * * * * *
 *
 *   For the include option.
 */
static void
doOptInclude(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    /* extracted from tcpprep_opts.def, line 311 */
    
    char *include;
    
    include = safe_strdup(OPT_ARG(INCLUDE));
    options.xX.mode = xX_MODE_INCLUDE;
        
    if ((options.xX.mode = parse_xX_str(&options.xX, include, &options.bpf)) == xXError)
        errx(1, "Unable to parse include/exclude rule: %s", OPT_ARG(INCLUDE));

    free(include);
    
}

/* * * * * * *
 *
 *   For the exclude option.
 */
static void
doOptExclude(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    /* extracted from tcpprep_opts.def, line 358 */
    
    char *exclude;
    
    exclude = safe_strdup(OPT_ARG(EXCLUDE));
    options.xX.mode = xX_MODE_EXCLUDE;
    
    if ((options.xX.mode = parse_xX_str(&options.xX, exclude, &options.bpf)) == xXError)
        errx(1, "Unable to parse include/exclude rule: %s", OPT_ARG(EXCLUDE));
    
    free(exclude);
    
}

/* * * * * * *
 *
 *   For the services option.
 */
static void
doOptServices(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    /* extracted from tcpprep_opts.def, line 455 */
    parse_services(OPT_ARG(SERVICES), &options.services);
    
}

/* * * * * * *
 *
 *   For the nonip option.
 */
static void
doOptNonip(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    /* extracted from tcpprep_opts.def, line 466 */
 
    options.nonip = DIR_SERVER;
    
}

/* * * * * * *
 *
 *   For the minmask option.
 */
static void
doOptMinmask(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    static const struct {const int rmin, rmax;} rng[ 1 ] = {
        { 0, 32 } };
    int val;
    int ix;
    char const* pzIndent = "\t\t\t\t  ";
    extern FILE* option_usage_fp;

    if (pOptDesc == NULL) /* usage is requesting range list
                             option_usage_fp has already been set */
        goto emit_ranges;

    val = atoi( pOptDesc->optArg.argString );
    for (ix = 0; ix < 1; ix++) {
        if (val < rng[ix].rmin)
            continue;  /* ranges need not be ordered. */
        if (val == rng[ix].rmin)
            goto valid_return;
        if (rng[ix].rmax == INT_MIN)
            continue;
        if (val <= rng[ix].rmax)
            goto valid_return;
    }

    option_usage_fp = stderr;
    fprintf(stderr, _("%s error:  %s option value ``%s''is out of range.\n"),
            pOptions->pzProgName, pOptDesc->pz_Name, pOptDesc->optArg.argString);
    pzIndent = "\t";

  emit_ranges:
    fprintf( option_usage_fp, _("%sit must lie in the range: %d to %d\n"),
             pzIndent, rng[0].rmin, rng[0].rmax );
    if (pOptDesc == NULL)
        return;

    USAGE( EXIT_FAILURE );
    /* NOTREACHED */
    return;

  valid_return:
    pOptDesc->optArg.argInt = val;
}

/* * * * * * *
 *
 *   For the maxmask option.
 */
static void
doOptMaxmask(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    static const struct {const int rmin, rmax;} rng[ 1 ] = {
        { 0, 32 } };
    int val;
    int ix;
    char const* pzIndent = "\t\t\t\t  ";
    extern FILE* option_usage_fp;

    if (pOptDesc == NULL) /* usage is requesting range list
                             option_usage_fp has already been set */
        goto emit_ranges;

    val = atoi( pOptDesc->optArg.argString );
    for (ix = 0; ix < 1; ix++) {
        if (val < rng[ix].rmin)
            continue;  /* ranges need not be ordered. */
        if (val == rng[ix].rmin)
            goto valid_return;
        if (rng[ix].rmax == INT_MIN)
            continue;
        if (val <= rng[ix].rmax)
            goto valid_return;
    }

    option_usage_fp = stderr;
    fprintf(stderr, _("%s error:  %s option value ``%s''is out of range.\n"),
            pOptions->pzProgName, pOptDesc->pz_Name, pOptDesc->optArg.argString);
    pzIndent = "\t";

  emit_ranges:
    fprintf( option_usage_fp, _("%sit must lie in the range: %d to %d\n"),
             pzIndent, rng[0].rmin, rng[0].rmax );
    if (pOptDesc == NULL)
        return;

    USAGE( EXIT_FAILURE );
    /* NOTREACHED */
    return;

  valid_return:
    pOptDesc->optArg.argInt = val;
}

/* * * * * * *
 *
 *   For the version option.
 */
static void
doOptVersion(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    /* extracted from tcpprep_opts.def, line 567 */
    
    fprintf(stderr, "tcpprep version: %s (build %s)", VERSION, svn_version());
#ifdef DEBUG
    fprintf(stderr, " (debug)");
#endif
    fprintf(stderr, "\n");
    fprintf(stderr, "Copyright 2001-2008 by Aaron Turner <aturner at synfin dot net>\n");
    fprintf(stderr, "Cache file supported: %s\n", CACHEVERSION);
#ifdef HAVE_LIBNET
    fprintf(stderr, "Compiled against libnet: %s\n", LIBNET_VERSION);
#else
fprintf(stderr, "Not compiled with libnet.\n");
#endif
#ifdef HAVE_WINPCAP
fprintf(stderr, "Compiled against winpcap: %s\n", get_pcap_version());
#else
    fprintf(stderr, "Compiled against libpcap: %s\n", get_pcap_version());
#endif
#ifdef ENABLE_64BITS
    fprintf(stderr, "64 bit packet counters: enabled\n");
#else
    fprintf(stderr, "64 bit packet counters: disabled\n");
#endif
#ifdef ENABLE_VERBOSE
    fprintf(stderr, "Verbose printing via tcpdump: enabled\n");
#else
    fprintf(stderr, "Verbose printing via tcpdump: disabled\n");
#endif
    exit(0);
    
}

/* * * * * * *
 *
 *   For the less-help option.
 */
static void
doOptLess_Help(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    /* extracted from tcpprep_opts.def, line 607 */
  
    USAGE(EXIT_FAILURE);

}

/* extracted from /opt/local/share/autogen/optcode.tpl near line 537 */

#if ENABLE_NLS
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <autoopts/usage-txt.h>

static char* AO_gettext( char const* pz );
static void  coerce_it(void** s);

static char*
AO_gettext( char const* pz )
{
    char* pzRes;
    if (pz == NULL)
        return NULL;
    pzRes = _(pz);
    if (pzRes == pz)
        return pzRes;
    pzRes = strdup( pzRes );
    if (pzRes == NULL) {
        fputs( _("No memory for duping translated strings\n"), stderr );
        exit( EXIT_FAILURE );
    }
    return pzRes;
}

static void coerce_it(void** s) { *s = AO_gettext(*s); }
#define COERSION(_f) \
  coerce_it((void*)&(tcpprepOptions._f))

/*
 *  This invokes the translation code (e.g. gettext(3)).
 */
static void
translate_option_strings( void )
{
    /*
     *  Guard against re-translation.  It won't work.  The strings will have
     *  been changed by the first pass through this code.  One shot only.
     */
    if (option_usage_text.field_ct == 0)
        return;
    /*
     *  Do the translations.  The first pointer follows the field count field.
     *  The field count field is the size of a pointer.
     */
    {
        char** ppz = (char**)(void*)&(option_usage_text);
        int    ix  = option_usage_text.field_ct;

        do {
            ppz++;
            *ppz = AO_gettext(*ppz);
        } while (--ix > 0);
    }
    option_usage_text.field_ct = 0;

    {
        tOptDesc* pOD = tcpprepOptions.pOptDesc;
        int       ix  = tcpprepOptions.optCt;

        for (;;) {
            pOD->pzText           = AO_gettext(pOD->pzText);
            pOD->pz_NAME          = AO_gettext(pOD->pz_NAME);
            pOD->pz_Name          = AO_gettext(pOD->pz_Name);
            pOD->pz_DisableName   = AO_gettext(pOD->pz_DisableName);
            pOD->pz_DisablePfx    = AO_gettext(pOD->pz_DisablePfx);
            if (--ix <= 0)
                break;
            pOD++;
        }
    }
    COERSION(pzCopyright);
    COERSION(pzCopyNotice);
    COERSION(pzFullVersion);
    COERSION(pzUsageTitle);
    COERSION(pzExplain);
    COERSION(pzDetail);
}

#endif /* ENABLE_NLS */

#ifdef  __cplusplus
}
#endif
/* tcpprep_opts.c ends here */
