#   ifndef	DOC_DRAW_H
#   define	DOC_DRAW_H

#   include	"docBuf.h"
#   include	"docLayout.h"
#   include	<appDraw.h>

/************************************************************************/
/*									*/
/*  The different resources needed for drawing.				*/
/*									*/
/************************************************************************/

struct DrawingContext;

typedef void (*PARA_SIDES_PIXELS)( struct ParagraphFrame *	pf,
				const AppDrawingData *		add,
				const BufferItem *		bi );

typedef int (*DRAW_TEXT_LINE)(	const BufferItem *		bi,
				int				line,
				const struct ParagraphFrame *	pf,
				void *				through,
				struct DrawingContext *		dc );

typedef int (*DRAW_PARA_TOP)(	const BufferItem *		bi,
				const BorderProperties *	bp,
				const struct ParagraphFrame *	pf,
				void *				through,
				struct DrawingContext *		dc );

typedef int (*DRAW_PARA_BOTTOM)( const BufferItem *		bi,
				const BorderProperties *	bp,
				const struct ParagraphFrame *	pf,
				void *				through,
				struct DrawingContext *		dc );

typedef int (*DRAW_CELL_TOP)(	const BorderProperties *	bp,
				int				asGrid,
				int				x0Twips,
				int				x0Pixels,
				int				x1Twips,
				int				x1Pixels,
				void *				through,
				struct DrawingContext *		dc,
				const LayoutPosition *		lpTop );

typedef int (*DRAW_CELL_BOTTOM)( const BorderProperties *	bp,
				int				asGrid,
				int				x0Twips,
				int				x0Pixels,
				int				x1Twips,
				int				x1Pixels,
				void *				through,
				struct DrawingContext *		dc,
				const LayoutPosition *		lpBottom );

typedef int (*DRAW_CELL_LEFT)(	const BorderProperties *	bp,
				int				asGrid,
				void *				through,
				struct DrawingContext *		dc,
				int				x0Twips,
				int				x0Pixels,
				const LayoutPosition *		lpTop,
				const LayoutPosition *		lpBelow );

typedef int (*DRAW_CELL_RIGHT)(	const BorderProperties *	bp,
				int				asGrid,
				void *				through,
				struct DrawingContext *		dc,
				int				x1Twips,
				int				x1Pixels,
				const LayoutPosition *		lpTop,
				const LayoutPosition *		lpBelow );

typedef int (*FINISH_PAGE)(	void *				through,
				struct DrawingContext *		dc,
				int				page,
				int				asLast );

typedef int (*START_PAGE)(	void *				through,
				const DocumentGeometry *	dg,
				struct DrawingContext *		dc,
				int				page );

typedef struct DrawingContext
    {
    int				dcCurrentPhysicalFont;

    AppDrawingData *		dcDrawingData;
    BufferDocument *		dcDocument;
    const DocumentRectangle *	dcClipRect;
    const DocumentSelection *	dcDocumentSelection;
    const SelectionGeometry *	dcSelectionGeometry;
    int				dcFirstPage;
    int				dcLastPage;
    int				dcDrawHeadersFooters;

    int				dcDrawTableGrid;

    DRAW_TEXT_LINE		dcDrawTextLine;

    DRAW_PARA_TOP		dcDrawParaTop;
    DRAW_PARA_BOTTOM		dcDrawParaBottom;
    DRAW_CELL_TOP 		dcDrawCellTop;
    DRAW_CELL_BOTTOM 		dcDrawCellBottom;
    DRAW_CELL_LEFT		dcDrawCellLeft;
    DRAW_CELL_RIGHT		dcDrawCellRight;
    FINISH_PAGE			dcFinishPage;
    START_PAGE			dcStartPage;
    PARA_SIDES_PIXELS		dcParaFramePixels;
    LAYOUT_EXTERNAL		dcLayoutExternal;
    DOC_CLOSE_OBJECT		dcCloseObject;
    } DrawingContext;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitDrawingContext(	DrawingContext *	dc );

extern int docDrawItem(	BufferItem *			bi,
			void *				through,
			DrawingContext *		dc );

extern int docDrawPageHeader(	BufferItem *			sectBi,
				void *				through,
				DrawingContext *		dc,
				int				page );

extern int docDrawPageFooter(	BufferItem *			sectBi,
				void *				through,
				DrawingContext *		dc,
				int				page );

extern int docDrawFootnotesForColumn(
				int				page,
				void *				through,
				DrawingContext *		dc );

extern int docDrawEndnotesForSection(	int			sect,
					void *			through,
					DrawingContext *	dc );

extern int docDrawEndnotesForDocument(	void *			through,
					DrawingContext *	dc );

extern int docDrawToPageOfItem(		BufferItem *		prevBodyBi,
					BufferItem *		thisBodyBi,
					BufferItem *		thisBi,
					void *			through,
					LayoutPosition *	lpHere,
					DrawingContext *	dc );

#   endif
