/************************************************************************/
/*									*/
/*  Data that describes where a font belongs in the mess of font	*/
/*  encodings and character sets that we have to cope with.		*/
/*									*/
/************************************************************************/

#   ifndef	UTIL_FONT_ENCODING_H
#   define	UTIL_FONT_ENCODING_H

/************************************************************************/
/*									*/
/*  Font encodings that we more or less actively support.		*/
/*									*/
/************************************************************************/

#   define	ENCODINGpsFONTSPECIFIC		-1
#   define	ENCODINGpsISO_8859_1		0
#   define	ENCODINGpsISO_8859_2		1
#   define	ENCODINGpsADOBE_SYMBOL		2
#   define	ENCODINGpsADOBE_CYRILLIC	3
#   define	ENCODINGpsADOBE_DINGBATS	4
#   define	ENCODINGps_COUNT		5

/************************************************************************/
/*									*/
/*  Font character sets as used by windows programs.			*/
/*									*/
/************************************************************************/

#   define FONTcharsetDEFAULT		1
#   define FONTcharsetSYMBOL		2
#   define FONTcharsetOEM		255
#   define FONTcharsetANSI		0		/*  cpg 1252	*/
#   define FONTcharsetRUSSIAN		204		/*  cpg 1251	*/
#   define FONTcharsetEE		238		/*  cpg 1250	*/
#   define FONTcharsetGREEK		161		/*  cpg 1253	*/
#   define FONTcharsetTURKISH		162		/*  cpg 1254	*/
#   define FONTcharsetBALTIC		186		/*  cpg 1257	*/
#   define FONTcharsetHEBREW		177		/*  cpg 1255	*/
#   define FONTcharsetARABIC		178		/*  cpg 1256	*/
#   define FONTcharsetSHIFTJIS		128		/*  cpg 932	*/
#   define FONTcharsetHANGEUL		129		/*  cpg 949	*/
#   define FONTcharsetGB2313		134		/*  cpg 936	*/
#   define FONTcharsetCHINESEBIG5	136		/*  cpg 950	*/

typedef struct FontCharset
    {
    const char * const *	fcGlyphNames;
    int				fcGlyphCount;
    const char *		fcEncodingSuffix;
    const char *		fcEncodingArray;

    char *			fcId;
    char *			fcLabel;

    int				fcOfficeCharset;
    int				fcOfficeCodepage;
    const char *		fcOfficeFontnameSuffix;
    } FontCharset;

/************************************************************************/
/*									*/
/*  Declarations.							*/
/*									*/
/************************************************************************/

extern const FontCharset PS_Encodings[ENCODINGps_COUNT];

extern const char * const	psIsoLatin1GlyphNames[256];
extern const char * const	psIsoLatin2GlyphNames[256];
extern const char * const	psSymbolGlyphNames[256];
extern const char * const	psCyrillicGlyphNames[256];
extern const char * const	psDingbatGlyphNames[256];

extern const unsigned char	docWIN1250_to_ISO2[256];
extern const unsigned char	docISO2_to_WIN1250[256];

extern const unsigned char	docWIN1251_to_KOI8R[256];
extern const unsigned char	docKOI8R_to_WIN1251[256];

extern const unsigned char	docWIN1251_to_ISO5[256];
extern const unsigned char	docISO5_to_WIN1251[256];

extern const unsigned char	docDOS437_to_ISO1[256];
extern const unsigned char	docDOS850_to_ISO1[256];
extern const unsigned char	docMAC_to_ISO1[256];

#   endif
