#   ifndef	APP_PS_H
#   define	APP_PS_H

#   include	<stdio.h>
#   include	<appGeo.h>
#   include	<docFont.h>
#   include	<psFont.h>
#   include	<utilFontEncoding.h>
#   include	<utilPostscriptFace.h>

/************************************************************************/
/*									*/
/*  The state of a printing job.					*/
/*									*/
/************************************************************************/

typedef struct NupTransform
    {
    double		ntAxx;
    double		ntAxy;
    double		ntAyx;
    double		ntAyy;
    double		ntTx;
    double		ntTy;
    } NupTransform;

#   define	NUP_X( x, y, nt ) \
			( (nt)->ntAxx* (x)+ (nt)->ntAyx* (y)+ (nt)->ntTx )
#   define	NUP_Y( x, y, nt ) \
			( (nt)->ntAxy* (x)+ (nt)->ntAyy* (y)+ (nt)->ntTy )

typedef struct PrintingState
    {
    FILE *			psFile;

    int				psCurrentPhysicalFont;
    int				psPagesPrinted;
    int				psSheetsPrinted;

    NupTransform		psTransform;
    NupTransform		psCurrentTransform;
    DocumentGeometry		psPrinterGeometry;
    char *			psOrientation;
    int				psRotated;

    DocumentRectangle		psSheetBoundingBox;

    int				psNup;
    NupTransform *		psNupTransforms;

    int				psInsideLink;
    int				psUseLinkColor;
    int				psLinkParticulesDone;
    int				psLinkRectLeft;

    int				psCurrentColor;
#   define			PScolorNONE	-1
#   define			PScolorTEXT	1
#   define			PScolorLINK	2

    const char *		psLinkFile;
    int				psLinkFileSize;
    const char *		psLinkMark;
    int				psLinkMarkSize;

    int				psEncodingDefined[ENCODINGps_COUNT];
    } PrintingState;

/************************************************************************/
/*									*/
/*  Geometry specifications for a print job.				*/
/*									*/
/************************************************************************/

typedef struct PrintGeometry
    {
    DocumentGeometry	pgSheetGeometry;
    int			pgRotate90;
    int			pgCenterHorizontally;
    int			pgNup;
    int			pgHorizontal;
    } PrintGeometry;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void utilPsInitPrintGeometry(	PrintGeometry *	pg );

extern void utilPsStartDSCDocument(
			const PrintingState *		ps,
			const PostScriptFaceList *	psfl,
			const char *			title,
			const char *			creatorName,
			const char *			creatorReference );

extern int appPsSetNup(	PrintingState *			ps,
			const DocumentGeometry *	dgPage,
			const PrintGeometry *		pg,
			int				hasPageHeader,
			int				hasPageFooter );

extern void appPsPrintString(	FILE *			f,
				const unsigned char *	s,
				int			len );

extern void appPsSetFont(	FILE *		f,
				const char *	prefix,
				TextAttribute	ta );

extern void appPsInitPrintingState(	PrintingState *	ps );
extern void appPsCleanPrintingState(	PrintingState *	ps );

extern void utilPsSetLinkColor( PrintingState *   ps );
extern void utilPsSetTextColor( PrintingState *   ps );

extern void appPsStartPage(	PrintingState *			ps,
				int				documentPage );

extern void utilPsFinishPage(	PrintingState *		ps,
				int			documentPage,
				int			asLast );

extern int utilPsGetNupFactor(	double *			pFac,
				int *				pRotate,
				int *				pXShift,
				int *				pYShift,
				const DocumentGeometry *	dgPage,
				const PrintGeometry *		pg );

extern void appPsFontNames(	FILE *				f,
				const PostScriptFaceList *	psfl,
				int *				encodingDefined,
				int				allFonts );

extern void appPsListFontNames(	FILE *				f,
				const PostScriptFaceList *	psfl );

extern void appPsDefineFontEncoding(	FILE *			f,
					const char *		name,
					const char * const *	glyphNames );

extern void appPsWriteEpsHeader(	FILE *			f,
					const char *		creator,
					const char *		title,
					int			pointsWide,
					int			pointsHigh );

extern void appPsSetPdfmarkEmulation(		FILE *	f );
extern void appPsSetRectfillEmulation(		FILE *	f );
extern void appPsSetSelectfontEmulation(	FILE *	f );

extern void utilPsDefineProcedure(	FILE *			f,
					const char **		lines,
					int			count );

extern void appPsDefineEpsProcs(	FILE *		f );

extern void appPsBeginEpsObject(	PrintingState *		ps,
					int			x0Twips,
					int			y0Twips,
					int			llxTwips,
					int			llyTwips,
					int			urxTwips,
					int			uryTwips,
					const unsigned char *	file );

extern void appPsEndEpsObject(		PrintingState *		ps );

extern void utilPsFoldComment(		FILE *			f,
					const char *		name,
					const char *		value );

extern int utilPsDestPdfmark(		PrintingState *		ps,
					int			lineTop,
					const char *		refName,
					int			refSize );

#   endif	/*  APP_PS_H  */
