class Model

  class Item
    attr_reader :name, :price
    def initialize(name,price)
      @name = name
      @price = price
    end
  end

  attr_reader :items

  def initialize(init_data = nil)
    @items = []
    if init_data then
      init_data.each { |name,price| add_item( name, price ) }
    end
  end

  def amount
    val = 0
    items.each { |i| val += i.price }
    return val
  end

  def add_item(name,price)
    @items.push Item.new(name,price)
  end

  def del_item(name)
    @items.delete_if {|i| i.name == name }
  end

  def reset
    @items = []
  end

end
