/* Trivial modification of usage.c and printversion.c in web2c-7.2/web2c/lib.
   The two files are in public domain. */

#include "config.h"

void
usage P2C(int, status,  const_string, str)
{
  if (status == 0) {
    fputs (str, stdout);
    putchar ('\n');
    fputs ("Email bug reports to sakurai@math.s.chiba-u.ac.jp.\n", stdout);
  } else {
    fprintf (stderr, "Try `%s --help' for more information.\n", str);
  }
  uexit (status);
}

void
printversionandexit P3C(const_string, banner,
                        const_string, copyright_holder,  const_string, author)
{
  extern string versionstring;           /* from web2c/lib/version.c */
  extern KPSEDLL string kpathsea_version_string;/* from kpathsea/version.c */
  string prog_name, base_prog_name;
  unsigned len;
  const_string prog_name_end = strchr (banner, ',');
  const_string prog_version = strchr (prog_name_end+2, ' ');
  const_string base_banner = strchr (prog_version, ',') + 2;
  const_string based_prog = base_banner + sizeof ("based on");
  assert (prog_name_end && prog_version);
  prog_version++;
  
  len = prog_name_end - banner - sizeof ("This is");
  prog_name = xmalloc (len + 1);
  strncpy (prog_name, banner + sizeof ("This is"), len);
  prog_name[len] = 0;
  len = strchr(based_prog, ' ') - based_prog;
  base_prog_name = xmalloc (len + 1);
  strncpy (base_prog_name, based_prog, len);
  base_prog_name[len] = 0;

  /* The Web2c version string starts with a space.  */
  printf ("%s%s %s\n", prog_name, versionstring, prog_version);
  puts (kpathsea_version_string);

  if (copyright_holder) {
    printf ("Copyright (C) 1998 %s.\n", copyright_holder);
    if (!author)
      author = copyright_holder;
  }

  puts ("Kpathsea is copyright (C) 1999 Free Software Foundation, Inc.");

  puts ("There is NO warranty.  Redistribution of this software is");
  fputs ("covered by the terms of ", stdout);
  /* DVIcopy is GPL'd, so no additional words needed. */
  if (/*copyright_holder && */!STREQ (prog_name, "DVIcopy")) {
    printf ("\nand the %s copyright", base_prog_name);
  }
  puts ("the GNU General Public License.");
  puts ("For more information about these matters, see the files");
  printf ("named COPYING and the %s and %s source.\n",
	  base_prog_name, prog_name);
  printf ("Primary author of %s: %s; %s author: %s;\n",
          base_prog_name, copyright_holder, prog_name, author);
  puts ("Kpathsea written by Karl Berry and others.\n");

  uexit (0);
}
